/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.OrgUnitTreePromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CheckAccountRelationReturn;
import com.kingdee.eas.fi.gl.CheckPeriodRelationReturn;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GLPeriodEndFilter;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gl.client.AbstractVirtualCompanySumBalanceUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;

public class VirtualCompanySumBalanceUI
extends AbstractVirtualCompanySumBalanceUI {
    protected CompanyOrgUnitInfo curCompany;
    protected UserInfo curUser;
    protected PeriodInfo curPeriod;
    private String filterCompanyID;
    private String filterPeriodID;
    private IGLPeriodEndFacade periodEndCtrl;
    private GLPeriodEndFilter filter;
    private int iSuccess = 0;
    private GlUtils.AccountPeriodInfo pi = null;
    private String strOldCompany = "";
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.GLPeriodEndResource";
    protected PreChangeListener companyPreChangeLs = new PreChangeListener(){

        public void preChange(PreChangeEvent e) {
            try {
                VirtualCompanySumBalanceUI.this.changePeriodByCompany((CompanyOrgUnitInfo)e.getData());
            }
            catch (Exception e1) {
                VirtualCompanySumBalanceUI.this.prbCompany.setValue(e.getOldData());
            }
        }
    };

    public void onLoad() throws Exception {
        this.fetchInitData();
        this.initHeaderStyle();
        super.onLoad();
        this.loadFields();
    }

    @Override
    public void loadFields() {
        this.detachListeners();
        super.loadFields();
        if (GlUtils.isCompanyUnion(this.curCompany)) {
            this.prbCompany.setValue((Object)this.curCompany);
            this.strOldCompany = this.curCompany.getId().toString();
            GlUtils.appliesPeriodControl(this.spnYearFrom, this.spnYearTo, this.spnPeriodFrom, this.spnPeriodTo, null, null, this.pi, false);
        }
        this.attachListeners();
    }

    protected void attachListeners() {
        this.prbCompany.addPreChangeListener(this.companyPreChangeLs);
    }

    protected void detachListeners() {
        this.prbCompany.removePreChangeListener(this.companyPreChangeLs);
    }

    private void initHeaderStyle() throws Exception {
        this.kdlblPic.setIcon((Icon)new ImageIcon(EASResource.getImage((String)"imgGuide_pic260")));
        OrgType[] CompanyType = new OrgType[]{OrgType.Company};
        this.prbCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        this.prbCompany.setEditFormat("$number$");
        this.prbCompany.setCommitFormat("$number$");
        this.prbCompany.setDisplayFormat("$name$");
        this.prbCompany.setEntityViewInfo(this.getCompanyEntityView());
        OrgUnitTreePromptBox boxCompany1 = new OrgUnitTreePromptBox((IUIObject)this, CompanyType, null, false, false, true);
        this.prbCompany.setSelector((KDPromptSelector)boxCompany1);
        this.prbCompany.setEditable(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void spnYearFrom_stateChanged(ChangeEvent e) throws Exception {
        super.spnYearFrom_stateChanged(e);
    }

    @Override
    protected void spnPeriodFrom_stateChanged(ChangeEvent e) throws Exception {
        super.spnPeriodFrom_stateChanged(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.iSuccess == 0) {
            this.doOK();
        } else {
            this.destroyWindow();
        }
    }

    private void doOK() throws Exception {
        int result = 0;
        this.txtaResult.setText("");
        if (this.checkDataObject()) {
            CompanyOrgUnitInfo com = (CompanyOrgUnitInfo)this.prbCompany.getValue();
            Integer yearFrom = (Integer)this.spnYearFrom.getValue();
            Integer periodFrom = (Integer)this.spnPeriodFrom.getValue();
            PeriodInfo prd = PeriodUtils.getPeriodInfo((int)yearFrom, (int)periodFrom, (IObjectPK)new ObjectUuidPK(com.getId()));
            if (prd == null) {
                String strMsg = EASResource.getString((String)RESOURCE_PATH, (String)"errPeriodSumBal");
                this.txtaResult.append(strMsg);
                return;
            }
            if (prd.getPeriodYear() == 0) {
                String strMsg = EASResource.getString((String)RESOURCE_PATH, (String)"errPeriodSumBal");
                this.txtaResult.append(strMsg);
                return;
            }
            String companyID = com.getId().toString();
            String periodID = prd.getId().toString();
            CheckAccountRelationReturn[] checkReturnAcct = this.getBizInterface().checkAccountRelation(companyID);
            if (checkReturnAcct != null) {
                this.txtaResult.append(EASResource.getString((String)RESOURCE_PATH, (String)"errAccountRelation"));
                return;
            }
            CheckPeriodRelationReturn[] checkReturnPrd = this.getBizInterface().checkPeriodRelation(companyID, periodID);
            if (checkReturnPrd != null) {
                this.txtaResult.append(EASResource.getString((String)RESOURCE_PATH, (String)"errPeriodRelation"));
                return;
            }
            result = this.getBizInterface().virtualCompanySumBalance(companyID, periodID);
            if (result == 0) {
                String strMsg = EASResource.getString((String)RESOURCE_PATH, (String)"succVirtualSumBal");
                this.txtaResult.append(strMsg);
                this.setBtnOKOK();
            } else {
                String strMsg = EASResource.getString((String)RESOURCE_PATH, (String)"errVirtualSumBal");
                this.txtaResult.append(strMsg);
            }
        }
    }

    private void fetchInitData() throws Exception {
        this.filter = new GLPeriodEndFilter();
        IGLPeriodEndFacade ctrl = this.getBizInterface();
        this.filter = ctrl.fetchInitData();
        this.curUser = this.filter.getCurUser();
        this.curCompany = this.filter.getCurCompany();
        this.curPeriod = this.filter.getCurPeriod();
        this.pi = ctrl.getAccountPeriod(this.curCompany.getId().toString(), this.curCompany.getAccountPeriodType().getId().toString());
    }

    protected IGLPeriodEndFacade getBizInterface() throws Exception {
        if (this.periodEndCtrl == null) {
            this.periodEndCtrl = GLPeriodEndFacadeFactory.getRemoteInstance();
        }
        return this.periodEndCtrl;
    }

    private EntityViewInfo getCompanyEntityView() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("IsOnlyUnion", (Object)"true"));
        filter.getFilterItems().add(new FilterItemInfo("Type", (Object)new Integer(1)));
        filter.setMaskString("(#0 and #1)");
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSorter().add(new SorterItemInfo("number"));
        return view;
    }

    private SelectorItemCollection getCompanySelector() {
        SelectorItemCollection col = new SelectorItemCollection();
        col.add(new SelectorItemInfo("id"));
        col.add(new SelectorItemInfo("number"));
        col.add(new SelectorItemInfo("name"));
        return col;
    }

    private void setBtnOKOK() {
        this.iSuccess = 1;
        this.btnOK.setText(EASResource.getString((String)RESOURCE_PATH, (String)"btnOKText"));
    }

    private void changePeriodByCompany(CompanyOrgUnitInfo com) throws EASBizException, BOSException, Exception {
        if (!com.getId().toString().equals(this.strOldCompany)) {
            if (!GlUtils.isCompanyUnion(com)) {
                throw new Exception();
            }
            this.strOldCompany = com.getId().toString();
            this.pi = this.getBizInterface().getAccountPeriod(this.strOldCompany, com.getAccountPeriodType().getId().toString());
            GlUtils.appliesPeriodControl(this.spnYearFrom, this.spnYearTo, this.spnPeriodFrom, this.spnPeriodTo, null, null, this.pi, false);
        }
    }

    protected boolean checkDataObject() {
        if (this.prbCompany.getValue() == null) {
            String errMsg = EASResource.getString((String)RESOURCE_PATH, (String)"virtualSumNoCompany");
            MsgBox.showWarning((Component)((Object)this), (String)errMsg);
            this.prbCompany.requestFocus();
            return false;
        }
        return true;
    }
}

