/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.client.AbstractVoucherAsstActTypeMoveToLeafUI;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class VoucherAsstActTypeMoveToLeafUI
extends AbstractVoucherAsstActTypeMoveToLeafUI
implements Runnable {
    private static final Logger logger = CoreUIObject.getLogger(VoucherAsstActTypeMoveToLeafUI.class);
    private boolean stop = false;
    private int maxFuture = 13;
    private static final Color WARN_COLOR = new Color(246, 168, 46);
    private SimpleAttributeSet defAttr = new SimpleAttributeSet();
    private SimpleAttributeSet warnAttr = new SimpleAttributeSet();
    private Map<String, AsstAccountInfo> asstAccounts = new HashMap<String, AsstAccountInfo>();
    private Map<String, AsstActTypeCollection> asstActTypess = new HashMap<String, AsstActTypeCollection>();
    private Map<String, Map<String, String>> parentToDetailAsstActTypes = new HashMap<String, Map<String, String>>();
    private Map<String, AssistantHGInfo> hgs = new HashMap<String, AssistantHGInfo>();
    private Map<String, AssistantHGInfo> oldToNewHgs = new HashMap<String, AssistantHGInfo>();
    private int detailCount = 0;
    private String companyHint = "";
    DataChangeListener companyListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                VoucherAsstActTypeMoveToLeafUI.this.initPeriod();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLAutoGenerateResource";

    public VoucherAsstActTypeMoveToLeafUI() throws Exception {
        StyleConstants.setForeground(this.warnAttr, WARN_COLOR);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initMyIcon();
        this.initCompany();
        this.initPeriod();
    }

    private void initMyIcon() throws Exception {
        this.periodFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.periodTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.btnOk.setEnabled(true);
    }

    private void initCompany() throws Exception {
        this.promptCompany.setQueryInfo("com.kingdee.eas.fi.gl.app.CompanyOrgUnitQuery");
        this.promptCompany.setEditable(true);
        this.promptCompany.setEditFormat("$number$");
        this.promptCompany.setCommitFormat("$name$;$number$");
        this.promptCompany.setDisplayFormat("$number$-$name$");
        this.promptCompany.setEnabledMultiSelection(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isSealup", (Object)new Integer(0)));
        StringBuffer sql = new StringBuffer();
        sql.append("select c.FID \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_BD_SystemStatus s \n");
        sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 6 \n");
        sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
        sql.append("where sc.FIsStart = 1 and c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
        sql.append("    and sc.FStartPeriodID is not null \n");
        sql.append("    and sc.FCurrentPeriodID is not null \n");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        view.setFilter(filter);
        this.promptCompany.setEntityViewInfo(view);
        this.promptCompany.setValue((Object)new Object[]{SysContext.getSysContext().getCurrentFIUnit()});
        this.promptCompany.addDataChangeListener(this.companyListener);
    }

    private void initPeriod() throws Exception {
        Object[] objects = (Object[])this.promptCompany.getValue();
        if (objects == null || objects.length == 0) {
            CompanyOrgUnitInfo company = this.queryCompany(SysContext.getSysContext().getCurrentFIUnit());
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)company.getAccountPeriodType().getId().toString()));
            this.periodFrom.setEntityViewInfo(view);
            this.periodTo.setEntityViewInfo(view);
            this.periodFrom.setValue(null);
            this.periodTo.setValue(null);
        } else if (objects.length == 1) {
            CompanyOrgUnitInfo company = this.queryCompany((CompanyOrgUnitInfo)objects[0]);
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
            PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
            EntityViewInfo tView = new EntityViewInfo();
            FilterInfo tFilter = new FilterInfo();
            tView.setFilter(tFilter);
            tFilter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)company.getAccountPeriodType().getId().toString()));
            tFilter.getFilterItems().add(new FilterItemInfo("number", (Object)curPeriod.getNumber(), CompareType.GREATER));
            SelectorItemCollection tSelector = new SelectorItemCollection();
            tSelector.add("number");
            tView.setSelector(tSelector);
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo si = new SorterItemInfo("number");
            si.setSortType(SortType.ASCEND);
            sorter.add(si);
            tView.setSorter(sorter);
            PeriodCollection coll = PeriodFactory.getRemoteInstance().getPeriodCollection(tView);
            int maxPeriod = curPeriod.getNumber();
            if (coll.size() >= this.maxFuture) {
                maxPeriod = coll.get(this.maxFuture - 1).getNumber();
            } else if (coll.size() > 0) {
                maxPeriod = coll.get(coll.size() - 1).getNumber();
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)company.getAccountPeriodType().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)startPeriod.getNumber(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)maxPeriod, CompareType.LESS_EQUALS));
            this.periodFrom.setEntityViewInfo(view);
            this.periodTo.setEntityViewInfo(view);
            this.periodFrom.setValue((Object)curPeriod);
            this.periodTo.setValue((Object)curPeriod);
        } else {
            CompanyOrgUnitInfo company = this.queryCompany((CompanyOrgUnitInfo)objects[0]);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)company.getAccountPeriodType().getId().toString()));
            this.periodFrom.setEntityViewInfo(view);
            this.periodTo.setEntityViewInfo(view);
            this.periodFrom.setValue(null);
            this.periodTo.setValue(null);
        }
    }

    @Override
    public void actionComfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.btnOk.getClientProperty((Object)"canStop") != null) {
            this.stop = true;
            this.actionComfirm.setEnabled(false);
            this.btnOk.setEnabled(false);
            return;
        }
        new Thread(this).start();
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        this.taInfo.setText("");
        this.detailCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.btnOk.putClientProperty((Object)"canStop", (Object)true);
        this.btnOk.setText(this.getResource("stop"));
        this.enableComponent(false);
        this.asstAccounts.clear();
        this.asstActTypess.clear();
        this.detailCount = 0;
        try {
            this.showInfo(this.getResource("abstracting"));
            List<String> companyIds = this.queryCompanys();
            if (this.cbShowDetail.isSelected()) {
                this.showDetail(this.getResource("showDetail"));
            }
            for (int i = 0; i < companyIds.size(); ++i) {
                CompanyOrgUnitInfo company = this.queryCompany(companyIds.get(i));
                if (company == null) continue;
                this.parentToDetailAsstActTypes.clear();
                this.hgs.clear();
                this.oldToNewHgs.clear();
                this.companyHint = this.getResource("org_processing") + company.getName() + "(" + company.getNumber() + ")[" + (i + 1) + "/" + companyIds.size() + "]\u3000";
                this.showInfo(this.companyHint + "...");
                this.doRun(company);
                if (this.stop) break;
            }
            if (!this.stop) {
                this.showInfo(this.getResource("total_processed") + this.detailCount + this.getResource("record"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            this.btnOk.setText(this.getResource("execute"));
            this.enableComponent(true);
            this.actionComfirm.setEnabled(true);
            this.btnOk.setEnabled(true);
            this.btnOk.putClientProperty((Object)"canStop", null);
            this.stop = false;
        }
    }

    private void doRun(CompanyOrgUnitInfo company) throws SQLException, BOSException, EASBizException {
        String cuFilter = this.getCUFilter(company);
        this.showInfo(this.companyHint + this.getResource("abstract_assistact") + "...");
        List<Map<String, String>> datas = this.queryVoucher(company, cuFilter);
        boolean showDetail = this.cbShowDetail.isSelected();
        boolean change = this.cbChange.isSelected();
        for (int i = 0; i < datas.size(); ++i) {
            Map<String, String> data = datas.get(i);
            this.showInfo(this.companyHint + this.getResource("voucher_assistact") + "[" + (i + 1) + "/" + datas.size() + "]\u3000...");
            HashMap<String, String> pAssActType = new HashMap<String, String>();
            pAssActType.put("id", data.get("assActTypeId"));
            pAssActType.put("longNumber", data.get("assActTypeLongNumber"));
            pAssActType.put("name", data.get("assActTypeName"));
            Map<String, String> dAssActType = null;
            String pAssActTypeId = (String)pAssActType.get("id");
            if (this.parentToDetailAsstActTypes.containsKey(pAssActTypeId)) {
                dAssActType = this.parentToDetailAsstActTypes.get(pAssActTypeId);
            } else {
                dAssActType = this.findDetailAssActType(pAssActType, cuFilter, 1);
                this.parentToDetailAsstActTypes.put(pAssActTypeId, dAssActType);
            }
            String asstAccountId = data.get("asstAccountId");
            AsstActTypeCollection asstActTypes = this.getAsstActTypes(asstAccountId);
            String oldHgId = data.get("hgId");
            AssistantHGInfo oldHg = this.getOldHg(oldHgId, asstActTypes);
            AssistantHGInfo newHg = null;
            if (this.oldToNewHgs.containsKey(oldHgId)) {
                newHg = this.oldToNewHgs.get(oldHgId);
            } else {
                newHg = this.getNewHg(asstAccountId, asstActTypes, oldHg, dAssActType);
                this.oldToNewHgs.put(oldHgId, newHg);
            }
            ++this.detailCount;
            if (showDetail) {
                StringBuffer msg = new StringBuffer();
                msg.append(company.getNumber()).append(",");
                msg.append(data.get("period")).append(",");
                msg.append(data.get("voucherId")).append(",");
                msg.append(data.get("voucherNumber")).append(",");
                msg.append(data.get("entryId")).append(",");
                msg.append(data.get("entrySeq")).append(",");
                msg.append(data.get("recordId")).append(",");
                msg.append(data.get("asstSeq")).append(",");
                msg.append((String)pAssActType.get("id")).append(",");
                msg.append((String)pAssActType.get("longNumber")).append(",");
                msg.append(dAssActType.get("id")).append(",");
                msg.append(dAssActType.get("longNumber")).append(",");
                msg.append(oldHg.getId().toString()).append(",");
                msg.append("\"").append(oldHg.getNumberGroup()).append("\",");
                boolean warn = false;
                if (newHg != null) {
                    if (newHg.get("isNewCreate") != null) {
                        warn = true;
                    }
                    msg.append(newHg.getId().toString()).append(",");
                    msg.append("\"").append(newHg.getNumberGroup()).append("\",");
                } else {
                    msg.append("todo").append(",");
                    msg.append("\"").append(this.getResource("waiting_to_create")).append("\"");
                    warn = true;
                }
                if (this.detailCount <= 10000) {
                    this.showDetail(msg.toString(), warn);
                }
            }
            String companyId = company.getId().toString();
            String periodId = data.get("periodId");
            String recordId = data.get("recordId");
            if (newHg == null || !change) continue;
            Object[] params = new String[]{companyId, periodId, recordId, oldHgId, newHg.getId().toString()};
            String sql = "insert into T_GL_HgRepairLog (FCompanyID, FPeriodID, FRecordID, FOldHgID, FNewHgID) values (?, ?, ?, ?, ?)";
            FMIsqlFacadeFactory.getRemoteInstance().executeSql(sql, params);
            params = new String[]{newHg.getId().toString(), recordId};
            sql = "update T_GL_VoucherAssistRecord set FASSGRPID = ? where FID = ?";
            FMIsqlFacadeFactory.getRemoteInstance().executeSql(sql, params);
        }
    }

    private Map<String, String> findDetailAssActType(Map<String, String> pAssActType, String cuFilter, int count) throws BOSException, SQLException {
        if (count > 10) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("  select cg.FID, cg.FLongNumber, cg.FName_l2 FName \n");
        sql.append("  from T_BD_GeneralAsstActType cg \n");
        sql.append("  inner JOIN T_ORG_CtrlUnit CU ON cg.FControlUnitID = CU.FID \n");
        sql.append("  inner join T_ORG_Company creatorCompany ON cg.FCreatorCompanyID = creatorCompany.FID \n");
        sql.append("  where cg.fparentid = '" + pAssActType.get("id") + "' \n");
        sql.append("  and " + cuFilter + " \n");
        sql.append("  order by cg.fnumber \n");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        if (rs.next()) {
            HashMap<String, String> dAssActType = new HashMap<String, String>();
            dAssActType.put("id", rs.getString("FID"));
            dAssActType.put("longNumber", rs.getString("FLongNumber"));
            dAssActType.put("name", rs.getString("FName"));
            int ncount = count + 1;
            return this.findDetailAssActType(dAssActType, cuFilter, ncount);
        }
        return pAssActType;
    }

    private List<Map<String, String>> queryVoucher(CompanyOrgUnitInfo company, String cuFilter) throws BOSException, SQLException {
        boolean showDetail = this.cbShowDetail.isSelected();
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("  v.FPeriodID, r.FID FRecordID, hg.FAsstAccountID, r.FASSGRPID FHgID, gt.fid FAssActTypeID, gt.FLongNumber FAssActTypeLongNumber, gt.FName_l2 FAssActTypeName \n");
        if (showDetail) {
            sql.append("  , ve.FID, FEntryID, v.FID FVoucherID, v.FNumber FVoucherNumber, ve.FSeq FEntrySeq, r.FSeq FAsstSeq, p.FNumber FPeriod \n");
        }
        sql.append("from T_GL_Voucher v \n");
        sql.append("join T_BD_Period p on p.fid = v.FPeriodId \n");
        if (showDetail) {
            sql.append("join T_GL_VoucherEntry ve on ve.fbillid = v.fid \n");
            sql.append("join T_GL_VoucherAssistRecord r on r.fentryid = ve.fid \n");
        } else {
            sql.append("join T_GL_VoucherAssistRecord r on r.fbillid = v.fid \n");
        }
        sql.append("join T_BD_ASSISTANTHG hg on hg.fid = r.FASSGRPID \n");
        sql.append("join T_BD_GENERALASSTACTTYPE gt on gt.fid = hg.FGENERALASSACTTYPE1ID \n");
        sql.append("where v.FCompanyId = '" + company.getId() + "' \n");
        if (this.cbFilterPeriod.isSelected()) {
            PeriodInfo to;
            PeriodInfo from = (PeriodInfo)this.periodFrom.getValue();
            if (from != null) {
                sql.append("and p.fnumber >= " + from.getNumber() + " \n");
            }
            if ((to = (PeriodInfo)this.periodTo.getValue()) != null) {
                sql.append("and p.fnumber <= " + to.getNumber() + " \n");
            }
        }
        sql.append("and exists ( \n");
        sql.append("  select top 1 1 \n");
        sql.append("  from T_BD_GeneralAsstActType cg \n");
        sql.append("  inner JOIN T_ORG_CtrlUnit CU ON cg.FControlUnitID = CU.FID \n");
        sql.append("  inner join T_ORG_Company creatorCompany ON cg.FCreatorCompanyID = creatorCompany.FID \n");
        sql.append("  where cg.fparentid = hg.FGENERALASSACTTYPE1ID \n");
        sql.append("  and " + cuFilter + " \n");
        sql.append(") \n");
        sql.append("order by FAsstAccountID \n");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>();
        while (rs.next()) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("periodId", rs.getString("FPeriodID"));
            data.put("recordId", rs.getString("FRecordID"));
            data.put("asstAccountId", rs.getString("FAsstAccountID"));
            data.put("hgId", rs.getString("FHgID"));
            data.put("assActTypeId", rs.getString("FAssActTypeID"));
            data.put("assActTypeLongNumber", rs.getString("FAssActTypeLongNumber"));
            data.put("assActTypeName", rs.getString("FAssActTypeName"));
            if (showDetail) {
                data.put("voucherId", rs.getString("FVoucherID"));
                data.put("entryId", rs.getString("FEntryID"));
                data.put("period", rs.getString("FPeriod"));
                data.put("voucherNumber", rs.getString("FVoucherNumber"));
                data.put("entrySeq", rs.getString("FEntrySeq"));
                data.put("asstSeq", rs.getString("FAsstSeq"));
            }
            datas.add(data);
        }
        return datas;
    }

    private String getCUFilter(CompanyOrgUnitInfo company) {
        StringBuffer cuFilter = new StringBuffer();
        cuFilter.append("(");
        cuFilter.append("cu.FID = '" + company.getCU().getId() + "'");
        String cuLongNumber = company.getCU().getLongNumber();
        if (cuLongNumber == null || cuLongNumber.trim().length() == 0) {
            cuFilter.append(")");
            return cuFilter.toString();
        }
        String ln = cuLongNumber;
        String[] lnSecs = ln.split("!");
        int size = lnSecs.length;
        HashSet<String> lnUps = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size - 1; ++i) {
            if (i != 0) {
                sb.append("!");
            }
            sb.append(lnSecs[i]);
            lnUps.add(sb.toString());
        }
        if (lnUps.size() > 0) {
            cuFilter.append(" or cu.FLongNumber in (");
            for (String in : lnUps) {
                cuFilter.append("'").append(in).append("',");
            }
            cuFilter.deleteCharAt(cuFilter.length() - 1);
            cuFilter.append(")");
        }
        cuFilter.append(")");
        return cuFilter.toString();
    }

    private CompanyOrgUnitInfo queryCompany(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company.getAccountPeriodType() != null) {
            return company;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("accountPeriodType.id");
        CompanyOrgUnitInfo c = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selector);
        company.setAccountPeriodType(c.getAccountPeriodType());
        return company;
    }

    private List<String> queryCompanys() throws SQLException, BOSException {
        ArrayList<String> companyIds = new ArrayList<String>();
        Object[] objects = (Object[])this.promptCompany.getValue();
        if (objects != null && objects.length > 0) {
            for (Object obj : objects) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)obj;
                companyIds.add(company.getId().toString());
            }
            return companyIds;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FCompanyID from t_gl_voucher ");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        while (rs.next()) {
            companyIds.add(rs.getString("FCompanyID"));
        }
        return companyIds;
    }

    private CompanyOrgUnitInfo queryCompany(String companyId) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("longNumber");
        selector.add("name");
        selector.add("CU.id");
        selector.add("CU.number");
        selector.add("CU.longNumber");
        return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
    }

    private AsstAccountInfo getAsstAccount(String asstAccountId) throws BOSException, EASBizException {
        if (this.asstAccounts.containsKey(asstAccountId)) {
            return this.asstAccounts.get(asstAccountId);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("measureUnit.id");
        selector.add("measureUnit.coefficient");
        selector.add("measureUnit.qtyPrecision");
        selector.add("measureUnitGroup.id");
        AsstAccountInfo asstAccount = AsstAccountFactory.getRemoteInstance().getAsstAccountInfo((IObjectPK)new ObjectUuidPK(asstAccountId), selector);
        this.asstAccounts.put(asstAccountId, asstAccount);
        return asstAccount;
    }

    private AsstActTypeCollection getAsstActTypes(String asstAccountId) throws BOSException {
        if (this.asstActTypess.containsKey(asstAccountId)) {
            return this.asstActTypess.get(asstAccountId);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection asstcol = AsstActGroupDetailFactory.getRemoteInstance().getAsstActGroupDetailCollection(view);
        AsstActTypeCollection asstActTypes = new AsstActTypeCollection();
        for (int i = 0; i < asstcol.size(); ++i) {
            asstActTypes.add(asstcol.get(i).getAsstActType());
        }
        this.asstActTypess.put(asstAccountId, asstActTypes);
        return asstActTypes;
    }

    private AssistantHGInfo getOldHg(String oldHgId, AsstActTypeCollection asstActTypes) throws EASBizException, BOSException {
        if (this.hgs.containsKey(oldHgId)) {
            return this.hgs.get(oldHgId);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("numberGroup"));
        for (int i = 0; i < asstActTypes.size(); ++i) {
            AsstActTypeInfo t = asstActTypes.get(i);
            String propName = t.getAsstHGAttribute();
            selector.add(new SelectorItemInfo(propName + ".id"));
            selector.add(new SelectorItemInfo(propName + ".number"));
            selector.add(new SelectorItemInfo(propName + ".name"));
        }
        AssistantHGInfo oldHg = AssistantHGFactory.getRemoteInstance().getAssistantHGInfo((IObjectPK)new ObjectUuidPK(oldHgId), selector);
        this.hgs.put(oldHgId, oldHg);
        return oldHg;
    }

    private AssistantHGInfo getNewHg(String asstAccountId, AsstActTypeCollection asstActTypes, AssistantHGInfo oldHg, Map<String, String> dAssActType) throws BOSException, SQLException, EASBizException {
        AssistantHGInfo newHg = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("numberGroup"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filters = filter.getFilterItems();
        filters.add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        for (int i = 0; i < asstActTypes.size(); ++i) {
            AsstActTypeInfo t = asstActTypes.get(i);
            String propName = t.getAsstHGAttribute();
            if ("generalAssActType1".equals(propName)) {
                filters.add(new FilterItemInfo(propName + ".id", (Object)dAssActType.get("id")));
                continue;
            }
            IObjectValue obj = (IObjectValue)oldHg.get(propName);
            filters.add(new FilterItemInfo(propName + ".id", (Object)obj.get("id").toString()));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(selector);
        view.setFilter(filter);
        AssistantHGCollection newHgColl = AssistantHGFactory.getRemoteInstance().getAssistantHGCollection(view);
        if (newHgColl.size() > 0) {
            return newHgColl.get(0);
        }
        AssistantHGInfo hgInfo = new AssistantHGInfo();
        hgInfo.setId(null);
        hgInfo.setAsstAccount(this.getAsstAccount(asstAccountId));
        for (int i = 0; i < asstActTypes.size(); ++i) {
            String asstHGAttribute = asstActTypes.get(i).getAsstHGAttribute();
            if ("generalAssActType1".equals(asstHGAttribute)) {
                GeneralAsstActTypeInfo type1 = new GeneralAsstActTypeInfo();
                type1.setId(BOSUuid.read((String)dAssActType.get("id")));
                type1.setLongNumber(dAssActType.get("number"));
                type1.setName(dAssActType.get("name"));
                continue;
            }
            Object value = oldHg.get(asstHGAttribute);
            if (value == null) continue;
            hgInfo.put(asstHGAttribute, value);
        }
        newHg = AssistantHGFactory.getRemoteInstance().getAssistantHG(hgInfo, asstAccountId, asstActTypes);
        newHg.put("isNewCreate", (Object)true);
        return newHg;
    }

    private void enableComponent(boolean enable) {
        this.promptCompany.setEnabled(enable);
        this.periodFrom.setEnabled(enable);
        this.periodTo.setEnabled(enable);
        this.cbShowDetail.setEnabled(enable);
        this.cbChange.setEnabled(enable);
    }

    private void showInfo(String message) {
        this.tfInfo.setText(message);
    }

    private void showDetail(String message) {
        this.showDetail(message, false);
    }

    private void showDetail(String message, boolean warn) {
        Document doc = this.taInfo.getDocument();
        try {
            if (warn) {
                doc.insertString(doc.getLength(), message + "\n", this.warnAttr);
            } else {
                doc.insertString(doc.getLength(), message + "\n", this.defAttr);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.taInfo.setSelectionStart(doc.getLength());
    }

    public boolean checkBeforeWindowClosing() {
        this.stop = true;
        return super.checkBeforeWindowClosing();
    }

    public String getResource(String resName) {
        return EASResource.getString((String)RESOURCE, (String)resName);
    }
}

