/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IVoucherHelpFacade;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherHelpFacadeFactory;
import com.kingdee.eas.fi.gl.client.AbstractVoucherAutoVerifyUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class VoucherAutoVerifyUI
extends AbstractVoucherAutoVerifyUI {
    private static final long serialVersionUID = -5700314443481870404L;
    protected int returnValue = 1;
    protected VoucherEntryCollection result;
    private CompanyOrgUnitInfo company = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        String res = "com.kingdee.eas.fi.gl.client.GlResource";
        AccountViewInfo verifyAcc = (AccountViewInfo)this.kbpVerifyAccount.getValue();
        AccountViewInfo cussentAcc = (AccountViewInfo)this.kbpAccount.getValue();
        if (verifyAcc == null || cussentAcc == null || this.kbpCurrency.getValue() == null) {
            String inputMsg = EASResource.getString((String)res, (String)"inputMsg");
            MsgBox.showWarning((Component)((Object)this), (String)inputMsg);
            return;
        }
        if (!verifyAcc.getCAA().getId().toString().equals(cussentAcc.getCAA().getId().toString())) {
            String msg = EASResource.getString((String)res, (String)"CAANotSame");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        if (cussentAcc.getDC().getValue() != verifyAcc.getDC().getValue()) {
            String msg = EASResource.getString((String)res, (String)"DCNotSame");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        CurrencyInfo cur = (CurrencyInfo)this.kbpCurrency.getValue();
        if (!GlUtils.checkAccountAndCurrency(null, verifyAcc, cur, this.company)) {
            String msg1 = EASResource.getString((String)res, (String)"verifyAcc");
            String msg2 = EASResource.getString((String)res, (String)"CurrencyInfo");
            MsgBox.showWarning((Component)((Object)this), (String)(msg1 + verifyAcc.getNumber() + msg2 + cur.getName()));
            return;
        }
        if (!GlUtils.checkAccountAndCurrency(null, cussentAcc, cur, this.company)) {
            String msg1 = EASResource.getString((String)res, (String)"cussentAcc");
            String msg2 = EASResource.getString((String)res, (String)"CurrencyInfo");
            MsgBox.showWarning((Component)((Object)this), (String)(msg1 + cussentAcc.getNumber() + msg2 + cur.getName()));
            return;
        }
        this.setResult(this.buildResult());
        this.setReturnValue(0);
        this.actionCancel_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
        this.initMyIcon();
    }

    private void initData() throws Exception {
        this.company = this.getCurrentPanelCompany();
        boolean foreignCurrencySU = (Boolean)this.getUIContext().get("foreignCurrencySU");
        if (foreignCurrencySU) {
            CurrencyInfo cur = (CurrencyInfo)this.getUIContext().get("currency");
            this.kbpCurrency.setValue((Object)cur);
            this.kbpCurrency.setEnabled(false);
        }
    }

    private void initMyIcon() {
        this.kspCount.setModel((SpinnerModel)new SpinnerNumberModel(1000, 1, 10000, 1));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("AccountTableID.id", (Object)this.company.getAccountTable().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"true"));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("AC", (Object)"true"));
        StringBuffer str = new StringBuffer();
        str.append("#0 and #1 and #2 and #3 and #4 and #5 ");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("longName"));
        view.getSelector().add(new SelectorItemInfo("isQty"));
        view.getSelector().add(new SelectorItemInfo("CAA.name"));
        view.getSelector().add(new SelectorItemInfo("AC"));
        view.getSelector().add(new SelectorItemInfo("ACNotice"));
        view.getSelector().add(new SelectorItemInfo("accountTableID.number"));
        view.getSelector().add(new SelectorItemInfo("accountTableID.name"));
        view.getSorter().add(new SorterItemInfo("number"));
        String nameFormat = "$number$ - $name$";
        String longNameFormat = "$number$ - $longName$";
        boolean isLongName = "1".equals(this.getUIContext().get("isLongName").toString());
        this.kbpAccount.setEditFormat("$number$");
        this.kbpAccount.setEnabledMultiSelection(false);
        this.kbpAccount.setDisplayFormat(isLongName ? longNameFormat : nameFormat);
        this.kbpAccount.setCommitFormat("$number$");
        this.kbpAccount.setRefresh(true);
        this.kbpAccount.setEntityViewInfo(view);
        this.kbpAccount.setSelectorCollection(this.getAccountSelector());
        this.kbpAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.kbpAccount.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this, this.company, this.company.getAccountTable(), filter, false, true));
        this.kbpVerifyAccount.setEditFormat("$number$");
        this.kbpVerifyAccount.setEnabledMultiSelection(false);
        this.kbpVerifyAccount.setDisplayFormat(isLongName ? longNameFormat : nameFormat);
        this.kbpVerifyAccount.setCommitFormat("$number$");
        this.kbpVerifyAccount.setRefresh(true);
        this.kbpVerifyAccount.setEntityViewInfo(view);
        this.kbpVerifyAccount.setSelectorCollection(this.getAccountSelector());
        this.kbpVerifyAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.kbpVerifyAccount.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)this, this.company, this.company.getAccountTable(), filter, false, true));
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    private SelectorItemCollection getAccountSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("AC"));
        sic.add(new SelectorItemInfo("bw"));
        sic.add(new SelectorItemInfo("ACNotice"));
        sic.add(new SelectorItemInfo("control"));
        sic.add(new SelectorItemInfo("isCash"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("isCashEquivalent"));
        sic.add(new SelectorItemInfo("hasUserProperty"));
        sic.add(new SelectorItemInfo("isGFreeze"));
        sic.add(new SelectorItemInfo("isCFreeze"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("PLType"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("measureUnitID.number"));
        sic.add(new SelectorItemInfo("measureUnitID.name"));
        sic.add(new SelectorItemInfo("measureUnitID.coefficient"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("CAA.id"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.number"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.name"));
        sic.add(new SelectorItemInfo("CAA.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("CAA.measureUnitGroup.id"));
        sic.add(new SelectorItemInfo("CAA.isQty"));
        sic.add(new SelectorItemInfo("CAA.name"));
        sic.add(new SelectorItemInfo("CAA.number"));
        sic.add(new SelectorItemInfo("companyID.id"));
        sic.add(new SelectorItemInfo("accountTableID.id"));
        return sic;
    }

    private IVoucherHelpFacade getBizInterface() throws Exception {
        return VoucherHelpFacadeFactory.getRemoteInstance();
    }

    public void setReturnValue(int rv) {
        this.returnValue = rv;
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public void setResult(VoucherEntryCollection entries) {
        this.result = entries;
    }

    public VoucherEntryCollection getResult() {
        return this.result;
    }

    public VoucherEntryCollection buildResult() throws Exception {
        AccountViewInfo verifyAcc = (AccountViewInfo)this.kbpVerifyAccount.getValue();
        AccountViewInfo cussentAcc = (AccountViewInfo)this.kbpAccount.getValue();
        CurrencyInfo cur = (CurrencyInfo)this.kbpCurrency.getValue();
        int count = (Integer)this.kspCount.getValue();
        VoucherAssistRecordCollection asstRecords = this.getBizInterface().createVerifyAssistRecords(verifyAcc.getId().toString(), verifyAcc.getCAA().getId().toString(), cur.getId().toString(), count, this.company.getId().toString());
        if (asstRecords == null || asstRecords.size() == 0) {
            String res = "com.kingdee.eas.fi.gl.client.GlResource";
            String msg = EASResource.getString((String)res, (String)"NoRecord");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
        VoucherEntryCollection entries = new VoucherEntryCollection();
        VoucherEntryInfo entry = new VoucherEntryInfo();
        entry.setAccount(verifyAcc);
        entry.setCAA(verifyAcc.getCAA());
        entry.setEntryDC(verifyAcc.getDC().getValue() == 1 ? EntryDC.CREDIT : EntryDC.DEBIT);
        entry.setCurrency(cur);
        entry.setAssistRecords((AbstractObjectCollection)asstRecords);
        entry.setIsVerify(true);
        entries.add(entry);
        VoucherEntryInfo entry2 = new VoucherEntryInfo();
        entry2.setAccount(cussentAcc);
        entry2.setEntryDC(cussentAcc.getDC().getValue() == 1 ? EntryDC.DEBIT : EntryDC.CREDIT);
        entry2.setCurrency(cur);
        VoucherAssistRecordCollection asstRecords2 = (VoucherAssistRecordCollection)asstRecords.clone();
        entry2.setAssistRecords((AbstractObjectCollection)asstRecords2);
        int size = asstRecords2.size();
        for (int j = 0; j < size; ++j) {
            VoucherAssistRecordInfo rec = asstRecords2.get(j);
            rec.setVerifiedCussent(null);
        }
        entry2.setIsVerify(false);
        entries.add(entry2);
        return entries;
    }

    private CompanyOrgUnitInfo getCurrentPanelCompany() {
        CompanyOrgUnitInfo company = null;
        company = this.getUIContext().get("COMPANY") != null ? (CompanyOrgUnitInfo)this.getUIContext().get("COMPANY") : SysContext.getSysContext().getCurrentFIUnit();
        return company;
    }
}

