/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.client.AbstractVoucherBalanceEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class VoucherBalanceEditUI
extends AbstractVoucherBalanceEditUI {
    private VoucherEntryInfo voucherEntry = null;
    private CompanyOrgUnitInfo curCompany = null;
    private CurrencyInfo localCurrency = null;
    private CurrencyInfo rptCurrency = null;
    private boolean usingRpt = false;
    private static final long serialVersionUID = -2700500942715769049L;
    private static final Logger logger = CoreUIObject.getLogger(VoucherBalanceEditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.toolBar.setVisible(false);
        SysContext ctx = SysContext.getSysContext();
        BigDecimal lamount = (BigDecimal)this.getUIContext().get("LocalAmount");
        BigDecimal ramount = (BigDecimal)this.getUIContext().get("RptAmount");
        this.localCurrency = (CurrencyInfo)this.getUIContext().get("BaseCurrency");
        this.rptCurrency = (CurrencyInfo)this.getUIContext().get("RptCurrency");
        this.usingRpt = (Boolean)this.getUIContext().get("useReportingCurrency");
        this.comboEntryDC.setSelectedItem((Object)(lamount.signum() > 0 ? EntryDC.CREDIT : EntryDC.DEBIT));
        this.txtOriginalAmount.setHorizontalAlignment(4);
        this.txtOriginalAmount.setDataVerifierType(-1);
        this.txtOriginalAmount.setSupportedEmpty(true);
        this.txtOriginalAmount.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        this.txtOriginalAmount.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        this.txtOriginalAmount.setValue((Object)GlUtils.zero);
        this.txtLocalAmount.setHorizontalAlignment(4);
        this.txtLocalAmount.setDataVerifierType(-1);
        this.txtLocalAmount.setSupportedEmpty(true);
        this.txtLocalAmount.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        this.txtLocalAmount.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        if (this.localCurrency != null) {
            this.txtLocalAmount.setPrecision(this.localCurrency.getPrecision());
        }
        this.txtLocalAmount.setValue((Object)lamount.abs());
        this.txtReportAmount.setHorizontalAlignment(4);
        this.txtReportAmount.setDataVerifierType(-1);
        this.txtReportAmount.setSupportedEmpty(true);
        this.txtReportAmount.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        this.txtReportAmount.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        if (!this.usingRpt) {
            this.txtReportAmount.setVisible(false);
            if (this.rptCurrency != null) {
                this.txtReportAmount.setPrecision(this.rptCurrency.getPrecision());
            }
        }
        this.txtReportAmount.setValue((Object)ramount.abs());
        this.curCompany = ctx.getCurrentFIUnit();
        SelectorItemCollection sic = new SelectorItemCollection();
        this.prmtAccount.setEditable(true);
        this.prmtAccount.setEditFormat("$number$");
        this.prmtAccount.setDisplayFormat("$number$");
        this.prmtAccount.setCommitFormat("$helpCode$;$number$;$name$");
        this.prmtAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("AC"));
        sic.add(new SelectorItemInfo("control"));
        sic.add(new SelectorItemInfo("isCash"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("isCashEquivalent"));
        sic.add(new SelectorItemInfo("hasUserProperty"));
        sic.add(new SelectorItemInfo("isGFreeze"));
        sic.add(new SelectorItemInfo("isCFreeze"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("PLType"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("measureUnitID.number"));
        sic.add(new SelectorItemInfo("measureUnitID.name"));
        sic.add(new SelectorItemInfo("measureUnitID.coefficient"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("CAA.id"));
        sic.add(new SelectorItemInfo("companyID.id"));
        sic.add(new SelectorItemInfo("accountTableID.id"));
        this.prmtAccount.setSelectorCollection(sic);
        this.prmtAccount.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID, CompareType.NOTEQUALS));
                fic.add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID, CompareType.NOTEQUALS));
                filter.setMaskString("#0 AND #1");
                AccountViewInfo acc = (AccountViewInfo)VoucherBalanceEditUI.this.prmtAccount.getValue();
                if (acc != null) {
                    try {
                        SelectorItemCollection selector = new SelectorItemCollection();
                        selector.add(new SelectorItemInfo("id"));
                        selector.add(new SelectorItemInfo("accountingcurrency"));
                        selector.add(new SelectorItemInfo("accountCurrency.currency.id"));
                        acc = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(acc.getId().toString()), selector);
                    }
                    catch (EASBizException selector) {
                    }
                    catch (BOSException selector) {
                        // empty catch block
                    }
                    if (acc.getAccountingcurrency().getValue() == 0) {
                        fic.add(new FilterItemInfo("id", (Object)VoucherBalanceEditUI.this.curCompany.getBaseCurrency().getId()));
                        filter.setMaskString("#0 AND #1 AND #2");
                    } else if (acc.getAccountingcurrency().getValue() == 1) {
                        AccountCurrencyCollection cc = acc.getAccountCurrency();
                        Iterator iter = cc.iterator();
                        StringBuffer mask = new StringBuffer("#0 AND #1 AND (#2");
                        fic.add(new FilterItemInfo("id", (Object)"11111111-1111-1111-1111-11111111111111111111"));
                        int i = 3;
                        while (iter.hasNext()) {
                            fic.add(new FilterItemInfo("id", (Object)((AccountCurrencyInfo)iter.next()).getCurrency().getId()));
                            mask.append(" OR #").append(i++);
                        }
                        mask.append(")");
                        filter.setMaskString(mask.toString());
                    }
                    VoucherBalanceEditUI.this.prmtCurrency.setEntityViewInfo(view);
                    try {
                        CurrencyCollection col = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
                        VoucherBalanceEditUI.this.prmtCurrency.setValue((Object)col.get(0));
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                    }
                }
            }
        });
        String accouttable = this.curCompany.getAccountTable().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)this.curCompany.getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("control", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("control", null));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)accouttable));
        fic.add(new FilterItemInfo("CAA.id", null));
        filter.setMaskString("#0 AND #1 AND #2  AND ( #3 or  #4)  AND #5 AND #6");
        AccountPromptBox pb = new AccountPromptBox((IUIObject)this, this.curCompany, filter, false, true);
        FilterInfo newFilter = new FilterInfo();
        newFilter = (FilterInfo)filter.clone();
        newFilter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        newFilter.setMaskString("#0 AND #1 AND #2  AND ( #3 or  #4)  AND #5 AND #6 AND #7");
        this.prmtAccount.setEntityViewInfo(view);
        view.setFilter(newFilter);
        this.prmtAccount.setSelector((KDPromptSelector)pb);
        this.prmtCurrency.setEditable(true);
        this.prmtCurrency.setEditFormat("$number$");
        this.prmtCurrency.setDisplayFormat("$name$");
        this.prmtCurrency.setCommitFormat("$number$");
        this.prmtCurrency.setQueryInfo("com.kingdee.eas.fi.gl.app.VoucherCurrencyQuery");
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("deletedStatus"));
        this.prmtCurrency.setSelectorCollection(sic);
        this.prmtCurrency.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                CurrencyInfo currency = (CurrencyInfo)VoucherBalanceEditUI.this.prmtCurrency.getValue();
                if (currency != null) {
                    VoucherBalanceEditUI.this.txtOriginalAmount.setPrecision(currency.getPrecision());
                }
            }
        });
    }

    protected CompanyOrgUnitInfo getCurrentCompany() {
        CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        return org;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.voucherEntry = new VoucherEntryInfo();
        AccountViewInfo account = (AccountViewInfo)this.prmtAccount.getValue();
        if (account == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"36_VoucherBalanceEditUI"));
            this.voucherEntry = null;
            return;
        }
        this.voucherEntry.setAccount(account);
        CurrencyInfo currency = (CurrencyInfo)this.prmtCurrency.getValue();
        if (currency == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"37_VoucherBalanceEditUI"));
            this.voucherEntry = null;
            return;
        }
        this.voucherEntry.setCurrency(currency);
        BigDecimal local = this.txtLocalAmount.getBigDecimalValue();
        if (local == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"38_VoucherBalanceEditUI"));
            this.voucherEntry = null;
            return;
        }
        if (local.doubleValue() == 0.0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"39_VoucherBalanceEditUI"));
            this.voucherEntry = null;
            return;
        }
        this.voucherEntry.setLocalAmount(local);
        this.voucherEntry.setReportingAmount(this.txtReportAmount.getBigDecimalValue() == null ? GlUtils.zero : this.txtReportAmount.getBigDecimalValue());
        this.voucherEntry.setOriginalAmount(this.txtOriginalAmount.getBigDecimalValue() == null ? GlUtils.zero : this.txtOriginalAmount.getBigDecimalValue());
        this.voucherEntry.setEntryDC((EntryDC)this.comboEntryDC.getSelectedItem());
        this.voucherEntry.setDescription(this.txtDescription.getStringValue());
        this.uiWindow.close();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.voucherEntry = null;
        this.uiWindow.close();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return VoucherFactory.getRemoteInstance();
    }

    protected void inOnload() throws Exception {
    }

    public VoucherEntryInfo getVoucherEntry() {
        return this.voucherEntry;
    }
}

