/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.AbstractVoucherConvertUI;
import com.kingdee.eas.fi.gl.client.PoiEventUserModelXlsxReader;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class VoucherConvertUI
extends AbstractVoucherConvertUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherConvertUI.class);
    public static final DateFormat DF_LOG = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLAutoGenerateResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() {
        this.kDScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
        this.kDScrollPane2.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int height = VoucherConvertUI.this.getSize().height;
                if (height > 300) {
                    VoucherConvertUI.this.kDSplitPane1.setDividerLocation(height - 200);
                }
            }
        });
        this.btnFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File defaultPath = new File("vouchers");
                JFileChooser chooser = new JFileChooser();
                String currentPath = VoucherConvertUI.this.tfFile.getText();
                if (currentPath != null && currentPath.trim().length() > 0) {
                    File parent;
                    File dir = new File(currentPath);
                    if (dir.isDirectory()) {
                        parent = dir.getParentFile();
                        if (parent != null) {
                            chooser.setCurrentDirectory(parent);
                        } else {
                            chooser.setCurrentDirectory(dir);
                        }
                    } else {
                        parent = dir.getParentFile();
                        if (parent != null) {
                            chooser.setCurrentDirectory(parent);
                        } else {
                            chooser.setCurrentDirectory(defaultPath);
                        }
                    }
                } else {
                    chooser.setCurrentDirectory(defaultPath);
                }
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "Excel(*.xlsx)";
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".xlsx");
                    }
                });
                chooser.setFileSelectionMode(2);
                chooser.setAcceptAllFileFilterUsed(false);
                int result = chooser.showOpenDialog((Component)((Object)VoucherConvertUI.this));
                if (result == 0) {
                    String selectedPath = chooser.getSelectedFile().getAbsolutePath();
                    VoucherConvertUI.this.tfFile.setText(selectedPath);
                }
            }
        });
        this.btnOpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = null;
                String currentPath = VoucherConvertUI.this.tfFile.getText();
                if (currentPath != null && (currentPath = currentPath.trim()).length() > 0) {
                    file = new File(currentPath);
                }
                if (file != null && file.isFile()) {
                    VoucherConvertUI.this.open(file);
                } else {
                    VoucherConvertUI.this.btnFilePositionActionPerformed(e);
                }
            }
        });
        this.btnFilePosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VoucherConvertUI.this.btnFilePositionActionPerformed(e);
            }
        });
        Map context = this.getUIContext();
        if (context.get("path") != null) {
            this.tfFile.setText(context.get("path").toString().trim());
        }
    }

    public void btnFilePositionActionPerformed(ActionEvent e) {
        File defaultPath = new File("vouchers");
        String currentPath = this.tfFile.getText();
        if (currentPath == null || currentPath.trim().length() == 0) {
            this.explorerFile(defaultPath, false);
            return;
        }
        File currentFile = new File(currentPath = currentPath.trim());
        if (currentFile.exists()) {
            this.explorerFile(currentFile, true);
        } else {
            File parent = currentFile.getParentFile();
            if (parent != null) {
                if (parent.isDirectory()) {
                    this.explorerFile(parent, false);
                } else {
                    JOptionPane.showMessageDialog(this.getTopLevelAncestor(), parent.getAbsolutePath() + "\uff1a" + this.getResource("dictory_not_exist"));
                }
            }
        }
    }

    public void open(File file) {
        String command = "cmd /c start " + file.getAbsolutePath();
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void explorerFile(File file, boolean select) {
        if (file != null) {
            try {
                String command = "explorer ";
                if (select) {
                    command = command + "/select, ";
                }
                command = command + file.getAbsolutePath();
                Runtime.getRuntime().exec(command);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void actionVoucherImport_actionPerformed(ActionEvent e) throws Exception {
        String path = this.tfFile.getText();
        if (path == null || path.trim().length() == 0) {
            this.error(this.getResource("please_provide_file_position"));
            return;
        }
        File file = new File(path = path.trim());
        if (!file.exists() || file.isDirectory()) {
            this.error(this.getResource("please_provide_file_position"));
            return;
        }
        LinkedHashMap<String, List<List<String>>> liness = PoiEventUserModelXlsxReader.read(file);
        if (liness.size() > 0) {
            Iterator<String> iterator = liness.keySet().iterator();
            if (iterator.hasNext()) {
                String sheetName = iterator.next();
                List<List<String>> lines = liness.get(sheetName);
                this.tpContent.setText(JSON.toJSONString(lines));
            }
            this.info(this.getResource("import_finished"));
        } else {
            this.info(this.getResource("file_no_data"));
        }
    }

    @Override
    public void actionVoucherExport_actionPerformed(ActionEvent e) throws Exception {
        String content;
        String path = this.tfFile.getText();
        if (path == null || path.trim().length() == 0) {
            this.error(this.getResource("please_provide_file_position"));
            return;
        }
        File file = new File(path = path.trim());
        if (file.isDirectory()) {
            this.error(this.getResource("please_provide_file_position"));
            return;
        }
        if (!file.exists()) {
            File parent = file.getParentFile();
            if (parent == null || !parent.isDirectory()) {
                this.error(this.getResource("file_not_exist"));
                return;
            }
        } else {
            int r = MsgBox.showConfirm2New((Component)((Object)this), (String)this.getResource("isCover"));
            if (r != 0) {
                return;
            }
        }
        if ((content = this.tpContent.getText()) == null) {
            this.error(this.getResource("no_voucher_data"));
            return;
        }
        if ((content = content.trim()).length() == 0) {
            this.error(this.getResource("no_voucher_data"));
            return;
        }
        List dataRows = null;
        try {
            dataRows = (List)JSON.parseObject((String)content, List.class);
            this.buildExcel(dataRows, path);
            this.info(this.getResource("export_finished"));
        }
        catch (Exception ex) {
            this.error(this.getResource("please_check_voucherdata_format"));
            this.error(ex);
            return;
        }
        if (dataRows != null && dataRows.size() > 0) {
            this.open(new File(path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildExcel(List<List> dataRows, String filepath) throws Exception {
        int i;
        SXSSFWorkbook workbook = new SXSSFWorkbook(500);
        SXSSFSheet currentSheet = workbook.createSheet(this.getResource("voucher"));
        Row row = currentSheet.createRow(0);
        List head = dataRows.get(0);
        for (i = 0; i < head.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue((String)head.get(i));
        }
        for (i = 1; i < dataRows.size(); ++i) {
            row = currentSheet.createRow(i);
            List items = dataRows.get(i);
            for (int j = 0; j < items.size(); ++j) {
                Object value = items.get(j);
                if (value == null) {
                    row.createCell(j).setCellValue("");
                    continue;
                }
                if (value instanceof String) {
                    row.createCell(j).setCellValue((String)value);
                    continue;
                }
                if (value instanceof Integer) {
                    row.createCell(j).setCellValue((double)((Integer)value).intValue());
                    continue;
                }
                if (value instanceof BigDecimal) {
                    row.createCell(j).setCellValue(((BigDecimal)value).doubleValue());
                    continue;
                }
                if (value instanceof Double) {
                    row.createCell(j).setCellValue(((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    row.createCell(j).setCellValue(String.valueOf(value));
                    continue;
                }
                row.createCell(j).setCellValue(value.toString());
            }
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(filepath);
            workbook.write((OutputStream)os);
            os.flush();
        }
        finally {
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public void info(String msg) {
        this.log(DF_LOG.format(new Date()) + " " + msg, Color.black);
    }

    public void error(String msg) {
        this.log(DF_LOG.format(new Date()) + " " + msg, Color.red);
    }

    public void error(Throwable t) {
        this.error(GlUtils.printStackTrace(t));
    }

    private synchronized void log(final String msg, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleAttributeSet attributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(attributeSet, color);
                Document doc = VoucherConvertUI.this.tpConsole.getDocument();
                try {
                    doc.insertString(doc.getLength(), msg + "\n", attributeSet);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                VoucherConvertUI.this.tpConsole.setSelectionStart(doc.getLength());
            }
        });
    }

    public String getResource(String resName) {
        return EASResource.getString((String)RESOURCE, (String)resName);
    }
}

