/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.kdf.data.impl.ICrossPrintDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.ui.NoteFileDialog;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherCrossProvider;
import com.kingdee.eas.fi.gl.VoucherPrintSettingInfo;
import com.kingdee.eas.fi.gl.client.AbstractVoucherCrossPrintParamUI;
import com.kingdee.eas.fi.gl.client.VoucherEditParam;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class VoucherCrossPrintParamUI
extends AbstractVoucherCrossPrintParamUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherCrossPrintParamUI.class);
    VoucherCollection vchCol = null;
    VoucherEditParam editParam = null;
    String path1 = null;
    String path2 = null;

    public VoucherCrossPrintParamUI() throws Exception {
        this.actionComfirm.setEnabled(true);
        this.actionCancel.setEnabled(true);
        this.actionPrint.setEnabled(true);
        this.actionSelect1.setEnabled(true);
        this.actionSelect2.setEnabled(true);
    }

    public void onLoad() throws Exception {
        this.loadFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        Map ctx = this.getUIContext();
        this.editParam = (VoucherEditParam)ctx.get("editParam");
        this.vchCol = (VoucherCollection)ctx.get("VoucherCollection");
        String path = this.editParam.getTemplatepath1();
        if (path != null) {
            this.txtPrintTemplate1.setText(path);
        }
        if ((path = this.editParam.getTemplatepath2()) != null) {
            this.txt.setText(path);
        }
        this.path1 = this.editParam.getTemplatepathPath1();
        this.txt.setEditable(false);
        this.txtPrintTemplate1.setEditable(false);
        this.path2 = this.editParam.getTemplatepathPath2();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void save() {
        this.editParam.setTemplatepath2(this.txt.getText());
        this.editParam.setTemplatepath1(this.txtPrintTemplate1.getText());
        this.editParam.setTemplatepathPath2(this.path2);
        this.editParam.setTemplatepathPath1(this.path1);
        try {
            this.editParam.sync();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void print(boolean preview) throws EASBizException, BOSException {
        String templatePath1 = this.path1;
        String templatePath2 = this.path2;
        String[] templates = new String[]{templatePath1, templatePath2};
        VoucherPrintSettingInfo setting = this.getVoucherPrintSettingInfo();
        Locale locale = SysContext.getSysContext().getLocale();
        ICrossPrintDataProvider[] datas = new ICrossPrintDataProvider[]{new VoucherCrossProvider(locale, this.vchCol, setting, false, false), new VoucherCrossProvider(locale, this.vchCol, setting, true, false)};
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.crossPrint(templates, datas, preview, (Component)((Object)this));
    }

    private VoucherPrintSettingInfo getVoucherPrintSettingInfo() {
        boolean isPrintCashflowMeOrOther = true;
        isPrintCashflowMeOrOther = this.editParam.isRdobPrintCashflow() && !this.editParam.isRdobPrintCashflowOther();
        VoucherPrintSettingInfo setting = new VoucherPrintSettingInfo();
        setting.setPrintCashFlow(this.editParam.isBchkPrintCashFlow());
        setting.setPrintAssistant(this.editParam.isBchkAssistant());
        setting.setShowAsstFullName(this.editParam.isShowChkShowAsstDetail());
        setting.setShowAsstNumber(this.editParam.isChkShowAsstNumber());
        setting.setAutoMachAsstTemplate(this.editParam.isChkAutoMatching());
        setting.setAutoMachMulCurrencyTemplate(this.editParam.isChkAutoDuoCurrency());
        setting.setPrintCashflowMeOrOther(isPrintCashflowMeOrOther);
        setting.setShowAccountNumber(this.editParam.isChkShowAccountNumber());
        setting.setShowAccountFullName(this.editParam.isChkShowAccountDetail());
        setting.setNotPrintSelectedAss(this.editParam.isChkSelectorActTypeNotPrint());
        setting.setSeleectedAsstList(this.editParam.getStrAsstActSelectedList());
        setting.setNotPrintSelectedAccountAsst(this.editParam.isChkSelectorAccountNotPrintAsst());
        setting.setSelectedAccountList(this.editParam.getStrSelectedList());
        return setting;
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.save();
        this.print(true);
    }

    @Override
    public void actionComfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionComfirm_actionPerformed(e);
        this.save();
        this.disposeUIWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.save();
        this.print(false);
    }

    @Override
    public void actionSelect1_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelect1_actionPerformed(e);
        String lastpath = this.txtPrintTemplate1.getText();
        KDNoteHelper appHlp = new KDNoteHelper();
        String[] result = appHlp.selectTemplatePath((Component)((Object)this), lastpath, "/FI/GL/Voucher");
        if (result == null) {
            return;
        }
        this.path1 = result[0];
        this.txtPrintTemplate1.setText(result[1]);
    }

    @Override
    public void actionSelect2_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelect2_actionPerformed(e);
        String lastpath = this.txt.getText();
        KDNoteHelper appHlp = new KDNoteHelper();
        String[] result = appHlp.selectTemplatePath((Component)((Object)this), lastpath, "/FI/GL/Voucher");
        if (result == null) {
            return;
        }
        this.path2 = result[0];
        this.txt.setText(result[1]);
    }

    private String getPath(String lastpath, String path) {
        NoteFileDialog nfDlg = new NoteFileDialog();
        nfDlg.setShowFileName(true);
        nfDlg.setNoteType(path);
        String noteName2 = PathUtil.getLastName((String)lastpath);
        nfDlg.setNoteName(noteName2);
        if (nfDlg.showDialog()) {
            return nfDlg.getRelativeNotePathText();
        }
        return null;
    }
}

