/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.VoucherHelpFacadeFactory;
import java.util.HashMap;
import java.util.Map;

public class VoucherEditCache {
    public static final String KEY = "voucherEditCache";
    private static VoucherEditCache instance = null;
    private Map<String, IObjectValue> defaultAssistantHgInfos = new HashMap<String, IObjectValue>();
    private Map<String, GeneralAsstActTypeGroupInfo> generalAsstActTypeGroups = new HashMap<String, GeneralAsstActTypeGroupInfo>();

    public static synchronized VoucherEditCache getInstance() {
        if (instance == null) {
            instance = new VoucherEditCache();
        }
        return instance;
    }

    public static synchronized void clear() {
        instance = new VoucherEditCache();
    }

    private String getVKey(String vkey) {
        if (this == instance) {
            return SysContext.getSysContext().getDCNumber() + "_" + vkey;
        }
        return vkey;
    }

    public IObjectValue getDefaultAssistantHgInfo(String accountId, String caaId) throws EASBizException, BOSException {
        if (accountId == null || caaId == null) {
            return null;
        }
        String vkey = this.getVKey(accountId + "_" + caaId);
        if (this.defaultAssistantHgInfos.containsKey(vkey)) {
            return this.defaultAssistantHgInfos.get(vkey);
        }
        IObjectValue def = VoucherHelpFacadeFactory.getRemoteInstance().getDefaultAssistantHgInfo((IObjectPK)new ObjectUuidPK(accountId), caaId);
        this.defaultAssistantHgInfos.put(vkey, def);
        return def;
    }

    public GeneralAsstActTypeGroupInfo getGeneralAsstActTypeGroupInfo(String groupId) {
        if (groupId == null) {
            return null;
        }
        String vkey = this.getVKey(groupId);
        if (this.generalAsstActTypeGroups.containsKey(vkey)) {
            return this.generalAsstActTypeGroups.get(vkey);
        }
        GeneralAsstActTypeGroupInfo info = null;
        try {
            info = GeneralAsstActTypeGroupFactory.getRemoteInstance().getGeneralAsstActTypeGroupInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)groupId)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.generalAsstActTypeGroups.put(vkey, info);
        return info;
    }
}

