/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.rpc.RPCException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AccountBalanceFactory;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLAsstBalanceInfo;
import com.kingdee.eas.fi.gl.GLBalanceInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.client.ShowWorkButton;
import com.kingdee.eas.fi.gl.client.VoucherAssistRecordData;
import com.kingdee.eas.fi.gl.client.VoucherEditBaseUI;
import com.kingdee.eas.fi.gl.client.VoucherEntryData;
import com.kingdee.eas.fi.gl.client.VoucherUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

class VoucherEditUIBalanceMonitor {
    private VoucherEditBaseUI ui;
    private CurrencyInfo localCurr;
    private boolean foreignCurrencySU = false;
    private VoucherInfo newVoucher;
    private VoucherInfo oldVoucher;
    private boolean isEdit = false;
    protected static final Logger logger = CoreUIObject.getLogger(VoucherEditUIBalanceMonitor.class);

    protected VoucherEditUIBalanceMonitor(VoucherEditBaseUI ui, CurrencyInfo localCurr, boolean isEdit, boolean foreignCurrencySU) {
        this.ui = ui;
        this.localCurr = localCurr;
        this.foreignCurrencySU = foreignCurrencySU;
        this.newVoucher = this.getNewVoucher(isEdit);
        if (ui.oldVoucher != null && ui.oldVoucher.getBizStatus() == VoucherStatusEnum.SUBMITTED && isEdit) {
            this.oldVoucher = ui.oldVoucher;
        }
        this.isEdit = isEdit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void show(final AccountViewInfo account, final CurrencyInfo currency, final boolean isCredit, final AssistantHGInfo hg) {
        class BanlanceTask
        extends Thread {
            private int version = 0;

            public BanlanceTask(int version) {
                this.version = version;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (account == null || currency == null) {
                    VoucherEditUIBalanceMonitor.this.ui.showWorkButton("", "", false);
                    return;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object object = ((VoucherEditUIBalanceMonitor)VoucherEditUIBalanceMonitor.this).ui.balSynObj;
                synchronized (object) {
                    if (this.version != ((VoucherEditUIBalanceMonitor)VoucherEditUIBalanceMonitor.this).ui.balSynVer) {
                        return;
                    }
                }
                BigDecimal[] amounts = null;
                BigDecimal[] amountsBase = null;
                CompanyOrgUnitInfo company = ((VoucherEditUIBalanceMonitor)VoucherEditUIBalanceMonitor.this).ui.editData.getCompany();
                boolean isBaseCurrencyQuery = company.getBaseCurrency().getId().toString().equals(currency.getId().toString());
                try {
                    List list;
                    if (hg != null) {
                        list = VoucherEditUIBalanceMonitor.this.getAssistBalance2(VoucherEditUIBalanceMonitor.this.oldVoucher, VoucherEditUIBalanceMonitor.this.newVoucher, account, currency, hg, isCredit, VoucherEditUIBalanceMonitor.this.isEdit);
                        amounts = (BigDecimal[])list.get(0);
                        if (!isBaseCurrencyQuery) {
                            amountsBase = (BigDecimal[])list.get(1);
                        }
                    } else {
                        list = VoucherEditUIBalanceMonitor.this.getAccountBalance2(VoucherEditUIBalanceMonitor.this.oldVoucher, VoucherEditUIBalanceMonitor.this.newVoucher, account, currency, isCredit, VoucherEditUIBalanceMonitor.this.isEdit);
                        amounts = (BigDecimal[])list.get(0);
                        if (!isBaseCurrencyQuery) {
                            amountsBase = (BigDecimal[])list.get(1);
                        }
                    }
                }
                catch (RPCException ex) {
                    try {
                        List list;
                        if (hg != null) {
                            list = VoucherEditUIBalanceMonitor.this.getAssistBalance2(VoucherEditUIBalanceMonitor.this.oldVoucher, VoucherEditUIBalanceMonitor.this.newVoucher, account, currency, hg, isCredit, VoucherEditUIBalanceMonitor.this.isEdit);
                            amounts = (BigDecimal[])list.get(0);
                            if (!isBaseCurrencyQuery) {
                                amountsBase = (BigDecimal[])list.get(1);
                            }
                        } else {
                            list = VoucherEditUIBalanceMonitor.this.getAccountBalance2(VoucherEditUIBalanceMonitor.this.oldVoucher, VoucherEditUIBalanceMonitor.this.newVoucher, account, currency, isCredit, VoucherEditUIBalanceMonitor.this.isEdit);
                            amounts = (BigDecimal[])list.get(0);
                            if (!isBaseCurrencyQuery) {
                                amountsBase = (BigDecimal[])list.get(1);
                            }
                        }
                    }
                    catch (Exception ex1) {
                        System.out.println(((VoucherEditUIBalanceMonitor)VoucherEditUIBalanceMonitor.this).ui.curEntryIndex);
                        logger.error((Object)ex1);
                    }
                    logger.error((Object)ex.getStackTrace(), (Throwable)ex);
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getStackTrace(), (Throwable)ex);
                }
                String balTxt = VoucherEditUIBalanceMonitor.this.getAmountTxt(account, isCredit, (BigDecimal)amounts[0], (BigDecimal)amounts[1], (BigDecimal)amounts[2]);
                String balTxtBase = "";
                if (!isBaseCurrencyQuery) {
                    balTxtBase = VoucherEditUIBalanceMonitor.this.getAmountTxt(account, isCredit, amountsBase[0], amountsBase[1], amountsBase[2]);
                    balTxt = currency.getName() + ":" + balTxtBase + "  " + company.getBaseCurrency().getName() + ":" + balTxt;
                }
                String[] txt = VoucherEditUIBalanceMonitor.this.getDisplayName(account, hg, balTxt);
                ShowWorkButton showButton = new ShowWorkButton(VoucherEditUIBalanceMonitor.this.ui, txt, amounts[2]);
                Object object2 = ((VoucherEditUIBalanceMonitor)VoucherEditUIBalanceMonitor.this).ui.balSynObj;
                synchronized (object2) {
                    if (this.version == ((VoucherEditUIBalanceMonitor)VoucherEditUIBalanceMonitor.this).ui.balSynVer) {
                        SwingUtilities.invokeLater(showButton);
                    }
                }
            }
        }
        BanlanceTask t;
        Object object = this.ui.balSynObj;
        synchronized (object) {
            if (this.ui.balSynVer == Integer.MAX_VALUE) {
                this.ui.balSynVer = 0;
            }
            t = new BanlanceTask(++this.ui.balSynVer);
        }
        t.start();
    }

    private VoucherInfo getNewVoucher(boolean isEdit) {
        CurrencyInfo currency = (CurrencyInfo)this.ui.cbxCurrency.getSelectedItem();
        if (this.foreignCurrencySU && currency == null) {
            MsgBox.info((String)"info", (String)"Please select currency!", (Component)((Object)this.ui));
            SysUtil.abort();
        }
        VoucherInfo newVoucher = new VoucherInfo();
        if (!isEdit) {
            newVoucher.setCompany(this.ui.editData.getCompany());
            newVoucher.setPeriod(this.ui.editData.getPeriod());
            newVoucher.setBizStatus(this.ui.editData.getBizStatus());
        } else {
            newVoucher.setCompany(this.ui.editData.getCompany());
            newVoucher.setPeriod((PeriodInfo)this.ui.cbxPeriod.getSelectedItem());
            newVoucher.setBizStatus(this.ui.editData.getBizStatus());
            int rowCount = this.ui.tblDetail.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                IRow entryRow = this.ui.tblDetail.getRow(i);
                VoucherEntryInfo entry = null;
                if (i == this.ui.curEntryIndex) {
                    entry = this.genVoucherEntryInfo(entryRow, currency);
                } else {
                    VoucherEntryData lineData = (VoucherEntryData)this.ui.tblDetail.getRow(i).getUserObject();
                    entry = lineData.getEntry();
                }
                if (entry == null) continue;
                newVoucher.getEntries().add(entry);
            }
        }
        return newVoucher;
    }

    private VoucherEntryInfo genVoucherEntryInfo(IRow entryRow, CurrencyInfo currency) {
        Object obj = entryRow.getCell("e.account").getValue();
        AccountViewInfo account = null;
        account = obj instanceof Object[] ? (AccountViewInfo)((Object[])obj)[0] : (AccountViewInfo)obj;
        if (!this.foreignCurrencySU) {
            currency = (CurrencyInfo)entryRow.getCell("e.currency").getValue();
        }
        if (account == null || currency == null) {
            return null;
        }
        VoucherEntryInfo entry = new VoucherEntryInfo();
        entry.setAccount(account);
        entry.setCurrency(currency);
        ICell amntCell = entryRow.getCell("e.amount");
        BigDecimal entryOAmount = (BigDecimal)amntCell.getValue();
        if (entryOAmount == null) {
            entryOAmount = GlUtils.zero;
        }
        entry.setOriginalAmount(entryOAmount);
        EntryDC dc = (EntryDC)amntCell.getUserObject();
        if (dc == null) {
            dc = EntryDC.DEBIT;
        }
        entry.setEntryDC(dc);
        BigDecimal entryLAmount = null;
        entryLAmount = EntryDC.DEBIT.equals((Object)dc) ? (BigDecimal)entryRow.getCell("e.localAmountDebit").getValue() : (BigDecimal)entryRow.getCell("e.localAmountCredit").getValue();
        if (entryLAmount == null) {
            entryLAmount = GlUtils.zero;
        }
        entry.setLocalAmount(entryLAmount);
        for (int j = 0; j < this.ui.tblAssistRecord.getRowCount(); ++j) {
            IRow recordRow = this.ui.tblAssistRecord.getRow(j);
            VoucherAssistRecordInfo record = null;
            if (j == this.ui.curAssistRecordIndex) {
                record = this.genVoucherAssistRecordInfo(entryRow, recordRow);
            } else if (recordRow.getUserObject() != null) {
                record = ((VoucherAssistRecordData)recordRow.getUserObject()).getAssistRecord();
            }
            if (record == null) continue;
            entry.getAssistRecords().add(record);
        }
        return entry;
    }

    private VoucherAssistRecordInfo genVoucherAssistRecordInfo(IRow entryRow, IRow recordRow) {
        VoucherAssistRecordData assData = (VoucherAssistRecordData)recordRow.getUserObject();
        if (assData != null && !assData.getHasChanged()) {
            return assData.getAssistRecord();
        }
        Object[] info = assData.getColInfo();
        if (info != null) {
            VoucherAssistRecordInfo record = new VoucherAssistRecordInfo();
            AssistantHGInfo assGrp = null;
            assGrp = assData.getHasAssItemChanged() ? this.genAssGrp(entryRow, recordRow, info) : assData.getAssistRecord().getAssGrp();
            if (assGrp == null) {
                return null;
            }
            record.setAssGrp(assGrp);
            BigDecimal recordLAmount = (BigDecimal)recordRow.getCell("localAmount").getValue();
            if (recordLAmount == null) {
                recordLAmount = GlUtils.zero;
            }
            record.setLocalAmount(recordLAmount);
            BigDecimal recordOAmount = (BigDecimal)recordRow.getCell("amount").getValue();
            if (recordOAmount == null) {
                recordOAmount = GlUtils.zero;
            }
            record.setOriginalAmount(recordOAmount);
            return record;
        }
        return null;
    }

    private AssistantHGInfo genAssGrp(IRow entryRow, IRow recordRow, Object[] info) {
        AssistantHGInfo assGrp = new AssistantHGInfo();
        VoucherInfo.DynamicColumnInfo[] itemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
        for (int k = 0; k < itemCols.length; ++k) {
            VoucherInfo.DynamicColumnInfo colInfo = itemCols[k];
            String key = colInfo.getMappingPropName();
            String colKey = "#" + key;
            Object val = recordRow.getCell(colKey).getValue();
            assGrp.put(key, val);
        }
        Object obj = entryRow.getCell("e.account").getValue();
        AccountViewInfo account = null;
        account = obj instanceof Object[] ? (AccountViewInfo)((Object[])obj)[0] : (AccountViewInfo)obj;
        assGrp = this.ui.confirmAssGrp(assGrp, account.getCAA().getId().toString(), itemCols);
        return assGrp;
    }

    private BigDecimal[] getAssistBalance(VoucherInfo oldVoucher, VoucherInfo voucher, AccountViewInfo account, CurrencyInfo currency, AssistantHGInfo hg, boolean isCredit, boolean isEdit) throws BOSException, EASBizException {
        if (voucher == null || account == null || currency == null || hg == null) {
            throw new BOSException("The voucher or account or currency or hg is empty!");
        }
        GLAsstBalanceInfo bal = AccountBalanceFactory.getRemoteInstance().getGLAsstBalanceNew(this.toMapParam(account, currency, hg, isCredit, isEdit));
        BigDecimal[] amounts = new BigDecimal[3];
        if (this.foreignCurrencySU) {
            amounts[0] = bal.getDebitFor();
            amounts[1] = bal.getCreditFor();
            amounts[2] = bal.getOrigAmount();
        } else {
            amounts[0] = bal.getDebitLocal();
            amounts[1] = bal.getCreditLocal();
            amounts[2] = bal.getLocalAmount();
        }
        return amounts;
    }

    private List<BigDecimal[]> getAssistBalance2(VoucherInfo oldVoucher, VoucherInfo voucher, AccountViewInfo account, CurrencyInfo currency, AssistantHGInfo hg, boolean isCredit, boolean isEdit) throws BOSException, EASBizException {
        if (voucher == null || account == null || currency == null || hg == null) {
            throw new BOSException("The voucher or account or currency or hg is empty!");
        }
        GLAsstBalanceInfo bal = AccountBalanceFactory.getRemoteInstance().getGLAsstBalanceNew(this.toMapParam(account, currency, hg, isCredit, isEdit));
        BigDecimal[] amounts = new BigDecimal[3];
        BigDecimal[] amountsBase = new BigDecimal[3];
        if (this.foreignCurrencySU) {
            amounts[0] = bal.getDebitFor();
            amounts[1] = bal.getCreditFor();
            amounts[2] = bal.getOrigAmount();
        } else {
            amounts[0] = bal.getDebitLocal();
            amounts[1] = bal.getCreditLocal();
            amounts[2] = bal.getLocalAmount();
            amountsBase[0] = bal.getDebitFor();
            amountsBase[1] = bal.getCreditFor();
            amountsBase[2] = bal.getOrigAmount();
        }
        ArrayList<BigDecimal[]> list = new ArrayList<BigDecimal[]>();
        list.add(amounts);
        list.add(amountsBase);
        return list;
    }

    private BigDecimal[] getAccountBalance(VoucherInfo oldVoucher, VoucherInfo voucher, AccountViewInfo account, CurrencyInfo currency, boolean isCredit, boolean isEdit) throws BOSException, EASBizException {
        if (voucher == null || account == null || currency == null) {
            throw new BOSException("The voucher or account or currency is empty!");
        }
        GLBalanceInfo bal = AccountBalanceFactory.getRemoteInstance().getGLAccountBalanceNew(this.toMapParam(account, currency, null, isCredit, isEdit));
        BigDecimal[] amounts = new BigDecimal[3];
        if (this.foreignCurrencySU) {
            amounts[0] = bal.getDebitFor();
            amounts[1] = bal.getCreditFor();
            amounts[2] = bal.getOrigAmount();
        } else {
            amounts[0] = bal.getDebitLocal();
            amounts[1] = bal.getCreditLocal();
            amounts[2] = bal.getLocalAmount();
        }
        return amounts;
    }

    private List<BigDecimal[]> getAccountBalance2(VoucherInfo oldVoucher, VoucherInfo voucher, AccountViewInfo account, CurrencyInfo currency, boolean isCredit, boolean isEdit) throws BOSException, EASBizException {
        if (voucher == null || account == null || currency == null) {
            throw new BOSException("The voucher or account or currency is empty!");
        }
        GLBalanceInfo bal = AccountBalanceFactory.getRemoteInstance().getGLAccountBalanceNew(this.toMapParam(account, currency, null, isCredit, isEdit));
        BigDecimal[] amounts = new BigDecimal[3];
        BigDecimal[] amountsBase = new BigDecimal[3];
        if (this.foreignCurrencySU) {
            amounts[0] = bal.getDebitFor();
            amounts[1] = bal.getCreditFor();
            amounts[2] = bal.getOrigAmount();
        } else {
            amounts[0] = bal.getDebitLocal();
            amounts[1] = bal.getCreditLocal();
            amounts[2] = bal.getLocalAmount();
            amountsBase[0] = bal.getDebitFor();
            amountsBase[1] = bal.getCreditFor();
            amountsBase[2] = bal.getOrigAmount();
        }
        ArrayList<BigDecimal[]> list = new ArrayList<BigDecimal[]>();
        list.add(amounts);
        list.add(amountsBase);
        return list;
    }

    private String getAmountTxt(AccountViewInfo account, boolean isCredit, BigDecimal debit, BigDecimal credit, BigDecimal endBalance) {
        String debitTxt = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.VoucherEditResource.debitSide");
        String creditTxt = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.VoucherEditResource.creditSide");
        String balanceAmount = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.VoucherEditResource.BalanceAmount");
        String tDebit = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.VoucherEditResource.YearDebitAmount");
        String tCredit = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.VoucherEditResource.yearCreditAmount");
        boolean accIsDebit = account.getDC() == BalanceDirectionEnum.DEBIT;
        StringBuffer balTxt = new StringBuffer();
        balTxt.append(" ").append(balanceAmount).append(accIsDebit ? debitTxt : creditTxt).append(":").append(GlUtils.formatNumber(accIsDebit ? endBalance : endBalance.negate(), this.localCurr.getPrecision()));
        balTxt.append("   ").append(isCredit ? tCredit : tDebit).append(":").append(GlUtils.formatNumber(isCredit ? credit : debit, this.localCurr.getPrecision()));
        return balTxt.toString();
    }

    private String[] getDisplayName(AccountViewInfo account, AssistantHGInfo hg, String balTxt) {
        String[] showTxt = new String[2];
        String txt = account.getNumber();
        if (hg == null) {
            showTxt[0] = txt + balTxt;
            showTxt[1] = showTxt[0];
            return showTxt;
        }
        if (hg.getLongNameGroup() == null) {
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("longNameGroup"));
                hg = AssistantHGFactory.getRemoteInstance().getAssistantHGInfo((IObjectPK)new ObjectUuidPK(hg.getId().toString()), sic);
                hg.setLongNameGroup(hg.getLongNameGroup());
            }
            catch (Exception e) {
                this.ui.handUIExceptionAndAbort(e);
            }
        }
        String hgName = VoucherUtil.decodeSplitFlag(hg.getLongNameGroup());
        showTxt[0] = txt + "(" + (hgName != null && hgName.length() > 30 ? hgName.substring(0, 30) + "..." : hgName) + ")" + balTxt;
        showTxt[1] = txt + "(" + hgName + ")" + balTxt;
        return showTxt;
    }

    private Map toMapParam(AccountViewInfo account, CurrencyInfo currency, AssistantHGInfo hg, boolean isCredit, boolean isEdit) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("account", account);
        param.put("currency", currency);
        param.put("queryDebit", !isCredit);
        param.put("queryCredit", isCredit);
        param.put("hg", hg);
        param.put("isEdit", isEdit);
        HashMap<String, Object> voucher = new HashMap<String, Object>();
        voucher.put("company", this.newVoucher.getCompany());
        voucher.put("period", this.newVoucher.getPeriod());
        voucher.put("status", this.newVoucher.getBizStatus());
        voucher.put("entries", this.entryToMap(this.newVoucher, account, currency, hg));
        param.put("voucher", voucher);
        HashMap<String, Object> oldvch = null;
        if (this.oldVoucher != null) {
            oldvch = new HashMap<String, Object>();
            oldvch.put("company", this.oldVoucher.getCompany());
            oldvch.put("period", this.oldVoucher.getPeriod());
            oldvch.put("status", this.oldVoucher.getBizStatus());
            oldvch.put("entries", this.entryToMap(this.oldVoucher, account, currency, hg));
        }
        param.put("oldVoucher", oldvch);
        return param;
    }

    private List<Map> entryToMap(VoucherInfo voucher, AccountViewInfo account, CurrencyInfo currency, AssistantHGInfo hg) {
        ArrayList<Map> entries = new ArrayList<Map>();
        Iterator entryIt = voucher.getEntries().iterator();
        VoucherEntryInfo entryInfo = null;
        AccountViewInfo accInfo = null;
        CurrencyInfo curInfo = null;
        HashMap<String, Object> entry = null;
        while (entryIt.hasNext()) {
            entryInfo = (VoucherEntryInfo)entryIt.next();
            accInfo = entryInfo.getAccount();
            curInfo = entryInfo.getCurrency();
            if (accInfo == null || !accInfo.getId().equals((Object)account.getId()) || curInfo == null || !curInfo.getId().equals((Object)currency.getId())) continue;
            entry = new HashMap<String, Object>();
            entry.put("account", accInfo);
            entry.put("currency", curInfo);
            entry.put("dc", entryInfo.getEntryDC());
            if (hg != null) {
                entry.put("assistRecords", this.asstToMap(entryInfo, hg));
            } else {
                entry.put("originalAmount", entryInfo.getOriginalAmount());
                entry.put("localAmount", entryInfo.getLocalAmount());
            }
            entries.add(entry);
        }
        return entries;
    }

    private List<Map> asstToMap(VoucherEntryInfo entryInfo, AssistantHGInfo hg) {
        ArrayList<Map> assists = new ArrayList<Map>();
        Iterator asstIt = entryInfo.getAssistRecords().iterator();
        VoucherAssistRecordInfo asst = null;
        HashMap<String, Object> asstMap = null;
        while (asstIt.hasNext()) {
            asst = (VoucherAssistRecordInfo)asstIt.next();
            if (asst.getAssGrp() == null || !hg.getId().equals((Object)asst.getAssGrp().getId())) continue;
            asstMap = new HashMap<String, Object>();
            asstMap.put("assGrpId", hg.getId());
            asstMap.put("originalAmount", asst.getOriginalAmount());
            asstMap.put("localAmount", asst.getLocalAmount());
            assists.add(asstMap);
        }
        return assists;
    }
}

