/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.ui.NormalSelector;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.client.AbstractVoucherExportUI;
import com.kingdee.eas.fi.gl.client.CompanyTreePromptBox;
import com.kingdee.eas.fi.gl.client.VoucherExporter;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class VoucherExportUI
extends AbstractVoucherExportUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherExportUI.class);
    protected static final String RESOURCE = "com.kingdee.eas.fi.gl.VoucherImport";
    private static final DateFormat DF_IMP = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat DF_LOG = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
    private static final Color WARN_COLOR = new Color(246, 168, 46);
    protected boolean isRunning = false;
    private boolean stop = false;
    private String companyIdFilter = null;
    private SourceSystemSelect _selectSys;
    private SourceTypeSelect _selectType;

    public VoucherExportUI() throws Exception {
        this.init();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.splitPane.setDividerLocation(602);
        this.kDPanel1.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
        this.kDScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
        KDPanel pnTop = new KDPanel();
        pnTop.setLayout((LayoutManager)new BorderLayout());
        this.splitPane.setTopComponent((Component)pnTop);
        this.kDPanel1.remove((Component)this.kDButton1);
        this.kDPanel1.remove((Component)this.btnExecute);
        this.kDPanel1.setPreferredSize(new Dimension(870, 566));
        KDScrollPane scrollPane = new KDScrollPane();
        scrollPane.getViewport().add((Component)this.kDPanel1);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        pnTop.add((Component)scrollPane, (Object)"Center");
        Box ctrl = Box.createHorizontalBox();
        ctrl.setBorder(BorderFactory.createEmptyBorder(5, 1, 0, 1));
        ctrl.add(Box.createHorizontalGlue());
        ctrl.add((Component)this.kDButton1);
        ctrl.add(Box.createHorizontalStrut(10));
        ctrl.add((Component)this.btnExecute);
        ctrl.add(Box.createHorizontalStrut(10));
        pnTop.add((Component)ctrl, (Object)"South");
    }

    private void init() {
        this.btnFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File defaultPath = new File("vouchers");
                JFileChooser chooser = new JFileChooser();
                String currentPath = VoucherExportUI.this.tfFile.getText();
                if (currentPath != null && currentPath.trim().length() > 0) {
                    File parent;
                    File dir = new File(currentPath);
                    if (dir.isDirectory()) {
                        parent = dir.getParentFile();
                        if (parent != null) {
                            chooser.setCurrentDirectory(parent);
                        } else {
                            chooser.setCurrentDirectory(dir);
                        }
                    } else {
                        parent = dir.getParentFile();
                        if (parent != null) {
                            chooser.setCurrentDirectory(parent);
                        } else {
                            chooser.setCurrentDirectory(defaultPath);
                        }
                    }
                } else {
                    chooser.setCurrentDirectory(defaultPath);
                }
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "Excel(*.xlsx)";
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".xlsx");
                    }
                });
                chooser.setFileSelectionMode(0);
                chooser.setAcceptAllFileFilterUsed(false);
                int result = chooser.showSaveDialog((Component)((Object)VoucherExportUI.this));
                if (result == 0) {
                    File file = chooser.getSelectedFile();
                    String path = file.getAbsolutePath();
                    if (!file.exists() && !path.toLowerCase().endsWith(".xlsx")) {
                        path = path + ".xlsx";
                    }
                    VoucherExportUI.this.tfFile.setText(path);
                }
            }
        });
        this.btnOpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = null;
                String currentPath = VoucherExportUI.this.tfFile.getText();
                if (currentPath != null && (currentPath = currentPath.trim()).length() > 0) {
                    file = new File(currentPath);
                }
                if (file != null && file.isFile()) {
                    VoucherExportUI.this.open(file);
                } else {
                    VoucherExportUI.this.btnFilePositionActionPerformed(e);
                }
            }
        });
        this.btnFilePosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VoucherExportUI.this.btnFilePositionActionPerformed(e);
            }
        });
        this.cbCompress.setVisible(false);
        this.cbShowRequest.setVisible(false);
        InputMap imEntry = this.getInputMap(2);
        KeyStroke ctrl_shift_f5 = KeyStroke.getKeyStroke(116, 3);
        imEntry.put(ctrl_shift_f5, "showAdvance");
        ActionMap entryActionMap = this.getActionMap();
        entryActionMap.put("showAdvance", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VoucherExportUI.this.showAdvanceActionPerformed(e);
            }
        });
        ActionListener statusListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDCheckBox box = (KDCheckBox)e.getSource();
                if (!(VoucherExportUI.this.cbBizStatusTemp.isSelected() || VoucherExportUI.this.cbBizStatusSubmit.isSelected() || VoucherExportUI.this.cbBizStatusAudit.isSelected() || VoucherExportUI.this.cbBizStatusPost.isSelected() || VoucherExportUI.this.cbBizStatusCancel.isSelected())) {
                    if (box == VoucherExportUI.this.cbBizStatusTemp) {
                        VoucherExportUI.this.cbBizStatusSubmit.setSelected(true);
                    } else if (box == VoucherExportUI.this.cbBizStatusSubmit) {
                        VoucherExportUI.this.cbBizStatusAudit.setSelected(true);
                    } else if (box == VoucherExportUI.this.cbBizStatusAudit) {
                        VoucherExportUI.this.cbBizStatusPost.setSelected(true);
                    } else if (box == VoucherExportUI.this.cbBizStatusPost) {
                        VoucherExportUI.this.cbBizStatusCancel.setSelected(true);
                    } else {
                        VoucherExportUI.this.cbBizStatusTemp.setSelected(true);
                    }
                }
            }
        };
        this.cbBizStatusTemp.addActionListener(statusListener);
        this.cbBizStatusSubmit.addActionListener(statusListener);
        this.cbBizStatusAudit.addActionListener(statusListener);
        this.cbBizStatusPost.addActionListener(statusListener);
        this.cbBizStatusCancel.addActionListener(statusListener);
        ActionListener checkListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDCheckBox box = (KDCheckBox)e.getSource();
                if (!VoucherExportUI.this.cbChecked.isSelected() && !VoucherExportUI.this.cbNotChecked.isSelected()) {
                    if (box == VoucherExportUI.this.cbChecked) {
                        VoucherExportUI.this.cbNotChecked.setSelected(true);
                    } else {
                        VoucherExportUI.this.cbChecked.setSelected(true);
                    }
                }
            }
        };
        this.cbChecked.addActionListener(checkListener);
        this.cbNotChecked.addActionListener(checkListener);
        ActionListener categoryListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDCheckBox box = (KDCheckBox)e.getSource();
                if (!(VoucherExportUI.this.cbCategoryFinance.isSelected() || VoucherExportUI.this.cbCategoryBudget.isSelected() || VoucherExportUI.this.cbCategoryParallel.isSelected())) {
                    if (box == VoucherExportUI.this.cbCategoryFinance) {
                        VoucherExportUI.this.cbCategoryBudget.setSelected(true);
                    } else if (box == VoucherExportUI.this.cbCategoryBudget) {
                        VoucherExportUI.this.cbCategoryParallel.setSelected(true);
                    } else {
                        VoucherExportUI.this.cbCategoryFinance.setSelected(true);
                    }
                }
            }
        };
        this.cbCategoryFinance.addActionListener(categoryListener);
        this.cbCategoryBudget.addActionListener(categoryListener);
        this.cbCategoryParallel.addActionListener(categoryListener);
        this.cbBatch.setSelected(true);
        this.spBatchCount.setModel((SpinnerModel)new SpinnerNumberModel(50, 1, 500, 10));
        this.spThreadCount.setModel((SpinnerModel)new SpinnerNumberModel(8, 1, 128, 2));
        EntityViewInfo companyView = new EntityViewInfo();
        companyView.setSelector(GlUtils.getCompanySic());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        companyView.setFilter(filter);
        this.promptCompany.setEntityViewInfo(companyView);
        this.promptCompany.setSelector(this.getCompanySelector());
        if (((Object)((Object)this)).getClass() == VoucherExportUI.class) {
            this.txtConsole.setContentType("text/html");
            this.txtConsole.setEditable(false);
            StringBuffer htmlText = new StringBuffer();
            htmlText.append("<html>");
            htmlText.append("<body>");
            htmlText.append(this.getString("Interface_Manual"));
            htmlText.append("<br>");
            htmlText.append("<a href=\"https://vip.kingdee.com/article/289404067737316096\">https://vip.kingdee.com/article/289404067737316096</a>");
            htmlText.append("<br>");
            htmlText.append("</body>");
            htmlText.append("</html>");
            this.txtConsole.setText(htmlText.toString());
            this.txtConsole.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent evt) {
                    if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(evt.getURL().toURI());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    private String getCompanyIdFilter() {
        if (this.companyIdFilter != null) {
            return this.companyIdFilter;
        }
        try {
            this.companyIdFilter = GLGeneralFacadeFactory.getRemoteInstance().getCompanyIDSQL(this.getPermissionItem(), null, true);
            return this.companyIdFilter;
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    protected KDPromptSelector getCompanySelector() {
        return new CompanyTreePromptBox((CoreUIObject)this, null, this.promptCompany, this.getPermissionItem(), true);
    }

    private FilterInfo getCompanyFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("unit.id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        return filter;
    }

    private String getPermissionItem() {
        return "gl_voucher_newExport";
    }

    public void showAdvanceActionPerformed(ActionEvent e) {
        this.cbCompress.setVisible(!this.cbCompress.isVisible());
        this.cbShowRequest.setVisible(!this.cbShowRequest.isVisible());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initSelect();
        this.loadConfig();
    }

    private void initSelect() {
        this.panelSourceSys.setLayout((LayoutManager)new BorderLayout());
        this.panelSourceSys.add((Component)((Object)this.getSelectSys()), (Object)"Center");
        this._selectSys.enableSelect(true);
        this._selectSys.enableSelectAll(true);
        this._selectSys.lstSupply.setEnabled(true);
        this._selectSys.lstSupply.removeAllElements();
        this._selectSys.getSelectedList().setEnabled(true);
        this.setSourceSystems();
        this.panelSourceType.setLayout((LayoutManager)new BorderLayout());
        this.panelSourceType.add((Component)((Object)this.getSelectTypes()), (Object)"Center");
        this._selectType.enableSelect(true);
        this._selectType.enableSelectAll(true);
        this._selectType.lstSupply.setEnabled(true);
        this._selectType.lstSupply.removeAllElements();
        this._selectType.getSelectedList().setEnabled(true);
        this.setSourceTypes();
    }

    public void btnFilePositionActionPerformed(ActionEvent e) {
        File defaultPath = new File("vouchers");
        String currentPath = this.tfFile.getText();
        if (currentPath == null || currentPath.trim().length() == 0) {
            this.explorerFile(defaultPath, false);
            return;
        }
        File currentFile = new File(currentPath = currentPath.trim());
        if (currentFile.exists()) {
            this.explorerFile(currentFile, true);
        } else {
            File parent = currentFile.getParentFile();
            if (parent != null) {
                if (parent.isDirectory()) {
                    this.explorerFile(parent, false);
                } else {
                    JOptionPane.showMessageDialog(this.getTopLevelAncestor(), parent.getAbsolutePath() + "\uff1a" + this.getString("Directory_NotExist"));
                }
            }
        }
    }

    public void open(File file) {
        String command = "cmd /c start " + file.getAbsolutePath();
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void explorerFile(File file, boolean select) {
        if (file != null) {
            try {
                String command = "explorer ";
                if (select) {
                    command = command + "/select, ";
                }
                command = command + file.getAbsolutePath();
                Runtime.getRuntime().exec(command);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void actionDefaultSetting_actionPerformed(ActionEvent e) throws Exception {
        String fromPeriod = "";
        String toPeriod = "";
        CompanyOrgUnitInfo[] cs = null;
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (company != null && company.isIsBizUnit()) {
            cs = new CompanyOrgUnitInfo[]{company};
            PeriodInfo current = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(company.getId().toString()));
            if (current != null) {
                fromPeriod = String.valueOf(current.getNumber());
                toPeriod = String.valueOf(current.getNumber());
            }
        }
        this.promptCompany.setValue(cs);
        this.tfFromPeriod.setText(fromPeriod);
        this.tfToPeriod.setText(toPeriod);
        this.promptVoucherType.setValue(null);
        this.tfVoucherId.setText("");
        this.tfImportKey.setText("");
        this.tfVoucherNumber.setText("");
        this.tfExcludeVoucherNumber.setText("");
        this.tfFromVoucherNumber.setText("");
        this.tfToVoucherNumber.setText("");
        this.tfFromBookedDate.setValue(null);
        this.tfToBookedDate.setValue(null);
        this.tfFromBizDate.setValue(null);
        this.tfToBizDate.setValue(null);
        this.tfCreator.setText(SysContext.getSysContext().getCurrentUserInfo().getNumber());
        this.tfAuditor.setText("");
        this.tfPoster.setText("");
        this.tfCashier.setText("");
        this.tfVoucherAbstract.setText("");
        this.tfDescription.setText("");
        this.cbBizStatusTemp.setSelected(true);
        this.cbBizStatusSubmit.setSelected(true);
        this.cbBizStatusAudit.setSelected(true);
        this.cbBizStatusPost.setSelected(true);
        this.cbBizStatusCancel.setSelected(false);
        this.cbChecked.setSelected(true);
        this.cbNotChecked.setSelected(true);
        this.cbCategoryFinance.setSelected(true);
        this.cbCategoryBudget.setSelected(true);
        this.cbCategoryParallel.setSelected(true);
        this.tfEntryDescription.setText("");
        this.promptCurrency.setValue(null);
        this.tfAccountNumber.setText("");
        this.tfFromAccountNumber.setText("");
        this.tfToAccountNumber.setText("");
        this.tfEntryAmount.setText("");
        this.tfEntryMinAmount.setText("");
        this.tfEntryMaxAmount.setText("");
        this.cbColumnAlias.setSelected(true);
        this.cbExpEntry.setSelected(true);
        this.cbExpRecord.setSelected(true);
        this.cbCashflow.setSelected(true);
        this.cbExpAccountCustomizedProperty.setSelected(true);
        this.cbExpExtendProperty.setSelected(true);
        this.txtExtends.setText("");
        this.cbCompress.setSelected(true);
        this.cbBatch.setSelected(true);
        this.spBatchCount.setValue((Object)50);
        this.spThreadCount.setValue((Object)8);
        this.cbShowRequest.setSelected(false);
    }

    @Override
    public void actionVoucherOldExport_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.VoucherOldExportUI", (Map)uiContext, null, OprtState.EDIT);
            this.destroyWindow();
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        this.txtConsole.setText("");
    }

    @Override
    public void actionExecute_actionPerformed(ActionEvent e) throws Exception {
        this.btnExecuteActionPerformed(e);
    }

    public boolean checkBeforeWindowClosing() {
        this.stop = true;
        this.saveConfig();
        return super.checkBeforeWindowClosing();
    }

    private void btnExecuteActionPerformed(ActionEvent e) {
        if (this.btnExecute.getClientProperty((Object)"canStop") != null) {
            this.stop = true;
            this.btnExecute.setEnabled(false);
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                VoucherExportUI.this.execute();
            }
        }).start();
    }

    private void execute() {
        try {
            this.isRunning = true;
            this.btnExecute.putClientProperty((Object)"canStop", (Object)true);
            this.btnExecute.setText(this.getString("Stop"));
            this.enableComponent(false);
            this.doExecute();
        }
        catch (Exception e) {
            this.error(e);
        }
        finally {
            this.btnExecute.setText(this.getString("Export"));
            this.enableComponent(true);
            this.btnExecute.setEnabled(true);
            this.btnExecute.putClientProperty((Object)"canStop", null);
            this.stop = false;
            this.isRunning = false;
        }
    }

    private void enableComponent(boolean enable) {
        this.tfFile.setEnabled(enable);
        this.btnFile.setEnabled(enable);
        this.btnOpenFile.setEnabled(enable);
        this.btnFilePosition.setEnabled(enable);
        this.promptCompany.setEnabled(enable);
        this.promptVoucherType.setEnabled(enable);
        this.cbBizStatusTemp.setEnabled(enable);
        this.cbBizStatusSubmit.setEnabled(enable);
        this.cbBizStatusAudit.setEnabled(enable);
        this.cbBizStatusPost.setEnabled(enable);
        this.cbBizStatusCancel.setEnabled(enable);
        this.cbChecked.setEnabled(enable);
        this.cbNotChecked.setEnabled(enable);
        this.cbCategoryFinance.setEnabled(enable);
        this.cbCategoryBudget.setEnabled(enable);
        this.cbCategoryParallel.setEnabled(enable);
        this.tfVoucherId.setEnabled(enable);
        this.tfImportKey.setEnabled(enable);
        this.tfVoucherNumber.setEnabled(enable);
        this.tfExcludeVoucherNumber.setEnabled(enable);
        this.tfFromVoucherNumber.setEnabled(enable);
        this.tfToVoucherNumber.setEnabled(enable);
        this.tfFromPeriod.setEnabled(enable);
        this.tfToPeriod.setEnabled(enable);
        this.tfFromBookedDate.setEnabled(enable);
        this.tfToBookedDate.setEnabled(enable);
        this.tfFromBizDate.setEnabled(enable);
        this.tfToBizDate.setEnabled(enable);
        this._selectSys.enableSelect(enable);
        this._selectSys.enableSelectAll(enable);
        this._selectSys.lstSupply.setEnabled(enable);
        this._selectSys.getSelectedList().setEnabled(enable);
        this._selectType.enableSelect(enable);
        this._selectType.enableSelectAll(enable);
        this._selectType.lstSupply.setEnabled(enable);
        this._selectType.getSelectedList().setEnabled(enable);
        this.tfVoucherAbstract.setEnabled(enable);
        this.tfDescription.setEnabled(enable);
        this.tfCreator.setEnabled(enable);
        this.tfAuditor.setEnabled(enable);
        this.tfPoster.setEnabled(enable);
        this.tfCashier.setEnabled(enable);
        this.tfEntryDescription.setEnabled(enable);
        this.promptCurrency.setEnabled(enable);
        this.tfAccountNumber.setEnabled(enable);
        this.tfFromAccountNumber.setEnabled(enable);
        this.tfToAccountNumber.setEnabled(enable);
        this.tfEntryAmount.setEnabled(enable);
        this.tfEntryMinAmount.setEnabled(enable);
        this.tfEntryMaxAmount.setEnabled(enable);
        this.cbColumnAlias.setEnabled(enable);
        this.cbExpEntry.setEnabled(enable);
        this.cbExpRecord.setEnabled(enable);
        this.cbCashflow.setEnabled(enable);
        this.cbExpAccountCustomizedProperty.setEnabled(enable);
        this.cbExpExtendProperty.setEnabled(enable);
        this.txtExtends.setEnabled(enable);
        this.cbBatch.setEnabled(enable);
        this.spBatchCount.setEnabled(enable);
        this.spThreadCount.setEnabled(enable);
        this.cbCompress.setEnabled(enable);
        this.cbShowRequest.setEnabled(enable);
        this.actionDefaultSetting.setEnabled(enable);
    }

    public void doExecute() {
        String strExtends;
        String toPeriodNumber;
        String fromPeriodNumber;
        Map<String, String> params = this.buildConfig();
        String path = params.get("file");
        if (path == null || path.trim().length() == 0) {
            this.error(this.getString("FilePosition_SetPlease"));
            return;
        }
        File file = new File(path = path.trim());
        if (file.isDirectory()) {
            this.error(this.getString("FilePosition_SetPlease"));
            return;
        }
        if (!file.exists()) {
            File parent = file.getParentFile();
            if (parent == null || !parent.isDirectory()) {
                this.error(this.getString("FilePosition_NotExist"));
                return;
            }
        } else {
            int r = MsgBox.showConfirm2New((Component)((Object)this), (String)this.getString("FileExist_Override"));
            if (r != 0) {
                return;
            }
        }
        if ((fromPeriodNumber = params.get("fromPeriodNumber")) != null && fromPeriodNumber.trim().length() > 0) {
            if (fromPeriodNumber.length() != 6) {
                this.error(this.getString("PeriodNumber_Error"));
                return;
            }
            try {
                int i = Integer.parseInt(fromPeriodNumber);
                int number = i % 100;
                if (i < 190001 || number < 1 || number > 13) {
                    this.error(this.getString("PeriodNumber_Error"));
                    return;
                }
            }
            catch (Exception e) {
                this.error(this.getString("PeriodNumber_Error"));
                return;
            }
        }
        if ((toPeriodNumber = params.get("toPeriodNumber")) != null && toPeriodNumber.trim().length() > 0) {
            if (toPeriodNumber.length() != 6) {
                this.error(this.getString("PeriodNumber_Error"));
                return;
            }
            try {
                int i = Integer.parseInt(toPeriodNumber);
                int number = i % 100;
                if (i < 190001 || number < 1 || number > 13) {
                    this.error(this.getString("PeriodNumber_Error"));
                    return;
                }
            }
            catch (Exception e) {
                this.error(this.getString("PeriodNumber_Error"));
                return;
            }
        }
        if ((strExtends = params.remove("extends")) != null && strExtends.trim().length() > 0 && (strExtends = strExtends.trim()).length() > 0) {
            HashMap<String, String> extendParams = new HashMap<String, String>();
            if (strExtends.startsWith("{") && strExtends.endsWith("}")) {
                Map exs = (Map)JSON.parseObject((String)strExtends, Map.class);
                for (Object key : exs.keySet()) {
                    extendParams.put(String.valueOf(key), String.valueOf(exs.get(key)));
                }
            } else {
                String[] strs;
                extendParams = new HashMap();
                for (String str : strs = strExtends.trim().split(";")) {
                    int index = str.indexOf("=");
                    if (index <= 0) continue;
                    String key = str.substring(0, index).trim();
                    String value = str.substring(index + 1).trim();
                    if (key.length() <= 0 || value.length() <= 0) continue;
                    extendParams.put(key, value);
                }
            }
            if (extendParams.size() > 0) {
                HashSet extendKeys = new HashSet(extendParams.keySet());
                extendParams.putAll(params);
                params = extendParams;
                params.put("extendKeys", JSON.toJSONString(extendKeys));
            }
        }
        this.getVoucherExporter(params).execute();
    }

    protected VoucherExporter getVoucherExporter(Map<String, String> config) {
        return new VoucherExporter(this, config){

            @Override
            public boolean isStop() {
                return VoucherExportUI.this.isStop();
            }
        };
    }

    public boolean isStop() {
        return this.stop;
    }

    public void info(String msg) {
        this.log(DF_LOG.format(new Date()) + " " + msg, Color.black);
    }

    public void warn(String msg) {
        this.log(DF_LOG.format(new Date()) + " " + msg, WARN_COLOR);
    }

    public void error(String msg) {
        this.log(DF_LOG.format(new Date()) + " " + msg, Color.red);
    }

    public void error(Throwable t) {
        this.error(GlUtils.printStackTrace(t));
    }

    private synchronized void log(final String msg, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleAttributeSet attributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(attributeSet, color);
                Document doc = VoucherExportUI.this.txtConsole.getDocument();
                try {
                    doc.insertString(doc.getLength(), msg + "\n", attributeSet);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                VoucherExportUI.this.txtConsole.setSelectionStart(doc.getLength());
            }
        });
    }

    protected String getConfigFile() {
        return "VoucherExport.properties";
    }

    protected void loadConfig() {
        String threadCount;
        String batchCount;
        String voucherAbstract;
        String sourceType;
        String sourceSys;
        File file2;
        Map<String, String> params = null;
        String filepath = this.getFilepath();
        if (filepath != null && (file2 = new File(filepath + this.getConfigFile())).isFile()) {
            params = this.loadConfig(filepath + this.getConfigFile());
        }
        if (params == null || params.size() == 0) {
            try {
                this.actionDefaultSetting_actionPerformed(null);
            }
            catch (Exception file2) {
                // empty catch block
            }
            return;
        }
        if (params.get("file") != null) {
            this.tfFile.setText((String)params.get("file"));
        }
        CompanyOrgUnitInfo[] cs = null;
        String companyNumber = (String)params.get("companyNumber");
        if (companyNumber != null && companyNumber.length() > 0) {
            HashSet<String> numbers = new HashSet<String>();
            for (String str : companyNumber.split(";")) {
                if (str.trim().length() <= 0) continue;
                numbers.add(str.trim());
            }
            if (numbers.size() > 0) {
                EntityViewInfo companyView = new EntityViewInfo();
                companyView.setSelector(GlUtils.getCompanySic());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
                companyView.setFilter(filter);
                SorterItemCollection sorter = new SorterItemCollection();
                SorterItemInfo item = new SorterItemInfo("longNumber");
                item.setSortType(SortType.ASCEND);
                sorter.add(item);
                companyView.setSorter(sorter);
                try {
                    CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(companyView);
                    if (coll.size() > 0) {
                        cs = new CompanyOrgUnitInfo[coll.size()];
                        for (int i = 0; i < coll.size(); ++i) {
                            cs[i] = coll.get(i);
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        this.promptCompany.setValue(cs);
        VoucherTypeInfo[] vts = null;
        String voucherType = (String)params.get("voucherType");
        if (voucherType != null && voucherType.trim().length() > 0) {
            HashSet<String> numbers = new HashSet<String>();
            for (String str : voucherType.split(";")) {
                if (str.trim().length() <= 0) continue;
                numbers.add(str.trim());
            }
            if (numbers.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                view.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
                view.setFilter(filter);
                SorterItemCollection sorter = new SorterItemCollection();
                SorterItemInfo item = new SorterItemInfo("number");
                item.setSortType(SortType.ASCEND);
                sorter.add(item);
                view.setSorter(sorter);
                try {
                    VoucherTypeCollection coll = VoucherTypeFactory.getRemoteInstance().getVoucherTypeCollection(view);
                    if (coll.size() > 0) {
                        vts = new VoucherTypeInfo[coll.size()];
                        for (int i = 0; i < coll.size(); ++i) {
                            vts[i] = coll.get(i);
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        this.promptVoucherType.setValue(vts);
        String voucherId = params.get("voucherId");
        if (voucherId == null) {
            voucherId = "";
        }
        this.tfVoucherId.setText(voucherId);
        String importKey = params.get("importKey");
        if (importKey == null) {
            importKey = "";
        }
        this.tfImportKey.setText(importKey);
        String voucherNumber = params.get("voucherNumber");
        if (voucherNumber == null) {
            voucherNumber = "";
        }
        this.tfVoucherNumber.setText(voucherNumber);
        String excludeVoucherNumber = params.get("excludeVoucherNumber");
        if (excludeVoucherNumber == null) {
            excludeVoucherNumber = "";
        }
        this.tfExcludeVoucherNumber.setText(excludeVoucherNumber);
        String fromVoucherNumber = params.get("fromVoucherNumber");
        if (fromVoucherNumber == null) {
            fromVoucherNumber = "";
        }
        this.tfFromVoucherNumber.setText(fromVoucherNumber);
        String toVoucherNumber = params.get("toVoucherNumber");
        if (toVoucherNumber == null) {
            toVoucherNumber = "";
        }
        this.tfToVoucherNumber.setText(toVoucherNumber);
        String fromPeriod = params.get("fromPeriodNumber");
        if (fromPeriod == null) {
            fromPeriod = "";
        }
        this.tfFromPeriod.setText(fromPeriod);
        String toPeriod = params.get("toPeriodNumber");
        if (toPeriod == null) {
            toPeriod = "";
        }
        this.tfToPeriod.setText(toPeriod);
        Date now = new Date();
        String fromBookedDate = params.get("fromBookedDate");
        if (fromBookedDate != null && fromBookedDate.trim().length() > 0) {
            try {
                this.tfFromBookedDate.setValue((Object)DF_IMP.parse(fromBookedDate.trim()));
            }
            catch (ParseException e) {
                this.tfFromBookedDate.setValue(null);
            }
        } else {
            this.tfFromBookedDate.setValue(null);
        }
        String toBookedDate = params.get("toBookedDate");
        if (toBookedDate != null && toBookedDate.trim().length() > 0) {
            try {
                this.tfToBookedDate.setValue((Object)DF_IMP.parse(toBookedDate.trim()));
            }
            catch (ParseException e) {
                this.tfToBookedDate.setValue(null);
            }
        } else {
            this.tfToBookedDate.setValue(null);
        }
        String fromBizDate = params.get("fromBizDate");
        if (fromBizDate != null && fromBizDate.trim().length() > 0) {
            try {
                this.tfFromBizDate.setValue((Object)DF_IMP.parse(fromBizDate.trim()));
            }
            catch (ParseException e) {
                this.tfFromBizDate.setValue(null);
            }
        } else {
            this.tfFromBizDate.setValue(null);
        }
        String toBizDate = params.get("toBizDate");
        if (toBizDate != null && toBizDate.trim().length() > 0) {
            try {
                this.tfToBizDate.setValue((Object)DF_IMP.parse(toBizDate.trim()));
            }
            catch (ParseException e) {
                this.tfToBizDate.setValue(null);
            }
        } else {
            this.tfToBizDate.setValue(null);
        }
        if (params.get("bizStatusTemp") != null) {
            this.cbBizStatusTemp.setSelected(Boolean.valueOf(params.get("bizStatusTemp")).booleanValue());
        } else {
            this.cbBizStatusTemp.setSelected(true);
        }
        if (params.get("bizStatusSubmit") != null) {
            this.cbBizStatusSubmit.setSelected(Boolean.valueOf(params.get("bizStatusSubmit")).booleanValue());
        } else {
            this.cbBizStatusSubmit.setSelected(true);
        }
        if (params.get("bizStatusAudit") != null) {
            this.cbBizStatusAudit.setSelected(Boolean.valueOf(params.get("bizStatusAudit")).booleanValue());
        } else {
            this.cbBizStatusAudit.setSelected(true);
        }
        if (params.get("bizStatusPost") != null) {
            this.cbBizStatusPost.setSelected(Boolean.valueOf(params.get("bizStatusPost")).booleanValue());
        } else {
            this.cbBizStatusPost.setSelected(true);
        }
        if (params.get("bizStatusCancel") != null) {
            this.cbBizStatusCancel.setSelected(Boolean.valueOf(params.get("bizStatusCancel")).booleanValue());
        } else {
            this.cbBizStatusCancel.setSelected(true);
        }
        if (!(this.cbBizStatusTemp.isSelected() || this.cbBizStatusSubmit.isSelected() || this.cbBizStatusAudit.isSelected() || this.cbBizStatusPost.isSelected() || this.cbBizStatusCancel.isSelected())) {
            this.cbBizStatusTemp.setSelected(true);
            this.cbBizStatusSubmit.setSelected(true);
            this.cbBizStatusAudit.setSelected(true);
            this.cbBizStatusPost.setSelected(true);
        }
        if (params.get("checked") != null) {
            this.cbChecked.setSelected(Boolean.valueOf(params.get("checked")).booleanValue());
        }
        if (params.get("notChecked") != null) {
            this.cbNotChecked.setSelected(Boolean.valueOf(params.get("notChecked")).booleanValue());
        }
        if (!this.cbChecked.isSelected() && !this.cbNotChecked.isSelected()) {
            this.cbChecked.setSelected(true);
            this.cbNotChecked.setSelected(true);
        }
        this.cbCategoryFinance.setSelected(params.get("categoryFinance") == null || "true".equals(params.get("categoryFinance")));
        this.cbCategoryBudget.setSelected(params.get("categoryBudget") == null || "true".equals(params.get("categoryBudget")));
        this.cbCategoryParallel.setSelected(params.get("categoryParallel") == null || "true".equals(params.get("categoryParallel")));
        if (!(this.cbCategoryFinance.isSelected() || this.cbCategoryBudget.isSelected() || this.cbCategoryParallel.isSelected())) {
            this.cbCategoryFinance.setSelected(true);
            this.cbCategoryBudget.setSelected(true);
            this.cbCategoryParallel.setSelected(true);
        }
        if (!StringUtils.isEmpty((String)(sourceSys = params.get("sourceSys")))) {
            this._selectSys.setSelected(sourceSys);
        }
        if (!StringUtils.isEmpty((String)(sourceType = params.get("sourceType")))) {
            this._selectType.setSelected(sourceType);
        }
        if ((voucherAbstract = params.get("voucherAbstract")) == null) {
            voucherAbstract = "";
        }
        this.tfVoucherAbstract.setText(voucherAbstract);
        String description = params.get("description");
        if (description == null) {
            description = "";
        }
        this.tfDescription.setText(description);
        String creator = params.get("creator");
        if (creator == null) {
            creator = "";
        }
        this.tfCreator.setText(creator);
        String auditor = params.get("auditor");
        if (auditor == null) {
            auditor = "";
        }
        this.tfAuditor.setText(auditor);
        String poster = params.get("poster");
        if (poster == null) {
            poster = "";
        }
        this.tfPoster.setText(poster);
        String cashier = params.get("cashier");
        if (cashier == null) {
            cashier = "";
        }
        this.tfCashier.setText(cashier);
        String entryDescription = params.get("entryDescription");
        if (entryDescription == null) {
            entryDescription = "";
        }
        this.tfEntryDescription.setText(entryDescription);
        CurrencyInfo[] cys = null;
        String currency = params.get("currency");
        if (currency != null && currency.trim().length() > 0) {
            HashSet<String> numbers = new HashSet<String>();
            for (String str : currency.split(";")) {
                if (str.trim().length() <= 0) continue;
                numbers.add(str.trim());
            }
            if (numbers.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                view.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
                view.setFilter(filter);
                SorterItemCollection sorter = new SorterItemCollection();
                SorterItemInfo item = new SorterItemInfo("number");
                item.setSortType(SortType.ASCEND);
                sorter.add(item);
                view.setSorter(sorter);
                try {
                    CurrencyCollection coll = CurrencyFactory.getRemoteInstance().getCurrencyCollection(view);
                    if (coll.size() > 0) {
                        cys = new CurrencyInfo[coll.size()];
                        for (int i = 0; i < coll.size(); ++i) {
                            cys[i] = coll.get(i);
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        this.promptCurrency.setValue(cys);
        String accountNumber = params.get("accountNumber");
        if (accountNumber == null) {
            accountNumber = "";
        }
        this.tfAccountNumber.setText(accountNumber);
        String fromAccountNumber = params.get("fromAccountNumber");
        if (fromAccountNumber == null) {
            fromAccountNumber = "";
        }
        this.tfFromAccountNumber.setText(fromAccountNumber);
        String toAccountNumber = params.get("toAccountNumber");
        if (toAccountNumber == null) {
            toAccountNumber = "";
        }
        this.tfToAccountNumber.setText(toAccountNumber);
        String entryAmount = params.get("entryAmount");
        if (entryAmount == null) {
            entryAmount = "";
        }
        this.tfEntryAmount.setText(entryAmount);
        String entryMinAmount = params.get("entryMinAmount");
        if (entryMinAmount == null) {
            entryMinAmount = "";
        }
        this.tfEntryMinAmount.setText(entryMinAmount);
        String entryMaxAmount = params.get("entryMaxAmount");
        if (entryMaxAmount == null) {
            entryMaxAmount = "";
        }
        this.tfEntryMaxAmount.setText(entryMaxAmount);
        if (params.get("isColumnAlias") != null) {
            this.cbColumnAlias.setSelected(Boolean.valueOf(params.get("isColumnAlias")).booleanValue());
        }
        this.cbExpEntry.setSelected(params.get("isExpEntry") == null || Boolean.valueOf(params.get("isExpEntry")) != false);
        this.cbExpRecord.setSelected(params.get("isExpRecord") == null || Boolean.valueOf(params.get("isExpRecord")) != false);
        if (params.get("isExpCashflow") != null) {
            this.cbCashflow.setSelected(Boolean.valueOf(params.get("isExpCashflow")).booleanValue());
        }
        this.cbExpAccountCustomizedProperty.setSelected(params.get("isExpAccountCustomizedProperty") == null || Boolean.valueOf(params.get("isExpAccountCustomizedProperty")) != false);
        this.cbExpExtendProperty.setSelected(params.get("isExpExtendProperty") == null || Boolean.valueOf(params.get("isExpExtendProperty")) != false);
        String extendParams = params.get("extends");
        if (extendParams == null) {
            extendParams = "";
        }
        this.txtExtends.setText(extendParams);
        if (params.get("batch") != null) {
            this.cbBatch.setSelected(Boolean.valueOf(params.get("batch")).booleanValue());
        }
        if ((batchCount = params.get("batchCount")) != null) {
            try {
                int i = Integer.parseInt(batchCount);
                if (i >= 1 && i <= 500) {
                    this.spBatchCount.setValue((Object)i);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        if ((threadCount = params.get("threadCount")) != null) {
            try {
                int i = Integer.parseInt(threadCount);
                if (i >= 1 && i <= 128) {
                    this.spThreadCount.setValue((Object)i);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (params.get("isCompress") != null) {
            this.cbCompress.setSelected(Boolean.valueOf(params.get("isCompress")).booleanValue());
        }
        if (params.get("showRequest") != null) {
            this.cbShowRequest.setSelected(Boolean.valueOf(params.get("showRequest")).booleanValue());
        }
    }

    SourceSystemSelect getSelectSys() {
        if (this._selectSys == null) {
            this._selectSys = new SourceSystemSelect();
        }
        return this._selectSys;
    }

    SourceTypeSelect getSelectTypes() {
        if (this._selectType == null) {
            this._selectType = new SourceTypeSelect();
        }
        return this._selectType;
    }

    private String getStepName() {
        return EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"182_VoucherPrintParamUI");
    }

    protected Map<String, String> buildConfig() {
        Object[] vts;
        Object[] cs;
        String filepath = this.tfFile.getText().trim();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file", filepath);
        StringBuffer str = new StringBuffer();
        Object object = this.promptCompany.getValue();
        if (object instanceof CompanyOrgUnitInfo[]) {
            for (CompanyOrgUnitInfo companyOrgUnitInfo : cs = (CompanyOrgUnitInfo[])object) {
                str.append(companyOrgUnitInfo.getNumber()).append(";");
            }
        } else if (object instanceof Object[]) {
            for (CompanyOrgUnitInfo companyOrgUnitInfo : cs = (Object[])object) {
                str.append(companyOrgUnitInfo.getNumber()).append(";");
            }
        } else if (object instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo c = (CompanyOrgUnitInfo)object;
            str.append(c.getNumber()).append(";");
        } else if (object != null) {
            str.append(object.toString());
        }
        params.put("companyNumber", str.toString());
        str.setLength(0);
        object = this.promptVoucherType.getValue();
        if (object instanceof VoucherTypeInfo[]) {
            vts = (VoucherTypeInfo[])object;
            for (CompanyOrgUnitInfo companyOrgUnitInfo : vts) {
                str.append(companyOrgUnitInfo.getNumber()).append(";");
            }
        } else if (object instanceof Object[]) {
            vts = (Object[])object;
            for (CompanyOrgUnitInfo companyOrgUnitInfo : vts) {
                str.append(((VoucherTypeInfo)companyOrgUnitInfo).getNumber()).append(";");
            }
        } else if (object instanceof VoucherTypeInfo) {
            VoucherTypeInfo vt = (VoucherTypeInfo)object;
            str.append(vt.getNumber()).append(";");
        } else if (object != null) {
            str.append(object.toString());
        }
        String sysList = this.getSystemSelectedList();
        String typeList = this.getTypeSelectedList();
        params.put("voucherType", str.toString());
        params.put("voucherId", this.tfVoucherId.getText());
        params.put("importKey", this.tfImportKey.getText());
        params.put("voucherNumber", this.tfVoucherNumber.getText());
        params.put("excludeVoucherNumber", this.tfExcludeVoucherNumber.getText());
        params.put("fromVoucherNumber", this.tfFromVoucherNumber.getText());
        params.put("toVoucherNumber", this.tfToVoucherNumber.getText());
        params.put("fromPeriodNumber", this.tfFromPeriod.getText());
        params.put("toPeriodNumber", this.tfToPeriod.getText());
        params.put("fromBookedDate", this.tfFromBookedDate.getText());
        params.put("toBookedDate", this.tfToBookedDate.getText());
        params.put("fromBizDate", this.tfFromBizDate.getText());
        params.put("toBizDate", this.tfToBizDate.getText());
        params.put("sourceSys", sysList);
        params.put("sourceType", typeList);
        params.put("voucherAbstract", this.tfVoucherAbstract.getText());
        params.put("description", this.tfDescription.getText());
        params.put("bizStatusTemp", String.valueOf(this.cbBizStatusTemp.isSelected()));
        params.put("bizStatusSubmit", String.valueOf(this.cbBizStatusSubmit.isSelected()));
        params.put("bizStatusAudit", String.valueOf(this.cbBizStatusAudit.isSelected()));
        params.put("bizStatusPost", String.valueOf(this.cbBizStatusPost.isSelected()));
        params.put("bizStatusCancel", String.valueOf(this.cbBizStatusCancel.isSelected()));
        params.put("checked", String.valueOf(this.cbChecked.isSelected()));
        params.put("notChecked", String.valueOf(this.cbNotChecked.isSelected()));
        params.put("categoryFinance", String.valueOf(this.cbCategoryFinance.isSelected()));
        params.put("categoryBudget", String.valueOf(this.cbCategoryBudget.isSelected()));
        params.put("categoryParallel", String.valueOf(this.cbCategoryParallel.isSelected()));
        params.put("creator", this.tfCreator.getText());
        params.put("auditor", this.tfAuditor.getText());
        params.put("poster", this.tfPoster.getText());
        params.put("cashier", this.tfCashier.getText());
        params.put("entryDescription", this.tfEntryDescription.getText());
        str.setLength(0);
        object = this.promptCurrency.getValue();
        if (object instanceof CurrencyInfo[]) {
            CurrencyInfo[] cys;
            for (CurrencyInfo cy : cys = (CurrencyInfo[])object) {
                str.append(cy.getNumber()).append(";");
            }
        } else if (object instanceof Object[]) {
            Object[] cys;
            for (Object cy : cys = (Object[])object) {
                str.append(((CurrencyInfo)cy).getNumber()).append(";");
            }
        } else if (object instanceof CurrencyInfo) {
            CurrencyInfo cy = (CurrencyInfo)object;
            str.append(cy.getNumber()).append(";");
        } else if (object != null) {
            str.append(object.toString());
        }
        params.put("currency", str.toString());
        params.put("accountNumber", this.tfAccountNumber.getText());
        params.put("fromAccountNumber", this.tfFromAccountNumber.getText());
        params.put("toAccountNumber", this.tfToAccountNumber.getText());
        params.put("entryAmount", this.tfEntryAmount.getText());
        params.put("entryMinAmount", this.tfEntryMinAmount.getText());
        params.put("entryMaxAmount", this.tfEntryMaxAmount.getText());
        params.put("isColumnAlias", String.valueOf(this.cbColumnAlias.isSelected()));
        params.put("isExpEntry", String.valueOf(this.cbExpEntry.isSelected()));
        params.put("isExpRecord", String.valueOf(this.cbExpRecord.isSelected()));
        params.put("isExpCashflow", String.valueOf(this.cbCashflow.isSelected()));
        params.put("isExpAccountCustomizedProperty", String.valueOf(this.cbExpAccountCustomizedProperty.isSelected()));
        params.put("isExpExtendProperty", String.valueOf(this.cbExpExtendProperty.isSelected()));
        params.put("extends", this.txtExtends.getText());
        params.put("batch", String.valueOf(this.cbBatch.isSelected()));
        String batchCount = this.spBatchCount.getValue().toString();
        params.put("batchCount", batchCount);
        String threadCount = this.spThreadCount.getValue().toString();
        params.put("threadCount", threadCount);
        params.put("isCompress", String.valueOf(!this.cbCompress.isVisible() || this.cbCompress.isSelected()));
        params.put("showRequest", String.valueOf(this.cbShowRequest.isVisible() && this.cbShowRequest.isSelected()));
        return params;
    }

    protected void saveConfig() {
        File file;
        Map<String, String> params = this.buildConfig();
        String filepath = this.getFilepath();
        if (filepath != null && (file = new File(filepath)).isDirectory()) {
            this.saveConfig(params, filepath + this.getConfigFile());
        }
    }

    private String getSystemSelectedList() {
        StringBuffer sysSelectedList = new StringBuffer();
        int currectCount = this._selectSys.getSelectedList().getElementCount();
        if (currectCount > 0) {
            for (int i = 0; i < currectCount; ++i) {
                SystemEnum selectSys = (SystemEnum)this._selectSys.getSelectedList().getElement(i);
                sysSelectedList.append(selectSys.getValue()).append(";");
            }
        }
        if (sysSelectedList.length() != 0) {
            sysSelectedList.deleteCharAt(sysSelectedList.length() - 1);
        }
        return sysSelectedList.toString();
    }

    private String getTypeSelectedList() {
        StringBuffer typeSelectedList = new StringBuffer();
        int currectCount = this._selectType.getSelectedList().getElementCount();
        if (currectCount > 0) {
            for (int i = 0; i < currectCount; ++i) {
                SourceType selectType = (SourceType)this._selectType.getSelectedList().getElement(i);
                typeSelectedList.append(selectType.getValue()).append(";");
            }
        }
        if (typeSelectedList.length() != 0) {
            typeSelectedList.deleteCharAt(typeSelectedList.length() - 1);
        }
        return typeSelectedList.toString();
    }

    private String getFilepath() {
        String tempPath = System.getProperty("easclient.root");
        if (tempPath == null) {
            return null;
        }
        tempPath = tempPath + "/";
        tempPath = tempPath.replace('/', File.separatorChar);
        tempPath = tempPath.replace('\\', File.separatorChar);
        return tempPath;
    }

    public void saveConfig(Map<String, String> params, String filename) {
        ArrayList<String> lines = new ArrayList<String>(params.size());
        for (String key : params.keySet()) {
            lines.add(key + "=" + params.get(key));
        }
        this.saveTxt(lines, filename, "UTF-8");
    }

    public Map<String, String> loadConfig(String filename) {
        List<String> lines = this.loadTxt(filename, "UTF-8");
        HashMap<String, String> params = new HashMap<String, String>();
        for (String line : lines) {
            int index = (line = line.trim()).indexOf("=");
            if (index <= 0) continue;
            params.put(line.substring(0, index), line.substring(index + 1));
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTxt(List<String> lines, String filename, String coding) {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), coding));
            for (String line : lines) {
                writer.println(line);
            }
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> loadTxt(String filename, String coding) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            File file = new File(filename);
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), coding));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            this.error(e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return lines;
    }

    private void setSourceSystems() {
        List list = SystemEnum.getEnumList();
        for (SystemEnum item : list) {
            this._selectSys.lstSupply.addElement((Object)item);
        }
    }

    private void setSourceTypes() {
        List list = SourceType.getEnumList();
        for (SourceType item : list) {
            this._selectType.lstSupply.addElement((Object)item);
        }
    }

    protected String getString(String resName) {
        return EASResource.getString((String)RESOURCE, (String)resName);
    }

    class SourceTypeSelect
    extends NormalSelector {
        private KDList lstSupply;

        public SourceTypeSelect() {
            this.init();
        }

        public KDList getSupplyCtrl() {
            return this.lstSupply;
        }

        private void init() {
            this.lstSupply = new KDList();
            this.setSupplyCtrl((JComponent)this.lstSupply);
            this.setSupplyTitle(VoucherExportUI.this.getString("TO_BE_Selected"));
            this.setSelectedTitle(VoucherExportUI.this.getString("Selected"));
        }

        public void setSelected(String selectedList) {
            this.getSelectedList().removeAllElements();
            String[] list = selectedList.split(";");
            ArrayList<SourceType> sourceTypeList = new ArrayList<SourceType>();
            for (int count = 0; count < this.getSupplyCtrl().getElementCount(); ++count) {
                sourceTypeList.add((SourceType)this.getSupplyCtrl().getElement(count));
            }
            for (int i = 0; i < list.length; ++i) {
                for (int j = 0; j < sourceTypeList.size(); ++j) {
                    if (!list[i].equals(String.valueOf(((SourceType)sourceTypeList.get(j)).getValue()))) continue;
                    this.getSelectedList().addElement(sourceTypeList.get(j));
                }
            }
            this.getSelectedList().setSelectedIndex(this.getSelectedList().getElementCount() - 1);
        }

        protected void onSelect() {
            int currentSupplyIdx;
            StringBuffer sbExist = null;
            int currectIdx = this.getSelectedList().getSelectedIndex();
            Object[] objToSelect = this.getSupplyCtrl().getSelectedValues();
            for (int i = objToSelect.length - 1; i >= 0; --i) {
                if (this.getSelectedList().getIndexOfElement(objToSelect[i]) == -1) {
                    this.getSelectedList().insertElement(objToSelect[i], currectIdx + 1);
                    this.getSelectedList().setSelectedValue(objToSelect[i], true);
                    continue;
                }
                if (sbExist == null) {
                    sbExist = new StringBuffer();
                }
                if (sbExist.length() > 0) {
                    sbExist.append(", ");
                }
                sbExist.append(objToSelect[i]);
            }
            if (sbExist != null) {
                sbExist.append("\r\n");
                sbExist.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"179_VoucherPrintParamUI"));
                WindowUtil.msgboxWarning((Object)sbExist.toString(), (String)VoucherExportUI.this.getStepName(), (Component)((Object)this));
            }
            if ((currentSupplyIdx = this.getSupplyCtrl().getSelectedIndex()) + 1 < this.getSupplyCtrl().getElementCount()) {
                this.getSupplyCtrl().setSelectedValue(this.getSupplyCtrl().getElement(currentSupplyIdx + 1), true);
            }
        }

        protected void onSelectAll() {
            this.getSelectedList().removeAllElements();
            int c = this.getSupplyCtrl().getElementCount();
            for (int i = 0; i < c; ++i) {
                this.getSelectedList().addElement(this.getSupplyCtrl().getElement(i));
            }
            this.getSelectedList().setSelectedIndex(this.getSelectedList().getElementCount() - 1);
        }
    }

    class SourceSystemSelect
    extends NormalSelector {
        private KDList lstSupply;

        public SourceSystemSelect() {
            this.init();
        }

        public KDList getSupplyCtrl() {
            return this.lstSupply;
        }

        private void init() {
            this.lstSupply = new KDList();
            this.setSupplyCtrl((JComponent)this.lstSupply);
            this.setSupplyTitle(VoucherExportUI.this.getString("TO_BE_Selected"));
            this.setSelectedTitle(VoucherExportUI.this.getString("Selected"));
        }

        public void setSelected(String selectedList) {
            this.getSelectedList().removeAllElements();
            String[] list = selectedList.split(";");
            ArrayList<SystemEnum> systemEnumList = new ArrayList<SystemEnum>();
            for (int count = 0; count < this.getSupplyCtrl().getElementCount(); ++count) {
                systemEnumList.add((SystemEnum)this.getSupplyCtrl().getElement(count));
            }
            for (int i = 0; i < list.length; ++i) {
                for (int j = 0; j < systemEnumList.size(); ++j) {
                    if (!list[i].equals(String.valueOf(((SystemEnum)systemEnumList.get(j)).getValue()))) continue;
                    this.getSelectedList().addElement(systemEnumList.get(j));
                }
            }
            this.getSelectedList().setSelectedIndex(this.getSelectedList().getElementCount() - 1);
        }

        protected void onSelect() {
            int currentSupplyIdx;
            StringBuffer sbExist = null;
            int currectIdx = this.getSelectedList().getSelectedIndex();
            Object[] objToSelect = this.getSupplyCtrl().getSelectedValues();
            for (int i = objToSelect.length - 1; i >= 0; --i) {
                if (this.getSelectedList().getIndexOfElement(objToSelect[i]) == -1) {
                    this.getSelectedList().insertElement(objToSelect[i], currectIdx + 1);
                    this.getSelectedList().setSelectedValue(objToSelect[i], true);
                    continue;
                }
                if (sbExist == null) {
                    sbExist = new StringBuffer();
                }
                if (sbExist.length() > 0) {
                    sbExist.append(", ");
                }
                sbExist.append(objToSelect[i]);
            }
            if (sbExist != null) {
                sbExist.append("\r\n");
                sbExist.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"179_VoucherPrintParamUI"));
                WindowUtil.msgboxWarning((Object)sbExist.toString(), (String)VoucherExportUI.this.getStepName(), (Component)((Object)this));
            }
            if ((currentSupplyIdx = this.getSupplyCtrl().getSelectedIndex()) + 1 < this.getSupplyCtrl().getElementCount()) {
                this.getSupplyCtrl().setSelectedValue(this.getSupplyCtrl().getElement(currentSupplyIdx + 1), true);
            }
        }

        protected void onSelectAll() {
            this.getSelectedList().removeAllElements();
            int c = this.getSupplyCtrl().getElementCount();
            for (int i = 0; i < c; ++i) {
                this.getSelectedList().addElement(this.getSupplyCtrl().getElement(i));
            }
            this.getSelectedList().setSelectedIndex(this.getSelectedList().getElementCount() - 1);
        }
    }
}

