/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.WSVoucherFactory;
import com.kingdee.eas.fi.gl.ZipUtils;
import com.kingdee.eas.fi.gl.client.VoucherExportUI;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class VoucherExporter {
    protected VoucherExportUI exportUI;
    protected Map<String, String> config;
    protected List<List> tmpData = null;
    protected int cacheSize = 50000;
    protected int voucherCount = 0;
    protected int rowCount = 0;
    protected int batchRowCount = 0;
    protected int tmpDataIndex = 0;
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.client.VoucherExporterResource";

    public String getResource(String resName) {
        return EASResource.getString((String)RESOURCE, (String)resName);
    }

    public VoucherExporter(VoucherExportUI exportUI, Map<String, String> config) {
        this.exportUI = exportUI;
        this.config = config;
        String param = this.config.get("cacheSize");
        if (param != null && param.toString().trim().length() > 0) {
            try {
                int size = Integer.parseInt(param.toString().trim());
                if (size >= 10000 && size <= 200000) {
                    this.cacheSize = size;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tmpData = new ArrayList<List>(this.cacheSize + 10000);
    }

    public boolean beforeExecute() throws Exception {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.info("***************************************************************************");
        try {
            Set<String> extendKeys;
            boolean notChecked;
            boolean checked;
            this.info(this.getResource("begin_export") + " nExportVoucher...");
            if (!this.beforeExecute()) {
                return;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("LOGIN_TYPE", "GUI");
            params.put("companyNumber", this.config.get("companyNumber"));
            params.put("voucherType", this.config.get("voucherType"));
            params.put("voucherId", this.config.get("voucherId"));
            params.put("importKey", this.config.get("importKey"));
            params.put("voucherNumber", this.config.get("voucherNumber"));
            params.put("excludeVoucherNumber", this.config.get("excludeVoucherNumber"));
            params.put("fromVoucherNumber", this.config.get("fromVoucherNumber"));
            params.put("toVoucherNumber", this.config.get("toVoucherNumber"));
            params.put("fromPeriodNumber", this.config.get("fromPeriodNumber"));
            params.put("toPeriodNumber", this.config.get("toPeriodNumber"));
            params.put("fromBookedDate", this.config.get("fromBookedDate"));
            params.put("toBookedDate", this.config.get("toBookedDate"));
            params.put("fromBizDate", this.config.get("fromBizDate"));
            params.put("toBizDate", this.config.get("toBizDate"));
            HashSet<Integer> bizStatuses = new HashSet<Integer>();
            if ("true".equals(this.config.get("bizStatusTemp"))) {
                bizStatuses.add(0);
            }
            if ("true".equals(this.config.get("bizStatusSubmit"))) {
                bizStatuses.add(1);
            }
            if ("true".equals(this.config.get("bizStatusAudit"))) {
                bizStatuses.add(3);
            }
            if ("true".equals(this.config.get("bizStatusPost"))) {
                bizStatuses.add(5);
            }
            if ("true".equals(this.config.get("bizStatusCancel"))) {
                bizStatuses.add(2);
            }
            if (bizStatuses.size() > 0) {
                params.put("bizStatus", bizStatuses);
            }
            if ((checked = Boolean.valueOf(this.config.get("checked")).booleanValue()) != (notChecked = Boolean.valueOf(this.config.get("notChecked")).booleanValue())) {
                params.put("isCheck", checked ? "true" : "false");
            }
            HashSet<Integer> category = new HashSet<Integer>();
            if ("true".equals(this.config.get("categoryFinance"))) {
                category.add(1);
            }
            if ("true".equals(this.config.get("categoryBudget"))) {
                category.add(2);
            }
            if ("true".equals(this.config.get("categoryParallel"))) {
                category.add(3);
            }
            if (category.size() > 0) {
                params.put("category", category);
            }
            params.put("creator", this.config.get("creator"));
            params.put("auditor", this.config.get("auditor"));
            params.put("poster", this.config.get("poster"));
            params.put("cashier", this.config.get("cashier"));
            params.put("sourceSys", this.config.get("sourceSys"));
            params.put("sourceType", this.config.get("sourceType"));
            params.put("voucherAbstract", this.config.get("voucherAbstract"));
            params.put("description", this.config.get("description"));
            params.put("entryDescription", this.config.get("entryDescription"));
            params.put("currency", this.config.get("currency"));
            params.put("accountNumber", this.config.get("accountNumber"));
            params.put("fromAccountNumber", this.config.get("fromAccountNumber"));
            params.put("toAccountNumber", this.config.get("toAccountNumber"));
            params.put("entryAmount", this.config.get("entryAmount"));
            params.put("entryMinAmount", this.config.get("entryMinAmount"));
            params.put("entryMaxAmount", this.config.get("entryMaxAmount"));
            params.put("isColumnAlias", this.config.get("isColumnAlias"));
            params.put("isExpEntry", this.config.get("isExpEntry"));
            params.put("isExpRecord", this.config.get("isExpRecord"));
            params.put("isExpCashflow", this.config.get("isExpCashflow"));
            params.put("isExpAccountCustomizedProperty", this.config.get("isExpAccountCustomizedProperty"));
            params.put("isExpExtendProperty", this.config.get("isExpExtendProperty"));
            params.put("isCompress", this.config.get("isCompress"));
            if (this.config.get("extendKeys") != null) {
                extendKeys = (Set)JSON.parseObject((String)this.config.get("extendKeys"), Set.class);
                for (String key : extendKeys) {
                    if (!this.config.containsKey(key)) continue;
                    params.put(key, this.config.get(key));
                }
            } else {
                extendKeys = new HashSet();
            }
            String companyNumber = (String)params.get("companyNumber");
            String voucherId = (String)params.get("voucherId");
            String voucherNumber = (String)params.get("voucherNumber");
            String importKey = (String)params.get("importKey");
            if (!(!"true".equals(this.config.get("batch")) || companyNumber == null || companyNumber.trim().length() <= 0 || voucherId != null && voucherId.trim().length() != 0 || importKey != null && importKey.trim().length() != 0 || voucherNumber != null && voucherNumber.trim().length() != 0)) {
                this.batch(params, extendKeys);
                return;
            }
            long start = System.currentTimeMillis();
            String jsonParams = JSON.toJSONString(params);
            if ("true".equals(this.config.get("showRequest"))) {
                this.info("params\uff1a" + jsonParams);
            }
            String jsonResult = WSVoucherFactory.getRemoteInstance().nExportVoucher(jsonParams, false);
            if ("true".equals(this.config.get("isCompress"))) {
                jsonResult = ZipUtils.gunzip(jsonResult);
            }
            if ("true".equals(this.config.get("showRequest"))) {
                this.info("result\uff1a" + (jsonResult.length() > 100000 ? jsonResult.substring(0, 100000) : jsonResult));
            }
            Map resultMap = (Map)JSON.parseObject((String)jsonResult, Map.class);
            long used = System.currentTimeMillis() - start;
            List errs = (List)resultMap.get("errs");
            StringBuffer info = new StringBuffer();
            info.append(", " + MessageFormat.format(this.getResource("invoke_time"), used));
            info.append(", " + MessageFormat.format(this.getResource("total_time"), resultMap.get("totalTime")));
            info.append(", " + MessageFormat.format(this.getResource("network_time"), used - Long.parseLong(resultMap.get("totalTime").toString())));
            this.info(info.toString());
            if (errs != null && errs.size() > 0) {
                this.error(this.getResource("export_error"));
                for (int i = 0; i < errs.size(); ++i) {
                    this.error(errs.get(i).toString() + (i == errs.size() - 1 ? "\n" : ""));
                }
                return;
            }
            this.prepareResult(resultMap);
            this.voucherCount = Integer.parseInt(resultMap.get("voucherCount").toString());
            List dataRows = (List)resultMap.get("rows");
            int headSize = "true".equals(this.config.get("isColumnAlias")) ? 2 : 1;
            this.rowCount = dataRows.size() - headSize;
            this.info(MessageFormat.format(this.getResource("finished_detail"), this.voucherCount, this.rowCount, System.currentTimeMillis() - start));
            this.info(this.getResource("generate_excel"));
            long start2 = System.currentTimeMillis();
            String path = this.config.get("file").trim();
            this.buildExcel(dataRows, path);
            this.info(MessageFormat.format(this.getResource("create_excel_time"), System.currentTimeMillis() - start2));
            this.info(MessageFormat.format(this.getResource("export_finished_detail"), System.currentTimeMillis() - start));
            if (dataRows != null && dataRows.size() > 0) {
                this.open(new File(path));
            }
        }
        catch (Exception e) {
            this.error(e);
        }
        finally {
            this.afterExecute();
        }
    }

    protected void prepareResult(Map result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batch(Map<String, Object> params, Set<String> extendKeys) throws Exception {
        long start = System.currentTimeMillis();
        int threadCount = 8;
        try {
            int i = Integer.parseInt(this.config.get("threadCount"));
            if (i >= 1 && i <= 128) {
                threadCount = i;
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        int batchCount = 50;
        try {
            int i = Integer.parseInt(this.config.get("batchCount"));
            if (i >= 1 && i <= 500) {
                batchCount = i;
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        ArrayList<String> batchNames = new ArrayList<String>();
        ArrayList<List> errss = new ArrayList<List>();
        try {
            Object str = (String)params.get("companyNumber");
            str = ((String)str).trim();
            String[] companyNumbers = ((String)str).split(";");
            HashMap<String, Object> companyParams = new HashMap<String, Object>();
            companyParams.putAll(params);
            companyParams.put("onlyVoucherId", "true");
            block11: for (String companyNumber : companyNumbers) {
                if (this.isStop()) break;
                if ((companyNumber = companyNumber.trim()).length() == 0) continue;
                companyParams.put("companyNumber", companyNumber);
                long bstart = System.currentTimeMillis();
                String jsonParams = JSON.toJSONString(companyParams);
                if ("true".equals(this.config.get("showRequest"))) {
                    this.info("params\uff1a" + jsonParams);
                }
                String jsonResult = WSVoucherFactory.getRemoteInstance().nExportVoucher(jsonParams, false);
                if ("true".equals(this.config.get("isCompress"))) {
                    jsonResult = ZipUtils.gunzip(jsonResult);
                }
                if ("true".equals(this.config.get("showRequest"))) {
                    this.info("result\uff1a" + (jsonResult.length() > 100000 ? jsonResult.substring(0, 100000) : jsonResult));
                }
                Map resultMap = (Map)JSON.parseObject((String)jsonResult, Map.class);
                long bused = System.currentTimeMillis() - bstart;
                StringBuffer info = new StringBuffer();
                info.append(MessageFormat.format(this.getResource("org_time"), companyNumber, bused));
                info.append(", " + MessageFormat.format(this.getResource("total_time"), resultMap.get("totalTime")));
                info.append(", " + MessageFormat.format(this.getResource("network_time"), bused - Long.parseLong(resultMap.get("totalTime").toString())));
                this.info(info.toString());
                List errs = (List)resultMap.get("errs");
                if (errs != null && errs.size() > 0) {
                    errss.add(errs);
                    break;
                }
                List allVoucherIds = (List)resultMap.get("rows");
                if (allVoucherIds.size() == 0) {
                    allVoucherIds.add("notexistvoucherid");
                }
                List<List<String>> batchs = this.split(allVoucherIds, batchCount);
                int batchIndex = 0;
                for (List<String> batch : batchs) {
                    if (this.isStop()) continue block11;
                    HashMap<String, Object> batchParams = new HashMap<String, Object>();
                    batchParams.put("LOGIN_TYPE", "GUI");
                    batchParams.put("companyNumber", companyNumber);
                    batchParams.put("voucherId", batch);
                    batchParams.put("isColumnAlias", this.config.get("isColumnAlias"));
                    batchParams.put("isExpEntry", this.config.get("isExpEntry"));
                    batchParams.put("isExpRecord", this.config.get("isExpRecord"));
                    batchParams.put("isExpCashflow", this.config.get("isExpCashflow"));
                    batchParams.put("isExpAccountCustomizedProperty", this.config.get("isExpAccountCustomizedProperty"));
                    batchParams.put("isExpExtendProperty", this.config.get("isExpExtendProperty"));
                    batchParams.put("isCompress", this.config.get("isCompress"));
                    batchParams.put("batch", "true");
                    for (String key : extendKeys) {
                        if (!this.config.containsKey(key)) continue;
                        batchParams.put(key, this.config.get(key));
                    }
                    String name = companyNumber + ", " + ++batchIndex + "/" + batchs.size();
                    Future future = executor.submit(new ExportCallable(name, batchParams));
                    futures.add(future);
                    if (futures.size() < 100) continue;
                    this.wait(futures, batchNames, errss);
                }
            }
            if (futures.size() > 0) {
                this.wait(futures, batchNames, errss);
            }
        }
        finally {
            try {
                executor.shutdown();
            }
            catch (Throwable str) {}
        }
        if (errss.size() > 0) {
            for (List errs : errss) {
                this.error(this.getResource("export_error"));
                for (int i = 0; i < errs.size(); ++i) {
                    this.error(errs.get(i).toString() + (i == errs.size() - 1 ? "\n" : ""));
                }
            }
        }
        this.info(MessageFormat.format(this.getResource("finished_detail"), this.voucherCount, this.rowCount, System.currentTimeMillis() - start));
        this.info(this.getResource("generate_excel"));
        long start2 = System.currentTimeMillis();
        String path = this.config.get("file").trim();
        this.batchExcel(batchNames, this.tmpData, path);
        this.info(MessageFormat.format(this.getResource("create_excel_time"), System.currentTimeMillis() - start2));
        this.info(MessageFormat.format(this.getResource("export_finished_detail"), System.currentTimeMillis() - start));
        if (batchNames.size() > 0 || this.tmpData.size() > 0) {
            this.open(new File(path));
        }
    }

    private void wait(List<Future<Object>> futures, List<String> batchNames, List<List> errss) throws BOSException, EASBizException {
        Throwable ex = null;
        int headSize = "true".equals(this.config.get("isColumnAlias")) ? 2 : 1;
        for (Future<Object> one : futures) {
            try {
                List rows;
                Map resultMap = (Map)one.get();
                if (resultMap == null || resultMap.size() <= 0) continue;
                List errs = (List)resultMap.get("errs");
                if (errs != null && errs.size() > 0) {
                    errss.add(errs);
                }
                if ((rows = (List)resultMap.get("rows")) == null || rows.size() <= 0) continue;
                this.prepareResult(resultMap);
                rows = (List)resultMap.get("rows");
                if (this.batchRowCount > 0 && this.batchRowCount + rows.size() > this.cacheSize) {
                    String batchName = this.saveTmpFile(this.tmpData);
                    batchNames.add(batchName);
                    this.tmpData = new ArrayList<List>(this.cacheSize + 10000);
                    this.batchRowCount = 0;
                }
                if (this.tmpData.size() == 0) {
                    this.tmpData.addAll(rows);
                } else {
                    this.tmpData.addAll(rows.subList(headSize, rows.size()));
                }
                this.batchRowCount += rows.size() - headSize;
                this.rowCount += rows.size() - headSize;
                Object obj = resultMap.get("voucherCount");
                if (obj == null) continue;
                this.voucherCount += Integer.parseInt(obj.toString());
            }
            catch (Throwable e2) {
                Exception e2;
                Throwable cause = e2.getCause();
                if (cause != null && (cause instanceof EASBizException || cause instanceof BOSException)) {
                    e2 = (Exception)cause;
                }
                if (ex != null) continue;
                ex = e2;
            }
        }
        futures.clear();
        if (ex != null) {
            if (ex instanceof EASBizException) {
                throw (EASBizException)ex;
            }
            if (ex instanceof BOSException) {
                throw (BOSException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new BOSException(ex);
        }
    }

    private List<List<String>> split(List<String> set, int size) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        if (set.size() <= size) {
            ArrayList<String> part = new ArrayList<String>();
            part.addAll(set);
            list.add(part);
        } else {
            ArrayList<String> part = new ArrayList<String>();
            for (String str : set) {
                part.add(str);
                if (part.size() < size) continue;
                list.add(part);
                part = new ArrayList();
            }
            if (part.size() > 0) {
                list.add(part);
            }
        }
        return list;
    }

    public void open(File file) {
        String command = "cmd /c start " + file.getAbsolutePath();
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void afterExecute() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildExcel(List<List> dataRows, String filepath) throws Exception {
        int j;
        Row row;
        int i;
        SXSSFWorkbook workbook = new SXSSFWorkbook(500);
        CellStyle txtStyle = workbook.createCellStyle();
        DataFormat format = workbook.createDataFormat();
        txtStyle.setDataFormat(format.getFormat("@"));
        SXSSFSheet currentSheet = workbook.createSheet(this.getResource("voucher"));
        int headSize = "true".equals(this.config.get("isColumnAlias")) ? 2 : 1;
        HashSet<Integer> numColumns = new HashSet<Integer>();
        for (i = 0; i < headSize; ++i) {
            row = currentSheet.createRow(i);
            List head = dataRows.get(i);
            for (j = 0; j < head.size(); ++j) {
                String colName = (String)head.get(j);
                row.createCell(j).setCellValue(colName);
                if (i != 0 || !"localRate".equals(colName) && !"originalAmount".equals(colName) && !"debitAmount".equals(colName) && !"creditAmount".equals(colName) && !"qty".equals(colName) && !"price".equals(colName) && !"cashflowAmountOriginal".equals(colName) && !"cashflowAmountLocal".equals(colName) && !"cashflowAmountRpt".equals(colName)) continue;
                numColumns.add(j);
            }
        }
        for (i = headSize; i < dataRows.size(); ++i) {
            row = currentSheet.createRow(i);
            List items = dataRows.get(i);
            for (j = 0; j < items.size(); ++j) {
                String value = (String)items.get(j);
                if (value != null && numColumns.contains(j)) {
                    if ((value = value.trim()).length() > 0) {
                        row.createCell(j).setCellValue(Double.parseDouble(value));
                        continue;
                    }
                    row.createCell(j).setCellValue(value);
                    continue;
                }
                Cell cell = row.createCell(j);
                cell.setCellValue(value);
                cell.setCellStyle(txtStyle);
            }
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(filepath);
            workbook.write((OutputStream)os);
            os.flush();
        }
        finally {
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchExcel(List<String> batchNames, List<List> lastData, String filepath) throws Exception {
        SXSSFWorkbook workbook = new SXSSFWorkbook(500);
        CellStyle txtStyle = workbook.createCellStyle();
        DataFormat format = workbook.createDataFormat();
        txtStyle.setDataFormat(format.getFormat("@"));
        int headSize = "true".equals(this.config.get("isColumnAlias")) ? 2 : 1;
        int sheetIndex = 1;
        int rowIndex = 0;
        HashSet<Integer> numColumns = new HashSet<Integer>();
        SXSSFSheet currentSheet = workbook.createSheet(this.getResource("voucher") + sheetIndex++);
        for (int bi = 0; bi <= batchNames.size(); ++bi) {
            int startIndex;
            List dataRows;
            if (bi < batchNames.size()) {
                String batchName = batchNames.get(bi);
                Object object = this.readTmpFile(batchName, true);
                if (object == null && !(object instanceof List)) continue;
                dataRows = (List)object;
            } else {
                dataRows = lastData;
            }
            if (rowIndex > 0 && rowIndex + dataRows.size() - headSize > 1000000) {
                currentSheet = workbook.createSheet(this.getResource("voucher") + sheetIndex++);
                rowIndex = 0;
            }
            if (rowIndex == 0) {
                numColumns = new HashSet();
                List head = dataRows.get(0);
                for (int j = 0; j < head.size(); ++j) {
                    String colName = (String)head.get(j);
                    if (!"localRate".equals(colName) && !"originalAmount".equals(colName) && !"debitAmount".equals(colName) && !"creditAmount".equals(colName) && !"qty".equals(colName) && !"price".equals(colName) && !"cashflowAmountOriginal".equals(colName) && !"cashflowAmountLocal".equals(colName) && !"cashflowAmountRpt".equals(colName)) continue;
                    numColumns.add(j);
                }
            }
            for (int i = startIndex = rowIndex == 0 ? 0 : headSize; i < dataRows.size(); ++i) {
                int j;
                Row row = currentSheet.createRow(rowIndex++);
                List items = (List)dataRows.get(i);
                if (i >= headSize) {
                    for (j = 0; j < items.size(); ++j) {
                        String value = (String)items.get(j);
                        if (value != null && numColumns.contains(j)) {
                            if ((value = value.trim()).length() > 0) {
                                row.createCell(j).setCellValue(Double.parseDouble(value));
                                continue;
                            }
                            row.createCell(j).setCellValue(value);
                            continue;
                        }
                        Cell cell = row.createCell(j);
                        cell.setCellValue(value);
                        cell.setCellStyle(txtStyle);
                    }
                    continue;
                }
                for (j = 0; j < items.size(); ++j) {
                    row.createCell(j).setCellValue((String)items.get(j));
                }
            }
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(filepath);
            workbook.write((OutputStream)os);
            os.flush();
        }
        finally {
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected String saveTmpFile(List<List> data) throws BOSException {
        File tmp;
        if (data == null) {
            return null;
        }
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (tmpdir == null) {
            return null;
        }
        File dir = new File(tmpdir);
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        dir = new File(tmpdir + File.separator + "gl");
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdir();
        }
        File file = null;
        Object name = null;
        String prefix = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS_").format(new Date());
        for (int i = 0; i < 1000; ++i) {
            tmp = new File(tmpdir + File.separator + "gl" + File.separator + prefix + i + ".tmp");
            if (tmp.exists()) continue;
            file = tmp;
            name = prefix + i;
            break;
        }
        if (file == null) {
            return null;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            JSON.writeJSONString((OutputStream)fos, data, (SerializerFeature[])new SerializerFeature[0]);
            tmp = name;
            return tmp;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected Object readTmpFile(String name, boolean delete) throws BOSException {
        if (name == null || !name.equals(FilenameUtils.normalize((String)name))) {
            return null;
        }
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (tmpdir == null) {
            return null;
        }
        File dir = new File(tmpdir);
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        dir = new File(tmpdir + File.separator + "gl");
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        File file = new File(tmpdir + File.separator + "gl" + File.separator + name + ".tmp");
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            Object object = JSON.parseObject((InputStream)fis, List.class, (Feature[])new Feature[0]);
            return object;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (delete) {
                file.delete();
            }
        }
    }

    public boolean isStop() {
        return false;
    }

    public void info(String msg) {
        this.exportUI.info(msg);
    }

    public void warn(String msg) {
        this.exportUI.warn(msg);
    }

    public void error(String msg) {
        this.exportUI.error(msg);
    }

    public void error(Throwable t) {
        this.exportUI.error(t);
    }

    class ExportCallable
    implements Callable {
        private String name;
        private Map<String, Object> params;

        public ExportCallable(String name, Map<String, Object> params) {
            this.name = name;
            this.params = params;
        }

        public Object call() throws Exception {
            if (VoucherExporter.this.isStop()) {
                return new HashMap();
            }
            long start = System.currentTimeMillis();
            String jsonParams = JSON.toJSONString(this.params);
            String jsonResult = WSVoucherFactory.getRemoteInstance().nExportVoucher(jsonParams, false);
            if ("true".equals(VoucherExporter.this.config.get("isCompress"))) {
                jsonResult = ZipUtils.gunzip(jsonResult);
            }
            Map resultMap = (Map)JSON.parseObject((String)jsonResult, Map.class);
            long used = System.currentTimeMillis() - start;
            StringBuffer info = new StringBuffer();
            info.append(MessageFormat.format(VoucherExporter.this.getResource("batch_time"), this.name, used));
            info.append(", " + MessageFormat.format(VoucherExporter.this.getResource("total_time"), resultMap.get("totalTime")));
            info.append(", " + MessageFormat.format(VoucherExporter.this.getResource("network_time"), used - Long.parseLong(resultMap.get("totalTime").toString())));
            VoucherExporter.this.info(info.toString());
            return resultMap;
        }
    }
}

