/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IVoucherFacade;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.client.AbstractVoucherFastFailParamUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class VoucherFastFailParamUI
extends AbstractVoucherFastFailParamUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherFastFailParamUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblParam.checkParsed();
        this.tblParam.getSelectManager().setSelectMode(1);
        this.tblParam.getColumn("actionNode").getStyleAttributes().setLocked(true);
        this.showFastFailParam(this.getFastFailParam());
    }

    private void showFastFailParam(Map<String, Boolean> fastFailParam) {
        if (fastFailParam != null && fastFailParam.size() > 0) {
            Iterator<String> iterator = fastFailParam.keySet().iterator();
            this.tblParam.removeRows();
            while (iterator.hasNext()) {
                String actionNode = iterator.next();
                boolean status = fastFailParam.get(actionNode);
                IRow row = this.tblParam.addRow();
                row.getCell("actionNode").setValue((Object)actionNode);
                row.getCell("status").setValue((Object)status);
            }
            this.tblParam.getSelectManager().select(0, 0);
        }
    }

    protected Map<String, Boolean> getFastFailParam() throws BOSException, EASBizException {
        IVoucherFacade iVoucherFacade = this.getRemoteInterface();
        return iVoucherFacade.flushVoucherFastFailCache(null);
    }

    private IVoucherFacade getRemoteInterface() throws BOSException {
        return VoucherFacadeFactory.getRemoteInstance();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        String msg = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.VoucherEditResource", (String)"FAST_FAIL_WARNING");
        int result = MsgBox.showConfirm2((Component)((Object)this), (String)msg);
        if (result != 0) {
            return;
        }
        LinkedHashMap<String, Boolean> fastFailConfigMap = new LinkedHashMap<String, Boolean>();
        for (int i = 0; i < this.tblParam.getRowCount(); ++i) {
            IRow row = this.tblParam.getRow(i);
            Object actionNode = row.getCell("actionNode").getValue();
            if (actionNode == null) continue;
            String key = (String)actionNode;
            Boolean value = (Boolean)row.getCell("status").getValue();
            fastFailConfigMap.put(key, value);
        }
        Map map = this.getRemoteInterface().flushVoucherFastFailCache(fastFailConfigMap);
        this.destroyWindow();
    }
}

