/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GLPeriodFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherIOSparser;
import com.kingdee.eas.fi.gl.client.AbstractVoucherFilterPanel;
import com.kingdee.eas.fi.gl.client.CompanyTreePromptBox;
import com.kingdee.eas.fi.gl.client.DateUtils;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class VoucherFilterPanel
extends AbstractVoucherFilterPanel {
    private static final Logger logger = CoreUIObject.getLogger(VoucherFilterPanel.class);
    public static final String CWGXRESOURCE = "com.kingdee.eas.fi.gl.client.CWGXResource";
    protected UserInfo curUser = SysContext.getSysContext().getCurrentUserInfo();
    private VoucherFilterParam param;
    boolean isMasterBook = SysContext.getSysContext().getCurrentFIUnit().getMainOrg() == null;
    private String uiParam = null;
    private String companyIdFilter = null;
    public static final Object ALL_CURRENCY = new Object(){

        public String toString() {
            return EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"ALLCURRENCY");
        }
    };

    public VoucherFilterPanel(String uiparam) throws Exception {
        ExtendParser parserAccountFrom = new ExtendParser(this.pbxAccountFrom);
        this.pbxAccountFrom.setCommitParser((IParser)parserAccountFrom);
        ExtendParser parserAccountTo = new ExtendParser(this.pbxAccountTo);
        this.pbxAccountTo.setCommitParser((IParser)parserAccountTo);
        this.initUIContentLayout();
        this.dateFrom.setSupportedEmpty(false);
        this.dateTo.setSupportedEmpty(false);
        this.uiParam = uiparam;
    }

    public void initListener() {
        super.initListener();
        this.bpCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                if (VoucherFilterPanel.this.isCompanyChanged(event)) {
                    VoucherFilterPanel.this.companyChanged();
                    VoucherFilterPanel.this.changeAccountTable(event.getNewValue());
                }
            }
        });
        this.bpAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                try {
                    if (event.getStateChange() == 1 || VoucherFilterPanel.this.bpAccount.getSelectedItem() == null) {
                        VoucherFilterPanel.this.accountTableChanged();
                    }
                }
                catch (Exception e) {
                    VoucherFilterPanel.this.handUIException(e);
                }
            }
        });
    }

    public void changeAccountTable(Object obj) {
        AccountTableInfo atc = null;
        if (obj instanceof CompanyOrgUnitInfo) {
            atc = ((CompanyOrgUnitInfo)obj).getAccountTable();
        }
        this.setSelectedItem(this.bpAccount, atc);
    }

    protected void accountTableChanged() throws Exception {
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getSelectedItem();
        boolean b = account != null;
        this.pbxAccountFrom.setEnabled(b);
        this.pbxAccountTo.setEnabled(b);
        this.pbxAccountFrom.setValue(null);
        this.pbxAccountTo.setValue(null);
        this.setAccountF7Filter();
    }

    protected void setAccountF7Filter() {
        try {
            AccountTableInfo accountTable = (AccountTableInfo)this.bpAccount.getSelectedItem();
            CompanyOrgUnitInfo[] companys = this.getCompanys();
            if (accountTable == null || companys == null) {
                return;
            }
            FilterInfo filter = new FilterInfo();
            CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
            for (int i = 0; i < companys.length; ++i) {
                companyColl.add(companys[i]);
            }
            FilterInfo treeNodefilter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            if (companyColl.size() == 1) {
                fic.add(new FilterItemInfo("companyID.id", (Object)companys[0].getId().toString()));
            } else {
                CompanyOrgUnitInfo company = AccountTools.getCUCompanyOrgUnitInfo(null, (CompanyOrgUnitCollection)companyColl);
                fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
            }
            fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
            fic.add(new FilterItemInfo("isProfitCenter", (Object)1, CompareType.NOTEQUALS));
            String mStr = "#0 AND #1 AND #2";
            filter.setMaskString(mStr);
            if (this.uiParam != null) {
                HashSet<Integer> budgets = new HashSet<Integer>();
                budgets.add(12);
                budgets.add(13);
                budgets.add(14);
                if (this.uiParam.indexOf("VoucherCategory=FINANCE") >= 0) {
                    treeNodefilter.getFilterItems().add(new FilterItemInfo("property", budgets, CompareType.NOTINCLUDE));
                } else if (this.uiParam.indexOf("VoucherCategory=BUDGET") >= 0) {
                    treeNodefilter.getFilterItems().add(new FilterItemInfo("property", budgets, CompareType.INCLUDE));
                }
            }
            AccountPromptBox apb = new AccountPromptBox((IUIObject)this, companyColl, accountTable, filter, false, false, false);
            if (treeNodefilter.getFilterItems().size() > 0) {
                apb.setTreeNodefilter(treeNodefilter);
            }
            this.pbxAccountFrom.setSelector((KDPromptSelector)apb);
            this.pbxAccountTo.setSelector((KDPromptSelector)apb);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initAccountF7() throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        this.pbxAccountFrom.setEditable(true);
        this.pbxAccountFrom.setEditFormat("$number$");
        this.pbxAccountFrom.setCommitFormat("$helpCode$;$number$;$name$");
        this.pbxAccountFrom.setDisplayFormat("$number$ - $name$");
        this.pbxAccountFrom.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.pbxAccountFrom.setSelectorCollection(sic);
        this.pbxAccountFrom.setCommitParser((IParser)new AccountViewParser(this.pbxAccountFrom));
        this.pbxAccountTo.setEditFormat("$number$");
        this.pbxAccountTo.setCommitFormat("$helpCode$;$number$;$name$");
        this.pbxAccountTo.setDisplayFormat("$number$ - $name$");
        this.pbxAccountTo.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.pbxAccountTo.setSelectorCollection(sic);
        this.pbxAccountTo.setCommitParser((IParser)new AccountViewParser(this.pbxAccountTo));
        this.pbxAccountFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (!(VoucherFilterPanel.this.pbxAccountFrom.getData() instanceof AccountViewInfo)) {
                    VoucherFilterPanel.this.pbxAccountFrom.setValue(null);
                }
            }
        });
        this.pbxAccountTo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (!(VoucherFilterPanel.this.pbxAccountTo.getData() instanceof AccountViewInfo)) {
                    VoucherFilterPanel.this.pbxAccountTo.setValue(null);
                }
            }
        });
    }

    protected boolean isCompanyChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            return e.getOldValue() != null;
        }
        if (e.getOldValue() == null) {
            return true;
        }
        return !this.isCompanyEquals(e.getNewValue(), e.getOldValue());
    }

    protected boolean isCompanyEquals(Object newObject, Object oldObject) {
        if (newObject instanceof Object[] && oldObject instanceof Object[] && Arrays.toString((Object[])newObject).equalsIgnoreCase(Arrays.toString((Object[])oldObject))) {
            return true;
        }
        if (newObject instanceof CompanyOrgUnitInfo && oldObject instanceof CompanyOrgUnitInfo) {
            return ((CompanyOrgUnitInfo)newObject).getId().equals((Object)((CompanyOrgUnitInfo)oldObject).getId());
        }
        return false;
    }

    public boolean verify() {
        Date dateend;
        Date datestart;
        if (this.radByDate.isSelected() && (datestart = (Date)this.dateFrom.getValue()).after(dateend = (Date)this.dateTo.getValue())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"94_VoucherFilterPanel"));
            return false;
        }
        if (this.getCompanys() == null) {
            this.bpCompany.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"104_HGReplaceToolUI"));
            return false;
        }
        return this.verifyViewPermission();
    }

    protected CompanyOrgUnitInfo[] getCompanys() {
        Object company = this.bpCompany.getValue();
        if (company instanceof CompanyOrgUnitInfo) {
            return new CompanyOrgUnitInfo[]{(CompanyOrgUnitInfo)company};
        }
        if (this.bpCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            return (CompanyOrgUnitInfo[])this.bpCompany.getValue();
        }
        if (this.bpCompany.getValue() instanceof Object[]) {
            Object[] companyObjs = (Object[])this.bpCompany.getValue();
            return this.toObjectArray2CompanyArray(companyObjs);
        }
        return null;
    }

    private CompanyOrgUnitInfo[] toObjectArray2CompanyArray(Object[] companyObjs) {
        ArrayList<Object> companyList = new ArrayList<Object>();
        for (int i = 0; i < companyObjs.length; ++i) {
            if (!(companyObjs[i] instanceof CompanyOrgUnitInfo)) continue;
            companyList.add(companyObjs[i]);
        }
        if (companyList.isEmpty()) {
            return null;
        }
        CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[companyList.size()];
        return companyList.toArray(companys);
    }

    protected void setCompanys(CompanyOrgUnitInfo[] companys) {
        this.bpCompany.setValue((Object)companys);
    }

    public void onLoad() throws Exception {
        this.bpCompany.setEnabledMultiSelection(true);
        super.onLoad();
        this.initCompanyF7();
        this.initAccountTableComboBox();
        this.initCurrencyComboBox();
        this.initAccountF7();
    }

    private void initCompanyF7() throws Exception {
        EntityViewInfo companyView = new EntityViewInfo();
        companyView.setSelector(GlUtils.getCompanySic());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        companyView.setFilter(filter);
        this.bpCompany.setEntityViewInfo(companyView);
        this.bpCompany.setSelector(this.getCompanySelector());
    }

    protected KDPromptSelector getCompanySelector() {
        if (!GlUtils.isEmpty(this.uiParam) && "FSSC".equalsIgnoreCase(this.uiParam)) {
            return new CompanyTreePromptBox((CoreUIObject)this, null, this.bpCompany, this.getPermissionItem(), true);
        }
        NewCompanyF7 companySelector = new NewCompanyF7((IUIObject)this);
        companySelector.setShowAssistantOrg(false);
        companySelector.setIsCUFilter(false);
        companySelector.setShowVirtual(false);
        companySelector.setContainSealUp(false);
        companySelector.setNeedAddAssistant(true);
        companySelector.setOuterFilterInfo(this.getCompanyFilterInfo());
        return companySelector;
    }

    private FilterInfo getCompanyFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("unit.id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        return filter;
    }

    private String getCompanyIdFilter() {
        if (this.companyIdFilter != null) {
            return this.companyIdFilter;
        }
        try {
            this.companyIdFilter = GLGeneralFacadeFactory.getRemoteInstance().getCompanyIDSQL(this.getPermissionItem(), null, true);
            return this.companyIdFilter;
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    public void onShow() throws Exception {
        this.radByDate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    VoucherFilterPanel.this.radByPeriodOrDate_stateChanged(e);
                }
                catch (Exception exc) {
                    VoucherFilterPanel.this.handUIException(exc);
                }
            }
        });
        this.pbxAccountFrom.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (VoucherFilterPanel.this.pbxAccountFrom.getData() instanceof String) {
                    VoucherFilterPanel.this.pbxAccountFrom.setUserObject(null);
                    VoucherFilterPanel.this.pbxAccountFrom.setText(null);
                }
            }
        });
        this.pbxAccountTo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (VoucherFilterPanel.this.pbxAccountTo.getData() instanceof String) {
                    VoucherFilterPanel.this.pbxAccountTo.setUserObject(null);
                    VoucherFilterPanel.this.pbxAccountTo.setText(null);
                }
            }
        });
        this.dateFrom.setSupportedEmpty(false);
        this.dateTo.setSupportedEmpty(false);
    }

    @Override
    protected void radByPeriodOrDate_stateChanged(ChangeEvent e) throws Exception {
        if (this.radByPeriod.isSelected()) {
            this.pnlByPeriod.setVisible(true);
            this.pnlByDate.setVisible(false);
        } else {
            this.pnlByPeriod.setVisible(false);
            this.pnlByDate.setVisible(true);
        }
    }

    public boolean isByPeriod() {
        return this.radByPeriod.isSelected();
    }

    public String getStartPeriod() {
        Integer yearFrom = (Integer)this.spnYearFrom.getValue();
        Integer periodFrom = (Integer)this.spnPeriodFrom.getValue();
        return yearFrom + "." + periodFrom;
    }

    public String getEndPeriod() {
        Integer yearTo = (Integer)this.spnYearTo.getValue();
        Integer periodTo = (Integer)this.spnPeriodTo.getValue();
        return yearTo + "." + periodTo;
    }

    public String getStartDate() {
        DateFormat df = DateUtils.getDateFormat(1);
        Date date = (Date)this.dateFrom.getValue();
        return df.format(date);
    }

    public String getEndDate() {
        DateFormat df = DateUtils.getDateFormat(1);
        Date date = (Date)this.dateTo.getValue();
        return df.format(date);
    }

    public void syschronizeParam() {
        this.param = (VoucherFilterParam)this.getParam();
    }

    public VoucherFilterParam getParamOuter() {
        return this.param;
    }

    public FilterInfo getFilterInfo() {
        Object cur;
        AccountViewInfo accfromInfo;
        this.param = (VoucherFilterParam)this.getParam();
        int flag = this.param.getFlag();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        int index = 0;
        fic.add(new FilterItemInfo("company.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        StringBuffer maskString = new StringBuffer("#").append(index++).append(" AND ");
        AccountTableInfo accountTable = (AccountTableInfo)this.bpAccount.getSelectedItem();
        if (accountTable != null) {
            String accountTableId = accountTable.getId().toString();
            fic.add(new FilterItemInfo("account.accountTableID.id", (Object)accountTableId));
            maskString.append("#").append(index++).append(" AND ");
        }
        Set periodIds = null;
        maskString.append(" (");
        if ((flag & 0x40) != 0) {
            Date dtFrom = (Date)this.dateFrom.getValue();
            Date dtTo = (Date)this.dateTo.getValue();
            if (dtFrom == null || dtTo == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"5_ReqCheckFilterUI"));
                SysUtil.abort();
            }
            fic.add(new FilterItemInfo("bookedDate", (Object)DateTimeUtils.format((Date)dtFrom), CompareType.GREATER_EQUALS));
            fic.add(new FilterItemInfo("bookedDate", (Object)DateTimeUtils.format((Date)dtTo), CompareType.LESS_EQUALS));
            maskString.append("#" + index++ + " AND ");
            maskString.append("#" + index++ + ")");
            try {
                periodIds = GLPeriodFacadeFactory.getRemoteInstance().getPeriodIds(this.getCompanyIdSet(), dtFrom, dtTo);
            }
            catch (BOSException e) {
                logger.error((Object)e);
                SysUtil.abort((Throwable)e);
            }
        } else {
            Integer yearFrom = (Integer)this.spnYearFrom.getValue();
            Integer periodFrom = (Integer)this.spnPeriodFrom.getValue();
            Integer yearTo = (Integer)this.spnYearTo.getValue();
            Integer periodTo = (Integer)this.spnPeriodTo.getValue();
            Integer from = new Integer(yearFrom * 100 + periodFrom);
            Integer to = new Integer(yearTo * 100 + periodTo);
            try {
                Set pIds = GLPeriodFacadeFactory.getRemoteInstance().getPeriodIds(this.getCompanyIdSet(), from, to);
                if (pIds.size() == 0) {
                    pIds.add("unknow");
                }
                if (pIds != null && !pIds.isEmpty()) {
                    fic.add(new FilterItemInfo("period.id", (Object)pIds, CompareType.INCLUDE));
                    maskString.append("#" + index++ + ")");
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
                SysUtil.abort((Throwable)e);
            }
        }
        if ((flag & 1) != 0 && this.pbxAccountFrom.getValue() instanceof AccountViewInfo && (accfromInfo = (AccountViewInfo)this.pbxAccountFrom.getValue()) != null) {
            String accFrom = accfromInfo.getNumber().trim();
            fic.add(new FilterItemInfo("account.number", (Object)accFrom, CompareType.GREATER_EQUALS));
            maskString.append(" AND #" + index++);
        }
        if ((flag & 2) != 0 && this.pbxAccountTo.getValue() instanceof AccountViewInfo && (accfromInfo = (AccountViewInfo)this.pbxAccountTo.getValue()) != null) {
            String accTo = accfromInfo.getNumber().trim() + "z";
            fic.add(new FilterItemInfo("account.number", (Object)accTo, CompareType.LESS_EQUALS));
            maskString.append(" AND #" + index++);
        }
        if ((flag & 4) != 0 && (cur = this.cbxCurrency.getSelectedItem()) != null && cur != ALL_CURRENCY) {
            fic.add(new FilterItemInfo("currency.id", (Object)((CurrencyInfo)cur).getId().toString()));
            maskString.append(" AND #" + index++);
        }
        if ((flag & 0x20) != 0) {
            if (this.radCheck.isSelected()) {
                fic.add(new FilterItemInfo("cashier.id", null, CompareType.NOTEQUALS));
            } else {
                fic.add(new FilterItemInfo("cashier.id", null));
            }
            maskString.append(" AND #" + index++);
        }
        if ((flag & 8) != 0) {
            if (this.radAudited.isSelected()) {
                fic.add(new FilterItemInfo("auditor.id", null, CompareType.NOTEQUALS));
            } else {
                fic.add(new FilterItemInfo("auditor.id", null));
            }
            maskString.append(" AND #" + index++);
        }
        if ((flag & 0x10) != 0) {
            if (this.radPosted.isSelected()) {
                fic.add(new FilterItemInfo("bizStatus", (Object)new Integer(5)));
            } else {
                fic.add(new FilterItemInfo("bizStatus", (Object)new Integer(5), CompareType.NOTEQUALS));
            }
            maskString.append(" AND #" + index++);
        }
        if (periodIds != null && periodIds.size() > 0) {
            fic.add(new FilterItemInfo("period.id", (Object)periodIds, CompareType.INCLUDE));
            maskString.append(" AND #" + index++);
        }
        filter.setMaskString(maskString.toString());
        return filter;
    }

    public FilterInfo getVoucherFilterInfo() {
        this.param = (VoucherFilterParam)this.getParam();
        int flag = this.param.getFlag();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        int index = 0;
        StringBuffer maskString = null;
        if (this.getCompanyIdSet() == null || this.getCompanyIdSet().size() == 0) {
            maskString = new StringBuffer("(");
        } else {
            fic.add(new FilterItemInfo("company.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
            maskString = new StringBuffer("#0 AND (");
            index = 1;
        }
        if ((flag & 0x40) != 0) {
            Date dtFrom = (Date)this.dateFrom.getValue();
            Date dtTo = (Date)this.dateTo.getValue();
            fic.add(new FilterItemInfo("bookedDate", (Object)DateTimeUtils.format((Date)dtFrom), CompareType.GREATER_EQUALS));
            fic.add(new FilterItemInfo("bookedDate", (Object)DateTimeUtils.format((Date)dtTo), CompareType.LESS_EQUALS));
            maskString.append("#" + index++ + " AND ");
            maskString.append("#" + index++ + ")");
        } else {
            Integer yearFrom = (Integer)this.spnYearFrom.getValue();
            Integer periodFrom = (Integer)this.spnPeriodFrom.getValue();
            Integer yearTo = (Integer)this.spnYearTo.getValue();
            Integer periodTo = (Integer)this.spnPeriodTo.getValue();
            Integer from = new Integer(yearFrom * 100 + periodFrom);
            Integer to = new Integer(yearTo * 100 + periodTo);
            if ((flag & 0x80) != 0) {
                fic.add(new FilterItemInfo("period.number", (Object)from));
                maskString.append("#" + index++ + ")");
            } else {
                fic.add(new FilterItemInfo("period.number", (Object)from, CompareType.GREATER_EQUALS));
                fic.add(new FilterItemInfo("period.number", (Object)to, CompareType.LESS_EQUALS));
                maskString.append("#" + index++ + " AND ");
                maskString.append("#" + index++ + ")");
            }
        }
        if ((flag & 0x20) != 0) {
            if (this.radCheck.isSelected()) {
                fic.add(new FilterItemInfo("cashier.id", null, CompareType.NOTEQUALS));
            } else {
                fic.add(new FilterItemInfo("cashier.id", null));
            }
            maskString.append(" AND #" + index++);
        }
        if ((flag & 8) != 0) {
            if (this.radAudited.isSelected()) {
                fic.add(new FilterItemInfo("auditor.id", null, CompareType.NOTEQUALS));
            } else {
                fic.add(new FilterItemInfo("auditor.id", null));
            }
            maskString.append(" AND #" + index++);
        }
        if ((flag & 0x10) != 0) {
            if (this.radPosted.isSelected()) {
                fic.add(new FilterItemInfo("bizStatus", (Object)new Integer(5)));
            } else {
                fic.add(new FilterItemInfo("bizStatus", (Object)new Integer(5), CompareType.NOTEQUALS));
            }
            maskString.append(" AND #" + index++);
        }
        filter.setMaskString(maskString.toString());
        return filter;
    }

    public void loadData(EntityViewInfo view) {
        CompareType t;
        FilterItemInfo info;
        if (this.param == null) {
            return;
        }
        if (view == null || view.getFilter() == null || view.getFilter().getFilterItems() == null || view.getFilter().getFilterItems().size() == 0) {
            return;
        }
        FilterItemCollection fic = view.getFilter().getFilterItems();
        int index = 0;
        index = this.setCompany(fic, index);
        index = this.setAccountTable(fic, index);
        int flag = this.param.getFlag();
        index = (flag & 0x40) != 0 ? this.setBookedDate(fic, index) : this.setPeriod(fic, index, flag);
        index = this.setAccount(fic, index, flag);
        index = this.setCurrency(fic, index, flag);
        if ((flag & 0x20) != 0) {
            if ((info = fic.get(index++)) == null) {
                return;
            }
            t = info.getCompareType();
            if (CompareType.NOTEQUALS.equals((Object)t)) {
                this.radCheck.setSelected(true);
            } else {
                this.radUnCheck.setSelected(true);
            }
        } else {
            this.radCheckAll.setSelected(true);
        }
        if ((flag & 8) != 0) {
            if ((info = fic.get(index++)) == null) {
                return;
            }
            t = info.getCompareType();
            if (CompareType.NOTEQUALS.equals((Object)t)) {
                this.radAudited.setSelected(true);
            } else {
                this.radUnAudited.setSelected(true);
            }
        } else {
            this.radAuditAll.setSelected(true);
        }
        if ((flag & 0x10) != 0) {
            if ((info = fic.get(index++)) == null) {
                return;
            }
            t = info.getCompareType();
            if (CompareType.NOTEQUALS.equals((Object)t)) {
                this.radUnPosted.setSelected(true);
            } else {
                this.radPosted.setSelected(true);
            }
        } else {
            this.radPostAll.setSelected(true);
        }
        if (this.param.getByDetail() == 0) {
            this.radByVoucher.setSelected(true);
        } else if (this.param.getByDetail() == 1) {
            this.radByEntry.setSelected(true);
        }
    }

    private int setCurrency(FilterItemCollection fic, int index, int flag) {
        if ((flag & 4) != 0) {
            try {
                BOSUuid curId = BOSUuid.read((String)fic.get(index++).getCompareValue().toString());
                GlUtils.setSelectedItem(this.cbxCurrency, curId);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        } else {
            this.cbxCurrency.setSelectedItem(ALL_CURRENCY);
        }
        return index;
    }

    private int setAccount(FilterItemCollection fic, int index, int flag) {
        if ((flag & 1) != 0 && fic.get(index++) != null && fic.get(index - 1).getCompareValue() != null) {
            String accFrom = fic.get(index - 1).getCompareValue().toString();
            AccountViewInfo accFromInfon = null;
            try {
                accFromInfon = VoucherIOSparser.findAccountViewInfoByNumber(accFrom, false);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            this.pbxAccountFrom.setValue((Object)accFromInfon);
        } else {
            this.pbxAccountFrom.setValue(null);
        }
        if ((flag & 2) != 0 && fic.get(index++) != null && fic.get(index - 1).getCompareValue() != null) {
            String accTo = fic.get(index - 1).getCompareValue().toString();
            AccountViewInfo accFromInTo = null;
            try {
                accFromInTo = VoucherIOSparser.findAccountViewInfoByNumber(accTo.substring(0, accTo.length() - 1), false);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            this.pbxAccountTo.setValue(accFromInTo);
        } else {
            this.pbxAccountTo.setValue(null);
        }
        return index;
    }

    private int setPeriod(FilterItemCollection fic, int index, int flag) {
        this.radByPeriod.setSelected(true);
        Integer yearFrom = 0;
        Integer yearTo = 0;
        Integer periodFrom = 0;
        Integer periodTo = 0;
        if (fic.get(index).getPropertyName().equals("period.id")) {
            HashSet<Object> periodIds;
            Object value;
            if ((value = fic.get(index++).getCompareValue()) instanceof String) {
                periodIds = new HashSet<Object>();
                periodIds.add(value);
            } else {
                periodIds = (HashSet<Object>)value;
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("periodYear");
            selector.add("periodNumber");
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", periodIds, CompareType.INCLUDE));
            view.setFilter(filter);
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("number"));
            view.setSorter(sorter);
            try {
                PeriodCollection coll = PeriodFactory.getRemoteInstance().getPeriodCollection(view);
                if (coll.size() <= 0) {
                    this.setPeriodRange();
                    return index;
                }
                yearFrom = coll.get(0).getPeriodYear();
                periodFrom = coll.get(0).getPeriodNumber();
                yearTo = coll.get(coll.size() - 1).getPeriodYear();
                periodTo = coll.get(coll.size() - 1).getPeriodNumber();
            }
            catch (BOSException ignore) {
                return index;
            }
        } else if ((flag & 0x80) != 0) {
            Integer from;
            if ((from = (Integer)fic.get(index++).getCompareValue()) < 10000) {
                Integer to = from;
                yearFrom = yearTo = from;
                periodFrom = periodTo = to;
            } else {
                yearFrom = yearTo = new Integer((from - from % 100) / 100);
                periodFrom = periodTo = new Integer(from % 100);
            }
        } else {
            Integer from = (Integer)fic.get(index++).getCompareValue();
            Integer to = (Integer)fic.get(index++).getCompareValue();
            if (from < 10000) {
                yearFrom = from;
                periodFrom = to;
                yearTo = from;
                periodTo = to;
            } else {
                yearFrom = new Integer((from - from % 100) / 100);
                periodFrom = new Integer(from % 100);
                yearTo = new Integer((to - to % 100) / 100);
                periodTo = new Integer(to % 100);
            }
        }
        GlUtils.setSpinerValue(this.spnYearFrom, yearFrom);
        GlUtils.setSpinerValue(this.spnYearTo, yearTo);
        GlUtils.setSpinerValue(this.spnPeriodFrom, periodFrom);
        GlUtils.setSpinerValue(this.spnPeriodTo, periodTo);
        return index;
    }

    private int setBookedDate(FilterItemCollection fic, int index) {
        this.radByDate.setSelected(true);
        try {
            Date dtFrom = DateTimeUtils.parseDate((String)fic.get(index++).getCompareValue().toString());
            Date dtTo = DateTimeUtils.parseDate((String)fic.get(index++).getCompareValue().toString());
            this.dateFrom.setValue((Object)dtFrom);
            this.dateTo.setValue((Object)dtTo);
        }
        catch (Exception ex) {
            Date now = new Date();
            this.dateFrom.setValue((Object)now);
            this.dateTo.setValue((Object)now);
        }
        return index;
    }

    private int setAccountTable(FilterItemCollection fic, int index) {
        if (fic.get(index).getPropertyName().equals("account.accountTableID.id")) {
            String accountTableId = (String)fic.get(index).getCompareValue();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            try {
                AccountTableInfo accountTable = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(accountTableId), selector);
                this.setSelectedItem(this.bpAccount, accountTable);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            ++index;
        } else {
            this.setSelectedItem(this.bpAccount, null);
        }
        return index;
    }

    private int setCompany(FilterItemCollection fic, int index) {
        CompanyOrgUnitInfo[] companys = null;
        if (fic.get(index).getPropertyName().equals("company.id")) {
            EntityViewInfo companyView = new EntityViewInfo();
            companyView.setSelector(GlUtils.getCompanySic());
            Object companyId = fic.get(index).getCompareValue();
            Set<Object> companyIdSet = null;
            if (companyId instanceof String) {
                companyIdSet = new HashSet<Object>();
                companyIdSet.add(companyId);
            } else {
                companyIdSet = (Set)fic.get(index).getCompareValue();
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", companyIdSet, CompareType.INCLUDE));
            companyView.setFilter(filter);
            try {
                CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(companyView);
                companys = new CompanyOrgUnitInfo[companyColl.size()];
                for (int i = 0; i < companys.length; ++i) {
                    companys[i] = companyColl.get(i);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            ++index;
        } else {
            companys = new CompanyOrgUnitInfo[]{SysContext.getSysContext().getCurrentFIUnit()};
        }
        this.setCompanys(companys);
        return index;
    }

    public Object getParam() {
        Object accountTo;
        if (this.param == null) {
            this.param = new VoucherFilterParam();
        }
        int flag = 0;
        Object accountFrom = this.pbxAccountFrom.getValue();
        if (accountFrom != null) {
            flag |= 1;
        }
        if ((accountTo = this.pbxAccountTo.getValue()) != null) {
            flag |= 2;
        }
        if (this.cbxCurrency.getSelectedItem() != ALL_CURRENCY) {
            flag |= 4;
        }
        if (!this.radCheckAll.isSelected()) {
            flag |= 0x20;
        }
        if (!this.radAuditAll.isSelected()) {
            flag |= 8;
        }
        if (!this.radPostAll.isSelected()) {
            flag |= 0x10;
        }
        if (this.radByVoucher.isSelected()) {
            this.param.setByDetail(0);
        } else if (this.radByEntry.isSelected()) {
            this.param.setByDetail(1);
        }
        if (this.radByDate.isSelected()) {
            flag |= 0x40;
        } else {
            Integer yearFrom = (Integer)this.spnYearFrom.getValue();
            Integer periodFrom = (Integer)this.spnPeriodFrom.getValue();
            Integer yearTo = (Integer)this.spnYearTo.getValue();
            Integer periodTo = (Integer)this.spnPeriodTo.getValue();
            flag = yearFrom.equals(yearTo) ? (periodFrom.equals(periodTo) ? (flag |= 0x80) : (flag |= 0x100)) : (flag |= 0x200);
        }
        this.param.setFlag(flag);
        return this.param;
    }

    public void setParam(Object p) {
        this.param = (VoucherFilterParam)p;
    }

    public AccountTableInfo getAccountTable() {
        return (AccountTableInfo)this.bpAccount.getSelectedItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        super.clear();
        Map uictx = this.getUIContext();
        try {
            uictx.put("isClearing", Boolean.TRUE);
            this.radByPeriod.setSelected(true);
            this.pbxAccountFrom.setData(null);
            this.pbxAccountTo.setData(null);
            this.radAuditAll.setSelected(true);
            this.radUnPosted.setSelected(true);
            this.radCheckAll.setSelected(true);
            this.radByVoucher.setSelected(true);
            this.setSelectedItem(this.cbxCurrency, ALL_CURRENCY);
            CompanyOrgUnitInfo firstCompany = this.getFirstCompany();
            if (firstCompany != null) {
                this.bpCompany.setValue((Object)new CompanyOrgUnitInfo[]{firstCompany});
                AccountTableInfo ati = firstCompany.getAccountTable();
                this.setSelectedItem(this.bpAccount, ati);
            } else {
                this.bpCompany.setValue(null);
            }
        }
        finally {
            uictx.remove("isClearing");
        }
        this.setPeriodRange();
    }

    private CompanyOrgUnitInfo getFirstCompany() {
        try {
            return GLGeneralFacadeFactory.getRemoteInstance().getFirstCompany(this.getPermissionItem());
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptParamsUtil.getFromCustomerParams((CustomerParams)cp));
        }
        catch (EASBizException e) {
            this.getCommonQueryPanel().getSolutionListPanel().getCommonLeftPanel().setDeleteButtonEnable(true);
            this.handUIException(e);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)this.getParam());
        return cp;
    }

    @Override
    protected void pbxAccountFrom_dataChanged(DataChangeEvent e) throws Exception {
        Object accountFrom = this.pbxAccountFrom.getValue();
        Object accountTo = this.pbxAccountTo.getValue();
        if (accountFrom != null && accountTo == null) {
            if (accountFrom instanceof Object[]) {
                Object[] accounts = (Object[])accountFrom;
                for (int i = 0; i < accounts.length; ++i) {
                    if (accounts[i] != null) continue;
                    return;
                }
            }
            this.pbxAccountTo.setValue(accountFrom);
        }
    }

    protected void companyChanged() {
        boolean isEnable = this.getCompanys() != null;
        this.spnYearFrom.setEnabled(isEnable);
        this.spnPeriodFrom.setEnabled(isEnable);
        this.spnYearTo.setEnabled(isEnable);
        this.spnPeriodTo.setEnabled(isEnable);
        Object accountTable = this.bpAccount.getSelectedItem();
        this.pbxAccountFrom.setEnabled(isEnable && accountTable != null);
        this.pbxAccountTo.setEnabled(isEnable && accountTable != null);
        if (isEnable) {
            this.setPeriodRange();
        }
        this.setAccountF7Filter();
        this.firePropertyChange("companyF7", null, this.getCompanyIdSet());
    }

    private void setPeriodRange() {
        if (this.getUIContext().get("isClearing") != null) {
            return;
        }
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        if (companys == null) {
            return;
        }
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        for (int i = 0; i < companys.length; ++i) {
            companyColl.add(companys[i]);
        }
        boolean isPeriodEnable = !companyColl.isEmpty();
        this.spnYearFrom.setEnabled(isPeriodEnable);
        this.spnPeriodFrom.setEnabled(isPeriodEnable);
        this.spnYearTo.setEnabled(isPeriodEnable);
        this.spnPeriodTo.setEnabled(isPeriodEnable);
        this.dateFrom.setEnabled(isPeriodEnable);
        this.dateTo.setEnabled(isPeriodEnable);
        if (isPeriodEnable) {
            try {
                Map pdRang = VoucherFacadeFactory.getRemoteInstance().getPeriodRange(companyColl, null);
                PeriodEntity pe = new PeriodEntity(pdRang);
                SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnYearFrom, (KDSpinner)this.spnPeriodFrom, (KDSpinner)this.spnYearTo, (KDSpinner)this.spnPeriodTo, (boolean)false, (boolean)false);
                PeriodEntity p = pe.getQueryPeriod();
                int curYear = p.getCurrentYear();
                int cuePeriod = p.getCurrentPeriod();
                PeriodInfo curPeriodInfo = PeriodFactory.getRemoteInstance().getPeriodInfo(curYear, cuePeriod, companys[0].getAccountPeriodType());
                if (curPeriodInfo == null) {
                    Date now = new Date();
                    this.dateFrom.setValue((Object)now);
                    this.dateTo.setValue((Object)now);
                } else {
                    this.dateFrom.setValue((Object)curPeriodInfo.getBeginDate());
                    this.dateTo.setValue((Object)curPeriodInfo.getEndDate());
                }
            }
            catch (Exception e) {
                this.spnYearFrom.setEnabled(false);
                this.spnYearTo.setEnabled(false);
                this.spnPeriodFrom.setEnabled(false);
                this.spnPeriodTo.setEnabled(false);
                this.dateFrom.setEnabled(false);
                this.dateTo.setEnabled(false);
                MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            }
        }
    }

    protected Set getCompanyIdSet() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        HashSet<String> idSet = new HashSet<String>();
        if (companys == null) {
            return idSet;
        }
        for (int i = 0; i < companys.length; ++i) {
            idSet.add(companys[i].getId().toString());
        }
        return idSet;
    }

    protected void setSelectedItem(KDComboBox comboBox, Object value) {
        if (value == null) {
            comboBox.setSelectedItem(null);
            return;
        }
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            DataBaseInfo info;
            Object object = comboBox.getItemAt(i);
            if (value == object) {
                comboBox.setSelectedIndex(i);
                break;
            }
            if (!(value instanceof DataBaseInfo) || !(object instanceof DataBaseInfo) || (info = (DataBaseInfo)object) == null || !((DataBaseInfo)value).getId().equals((Object)info.getId())) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    protected void initAccountTableComboBox() throws Exception {
        AccountTableCollection accountTables = this.getAllAccountTableCollection();
        Vector accountTableList = this.toVector((AbstractObjectCollection)accountTables);
        accountTableList.add(0, null);
        this.bpAccount.setModel(new DefaultComboBoxModel(accountTableList));
    }

    protected void initCurrencyComboBox() throws Exception {
        CurrencyCollection currencyCollection = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
        Vector currencyList = this.toVector((AbstractObjectCollection)currencyCollection);
        currencyList.add(0, ALL_CURRENCY);
        this.cbxCurrency.setModel(new DefaultComboBoxModel(currencyList));
    }

    private Vector toVector(AbstractObjectCollection coll) {
        if (coll == null) {
            return null;
        }
        Vector v = new Vector();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            v.add(it.next());
        }
        return v;
    }

    private AccountTableCollection getAllAccountTableCollection() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return AccountTableFactory.getRemoteInstance().getAccountTableCollection(view);
    }

    protected CompanyOrgUnitInfo findCompanyOrgUnitInfo() throws EASBizException, BOSException {
        return GLGeneralFacadeFactory.getRemoteInstance().getFirstCompany(this.getPermissionItem());
    }

    private String getPermissionItem() {
        return "gl_voucher01_view";
    }

    private boolean verifyViewPermission() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        StringBuffer errOrg = new StringBuffer();
        try {
            Map mapOrgWithPerm = GLGeneralFacadeFactory.getRemoteInstance().getOrgWithPerm(this.getPermissionItem(), companys);
            for (int i = 0; i < companys.length; ++i) {
                CompanyOrgUnitInfo company = companys[i];
                if (mapOrgWithPerm.containsKey(company.getId().toString())) continue;
                if (errOrg.length() > 0) {
                    errOrg.append(",");
                }
                errOrg.append(company.getName());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (errOrg.length() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)CWGXRESOURCE, (String)"solutionNotValid"), errOrg.toString()));
            return false;
        }
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public String getUiParam() {
        return this.uiParam;
    }

    public static class VoucherFilterParam
    implements Serializable {
        private static final long serialVersionUID = -1524560711389808759L;
        public static final int HAS_ACCOUNT_FROM = 1;
        public static final int HAS_ACCOUNT_TO = 2;
        public static final int HAS_CURRENCY = 4;
        public static final int HAS_AUDIT = 8;
        public static final int HAS_POST = 16;
        public static final int HAS_CHECK = 32;
        public static final int BY_DATE = 64;
        public static final int SINGLE_PERIOD = 128;
        public static final int SAME_YEAR = 256;
        public static final int DIFF_YEAR = 512;
        private int flag = 0;
        private int byDetail;
        private int byVoucher;
        public static final int DETAIL_VOUCHER = 0;
        public static final int DETAIL_ENTRY = 1;
        public static final int DETAIL_VOUCHER_FORVF = 0;
        public static final int DETAIL_VOUCHER_ENTRY = 1;
        public static final int DETAIL_VOUCHER_FORASST = 2;
        public static final int DETAIL_VOUCHER_FORWF = 3;
        public Object treeModelOfCompany = null;

        public VoucherFilterParam() {
        }

        public VoucherFilterParam(int f, int bd, int bv) {
            this.flag = f;
            this.byDetail = bd;
            this.byVoucher = bv;
        }

        public int getFlag() {
            return this.flag;
        }

        public void setFlag(int f) {
            this.flag = f;
        }

        public int getByDetail() {
            return this.byDetail;
        }

        public void setByDetail(int bd) {
            this.byDetail = bd;
        }

        public int getByVoucher() {
            return this.byVoucher;
        }

        public void setByVoucher(int bv) {
            this.byVoucher = bv;
        }
    }
}

