/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.AbstractVoucherImportUI;
import com.kingdee.eas.fi.gl.client.VoucherNewImporter;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class VoucherImportUI
extends AbstractVoucherImportUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherImportUI.class);
    protected static final String RESOURCE = "com.kingdee.eas.fi.gl.VoucherImport";
    private static final DateFormat DF_IMP = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat DF_LOG = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
    private static final Color WARN_COLOR = new Color(246, 168, 46);
    protected boolean isRunning = false;
    private boolean stop = false;
    private boolean isAdvImportMode = false;
    private Box boxMain = null;
    private Component boxNumberStrut = null;
    private Box boxNumber = null;
    private Component boxCopyStrut = null;
    private Box boxCopy = null;
    private Component boxAdvanceStrut = null;
    private Box boxAdvance = null;

    public VoucherImportUI() throws Exception {
        this.btnCheck.putClientProperty((Object)"sourceText", (Object)this.btnCheck.getText());
        this.btnExecute.putClientProperty((Object)"sourceText", (Object)this.btnExecute.getText());
    }

    private void init() {
        this.kDPanel1.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
        this.kDScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
        this.splitPane.setDividerLocation(172);
        this.kDPanel1.removeAll();
        this.kDPanel1.setLayout((LayoutManager)new BorderLayout());
        this.boxMain = Box.createVerticalBox();
        this.boxMain.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.boxMain.setAlignmentX(0.0f);
        this.kDPanel1.add((Component)this.boxMain, (Object)"Center");
        Box boxData = Box.createHorizontalBox();
        boxData.setPreferredSize(new Dimension(60, 21));
        boxData.setMaximumSize(new Dimension(Integer.MAX_VALUE, 21));
        boxData.setAlignmentX(0.0f);
        this.boxMain.add(boxData);
        this.lbFile.setPreferredSize(new Dimension(68, 20));
        this.lbFile.setMaximumSize(new Dimension(68, 20));
        boxData.add((Component)this.lbFile);
        boxData.add(Box.createHorizontalStrut(10));
        boxData.add((Component)this.tfFile);
        boxData.add(Box.createHorizontalStrut(5));
        boxData.add((Component)this.btnFile);
        boxData.add(Box.createHorizontalStrut(5));
        boxData.add((Component)this.btnOpenFile);
        boxData.add(Box.createHorizontalStrut(5));
        boxData.add((Component)this.btnFilePosition);
        this.boxMain.add(Box.createVerticalStrut(5));
        Box boxAction = Box.createHorizontalBox();
        boxAction.setPreferredSize(new Dimension(60, 20));
        boxAction.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        boxAction.setAlignmentX(0.0f);
        this.boxMain.add(boxAction);
        this.lbAction.setPreferredSize(new Dimension(68, 20));
        this.lbAction.setMaximumSize(new Dimension(68, 20));
        boxAction.add((Component)this.lbAction);
        boxAction.add(Box.createHorizontalStrut(10));
        this.rbTemp.setPreferredSize(new Dimension(120, 20));
        this.rbTemp.setMaximumSize(new Dimension(120, 20));
        boxAction.add((Component)this.rbTemp);
        boxAction.add(Box.createHorizontalStrut(10));
        this.rbSubmit.setPreferredSize(new Dimension(120, 20));
        this.rbSubmit.setMaximumSize(new Dimension(120, 20));
        boxAction.add((Component)this.rbSubmit);
        boxAction.add(Box.createHorizontalStrut(10));
        this.rbAudit.setVisible(false);
        this.rbAudit.setPreferredSize(new Dimension(120, 20));
        this.rbAudit.setMaximumSize(new Dimension(120, 20));
        boxAction.add((Component)this.rbAudit);
        boxAction.add(Box.createHorizontalStrut(10));
        this.rbPost.setVisible(false);
        this.rbPost.setPreferredSize(new Dimension(120, 20));
        this.rbPost.setMaximumSize(new Dimension(120, 20));
        boxAction.add((Component)this.rbPost);
        this.boxMain.add(Box.createVerticalStrut(5));
        Box boxBatch = Box.createHorizontalBox();
        boxBatch.setPreferredSize(new Dimension(60, 20));
        boxBatch.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        boxBatch.setAlignmentX(0.0f);
        this.boxMain.add(boxBatch);
        this.lbBatchCount.setPreferredSize(new Dimension(68, 20));
        this.lbBatchCount.setMaximumSize(new Dimension(68, 20));
        boxBatch.add((Component)this.lbBatchCount);
        boxBatch.add(Box.createHorizontalStrut(10));
        this.spBatchCount.setPreferredSize(new Dimension(110, 20));
        this.spBatchCount.setMaximumSize(new Dimension(110, 20));
        boxBatch.add((Component)this.spBatchCount);
        boxBatch.add(Box.createHorizontalStrut(17));
        this.cbColumnAlias.setPreferredSize(new Dimension(120, 20));
        this.cbColumnAlias.setMaximumSize(new Dimension(120, 20));
        boxBatch.add((Component)this.cbColumnAlias);
        boxBatch.add(Box.createHorizontalStrut(10));
        this.cbVerify.setPreferredSize(new Dimension(120, 20));
        this.cbVerify.setMaximumSize(new Dimension(120, 20));
        boxBatch.add((Component)this.cbVerify);
        boxBatch.add(Box.createHorizontalStrut(10));
        this.cbCashflow.setPreferredSize(new Dimension(120, 20));
        this.cbCashflow.setMaximumSize(new Dimension(120, 20));
        boxBatch.add((Component)this.cbCashflow);
        boxBatch.add(Box.createHorizontalStrut(10));
        this.cbOverwrite.setPreferredSize(new Dimension(120, 20));
        this.cbOverwrite.setMaximumSize(new Dimension(120, 20));
        boxBatch.add((Component)this.cbOverwrite);
        boxBatch.add(Box.createHorizontalStrut(10));
        this.cbSynStarSeaData.setVisible(false);
        this.cbSynStarSeaData.setPreferredSize(new Dimension(130, 20));
        this.cbSynStarSeaData.setMaximumSize(new Dimension(130, 20));
        boxBatch.add((Component)this.cbSynStarSeaData);
        this.boxMain.add(Box.createVerticalStrut(5));
        Box boxIdField = Box.createHorizontalBox();
        boxIdField.setPreferredSize(new Dimension(60, 20));
        boxIdField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        boxIdField.setAlignmentX(0.0f);
        this.boxMain.add(boxIdField);
        this.lbIdField.setPreferredSize(new Dimension(68, 20));
        this.lbIdField.setMaximumSize(new Dimension(68, 20));
        boxIdField.add((Component)this.lbIdField);
        boxIdField.add(Box.createHorizontalStrut(7));
        this.cbCompanyNumberIdField.setPreferredSize(new Dimension(120, 20));
        this.cbCompanyNumberIdField.setMaximumSize(new Dimension(120, 20));
        boxIdField.add((Component)this.cbCompanyNumberIdField);
        this.cbCompanyNumberIdField.setSelected(true);
        this.cbCompanyNumberIdField.setEnabled(false);
        boxIdField.add(Box.createHorizontalStrut(10));
        this.cbVoucherNumberIdField.setPreferredSize(new Dimension(120, 20));
        this.cbVoucherNumberIdField.setMaximumSize(new Dimension(120, 20));
        boxIdField.add((Component)this.cbVoucherNumberIdField);
        this.cbVoucherNumberIdField.setSelected(true);
        this.cbVoucherNumberIdField.setEnabled(false);
        boxIdField.add(Box.createHorizontalStrut(10));
        this.cbPeriodIdField.setPreferredSize(new Dimension(120, 20));
        this.cbPeriodIdField.setMaximumSize(new Dimension(120, 20));
        boxIdField.add((Component)this.cbPeriodIdField);
        this.cbPeriodIdField.setSelected(true);
        this.cbPeriodIdField.setEnabled(false);
        boxIdField.add(Box.createHorizontalStrut(10));
        this.cbVoucherTypeIdField.setPreferredSize(new Dimension(120, 20));
        this.cbVoucherTypeIdField.setMaximumSize(new Dimension(120, 20));
        boxIdField.add((Component)this.cbVoucherTypeIdField);
        boxIdField.add(Box.createHorizontalStrut(10));
        this.cbBizStatusIdField.setPreferredSize(new Dimension(120, 20));
        this.cbBizStatusIdField.setMaximumSize(new Dimension(120, 20));
        boxIdField.add((Component)this.cbBizStatusIdField);
        this.boxMain.add(Box.createVerticalStrut(5));
        Box boxExtends = Box.createHorizontalBox();
        boxExtends.setPreferredSize(new Dimension(60, 20));
        boxExtends.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        boxExtends.setAlignmentX(0.0f);
        this.boxMain.add(boxExtends);
        this.lbExtends.setPreferredSize(new Dimension(68, 20));
        this.lbExtends.setMaximumSize(new Dimension(68, 20));
        boxExtends.add((Component)this.lbExtends);
        boxExtends.add(Box.createHorizontalStrut(10));
        this.txtExtends.setPreferredSize(new Dimension(120, 20));
        this.txtExtends.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        boxExtends.add((Component)this.txtExtends);
        boxExtends.add(Box.createHorizontalStrut(2));
        this.boxNumberStrut = Box.createVerticalStrut(5);
        this.boxNumberStrut.setVisible(false);
        this.boxMain.add(this.boxNumberStrut);
        this.boxNumber = Box.createHorizontalBox();
        this.boxNumber.setVisible(false);
        this.boxNumber.setPreferredSize(new Dimension(60, 20));
        this.boxNumber.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.boxNumber.setAlignmentX(0.0f);
        this.boxMain.add(this.boxNumber);
        this.lbNumberPrefix.setPreferredSize(new Dimension(68, 20));
        this.lbNumberPrefix.setMaximumSize(new Dimension(68, 20));
        this.boxNumber.add((Component)this.lbNumberPrefix);
        this.boxNumber.add(Box.createHorizontalStrut(10));
        this.tfNumberPrefix.setPreferredSize(new Dimension(110, 20));
        this.tfNumberPrefix.setMaximumSize(new Dimension(110, 20));
        this.boxNumber.add((Component)this.tfNumberPrefix);
        this.boxNumber.add(Box.createHorizontalStrut(22));
        this.lbPeriod.setPreferredSize(new Dimension(68, 20));
        this.lbPeriod.setMaximumSize(new Dimension(68, 20));
        this.boxNumber.add((Component)this.lbPeriod);
        this.boxNumber.add(Box.createHorizontalStrut(10));
        this.tfPeriodNumber.setPreferredSize(new Dimension(110, 20));
        this.tfPeriodNumber.setMaximumSize(new Dimension(110, 20));
        this.boxNumber.add((Component)this.tfPeriodNumber);
        this.boxNumber.add(Box.createHorizontalStrut(71));
        this.lbBookedDate.setPreferredSize(new Dimension(68, 20));
        this.lbBookedDate.setMaximumSize(new Dimension(68, 20));
        this.boxNumber.add((Component)this.lbBookedDate);
        this.boxNumber.add(Box.createHorizontalStrut(10));
        this.tfBookedDate.setPreferredSize(new Dimension(110, 20));
        this.tfBookedDate.setMaximumSize(new Dimension(110, 20));
        this.boxNumber.add((Component)this.tfBookedDate);
        this.boxNumber.add(Box.createHorizontalGlue());
        this.boxCopyStrut = Box.createVerticalStrut(5);
        this.boxCopyStrut.setVisible(false);
        this.boxMain.add(this.boxCopyStrut);
        this.boxCopy = Box.createHorizontalBox();
        this.boxCopy.setVisible(false);
        this.boxCopy.setPreferredSize(new Dimension(60, 20));
        this.boxCopy.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.boxCopy.setAlignmentX(0.0f);
        this.boxMain.add(this.boxCopy);
        this.lbVoucherCopy.setPreferredSize(new Dimension(68, 20));
        this.lbVoucherCopy.setMaximumSize(new Dimension(68, 20));
        this.boxCopy.add((Component)this.lbVoucherCopy);
        this.boxCopy.add(Box.createHorizontalStrut(10));
        this.spVoucherCopy.setPreferredSize(new Dimension(110, 20));
        this.spVoucherCopy.setMaximumSize(new Dimension(110, 20));
        this.boxCopy.add((Component)this.spVoucherCopy);
        this.boxCopy.add(Box.createHorizontalStrut(17));
        this.cbUnsaveSource.setPreferredSize(new Dimension(120, 20));
        this.cbUnsaveSource.setMaximumSize(new Dimension(120, 20));
        this.boxCopy.add((Component)this.cbUnsaveSource);
        this.boxCopy.add(Box.createHorizontalStrut(10));
        this.cbAdjustDescription.setPreferredSize(new Dimension(120, 20));
        this.cbAdjustDescription.setMaximumSize(new Dimension(120, 20));
        this.boxCopy.add((Component)this.cbAdjustDescription);
        this.boxCopy.add(Box.createHorizontalStrut(14));
        this.lbEntryCopy.setPreferredSize(new Dimension(68, 20));
        this.lbEntryCopy.setMaximumSize(new Dimension(68, 20));
        this.boxCopy.add((Component)this.lbEntryCopy);
        this.boxCopy.add(Box.createHorizontalStrut(10));
        this.spEntryCopy.setPreferredSize(new Dimension(110, 20));
        this.spEntryCopy.setMaximumSize(new Dimension(110, 20));
        this.boxCopy.add((Component)this.spEntryCopy);
        this.boxCopy.add(Box.createHorizontalStrut(1));
        this.boxCopy.add((Component)this.cbEntryCopyRandom);
        this.boxAdvanceStrut = Box.createVerticalStrut(5);
        this.boxAdvanceStrut.setVisible(false);
        this.boxMain.add(this.boxAdvanceStrut);
        this.boxAdvance = Box.createHorizontalBox();
        this.boxAdvance.setVisible(false);
        this.boxAdvance.setPreferredSize(new Dimension(60, 20));
        this.boxAdvance.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.boxAdvance.setAlignmentX(0.0f);
        this.boxMain.add(this.boxAdvance);
        this.lbOther.setPreferredSize(new Dimension(68, 20));
        this.lbOther.setMaximumSize(new Dimension(68, 20));
        this.boxAdvance.add((Component)this.lbOther);
        this.boxAdvance.add(Box.createHorizontalStrut(7));
        this.cbCompress.setPreferredSize(new Dimension(120, 20));
        this.cbCompress.setMaximumSize(new Dimension(120, 20));
        this.boxAdvance.add((Component)this.cbCompress);
        this.boxAdvance.add(Box.createHorizontalStrut(10));
        this.cbUseGlobalCache.setPreferredSize(new Dimension(120, 20));
        this.cbUseGlobalCache.setMaximumSize(new Dimension(120, 20));
        this.boxAdvance.add((Component)this.cbUseGlobalCache);
        this.boxAdvance.add(Box.createHorizontalStrut(10));
        this.cbRefreshGlobalCache.setPreferredSize(new Dimension(120, 20));
        this.cbRefreshGlobalCache.setMaximumSize(new Dimension(120, 20));
        this.boxAdvance.add((Component)this.cbRefreshGlobalCache);
        this.boxAdvance.add(Box.createHorizontalStrut(10));
        this.cbShowRequest.setPreferredSize(new Dimension(120, 20));
        this.cbShowRequest.setMaximumSize(new Dimension(120, 20));
        this.boxAdvance.add((Component)this.cbShowRequest);
        this.boxMain.add(Box.createVerticalStrut(5));
        Box boxLog = Box.createHorizontalBox();
        boxLog.setPreferredSize(new Dimension(60, 20));
        boxLog.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        boxLog.setAlignmentX(0.0f);
        this.boxMain.add(boxLog);
        this.lbLog.setPreferredSize(new Dimension(68, 20));
        this.lbLog.setMaximumSize(new Dimension(68, 20));
        boxLog.add((Component)this.lbLog);
        boxLog.add(Box.createHorizontalStrut(10));
        this.rbShowNoDetail.setPreferredSize(new Dimension(120, 20));
        this.rbShowNoDetail.setMaximumSize(new Dimension(120, 20));
        boxLog.add((Component)this.rbShowNoDetail);
        boxLog.add(Box.createHorizontalStrut(10));
        this.rbShowErrorDetail.setPreferredSize(new Dimension(120, 20));
        this.rbShowErrorDetail.setMaximumSize(new Dimension(120, 20));
        boxLog.add((Component)this.rbShowErrorDetail);
        boxLog.add(Box.createHorizontalStrut(10));
        this.rbShowAllDetail.setPreferredSize(new Dimension(120, 20));
        this.rbShowAllDetail.setMaximumSize(new Dimension(120, 20));
        boxLog.add((Component)this.rbShowAllDetail);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.rbTemp);
        group.add((AbstractButton)this.rbSubmit);
        group.add((AbstractButton)this.rbAudit);
        group.add((AbstractButton)this.rbPost);
        group = new ButtonGroup();
        group.add((AbstractButton)this.rbShowNoDetail);
        group.add((AbstractButton)this.rbShowErrorDetail);
        group.add((AbstractButton)this.rbShowAllDetail);
        boxLog.add(Box.createHorizontalGlue());
        boxLog.add((Component)this.cbJumpCheck);
        boxLog.add(Box.createHorizontalStrut(8));
        this.btnClear.setMargin(new Insets(2, 0, 2, 0));
        boxLog.add((Component)this.btnClear);
        boxLog.add(Box.createHorizontalStrut(8));
        boxLog.add((Component)this.btnCheck);
        boxLog.add(Box.createHorizontalStrut(8));
        boxLog.add((Component)this.btnExecute);
        this.rbSubmit.setSelected(true);
        this.cbColumnAlias.setSelected(true);
        this.cbCashflow.setSelected(true);
        this.cbOverwrite.setSelected(false);
        this.rbShowErrorDetail.setSelected(true);
        this.spBatchCount.setModel((SpinnerModel)new SpinnerNumberModel(10000, 100, 500000, 100));
        this.spVoucherCopy.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 1000000, 100));
        this.spEntryCopy.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, 100000, 100));
        this.btnFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File defaultPath = new File("vouchers");
                JFileChooser chooser = new JFileChooser();
                String currentPath = VoucherImportUI.this.tfFile.getText();
                if (currentPath != null && currentPath.trim().length() > 0) {
                    File parent;
                    File dir = new File(currentPath);
                    if (dir.isDirectory()) {
                        parent = dir.getParentFile();
                        if (parent != null) {
                            chooser.setCurrentDirectory(parent);
                        } else {
                            chooser.setCurrentDirectory(dir);
                        }
                    } else {
                        parent = dir.getParentFile();
                        if (parent != null) {
                            chooser.setCurrentDirectory(parent);
                        } else {
                            chooser.setCurrentDirectory(defaultPath);
                        }
                    }
                } else {
                    chooser.setCurrentDirectory(defaultPath);
                }
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "Excel(*.xlsx)";
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".xlsx");
                    }
                });
                chooser.setFileSelectionMode(2);
                chooser.setAcceptAllFileFilterUsed(false);
                int result = chooser.showOpenDialog((Component)((Object)VoucherImportUI.this));
                if (result == 0) {
                    String selectedPath = chooser.getSelectedFile().getAbsolutePath();
                    VoucherImportUI.this.tfFile.setText(selectedPath);
                }
            }
        });
        this.btnOpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = null;
                String currentPath = VoucherImportUI.this.tfFile.getText();
                if (currentPath != null && (currentPath = currentPath.trim()).length() > 0) {
                    file = new File(currentPath);
                }
                if (file != null && file.isFile()) {
                    VoucherImportUI.this.open(file);
                } else {
                    VoucherImportUI.this.btnFilePositionActionPerformed(e);
                }
            }
        });
        this.btnFilePosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VoucherImportUI.this.btnFilePositionActionPerformed(e);
            }
        });
        InputMap imEntry = this.getInputMap(2);
        KeyStroke ctrl_shift_f5 = KeyStroke.getKeyStroke(116, 3);
        imEntry.put(ctrl_shift_f5, "showAdvance");
        KeyStroke ctrl_shift_C = KeyStroke.getKeyStroke(67, 3);
        imEntry.put(ctrl_shift_C, "showConverter");
        ActionMap entryActionMap = this.getActionMap();
        entryActionMap.put("showAdvance", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VoucherImportUI.this.showAdvanceActionPerformed(e);
            }
        });
        entryActionMap.put("showConverter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VoucherImportUI.this.showConverterActionPerformed(e);
            }
        });
        this.txtConsole.setContentType("text/html");
        this.txtConsole.setEditable(false);
        StringBuffer htmlText = new StringBuffer();
        htmlText.append("<html>");
        htmlText.append("<body>");
        htmlText.append(this.getString("Interface_Manual"));
        htmlText.append("<br>");
        htmlText.append("<a href=\"https://vip.kingdee.com/article/289404007205120768\">https://vip.kingdee.com/article/289404007205120768</a>");
        htmlText.append("<br>");
        htmlText.append("</body>");
        htmlText.append("</html>");
        this.txtConsole.setText(htmlText.toString());
        this.txtConsole.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(evt.getURL().toURI());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    public void showAdvanceActionPerformed(ActionEvent e) {
        if (this.isAdvImportMode) {
            this.rbAudit.setVisible(false);
            this.rbPost.setVisible(false);
            this.cbSynStarSeaData.setVisible(false);
            if (!this.rbTemp.isSelected() && !this.rbSubmit.isSelected()) {
                this.rbSubmit.setSelected(true);
            }
            this.boxNumberStrut.setVisible(false);
            this.boxNumber.setVisible(false);
            this.boxCopyStrut.setVisible(false);
            this.boxCopy.setVisible(false);
            this.boxAdvanceStrut.setVisible(false);
            this.boxAdvance.setVisible(false);
            this.boxMain.revalidate();
            this.splitPane.setDividerLocation(172);
            this.isAdvImportMode = false;
            return;
        }
        OrgUnitInfo ou = SysContext.getSysContext().getCurrentOrgUnit();
        if (ou != null) {
            try {
                PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(ou.getId()), (String)"gl_tool");
                this.isAdvImportMode = true;
                this.rbAudit.setVisible(true);
                this.rbPost.setVisible(true);
                this.cbSynStarSeaData.setVisible(true);
                this.boxNumberStrut.setVisible(true);
                this.boxNumber.setVisible(true);
                this.boxCopyStrut.setVisible(true);
                this.boxCopy.setVisible(true);
                this.boxAdvanceStrut.setVisible(true);
                this.boxAdvance.setVisible(true);
                this.boxMain.revalidate();
                this.splitPane.setDividerLocation(248);
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
    }

    public void showConverterActionPerformed(ActionEvent e) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"canResize", (Object)"true");
        uiContext.put((Object)"path", (Object)this.tfFile.getText());
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.VoucherConvertUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.loadConfig();
    }

    public void btnFilePositionActionPerformed(ActionEvent e) {
        File defaultPath = new File("vouchers");
        String currentPath = this.tfFile.getText();
        if (currentPath == null || currentPath.trim().length() == 0) {
            this.explorerFile(defaultPath, false);
            return;
        }
        File currentFile = new File(currentPath = currentPath.trim());
        if (currentFile.exists()) {
            this.explorerFile(currentFile, true);
        } else {
            File parent = currentFile.getParentFile();
            if (parent != null) {
                if (parent.isDirectory()) {
                    this.explorerFile(parent, false);
                } else {
                    JOptionPane.showMessageDialog(this.getTopLevelAncestor(), parent.getAbsolutePath() + "\uff1a" + this.getString("Directory_NotExist"));
                }
            }
        }
    }

    public void open(File file) {
        String command = "cmd /c start " + file.getAbsolutePath();
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void explorerFile(File file, boolean select) {
        if (file != null) {
            try {
                String command = "explorer ";
                if (select) {
                    command = command + "/select, ";
                }
                command = command + file.getAbsolutePath();
                Runtime.getRuntime().exec(command);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void actionDefaultSetting_actionPerformed(ActionEvent e) throws Exception {
        this.rbSubmit.setSelected(true);
        this.spBatchCount.setValue((Object)10000);
        this.cbColumnAlias.setSelected(true);
        this.cbVerify.setSelected(false);
        this.cbCashflow.setSelected(true);
        this.cbOverwrite.setSelected(false);
        this.cbSynStarSeaData.setSelected(false);
        this.cbVoucherTypeIdField.setSelected(false);
        this.cbBizStatusIdField.setSelected(false);
        this.txtExtends.setText("");
        this.tfNumberPrefix.setText("");
        this.tfPeriodNumber.setText("");
        this.tfBookedDate.setValue(null);
        this.spVoucherCopy.setValue((Object)0);
        this.cbUnsaveSource.setSelected(false);
        this.cbAdjustDescription.setSelected(false);
        this.spEntryCopy.setValue((Object)0);
        this.cbEntryCopyRandom.setSelected(false);
        this.cbCompress.setSelected(true);
        this.cbUseGlobalCache.setSelected(false);
        this.cbRefreshGlobalCache.setSelected(false);
        this.cbShowRequest.setSelected(false);
        this.rbShowAllDetail.setSelected(true);
    }

    @Override
    public void actionVoucherOldImport_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.client.VoucherOldImportUI", (Map)uiContext, null, OprtState.EDIT);
            this.destroyWindow();
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        this.txtConsole.setText("");
    }

    @Override
    public void actionExecute_actionPerformed(ActionEvent e) throws Exception {
        this.btnExecuteActionPerformed(e);
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        this.btnExecuteActionPerformed(e);
    }

    public boolean checkBeforeWindowClosing() {
        this.stop = true;
        this.saveConfig();
        return super.checkBeforeWindowClosing();
    }

    private void btnExecuteActionPerformed(final ActionEvent e) {
        KDButton btn = (KDButton)e.getSource();
        if (btn.getClientProperty((Object)"canStop") != null) {
            this.stop = true;
            btn.setEnabled(false);
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                VoucherImportUI.this.execute(e);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(ActionEvent e) {
        KDButton btn = (KDButton)e.getSource();
        try {
            this.isRunning = true;
            btn.putClientProperty((Object)"canStop", (Object)true);
            btn.setText(this.getString("Stop"));
            this.enableComponent(e, false);
            this.doExecute(e);
        }
        catch (Exception ex) {
            this.error(ex);
        }
        finally {
            btn.setText((String)btn.getClientProperty((Object)"sourceText"));
            this.enableComponent(e, true);
            btn.setEnabled(true);
            btn.putClientProperty((Object)"canStop", null);
            this.stop = false;
            this.isRunning = false;
        }
    }

    private void enableComponent(ActionEvent e, boolean enable) {
        this.tfFile.setEnabled(enable);
        this.btnFile.setEnabled(enable);
        this.btnOpenFile.setEnabled(enable);
        this.btnFilePosition.setEnabled(enable);
        this.rbTemp.setEnabled(enable);
        this.rbSubmit.setEnabled(enable);
        this.rbAudit.setEnabled(enable);
        this.rbPost.setEnabled(enable);
        this.spBatchCount.setEnabled(enable);
        this.cbColumnAlias.setEnabled(enable);
        this.cbVerify.setEnabled(enable);
        this.cbCashflow.setEnabled(enable);
        this.cbOverwrite.setEnabled(enable);
        this.cbVoucherTypeIdField.setEnabled(enable);
        this.cbBizStatusIdField.setEnabled(enable);
        this.txtExtends.setEnabled(enable);
        this.tfNumberPrefix.setEnabled(enable);
        this.tfPeriodNumber.setEnabled(enable);
        this.tfBookedDate.setEnabled(enable);
        this.spVoucherCopy.setEnabled(enable);
        this.spEntryCopy.setEnabled(enable);
        this.cbEntryCopyRandom.setEnabled(enable);
        this.cbUnsaveSource.setEnabled(enable);
        this.cbAdjustDescription.setEnabled(enable);
        this.cbCompress.setEnabled(enable);
        this.cbUseGlobalCache.setEnabled(enable);
        this.cbRefreshGlobalCache.setEnabled(enable);
        this.cbShowRequest.setEnabled(enable);
        this.rbShowNoDetail.setEnabled(enable);
        this.rbShowErrorDetail.setEnabled(enable);
        this.rbShowAllDetail.setEnabled(enable);
        this.cbJumpCheck.setEnabled(enable);
        if (e.getSource() == this.btnCheck) {
            this.actionExecute.setEnabled(enable);
        } else if (e.getSource() == this.btnExecute) {
            this.actionCheck.setEnabled(enable);
        }
        this.actionDefaultSetting.setEnabled(enable);
    }

    public void doExecute(ActionEvent e) {
        String action;
        Map<String, String> params = this.buildConfig();
        if (e.getSource() == this.btnCheck) {
            params.put("onlyCheck", "true");
        }
        params.put("isSubmit", String.valueOf("submit".equals(action = params.remove("action")) || "audit".equals(action) || "post".equals(action)));
        params.put("isAudit", String.valueOf("audit".equals(action) || "post".equals(action)));
        params.put("isPost", String.valueOf("post".equals(action)));
        String strExtends = params.remove("extends");
        if (strExtends != null && strExtends.trim().length() > 0 && (strExtends = strExtends.trim()).length() > 0) {
            HashMap<String, String> extendParams = new HashMap<String, String>();
            if (strExtends.startsWith("{") && strExtends.endsWith("}")) {
                Map exs = (Map)JSON.parseObject((String)strExtends, Map.class);
                for (Object key : exs.keySet()) {
                    extendParams.put(String.valueOf(key), String.valueOf(exs.get(key)));
                }
            } else {
                String[] strs;
                extendParams = new HashMap();
                for (String str : strs = strExtends.trim().split(";")) {
                    int index = str.indexOf("=");
                    if (index <= 0) continue;
                    String key = str.substring(0, index).trim();
                    String value = str.substring(index + 1).trim();
                    if (key.length() <= 0 || value.length() <= 0) continue;
                    extendParams.put(key, value);
                }
            }
            if (extendParams.size() > 0) {
                HashSet extendKeys = new HashSet(extendParams.keySet());
                extendParams.putAll(params);
                params = extendParams;
                params.put("extendKeys", JSON.toJSONString(extendKeys));
            }
        }
        params.put("importVoucher", "false");
        if (!this.isAdvImportMode) {
            params.put("numberPrefix", "");
            params.put("periodNumber", "");
            params.put("bookedDate", "");
            params.put("voucherCopy", "0");
            params.put("unsaveSource", "false");
            params.put("adjustDescription", "false");
            params.put("entryCopy", "0");
            params.put("entryCopyRandom", "false");
            params.put("isCompress", "true");
            params.put("useGlobalCache", "false");
            params.put("clearGlobalCache", "false");
            params.put("showRequest", "false");
        }
        new VoucherNewImporter(this, params).execute();
    }

    public boolean isStop() {
        return this.stop;
    }

    public void info(String msg) {
        this.log(DF_LOG.format(new Date()) + " " + msg, Color.black);
    }

    public void warn(String msg) {
        this.log(DF_LOG.format(new Date()) + " " + msg, WARN_COLOR);
    }

    public void error(String msg) {
        this.log(DF_LOG.format(new Date()) + " " + msg, Color.red);
    }

    public void error(Throwable t) {
        this.error(GlUtils.printStackTrace(t));
    }

    private synchronized void log(final String msg, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleAttributeSet attributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(attributeSet, color);
                Document doc = VoucherImportUI.this.txtConsole.getDocument();
                try {
                    doc.insertString(doc.getLength(), msg + "\n", attributeSet);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                VoucherImportUI.this.txtConsole.setSelectionStart(doc.getLength());
            }
        });
    }

    protected void loadConfig() {
        String entryCopy;
        String extendParams;
        String batchCount;
        String action;
        File file2;
        Map<String, String> params = null;
        String filepath = this.getFilepath();
        if (filepath != null && (file2 = new File(filepath + "VoucherImport.properties")).isFile()) {
            params = this.loadConfig(filepath + "VoucherImport.properties");
        }
        if (params == null || params.size() == 0) {
            try {
                this.actionDefaultSetting_actionPerformed(null);
            }
            catch (Exception file2) {
                // empty catch block
            }
            return;
        }
        if (params.get("file") != null) {
            this.tfFile.setText((String)params.get("file"));
        }
        if ("temp".equals(action = (String)params.get("action"))) {
            this.rbTemp.setSelected(true);
        } else if ("audit".equals(action)) {
            this.rbAudit.setSelected(true);
        } else if ("post".equals(action)) {
            this.rbPost.setSelected(true);
        } else {
            this.rbSubmit.setSelected(true);
        }
        if (!this.rbTemp.isSelected() && !this.rbSubmit.isSelected()) {
            this.rbSubmit.setSelected(true);
        }
        if ((batchCount = params.get("batchCount")) != null) {
            try {
                int i = Integer.parseInt(batchCount);
                if (i >= 100 && i <= 500000) {
                    this.spBatchCount.setValue((Object)i);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        if (params.get("isColumnAlias") != null) {
            this.cbColumnAlias.setSelected(Boolean.valueOf(params.get("isColumnAlias")).booleanValue());
        }
        if (params.get("isVerify") != null) {
            this.cbVerify.setSelected(Boolean.valueOf(params.get("isVerify")).booleanValue());
        }
        if (params.get("isImpCashflow") != null) {
            this.cbCashflow.setSelected(Boolean.valueOf(params.get("isImpCashflow")).booleanValue());
        }
        if (params.get("overwrite") != null) {
            this.cbOverwrite.setSelected(Boolean.valueOf(params.get("overwrite")).booleanValue());
        }
        if (params.get("isVoucherTypeIdField") != null) {
            this.cbVoucherTypeIdField.setSelected(Boolean.valueOf(params.get("isVoucherTypeIdField")).booleanValue());
        }
        if (params.get("isBizStatusIdField") != null) {
            this.cbBizStatusIdField.setSelected(Boolean.valueOf(params.get("isBizStatusIdField")).booleanValue());
        }
        if ((extendParams = params.get("extends")) == null) {
            extendParams = "";
        }
        this.txtExtends.setText(extendParams);
        String numberPrefix = params.get("numberPrefix");
        if (numberPrefix == null) {
            numberPrefix = "";
        }
        this.tfNumberPrefix.setText(numberPrefix);
        String periodNumber = params.get("periodNumber");
        if (periodNumber == null) {
            periodNumber = "";
        }
        this.tfPeriodNumber.setText(periodNumber);
        String bookedDate = params.get("bookedDate");
        if (bookedDate == null || bookedDate.trim().length() == 0) {
            this.tfBookedDate.setValue(null);
        } else {
            try {
                this.tfBookedDate.setValue((Object)DF_IMP.parse(bookedDate.trim()));
            }
            catch (ParseException ignore) {
                this.tfBookedDate.setValue(null);
            }
        }
        String voucherCopy = params.get("voucherCopy");
        if (voucherCopy != null) {
            try {
                int i = Integer.parseInt(voucherCopy);
                if (i >= 0 && i <= 1000000) {
                    this.spVoucherCopy.setValue((Object)i);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        if ((entryCopy = params.get("entryCopy")) != null) {
            try {
                int i = Integer.parseInt(entryCopy);
                if (i >= 0 && i <= 100000) {
                    this.spEntryCopy.setValue((Object)i);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        if (params.get("entryCopyRandom") != null) {
            this.cbEntryCopyRandom.setSelected(Boolean.valueOf(params.get("entryCopyRandom")).booleanValue());
        }
        if (params.get("unsaveSource") != null) {
            this.cbUnsaveSource.setSelected(Boolean.valueOf(params.get("unsaveSource")).booleanValue());
        }
        if (params.get("adjustDescription") != null) {
            this.cbAdjustDescription.setSelected(Boolean.valueOf(params.get("adjustDescription")).booleanValue());
        } else {
            this.cbAdjustDescription.setSelected(true);
        }
        if (params.get("isCompress") != null) {
            this.cbCompress.setSelected(Boolean.valueOf(params.get("isCompress")).booleanValue());
        } else {
            this.cbCompress.setSelected(true);
        }
        if (params.get("useGlobalCache") != null) {
            this.cbUseGlobalCache.setSelected(Boolean.valueOf(params.get("useGlobalCache")).booleanValue());
        }
        if (params.get("clearGlobalCache") != null) {
            this.cbRefreshGlobalCache.setSelected(Boolean.valueOf(params.get("clearGlobalCache")).booleanValue());
        }
        if (params.get("showRequest") != null) {
            this.cbShowRequest.setSelected(Boolean.valueOf(params.get("showRequest")).booleanValue());
        }
        String showDetail = params.get("showDetail");
        int i = 1;
        if (params.get("showDetail") != null) {
            try {
                i = Integer.parseInt(showDetail);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.rbShowErrorDetail.setSelected(true);
        if (i == 0) {
            this.rbShowNoDetail.setSelected(true);
        } else if (i == 2) {
            this.rbShowAllDetail.setSelected(true);
        }
        if (params.get("jumpCheck") != null) {
            this.cbJumpCheck.setSelected(Boolean.valueOf(params.get("jumpCheck")).booleanValue());
        } else {
            this.cbJumpCheck.setSelected(true);
        }
    }

    protected Map<String, String> buildConfig() {
        HashMap<String, String> params = new HashMap<String, String>();
        String filepath = this.tfFile.getText().trim();
        params.put("file", filepath);
        params.put("importMode", this.isAdvImportMode ? "advance" : "common");
        String action = "submit";
        if (this.rbTemp.isSelected()) {
            action = "temp";
        } else if (this.rbAudit.isSelected()) {
            action = "audit";
        } else if (this.rbPost.isSelected()) {
            action = "post";
        }
        params.put("action", action);
        String batchCount = this.spBatchCount.getValue().toString();
        params.put("batchCount", batchCount);
        params.put("isColumnAlias", String.valueOf(this.cbColumnAlias.isSelected()));
        params.put("isVerify", String.valueOf(this.cbVerify.isSelected()));
        params.put("isImpCashflow", String.valueOf(this.cbCashflow.isSelected()));
        params.put("overwrite", String.valueOf(this.cbOverwrite.isSelected()));
        params.put("isVoucherTypeIdField", String.valueOf(this.cbVoucherTypeIdField.isSelected()));
        params.put("isBizStatusIdField", String.valueOf(this.cbBizStatusIdField.isSelected()));
        params.put("extends", this.txtExtends.getText());
        String numberPrefix = this.tfNumberPrefix.getText();
        String periodNumber = this.tfPeriodNumber.getText();
        String bookedDate = this.tfBookedDate.getText();
        params.put("numberPrefix", numberPrefix);
        params.put("periodNumber", periodNumber);
        params.put("bookedDate", bookedDate);
        String voucherCopy = this.spVoucherCopy.getValue().toString();
        params.put("voucherCopy", voucherCopy);
        String entryCopy = this.spEntryCopy.getValue().toString();
        params.put("unsaveSource", String.valueOf(this.cbUnsaveSource.isSelected()));
        params.put("adjustDescription", String.valueOf(this.cbAdjustDescription.isSelected()));
        params.put("entryCopy", entryCopy);
        params.put("entryCopyRandom", String.valueOf(this.cbEntryCopyRandom.isSelected()));
        params.put("isCompress", String.valueOf(this.cbCompress.isSelected()));
        params.put("useGlobalCache", String.valueOf(this.cbUseGlobalCache.isSelected()));
        params.put("clearGlobalCache", String.valueOf(this.cbRefreshGlobalCache.isSelected()));
        params.put("showRequest", String.valueOf(this.cbShowRequest.isSelected()));
        params.put("isCosmic", String.valueOf(this.cbSynStarSeaData.isSelected()));
        int showDetail = 0;
        if (this.rbShowErrorDetail.isSelected()) {
            showDetail = 1;
        } else if (this.rbShowAllDetail.isSelected()) {
            showDetail = 2;
        }
        params.put("showDetail", String.valueOf(showDetail));
        params.put("jumpCheck", String.valueOf(this.cbJumpCheck.isSelected()));
        return params;
    }

    protected void saveConfig() {
        File file;
        Map<String, String> params = this.buildConfig();
        String filepath = this.getFilepath();
        if (filepath != null && (file = new File(filepath)).isDirectory()) {
            this.saveConfig(params, filepath + "VoucherImport.properties");
        }
    }

    private String getFilepath() {
        String tempPath = System.getProperty("easclient.root");
        if (tempPath == null) {
            return null;
        }
        tempPath = tempPath + "/";
        tempPath = tempPath.replace('/', File.separatorChar);
        tempPath = tempPath.replace('\\', File.separatorChar);
        return tempPath;
    }

    public void saveConfig(Map<String, String> params, String filename) {
        ArrayList<String> lines = new ArrayList<String>(params.size());
        for (String key : params.keySet()) {
            lines.add(key + "=" + params.get(key));
        }
        this.saveTxt(lines, filename, "UTF-8");
    }

    public Map<String, String> loadConfig(String filename) {
        List<String> lines = this.loadTxt(filename, "UTF-8");
        HashMap<String, String> params = new HashMap<String, String>();
        for (String line : lines) {
            int index = (line = line.trim()).indexOf("=");
            if (index <= 0) continue;
            params.put(line.substring(0, index), line.substring(index + 1));
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTxt(List<String> lines, String filename, String coding) {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), coding));
            for (String line : lines) {
                writer.println(line);
            }
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> loadTxt(String filename, String coding) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            File file = new File(filename);
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), coding));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            this.error(e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return lines;
    }

    protected String getUIClassParam(String name) {
        Map uictx = this.getUIContext();
        String uiParam = (String)uictx.get("UIClassParam");
        if (uiParam != null) {
            for (String str : uiParam.split(";")) {
                if (!str.startsWith(name + "=")) continue;
                return str.substring(name.length() + 1);
            }
        }
        return (String)uictx.get(name);
    }

    protected String getString(String resName) {
        return EASResource.getString((String)RESOURCE, (String)resName);
    }
}

