/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.util.Map;

public class VoucherImporter {
    protected static final String RESOURCE = "com.kingdee.eas.fi.gl.VoucherImport";
    protected Map<String, String> config;
    protected int totalCount = 0;
    protected int sucCount = 0;
    protected boolean onlyCheck = false;

    public VoucherImporter(Map<String, String> config) {
        this.config = config;
        if (config.get("onlyCheck") != null && "true".equalsIgnoreCase(config.get("onlyCheck").toString())) {
            this.onlyCheck = true;
        }
    }

    public boolean beforeExecute() throws Exception {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.info("***************************************************************************");
        String path = this.config.get("file");
        if (path == null || path.trim().length() == 0) {
            this.error(this.getString("FilePosition_SetPlease"));
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            this.error(this.getString("FilePosition_NotExist"));
            return;
        }
        try {
            this.info(this.getString(this.onlyCheck ? "BeginCheck" : "BeginImport") + " " + (Boolean.valueOf(this.config.get("importVoucher")) != false ? "importVoucher" : "nImportVoucher") + "...");
            if (!this.beforeExecute()) {
                return;
            }
            this.totalCount = 0;
            this.sucCount = 0;
            long start = System.currentTimeMillis();
            if (file.isFile()) {
                this.importFile(file);
            } else {
                File[] subFiles;
                for (File subFile : subFiles = file.listFiles()) {
                    this.importFile(subFile);
                }
            }
            this.info(this.getString(this.onlyCheck ? "Check_TotalTime" : "Import_TotalTime") + (System.currentTimeMillis() - start) + "ms\uff0c" + this.getString(this.onlyCheck ? "TotalCheck_VoucherCount" : "TotalImport_VoucherCount") + this.totalCount + "\uff0c" + this.getString(this.onlyCheck ? "TotalPass_VoucherCount" : "TotalSuccess_VoucherCount") + this.sucCount + "\n");
        }
        catch (Exception e) {
            this.error(e);
        }
        finally {
            this.afterExecute();
        }
    }

    public void afterExecute() {
    }

    public void importFile(File file) throws Exception {
    }

    public void info(String msg) {
    }

    public void warn(String msg) {
    }

    public void error(String msg) {
    }

    public void error(Throwable t) {
    }

    protected String getString(String resName) {
        return EASResource.getString((String)RESOURCE, (String)resName);
    }
}

