/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IVoucherHelpFacade;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherHelpFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.client.AbstractVoucherMgCtrlUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class VoucherMgCtrlUI
extends AbstractVoucherMgCtrlUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherMgCtrlUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(true);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(false);
    }

    private void doSelect(boolean select) {
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            rowAss.getCell("mgCtrl").setValue((Object)select);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        int result;
        HashMap<String, Boolean> idList = new HashMap<String, Boolean>();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            String id = (String)rowAss.getUserObject();
            Boolean mgCtrl = (Boolean)rowAss.getCell("mgCtrl").getValue();
            idList.put(id, mgCtrl);
        }
        if (this.getFacade().setMgCtrl(idList) && (result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.client.GlResource", (String)"isExit"))) == 0) {
            this.btnCancel_actionPerformed(e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.actionSelectAll.setEnabled(true);
        this.actionClearAll.setEnabled(true);
        this.tblMain.getColumn("company").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("period").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("vouchertype").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("description").getStyleAttributes().setLocked(true);
        this.initData();
    }

    private void loadData() throws Exception {
        Object list = this.getUIContext().get("ids");
        String ids = "";
        if (list instanceof String) {
            ids = (String)list;
        } else {
            IIDList idl = (IIDList)list;
            int count = idl.getCount();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    ids = ids + ",";
                }
                ids = ids + idl.getID(i);
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = evi.getSelector();
        this.setSelector(selectorItemCollection);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)new Integer(1), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(1), CompareType.LESS_EQUALS));
        evi.setFilter(filter);
        SorterItemCollection sorters = evi.getSorter();
        sorters.add(new SorterItemInfo("voucherType.number"));
        sorters.add(new SorterItemInfo("number"));
        VoucherCollection col = VoucherFactory.getRemoteInstance().getVoucherCollection(evi);
        VoucherCollection filterCol = this.getVoucherCollectionWithFliter(col);
        this.tblMain.removeRows();
        if (filterCol != null && filterCol.size() > 0) {
            for (int i = 0; i < filterCol.size(); ++i) {
                IRow rowAss = this.tblMain.addRow();
                VoucherInfo info = filterCol.get(i);
                rowAss.setUserObject((Object)info.getId().toString());
                rowAss.getCell("company").setValue((Object)info.getCompany().getName());
                rowAss.getCell("period").setValue((Object)(info.getPeriod().getPeriodYear() + "." + info.getPeriod().getPeriodNumber()));
                rowAss.getCell("vouchertype").setValue((Object)info.getVoucherType().getName());
                rowAss.getCell("number").setValue((Object)info.getNumber());
                rowAss.getCell("description").setValue((Object)info.getVoucherAbstract());
                rowAss.getCell("mgCtrl").setValue((Object)info.isIsMgCtrl());
            }
        }
    }

    private VoucherCollection getVoucherCollectionWithFliter(VoucherCollection col) throws GLException, BOSException {
        if (col == null || col.size() == 0) {
            return null;
        }
        VoucherCollection vCol = new VoucherCollection();
        Map allCompanyParams = (Map)this.getUIContext().get("ALLCOMPANTPARAMS");
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            VoucherInfo info = col.get(i);
            String companyId = info.getCompany().getId().toString();
            GlParam params = (GlParam)allCompanyParams.get(companyId);
            boolean isUseMgCtrl = params.getBoolean("GL_029");
            int isSubmit = params.getInt("GL_075");
            if (!isUseMgCtrl || isSubmit == 0 && !info.getBizStatus().equals((Object)VoucherStatusEnum.TEMP)) continue;
            vCol.add(info);
        }
        return vCol;
    }

    private IVoucherHelpFacade getFacade() throws Exception {
        return VoucherHelpFacadeFactory.getRemoteInstance();
    }

    private void initData() throws Exception {
        this.loadData();
    }

    protected SelectorItemCollection setSelector(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        sic.add(new SelectorItemInfo("isMgCtrl"));
        sic.add(new SelectorItemInfo("voucherAbstract"));
        sic.add(new SelectorItemInfo("bizStatus"));
        return sic;
    }
}

