/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.alibaba.fastjson.JSON;
import com.kingdee.eas.fi.gl.WSVoucherFactory;
import com.kingdee.eas.fi.gl.ZipUtils;
import com.kingdee.eas.fi.gl.client.PoiEventUserModelXlsxReader;
import com.kingdee.eas.fi.gl.client.VoucherImportUI;
import com.kingdee.eas.fi.gl.client.VoucherImporter;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class VoucherNewImporter
extends VoucherImporter {
    private VoucherImportUI importUI;

    public VoucherNewImporter(VoucherImportUI importUI, Map<String, String> config) {
        super(config);
        this.importUI = importUI;
    }

    @Override
    public void importFile(File file) throws Exception {
        this.info(">>>>>>>>" + this.getString("Reading") + " " + file + " ...");
        boolean isColumnAlias = "true".equals(this.config.get("isColumnAlias"));
        LinkedHashMap<String, List<List<String>>> liness = PoiEventUserModelXlsxReader.read(file);
        StringBuffer sheetinfo = new StringBuffer();
        for (String sheetName : liness.keySet()) {
            if (sheetinfo.length() > 0) {
                sheetinfo.append(";  ");
            }
            sheetinfo.append("\u3000\u3000" + this.getString("PageLabel") + " " + sheetName + " " + this.getString("RecordCount") + " " + liness.get(sheetName).size());
        }
        this.info(sheetinfo.toString());
        boolean isVoucherTypeIdField = "true".equals(this.config.get("isVoucherTypeIdField"));
        boolean isBizStatusIdField = "true".equals(this.config.get("isBizStatusIdField"));
        for (String sheetName : liness.keySet()) {
            if (this.importUI.isStop()) break;
            long start = System.currentTimeMillis();
            List<List<String>> lines = liness.get(sheetName);
            if (lines.size() <= 1) continue;
            this.info("\u3000\u3000>>>>" + this.getString(this.onlyCheck ? "Check_PageLabel" : "Import_PageLabel") + " " + sheetName + " ...");
            HashMap<String, Integer> colIndexs = new HashMap<String, Integer>();
            List<String> header = lines.get(0);
            for (int i = 0; i < header.size(); ++i) {
                colIndexs.put(header.get(i), i);
            }
            List<String> aliases = null;
            int beginIndex = 1;
            if (isColumnAlias && lines.size() >= 2) {
                aliases = lines.get(1);
                beginIndex = 2;
            }
            ArrayList<List<List<String>>> vouchers = new ArrayList<List<List<String>>>();
            ArrayList<List<String>> voucher = new ArrayList<List<String>>();
            String preKey = "";
            int i = -1;
            for (List<String> line : lines) {
                if (++i < beginIndex) continue;
                String companyNumber = this.getValue(line, colIndexs, "companyNumber");
                String periodNumber = this.getValue(line, colIndexs, "periodNumber");
                String voucherNumber = this.getValue(line, colIndexs, "voucherNumber");
                String key = "";
                key = key + (companyNumber != null ? companyNumber : "emptyCompanyNumber");
                if (colIndexs.containsKey("periodYear")) {
                    String periodYear = this.getValue(line, colIndexs, "periodYear");
                    key = key + "_" + (periodYear != null ? periodYear : "emptyPeriodYear");
                }
                key = key + "_" + (periodNumber != null ? periodNumber : "emptyPeriodNumber");
                key = key + "_" + (voucherNumber != null ? voucherNumber : "emptyVoucherNumber");
                if (isVoucherTypeIdField) {
                    String voucherType = this.getValue(line, colIndexs, "voucherType");
                    key = key + "_" + (voucherType != null ? voucherType : "emptyVoucherType");
                }
                if (isBizStatusIdField) {
                    String bizStatus = this.getValue(line, colIndexs, "bizStatus");
                    key = key + "_" + (bizStatus != null ? bizStatus : "emptyBizStatus");
                }
                if (!key.equals(preKey) && voucher.size() > 0) {
                    vouchers.add(voucher);
                    voucher = new ArrayList();
                }
                voucher.add(line);
                preKey = key;
            }
            if (voucher.size() > 0) {
                vouchers.add(voucher);
                voucher = new ArrayList();
            }
            this.importVouchers(vouchers, header, aliases, colIndexs);
            this.info("\u3000\u3000" + this.getString(this.onlyCheck ? "Check_PageLabel" : "Import_PageLabel") + " " + sheetName + " " + this.getString("UseTime") + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected String getValue(List<String> line, Map<String, Integer> colIndexs, String colName) {
        Integer colIndex = colIndexs.get(colName);
        if (colIndex == null || colIndex >= line.size()) {
            return null;
        }
        return line.get(colIndex);
    }

    /*
     * WARNING - void declaration
     */
    public void importVouchers(List<List<List<String>>> vouchers, List<String> header, List<String> aliases, Map<String, Integer> colIndexs) throws Exception {
        String numberPrefix = (String)this.config.get("numberPrefix");
        if (numberPrefix == null) {
            numberPrefix = "";
        }
        numberPrefix = numberPrefix.trim();
        int rPeriodNumber = 0;
        String periodNumber = (String)this.config.get("periodNumber");
        if (periodNumber != null && periodNumber.trim().length() > 0) {
            rPeriodNumber = Integer.parseInt(periodNumber.trim());
        }
        String rBookedDate = (String)this.config.get("bookedDate");
        int headSize = aliases != null ? 2 : 1;
        int batchCount = Integer.parseInt((String)this.config.get("batchCount")) + headSize;
        int voucherCopy = Integer.parseInt((String)this.config.get("voucherCopy"));
        boolean adjustDescription = "true".equals(this.config.get("adjustDescription"));
        int entryCopy = Integer.parseInt((String)this.config.get("entryCopy"));
        boolean entryCopyRandom = "true".equals(this.config.get("entryCopyRandom"));
        int rowOffset = 0;
        Random random = new Random();
        if (this.importUI.isStop()) {
            return;
        }
        int tCount = 0;
        ArrayList<List<String>> posts = new ArrayList<List<String>>();
        posts.add(header);
        if (aliases != null) {
            posts.add(aliases);
        }
        for (List<List<String>> voucher : vouchers) {
            if (this.importUI.isStop()) break;
            ArrayList<List<String>> wswsvoucher = new ArrayList<List<String>>();
            for (List<String> entry : voucher) {
                List<String> item = this.buildList(entry, colIndexs, numberPrefix, rPeriodNumber, rBookedDate, adjustDescription);
                wswsvoucher.add(item);
            }
            if (!"true".equals(this.config.get("unsaveSource"))) {
                posts.addAll(wswsvoucher);
                ++tCount;
            }
            if (posts.size() >= batchCount) {
                this.doImportVouchers(posts, tCount, headSize, rowOffset);
                rowOffset += posts.size() - headSize;
                posts.clear();
                posts.add(header);
                if (aliases != null) {
                    posts.add(aliases);
                }
                tCount = 0;
            }
            for (int voucherCount = 1; voucherCount <= voucherCopy && !this.importUI.isStop(); ++voucherCount) {
                if (entryCopy == 0) {
                    Integer colIndex = null;
                    for (List list : wswsvoucher) {
                        List<String> copyitem = this.copyList(list);
                        if (copyitem.size() > 0) {
                            String string;
                            String string2;
                            colIndex = colIndexs.get("voucherNumber");
                            if (colIndex != null && colIndex < copyitem.size()) {
                                copyitem.set(colIndex, copyitem.get(colIndex) + "_copy" + voucherCount);
                            }
                            if ((colIndex = colIndexs.get("importKey")) != null && colIndex < copyitem.size() && (string2 = copyitem.get(colIndex)) != null && string2.trim().length() > 0) {
                                copyitem.set(colIndex, string2.trim() + "_copy" + voucherCount);
                            }
                            colIndex = colIndexs.get("description");
                            if (adjustDescription && colIndex != null && colIndex < copyitem.size() && (string = copyitem.get(colIndex)) != null && string.trim().length() > 0) {
                                copyitem.set(colIndex, string.trim() + "_copy" + voucherCount);
                            }
                        }
                        posts.add(copyitem);
                    }
                } else {
                    void var25_32;
                    int size = entryCopy + 1;
                    if (entryCopyRandom) {
                        size = random.nextInt(size) + 1;
                    }
                    int maxSeq = 0;
                    boolean bl = false;
                    while (var25_32 < size && !this.importUI.isStop()) {
                        for (List list : wswsvoucher) {
                            String description;
                            String importKey;
                            List<String> copyitem = this.copyList(list);
                            copyitem.set(colIndexs.get("voucherNumber"), copyitem.get(colIndexs.get("voucherNumber")) + "_copy" + voucherCount);
                            if (colIndexs.containsKey("importKey") && (importKey = copyitem.get(colIndexs.get("importKey"))) != null && importKey.trim().length() > 0) {
                                copyitem.set(colIndexs.get("importKey"), importKey.trim() + "_copy" + voucherCount);
                            }
                            if (adjustDescription && colIndexs.containsKey("description") && (description = copyitem.get(colIndexs.get("description"))) != null && description.trim().length() > 0) {
                                copyitem.set(colIndexs.get("description"), description.trim() + "_copy" + voucherCount);
                            }
                            String seq = copyitem.get(colIndexs.get("entrySeq"));
                            int iSeq = 0;
                            if (seq != null && seq.trim().length() > 0) {
                                try {
                                    iSeq = Integer.parseInt(seq.trim());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (var25_32 == false) {
                                if (iSeq > maxSeq) {
                                    maxSeq = iSeq;
                                }
                            } else {
                                copyitem.set(colIndexs.get("entrySeq"), String.valueOf(iSeq + maxSeq * var25_32));
                            }
                            if (var25_32 != false && colIndexs.containsKey("oppAccountSeq") && copyitem.size() > colIndexs.get("oppAccountSeq")) {
                                String oppSeq = copyitem.get(colIndexs.get("oppAccountSeq"));
                                if (oppSeq != null && oppSeq.trim().length() > 0) {
                                    try {
                                        oppSeq = String.valueOf(Integer.parseInt(oppSeq.trim()) + maxSeq * var25_32);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                copyitem.set(colIndexs.get("oppAccountSeq"), oppSeq);
                            }
                            posts.add(copyitem);
                        }
                        ++var25_32;
                    }
                }
                ++tCount;
                if (posts.size() < batchCount) continue;
                this.doImportVouchers(posts, tCount, headSize, rowOffset);
                rowOffset += posts.size() - headSize;
                posts.clear();
                posts.add(header);
                if (aliases != null) {
                    posts.add(aliases);
                }
                tCount = 0;
            }
        }
        if (posts.size() > headSize) {
            this.doImportVouchers(posts, tCount, headSize, rowOffset);
        }
    }

    protected List<String> buildList(List<String> entry, Map<String, Integer> colIndexs, String numberPrefix, int rPeriodNumber, String rBookedDate, boolean adjustDescription) {
        String description;
        String importKey;
        ArrayList<String> list = new ArrayList<String>(entry.size());
        list.addAll(entry);
        if (list.size() <= 0) {
            return list;
        }
        Integer index = colIndexs.get("voucherNumber");
        if (index != null && numberPrefix.length() > 0 && index < list.size()) {
            list.set(index, numberPrefix + entry.get(index));
        }
        if ((index = colIndexs.get("importKey")) != null && numberPrefix.length() > 0 && index < list.size() && (importKey = entry.get(index)) != null && importKey.trim().length() > 0) {
            list.set(index, numberPrefix + importKey.trim());
        }
        if (rPeriodNumber > 0) {
            Integer yearIndex = colIndexs.get("periodYear");
            Integer numberIndex = colIndexs.get("periodNumber");
            if (yearIndex != null && yearIndex < list.size()) {
                list.set(yearIndex, String.valueOf(rPeriodNumber / 100));
            }
            if (yearIndex != null && numberIndex != null) {
                if (numberIndex < list.size()) {
                    list.set(numberIndex, String.valueOf(rPeriodNumber % 100));
                }
            } else if (numberIndex != null && numberIndex < list.size()) {
                list.set(numberIndex, String.valueOf(rPeriodNumber));
            }
        }
        if (rBookedDate != null && rBookedDate.trim().length() > 0 && (index = colIndexs.get("bookedDate")) != null && index < list.size()) {
            list.set(index, rBookedDate.trim());
        }
        if (adjustDescription && (index = colIndexs.get("description")) != null && numberPrefix.length() > 0 && index < list.size() && (description = entry.get(index)) != null && description.trim().length() > 0) {
            list.set(index, numberPrefix + description.trim());
        }
        return list;
    }

    protected List<String> copyList(List<String> list) {
        ArrayList<String> copy = new ArrayList<String>(list.size());
        copy.addAll(list);
        return copy;
    }

    protected void doImportVouchers(List<List<String>> wswsvouchers, int tCount, int headSize, int rowOffset) throws Exception {
        String info;
        if (this.importUI.isStop()) {
            return;
        }
        this.info("\u3000\u3000\u3000\u3000>>" + this.getString("DataProcess") + "...");
        long start = System.currentTimeMillis();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("LOGIN_TYPE", "GUI");
        params.put("importMode", this.config.get("importMode"));
        params.put("isSubmit", this.config.get("isSubmit"));
        params.put("isAudit", this.config.get("isAudit"));
        params.put("isPost", this.config.get("isPost"));
        params.put("isVoucherTypeIdField", this.config.get("isVoucherTypeIdField"));
        params.put("isBizStatusIdField", this.config.get("isBizStatusIdField"));
        params.put("isVerify", this.config.get("isVerify"));
        params.put("isImpCashflow", this.config.get("isImpCashflow"));
        params.put("overwrite", this.config.get("overwrite"));
        params.put("isCompress", this.config.get("isCompress"));
        params.put("useGlobalCache", this.config.get("useGlobalCache"));
        params.put("clearGlobalCache", this.config.get("clearGlobalCache"));
        params.put("isColumnAlias", this.config.get("isColumnAlias"));
        params.put("rowOffset", rowOffset);
        params.put("isCosmic", this.config.get("isCosmic"));
        params.put("onlyCheck", this.config.get("onlyCheck"));
        params.put("jumpCheck", this.config.get("jumpCheck"));
        if (this.config.get("extendKeys") != null) {
            Set extendKeys = (Set)JSON.parseObject((String)((String)this.config.get("extendKeys")), Set.class);
            for (String key : extendKeys) {
                if (!this.config.containsKey(key)) continue;
                params.put(key, this.config.get(key));
            }
        }
        String strParams = JSON.toJSONString(params);
        String strRows = JSON.toJSONString(wswsvouchers);
        if ("true".equals(this.config.get("showRequest"))) {
            this.info("\u3000\u3000\u3000\u3000params\uff1a" + strParams);
            this.info("\u3000\u3000\u3000\u3000rows\uff1a" + (strRows.length() > 50000 ? strRows.substring(0, 50000) : strRows));
        }
        if ("true".equals(this.config.get("isCompress"))) {
            strRows = ZipUtils.gzip(strRows);
        }
        this.info("\u3000\u3000\u3000\u3000" + this.getString("Front_TranlateTime") + (System.currentTimeMillis() - start) + "ms");
        this.info("\u3000\u3000\u3000\u3000" + MessageFormat.format(this.getString("SubmitData_Rows"), wswsvouchers.size() - headSize) + "...");
        start = System.currentTimeMillis();
        String invokeStr = WSVoucherFactory.getRemoteInstance().nImportVoucher(strRows, strParams, false);
        long used = System.currentTimeMillis() - start;
        if ("true".equals(this.config.get("isCompress"))) {
            invokeStr = ZipUtils.gunzip(invokeStr);
        }
        if ("true".equals(this.config.get("showRequest"))) {
            this.info("\u3000\u3000\u3000\u3000result\uff1a" + (invokeStr.length() > 50000 ? invokeStr.substring(0, 50000) : invokeStr));
        }
        Map result = (Map)JSON.parseObject((String)invokeStr, Map.class);
        Map errs = (Map)result.get("errs");
        Map sucs = (Map)result.get("sucs");
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int i1 = 0;
                int i2 = 0;
                if (o1 instanceof Integer) {
                    i1 = (Integer)o1;
                    i2 = (Integer)o2;
                } else if (o1 instanceof String) {
                    i1 = Integer.parseInt((String)o1);
                    i2 = Integer.parseInt((String)o2);
                }
                if (i2 > i1) {
                    return -1;
                }
                if (i2 < i1) {
                    return 1;
                }
                return 0;
            }
        };
        Object showDetail = this.config.get("showDetail");
        if ("2".equals(showDetail) && sucs.size() > 0) {
            this.info("\u3000\u3000\u3000\u3000" + this.getString("SuccessInfo"));
            ArrayList sucsList = new ArrayList(sucs.size());
            sucsList.addAll(sucs.keySet());
            Collections.sort(sucsList, comparator);
            for (Object key : sucsList) {
                Map suc = (Map)sucs.get(key);
                info = "\u3000\u3000\u3000\u3000\u3000\u3000" + this.getString("Data_StartRow") + key;
                info = info + ", " + this.getString("Org") + suc.get("companyNumber");
                info = info + ", " + this.getString("Period") + suc.get("periodNumber");
                info = info + ", " + this.getString("Old_VoucherNumber") + suc.get("voucherNumber");
                if (suc.get("number") != null) {
                    info = info + ", " + this.getString("New_VoucherNumber") + suc.get("number");
                }
                if (suc.get("id") != null) {
                    info = info + ", ID " + suc.get("id");
                }
                this.info(info);
            }
        }
        if ("2".equals(showDetail) || "1".equals(showDetail)) {
            if (errs.size() > 0) {
                this.error("\u3000\u3000\u3000\u3000" + this.getString("ErrorInfo"));
                ArrayList errsList = new ArrayList(errs.size());
                errsList.addAll(errs.keySet());
                Collections.sort(errsList, comparator);
                for (Object key : errsList) {
                    Map err = (Map)errs.get(key);
                    if ("v".equals(err.get("type"))) {
                        info = "\u3000\u3000\u3000\u3000\u3000\u3000" + this.getString("Data_StartRow") + key;
                        info = info + ",   " + this.getString("Org") + err.get("companyNumber");
                        info = info + ", " + this.getString("Period") + err.get("periodNumber");
                        info = info + ", " + this.getString("Old_VoucherNumber") + err.get("voucherNumber");
                        info = info + ": " + err.get("msg");
                        this.error(info);
                        if (!err.containsKey("ex")) continue;
                        this.error((String)err.get("ex"));
                        continue;
                    }
                    info = "\u3000\u3000\u3000\u3000\u3000\u3000" + this.getString("DataRow") + key;
                    if (err.get("col") instanceof List) {
                        List cols = (List)err.get("col");
                        List vals = (List)err.get("val");
                        List msgs = (List)err.get("msg");
                        for (int i = 0; i < cols.size(); ++i) {
                            info = info + ",   " + this.getString("DataColumn") + cols.get(i);
                            info = info + "[" + vals.get(i) + "]";
                            info = info + ": " + msgs.get(i);
                        }
                    } else {
                        if (err.containsKey("col")) {
                            info = info + ",   " + this.getString("DataColumn") + err.get("col");
                        }
                        if (err.containsKey("val")) {
                            info = info + "[" + err.get("val") + "]";
                        }
                        info = info + ": " + err.get("msg");
                    }
                    if ("description".equals(err.get("col")) || "importKey".equals(err.get("col"))) {
                        if (err.containsKey("row")) {
                            info = info + ", " + this.getString("RelateRow") + err.get("row");
                        } else if (err.containsKey("id")) {
                            info = info + ", " + this.getString("RelateVoucher") + ", " + this.getString("Org") + err.get("companyNumber") + ", " + this.getString("Period") + err.get("periodNumber") + ", " + this.getString("Number") + err.get("number") + ", ID[" + err.get("id") + "]";
                        }
                    }
                    this.error(info);
                    if (!err.containsKey("ex")) continue;
                    this.error((String)err.get("ex"));
                }
            }
        } else if (errs.size() > 0) {
            this.error("\u3000\u3000\u3000\u3000" + this.getString("ExistError"));
        }
        this.totalCount += tCount;
        this.sucCount += sucs.size();
        StringBuffer info2 = new StringBuffer();
        info2.append("\u3000\u3000\u3000\u3000" + this.getString("This_UseTime") + used + "ms");
        info2.append(", " + this.getString("Behind_UseTime") + result.get("totalTime") + "ms \uff08" + this.getString("Prepare_UseTime") + result.get("prepareTime") + "ms, " + this.getString("Analysis_UseTime") + result.get("analysisTime") + "ms, " + this.getString("Save_UseTime") + result.get("saveTime") + "ms\uff09");
        info2.append(", " + this.getString("Net_UseTime") + (used - Long.parseLong(result.get("totalTime").toString())) + "ms");
        this.info(info2.toString());
        this.info("\u3000\u3000\u3000\u3000" + this.getString(this.onlyCheck ? "Check_VoucherCount" : "Import_VoucherCount") + tCount + "\uff0c" + this.getString(this.onlyCheck ? "Pass_VoucherCount" : "Success_VoucherCount") + sucs.size());
    }

    @Override
    public void info(String msg) {
        this.importUI.info(msg);
    }

    @Override
    public void warn(String msg) {
        this.importUI.warn(msg);
    }

    @Override
    public void error(String msg) {
        this.importUI.error(msg);
    }

    @Override
    public void error(Throwable t) {
        this.importUI.error(t);
    }
}

