/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.client.AbstractVoucherNumberAdjUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class VoucherNumberAdjUI
extends AbstractVoucherNumberAdjUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherNumberAdjUI.class);
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.GLPeriodEndResource";
    boolean isComfirm = false;
    private String autoNumberCache = null;
    private VoucherInfo voucherInfo;
    private VoucherStatusEnum status;

    public VoucherNumberAdjUI() throws Exception {
        Dimension size = new Dimension(300, 220);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void rbSystem_actionPerformed(ActionEvent e) throws Exception {
        this.txtnewNumber.setEditable(false);
    }

    protected void rbHand_actionPerformed(ActionEvent e) throws Exception {
        this.txtnewNumber.setEditable(true);
        String id = (String)this.getUIContext().get("ID");
        this.voucherInfo = (VoucherInfo)this.getFacade().getBillBaseInfo((IObjectPK)new ObjectUuidPK(id));
        this.status = this.voucherInfo.getBizStatus();
        this.autoNumberCache = this.getFacade().getVoucherNumber((BaseVoucherInfo)this.voucherInfo);
        this.txtnewNumber.setText(this.autoNumberCache);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.save();
        this.autoNumberCache = null;
        super.actionExitCurrent_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.toolBar.setVisible(false);
        this.actionConfirm.setEnabled(true);
        this.txtnewNumber.setEditable(true);
        this.initData();
    }

    private void initData() {
        String companyName = (String)this.getUIContext().get("company.name");
        this.txtCompany.setText(companyName);
        String period = (String)this.getUIContext().get("period");
        this.txtPeriod.setText(period);
        String voucherType = (String)this.getUIContext().get("voucherType");
        this.txtVoucherType.setText(voucherType);
        String number = (String)this.getUIContext().get("number");
        this.txtNumber.setText(number);
        String id = (String)this.getUIContext().get("ID");
        try {
            this.voucherInfo = (VoucherInfo)this.getFacade().getBillBaseInfo((IObjectPK)new ObjectUuidPK(id));
            if (!(this.voucherInfo.getBizStatus().equals((Object)VoucherStatusEnum.TEMP) || this.voucherInfo.getBizStatus().equals((Object)VoucherStatusEnum.SUBMITTED) || CodingRuleManagerFactory.getRemoteInstance().isExist((IObjectValue)this.voucherInfo, this.voucherInfo.getCompany().getId().toString(), "bizStatus"))) {
                this.voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
            }
            this.autoNumberCache = this.getFacade().getAvaiableVoucherNumber(this.voucherInfo);
            this.voucherInfo.setBizStatus(this.status);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.txtnewNumber.setText(this.autoNumberCache);
    }

    private IVoucher getFacade() throws Exception {
        return VoucherFactory.getRemoteInstance();
    }

    private void save() throws Exception {
        int choice;
        boolean numberAccordRule;
        String nubmer = this.txtnewNumber.getText();
        String id = (String)this.getUIContext().get("ID");
        if (nubmer == null || nubmer.length() == 0) {
            String msg = EASResource.getString((String)RESOURCE_PATH, (String)"MustNumber");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        if (this.autoNumberCache != null && !nubmer.equals(this.autoNumberCache)) {
            this.voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
            this.getFacade().recycleVoucherNumber((BaseVoucherInfo)this.voucherInfo, this.autoNumberCache);
            this.voucherInfo.setBizStatus(this.status);
        }
        if (!(numberAccordRule = this.getFacade().isNumberAccordRule(this.voucherInfo, nubmer)) && (choice = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.VerifyResource", (String)"voucherNumNotAccordRule"))) != 0) {
            SysUtil.abort();
        }
        this.getFacade().adjustNumber(id, false, nubmer);
        this.isComfirm = true;
    }

    public boolean isComfirm() {
        return this.isComfirm;
    }

    public void setComfirm(boolean isComfirm) {
        this.isComfirm = isComfirm;
    }

    @Override
    protected void kcCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.autoNumberCache != null) {
            this.voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
            this.getFacade().recycleVoucherNumber((BaseVoucherInfo)this.voucherInfo, this.autoNumberCache);
            this.voucherInfo.setBizStatus(this.status);
        }
        super.kcCancel_actionPerformed(e);
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            if (this.autoNumberCache != null) {
                this.voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
                this.getFacade().recycleVoucherNumber((BaseVoucherInfo)this.voucherInfo, this.autoNumberCache);
                this.voucherInfo.setBizStatus(this.status);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.checkBeforeWindowClosing();
    }
}

