/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IVoucherHelpFacade;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherHelpFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.client.AbstractVoucherNumberCheckUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class VoucherNumberCheckUI
extends AbstractVoucherNumberCheckUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherNumberCheckUI.class);
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.GLPeriodEndResource";
    private static Boolean isCheckNumberRepeated = Boolean.TRUE;
    boolean isComfirm = false;
    private PeriodInfo period = null;
    private CompanyOrgUnitInfo vchCompany;
    private String billID = null;
    private boolean isHandNumber = false;
    protected ItemListener voucherTypeChangeLs = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent evt) {
            VoucherTypeInfo vt;
            if (evt.getStateChange() == 1 && (vt = (VoucherTypeInfo)evt.getItem()) != null) {
                try {
                    VoucherNumberCheckUI.this.loadData();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
    };

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(true);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.doSelect(false);
    }

    @Override
    public void actionAuto_actionPerformed(ActionEvent e) throws Exception {
        boolean isSelected;
        IRow rowAss;
        int i;
        IColumn desCol = this.tblMain.getColumn("newNumber");
        desCol.getStyleAttributes().setLocked(true);
        int rowCount = this.tblMain.getRowCount();
        isCheckNumberRepeated = Boolean.TRUE;
        this.isHandNumber = false;
        if (rowCount == 0) {
            return;
        }
        boolean isControl = GlParam.getGlParams(null, (String)"GL_VCH_POST_CONTROL", (String)this.vchCompany.getId().toString()).getBoolean("GL_VCH_POST_CONTROL");
        int sum = 0;
        if (isControl) {
            SelectorItemCollection sic = new SelectorItemCollection();
            EntityViewInfo ev = new EntityViewInfo();
            ev.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.vchCompany.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)this.period.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("voucherType.id", (Object)((VoucherTypeInfo)this.cmbVoucherType.getSelectedItem()).getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(5), CompareType.EQUALS));
            ev.setFilter(filter);
            VoucherCollection postColl = VoucherFactory.getRemoteInstance().getVoucherCollection(ev);
            sum = postColl.size();
        }
        String[] number = this.getFacade().getBatchNumber(rowCount, sum + 1, (IObjectValue)((VoucherTypeInfo)this.cmbVoucherType.getSelectedItem()), (IObjectValue)this.vchCompany);
        ArrayList<String> numberList = new ArrayList<String>();
        block0: for (i = 0; i < rowCount; ++i) {
            rowAss = this.tblMain.getRow(i);
            isSelected = (Boolean)rowAss.getCell("select").getValue();
            if (isSelected) continue;
            String oldNumber = rowAss.getCell("oldNumber").getValue().toString();
            for (int j = 0; j < number.length; ++j) {
                if (!oldNumber.equals(number[j])) continue;
                number[j] = "";
                continue block0;
            }
        }
        for (i = 0; i < number.length; ++i) {
            if (StringUtils.isEmpty((String)number[i])) continue;
            numberList.add(number[i]);
        }
        for (i = 0; i < rowCount; ++i) {
            rowAss = this.tblMain.getRow(i);
            isSelected = (Boolean)rowAss.getCell("select").getValue();
            if (!isSelected) continue;
            rowAss.getCell("newNumber").setValue(numberList.get(0));
            numberList.remove(0);
        }
    }

    @Override
    public void actionHand_actionPerformed(ActionEvent e) throws Exception {
        isCheckNumberRepeated = Boolean.TRUE;
        this.isHandNumber = true;
        IColumn desCol = this.tblMain.getColumn("newNumber");
        desCol.getStyleAttributes().setLocked(false);
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            boolean isSelected = (Boolean)rowAss.getCell("select").getValue();
            if (!isSelected) continue;
            String number = (String)rowAss.getCell("oldNumber").getValue();
            rowAss.getCell("newNumber").setValue((Object)number);
        }
    }

    @Override
    public void actionUpdate_actionPerformed(ActionEvent e) throws Exception {
        this.update();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnSelect.setEnabled(true);
        this.btnClear.setEnabled(true);
        this.btnAuto.setEnabled(true);
        this.btnHand.setEnabled(true);
        this.btnUpdate.setEnabled(true);
        this.btnSelect.setEnabled(true);
        this.btnSelect.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnHand.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnAuto.setIcon(EASResource.getIcon((String)"imgTbtn_unite"));
        this.btnUpdate.setIcon(EASResource.getIcon((String)"imgTbtn_modifyattribute"));
        this.tblMain.checkParsed();
        IColumn newCol = this.tblMain.getColumn("newNumber");
        IColumn oldCol = this.tblMain.getColumn("oldNumber");
        newCol.setEditor(this.getTextEditor());
        newCol.getStyleAttributes().setLocked(true);
        oldCol.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("creator").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("abstract").getStyleAttributes().setLocked(true);
        this.tblMain.checkParsed();
        this.initData();
    }

    protected ICellEditor getTextEditor() {
        KDTDefaultCellEditor textEditor = new KDTDefaultCellEditor((JTextField)new KDTextField());
        textEditor.setClickCountToStart(1);
        return textEditor;
    }

    private void initData() throws Exception {
        this.vchCompany = this.getUIContext().get("company") != null ? (CompanyOrgUnitInfo)this.getUIContext().get("company") : SysContext.getSysContext().getCurrentFIUnit();
        if (this.getUIContext().get("billID") != null) {
            this.billID = this.getUIContext().get("billID").toString();
        }
        if (StringUtils.isEmpty((String)this.billID) && this.getUIContext().get("voucherId") != null) {
            this.billID = this.getUIContext().get("voucherId").toString();
        }
        this.txtCompany.setEditable(false);
        this.txtCompany.setText(this.vchCompany.getName().toString());
        this.txtPeriod.setEditable(false);
        if (this.getUIContext().get("period") != null) {
            this.period = (PeriodInfo)this.getUIContext().get("period");
        }
        this.txtPeriod.setText(this.period.toString());
        VoucherTypeCollection vtCol = GlUtils.getVoucherTypeCollection(null, null, this.vchCompany.getCU().getId().toString());
        boolean codeRuleHasVoucherType = true;
        if (!StringUtils.isEmpty((String)this.billID)) {
            codeRuleHasVoucherType = this.hasVoucherTypeInCodingRule(this.billID);
        }
        if (codeRuleHasVoucherType) {
            this.cmbVoucherType.addItems(vtCol.toArray());
            this.cmbVoucherType.addItemListener(this.voucherTypeChangeLs);
            GlUtils.setSelectedItem(this.cmbVoucherType, (CoreBaseInfo)vtCol.get(0));
        } else {
            this.cmbVoucherType.setEnabled(false);
        }
        this.loadData();
    }

    private boolean hasVoucherTypeInCodingRule(String billId) throws BOSException, EASBizException {
        VoucherInfo caller = (VoucherInfo)VoucherFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(billId), VoucherInfo.getDefaultSelector());
        caller.setBizStatus(VoucherStatusEnum.SUBMITTED);
        CodingRuleInfo codingRule = CodingRuleManagerFactory.getRemoteInstance().getCodingRule((IObjectValue)caller, caller.getCompany().getId().toString(), "bizStatus");
        if (codingRule != null && codingRule.getCodingRuleEntrys().size() > 0) {
            for (int i = 0; i < codingRule.getCodingRuleEntrys().size(); ++i) {
                if (codingRule.getCodingRuleEntrys().get(i).getValueAttribute() == null || !codingRule.getCodingRuleEntrys().get(i).getValueAttribute().startsWith("voucherType") || !codingRule.getCodingRuleEntrys().get(i).isIsSortByItem()) continue;
                return true;
            }
        }
        return false;
    }

    private IVoucherHelpFacade getFacade() throws Exception {
        return VoucherHelpFacadeFactory.getRemoteInstance();
    }

    private void update() throws Exception {
        this.checkSelect();
        Map numberMap = this.getSelectedValues();
        StringBuffer numberRuleCheckInfo = new StringBuffer();
        int cnt = 0;
        if (this.isHandNumber) {
            String hint;
            int choice;
            Set idKeySet = numberMap.keySet();
            HashSet filterIdSet = new HashSet(idKeySet);
            Iterator keyIterator = idKeySet.iterator();
            VoucherInfo voucherInfo = null;
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                String[] numbermap = (String[])numberMap.get(key);
                String newNumber = numbermap[0];
                String oldNumber = numbermap[1];
                if (0 == cnt) {
                    voucherInfo = (VoucherInfo)VoucherFactory.getRemoteInstance().getBillBaseInfo((IObjectPK)new ObjectUuidPK(key));
                } else {
                    voucherInfo.setNumber(oldNumber);
                }
                VoucherStatusEnum oldStatus = voucherInfo.getBizStatus();
                voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
                boolean numberAccordRule = VoucherFactory.getRemoteInstance().isNumberAccordRule(voucherInfo, newNumber);
                voucherInfo.setBizStatus(oldStatus);
                if (numberAccordRule) continue;
                ++cnt;
                numberRuleCheckInfo.append(newNumber).append("\n");
            }
            if (cnt > 0 && (choice = MsgBox.showConfirm2((String)(hint = EASResource.getString((String)"com.kingdee.eas.fi.gl.VerifyResource", (String)"voucherNumNotAccordRule") + "\n" + numberRuleCheckInfo.toString()))) != 0) {
                SysUtil.abort();
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isCheckNumberRepeated", isCheckNumberRepeated);
        map.put("sourceType", "1");
        if (this.getFacade().updateNumber(numberMap, map)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"227_VoucherNumberCheckUI"));
        }
        this.setComfirm(true);
        this.loadData();
    }

    public boolean isComfirm() {
        return this.isComfirm;
    }

    public void setComfirm(boolean isComfirm) {
        this.isComfirm = isComfirm;
    }

    private void loadData() throws Exception {
        VoucherTypeInfo vtDefault = (VoucherTypeInfo)this.cmbVoucherType.getSelectedItem();
        String voucherTypeId = vtDefault == null ? null : vtDefault.getId().toString();
        VoucherCollection col = this.getFacade().loadData(voucherTypeId, this.period.getId().toString(), this.vchCompany.getId().toString());
        this.tblMain.removeRows();
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                IRow rowAss = this.tblMain.addRow();
                VoucherInfo info = col.get(i);
                rowAss.setUserObject((Object)info);
                rowAss.getCell("select").setValue((Object)Boolean.FALSE);
                rowAss.getCell("id").setValue((Object)info.getId().toString());
                rowAss.getCell("oldNumber").setValue((Object)info.getNumber());
                rowAss.getCell("abstract").setValue((Object)info.getVoucherAbstract());
                rowAss.getCell("creator").setValue((Object)info.getCreator().getName());
            }
        }
    }

    private void doSelect(boolean select) {
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            rowAss.getCell("select").setValue((Object)select);
        }
    }

    protected IIDList getSelectedKeyValues() {
        RealModeIDList idList = new RealModeIDList();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            boolean isSelected = (Boolean)rowAss.getCell("select").getValue();
            if (!isSelected) continue;
            String id = (String)rowAss.getCell("id").getValue();
            idList.add(id);
        }
        return idList;
    }

    protected Map getSelectedValues() throws Exception {
        this.tblMain.getEditManager().stopEditing();
        HashSet<String> newNumberSet = new HashSet<String>();
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        VoucherTypeInfo voucherType = null;
        if (this.cmbVoucherType.getSelectedItem() != null && this.cmbVoucherType.getSelectedItem() instanceof VoucherTypeInfo) {
            voucherType = (VoucherTypeInfo)this.cmbVoucherType.getSelectedItem();
        }
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            boolean isSelected = (Boolean)rowAss.getCell("select").getValue();
            if (!isSelected) continue;
            String id = (String)rowAss.getCell("id").getValue();
            String number = (String)rowAss.getCell("newNumber").getValue();
            String oldNumber = (String)rowAss.getCell("oldNumber").getValue();
            if (number == null || number.trim().length() == 0) {
                StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"228_VoucherNumberCheckUI"));
                sb.append(i + 1).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"229_VoucherNumberCheckUI"));
                MsgBox.showWarning((Component)((Object)this), (String)sb.toString());
                SysUtil.abort();
            }
            if (number.equals(oldNumber)) continue;
            if (newNumberSet.contains(number)) {
                this.tblMain.getEditManager().editCellAt(i, this.tblMain.getColumnIndex("newNumber"));
                throw new VoucherException(VoucherException.VOUCHERNUMBERREPEAT);
            }
            newNumberSet.add(number);
            String[] numbermap = new String[]{number, oldNumber, voucherType == null ? "" : voucherType.getName()};
            map.put(id, numbermap);
        }
        return map;
    }

    protected void checkSelect() {
        IIDList list = this.getSelectedKeyValues();
        if (list.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }
}

