/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.eas.fi.gl.WSVoucherCollection;
import com.kingdee.eas.fi.gl.WSVoucherFactory;
import com.kingdee.eas.fi.gl.WSVoucherInfo;
import com.kingdee.eas.fi.gl.XlsxMapReader;
import com.kingdee.eas.fi.gl.client.VoucherImporter;
import com.kingdee.eas.fi.gl.client.VoucherOldImportUI;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class VoucherOldImporter
extends VoucherImporter {
    private static final DateFormat DF = new SimpleDateFormat("yyyy-MM-dd");
    private VoucherOldImportUI importUI;

    public VoucherOldImporter(VoucherOldImportUI importUI, Map<String, String> config) {
        super(config);
        this.importUI = importUI;
    }

    @Override
    public void importFile(File file) throws Exception {
        this.info(">>>>>>>>" + this.getString("Reading") + " " + file + " ...");
        HashMap<String, Class> clazzes = new HashMap<String, Class>();
        clazzes.put("periodYear", Integer.class);
        clazzes.put("periodNumber", Integer.class);
        clazzes.put("attaches", Integer.class);
        clazzes.put("isCheck", Boolean.class);
        clazzes.put("entrySeq", Integer.class);
        clazzes.put("entryDC", Integer.class);
        clazzes.put("originalAmount", Double.class);
        clazzes.put("debitAmount", Double.class);
        clazzes.put("creditAmount", Double.class);
        clazzes.put("localRate", Double.class);
        clazzes.put("qty", Double.class);
        clazzes.put("price", Double.class);
        clazzes.put("asstSeq", Integer.class);
        clazzes.put("cussent", Integer.class);
        clazzes.put("itemFlag", Integer.class);
        clazzes.put("oppAccountSeq", Integer.class);
        clazzes.put("cashflowAmountOriginal", Double.class);
        clazzes.put("cashflowAmountLocal", Double.class);
        clazzes.put("cashflowAmountRpt", Double.class);
        clazzes.put("primaryCoef", Integer.class);
        clazzes.put("supplyCoef", Integer.class);
        LinkedHashMap<String, List<Map<String, Object>>> liness = XlsxMapReader.readXlsx(file, clazzes);
        StringBuffer sheetinfo = new StringBuffer();
        for (String sheetName : liness.keySet()) {
            if (sheetinfo.length() > 0) {
                sheetinfo.append(";  ");
            }
            sheetinfo.append("\u3000\u3000" + this.getString("PageLabel") + " " + sheetName + " " + this.getString("RecordCount") + " " + (liness.get(sheetName).size() + 1));
        }
        this.info(sheetinfo.toString());
        boolean isVoucherTypeIdField = "true".equals(this.config.get("voucherTypeIdField"));
        boolean isBizStatusIdField = "true".equals(this.config.get("bizStatusIdField"));
        for (String sheetName : liness.keySet()) {
            if (this.importUI.isStop()) break;
            long start = System.currentTimeMillis();
            List<Map<String, Object>> lines = liness.get(sheetName);
            if (lines.size() <= 1) continue;
            this.info("\u3000\u3000>>>>" + this.getString("Import_PageLabel") + " " + sheetName + " ...");
            int beginIndex = 0;
            boolean isColumnAlias = "true".equals(this.config.get("isColumnAlias"));
            if (isColumnAlias) {
                beginIndex = 1;
            }
            ArrayList<String> voucherKeys = new ArrayList<String>();
            HashMap<String, List<Map<String, Object>>> vouchers = new HashMap<String, List<Map<String, Object>>>();
            for (int i = beginIndex; i < lines.size(); ++i) {
                ArrayList<Map<String, Object>> voucher;
                Map<String, Object> line = lines.get(i);
                Object companyNumber = line.get("companyNumber");
                Object periodNumber = line.get("periodNumber");
                Object voucherNumber = line.get("voucherNumber");
                String key = "";
                key = key + (companyNumber != null ? companyNumber : "emptyCompanyNumber");
                if (line.containsKey("periodYear")) {
                    Object periodYear = line.get("periodYear");
                    key = key + "_" + (periodYear != null ? periodYear : "emptyPeriodYear");
                }
                key = key + "_" + (periodNumber != null ? periodNumber : "emptyPeriodNumber");
                key = key + "_" + (voucherNumber != null ? voucherNumber : "emptyVoucherNumber");
                if (isVoucherTypeIdField) {
                    Object voucherType = line.get("voucherType");
                    key = key + "_" + (voucherType != null ? voucherType : "emptyVoucherType");
                }
                if (isBizStatusIdField) {
                    Object bizStatus = line.get("bizStatus");
                    key = key + "_" + (bizStatus != null ? bizStatus : "emptyBizStatus");
                }
                if ((voucher = (ArrayList<Map<String, Object>>)vouchers.get(key)) == null) {
                    voucherKeys.add(key);
                    voucher = new ArrayList<Map<String, Object>>();
                    vouchers.put(key, voucher);
                }
                voucher.add(line);
            }
            this.importVouchers(vouchers, voucherKeys);
            this.info("\u3000\u3000" + this.getString("Import_PageLabel") + " " + sheetName + " " + this.getString("UseTime") + (System.currentTimeMillis() - start) + "ms");
        }
    }

    public void importVouchers(Map<String, List<Map<String, Object>>> vouchers, List<String> voucherKeys) throws Exception {
        String numberPrefix = (String)this.config.get("numberPrefix");
        if (numberPrefix == null) {
            numberPrefix = "";
        }
        numberPrefix = numberPrefix.trim();
        int rPeriodNumber = 0;
        String periodNumber = (String)this.config.get("periodNumber");
        if (periodNumber != null && periodNumber.trim().length() > 0) {
            rPeriodNumber = Integer.parseInt(periodNumber.trim());
        }
        String rBookedDate = (String)this.config.get("bookedDate");
        int batchCount = Integer.parseInt((String)this.config.get("batchCount"));
        int voucherCopy = Integer.parseInt((String)this.config.get("voucherCopy"));
        boolean adjustDescription = "true".equals(this.config.get("adjustDescription"));
        int entryCopy = Integer.parseInt((String)this.config.get("entryCopy"));
        boolean entryCopyRandom = "true".equals(this.config.get("entryCopyRandom"));
        Random random = new Random();
        if (this.importUI.isStop()) {
            return;
        }
        int tCount = 0;
        WSVoucherCollection posts = new WSVoucherCollection();
        for (String voucherKey : voucherKeys) {
            if (this.importUI.isStop()) break;
            List<Map<String, Object>> voucher = vouchers.get(voucherKey);
            WSVoucherCollection wswsvoucher = new WSVoucherCollection();
            for (Map<String, Object> entry : voucher) {
                WSVoucherInfo item = this.buildVoucher(entry, numberPrefix, rPeriodNumber, rBookedDate, adjustDescription);
                wswsvoucher.add(item);
            }
            if (!"true".equals(this.config.get("unsaveSource"))) {
                posts.addCollection(wswsvoucher);
                ++tCount;
            }
            if (posts.size() >= batchCount) {
                this.doImportVouchers(posts, tCount);
                posts.clear();
                tCount = 0;
            }
            for (int voucherCount = 1; voucherCount <= voucherCopy && !this.importUI.isStop(); ++voucherCount) {
                if (entryCopy == 0) {
                    for (int i = 0; i < wswsvoucher.size(); ++i) {
                        WSVoucherInfo item = wswsvoucher.get(i);
                        WSVoucherInfo copyitem = this.copyVoucher(item);
                        copyitem.setVoucherNumber(copyitem.getVoucherNumber() + "_copy" + voucherCount);
                        if (copyitem.getImportKey() != null && copyitem.getImportKey().trim().length() > 0) {
                            copyitem.setImportKey(copyitem.getImportKey().trim() + "_copy" + voucherCount);
                        }
                        if (adjustDescription && copyitem.getDescription() != null && copyitem.getDescription().trim().length() > 0) {
                            copyitem.setDescription(copyitem.getDescription().trim() + "_copy" + voucherCount);
                        }
                        posts.add(copyitem);
                    }
                } else {
                    int size = entryCopy + 1;
                    if (entryCopyRandom) {
                        size = random.nextInt(size) + 1;
                    }
                    int maxSeq = 0;
                    for (int entryCount = 0; entryCount < size && !this.importUI.isStop(); ++entryCount) {
                        for (int i = 0; i < wswsvoucher.size(); ++i) {
                            WSVoucherInfo item = wswsvoucher.get(i);
                            WSVoucherInfo copyitem = this.copyVoucher(item);
                            copyitem.setVoucherNumber(copyitem.getVoucherNumber() + "_copy" + voucherCount);
                            if (copyitem.getImportKey() != null && copyitem.getImportKey().trim().length() > 0) {
                                copyitem.setImportKey(copyitem.getImportKey().trim() + "_copy" + voucherCount);
                            }
                            if (adjustDescription && copyitem.getDescription() != null && copyitem.getDescription().trim().length() > 0) {
                                copyitem.setDescription(copyitem.getDescription().trim() + "_copy" + voucherCount);
                            }
                            int iSeq = copyitem.getEntrySeq();
                            if (entryCount == 0) {
                                if (iSeq > maxSeq) {
                                    maxSeq = iSeq;
                                }
                            } else {
                                copyitem.setEntrySeq(iSeq + maxSeq * entryCount);
                            }
                            if (entryCount != 0 && copyitem.getOppAccountSeq() > 0) {
                                copyitem.setOppAccountSeq(copyitem.getOppAccountSeq() + maxSeq * entryCount);
                            }
                            posts.add(copyitem);
                        }
                    }
                }
                ++tCount;
                if (posts.size() < batchCount) continue;
                this.doImportVouchers(posts, tCount);
                posts.clear();
                tCount = 0;
            }
        }
        if (posts.size() > 0) {
            this.doImportVouchers(posts, tCount);
        }
    }

    protected WSVoucherInfo buildVoucher(Map<String, Object> entry, String numberPrefix, int rPeriodNumber, String rBookedDate, boolean adjustDescription) throws ParseException {
        String strAssistEndDate;
        Integer asstSeq;
        Double localRate;
        WSVoucherInfo info = new WSVoucherInfo();
        info.setCompanyNumber((String)entry.get("companyNumber"));
        info.setVoucherNumber(numberPrefix + entry.get("voucherNumber"));
        info.setImportKey((String)entry.get("importKey"));
        String importKey = info.getImportKey();
        if (importKey != null && importKey.trim().length() > 0) {
            info.setImportKey(numberPrefix + importKey.trim());
        }
        if (rPeriodNumber > 0) {
            info.setPeriodYear(rPeriodNumber / 100);
            info.setPeriodNumber(rPeriodNumber % 100);
        } else {
            Integer periodNumber;
            Integer periodYear = (Integer)entry.get("periodYear");
            if (periodYear != null) {
                info.setPeriodYear(periodYear);
            }
            if ((periodNumber = (Integer)entry.get("periodNumber")) != null) {
                info.setPeriodNumber(periodNumber);
                if (periodNumber > 100) {
                    info.setPeriodYear(periodNumber / 100);
                    info.setPeriodNumber(periodNumber % 100);
                }
            }
        }
        if (rBookedDate != null && rBookedDate.trim().length() > 0) {
            info.setBookedDate(DF.parse(rBookedDate.trim()));
        } else {
            String strBookedDate = (String)entry.get("bookedDate");
            if (strBookedDate != null && strBookedDate.trim().length() > 0) {
                info.setBookedDate(DF.parse(strBookedDate.trim()));
            }
        }
        String strBizDate = (String)entry.get("bizDate");
        if (strBizDate != null && strBizDate.trim().length() > 0) {
            info.setBizDate(DF.parse(strBizDate.trim()));
        }
        info.setVoucherType((String)entry.get("voucherType"));
        String description = (String)entry.get("description");
        if (adjustDescription && description != null && description.trim().length() > 0) {
            description = numberPrefix + description.trim();
        }
        info.setDescription(description);
        info.setVoucherAbstract((String)entry.get("voucherAbstract"));
        Integer attaches = (Integer)entry.get("attaches");
        if (attaches != null) {
            info.setAttaches(attaches);
        }
        if (entry.get("isCheck") != null) {
            info.setIsCheck((Boolean)entry.get("isCheck"));
        }
        info.setCreator((String)entry.get("creator"));
        info.setAuditor((String)entry.get("auditor"));
        info.setPoster((String)entry.get("poster"));
        if (entry.get("entrySeq") != null) {
            info.setEntrySeq((Integer)entry.get("entrySeq"));
        }
        info.setProfitCenterNumber((String)entry.get("profitCenterNumber"));
        info.setAccountNumber((String)entry.get("accountNumber"));
        info.setCurrencyNumber((String)entry.get("currencyNumber"));
        if (entry.get("entryDC") != null) {
            info.setEntryDC((Integer)entry.get("entryDC"));
        }
        info.setMeasurement((String)entry.get("measurement"));
        Integer cussent = (Integer)entry.get("cussent");
        if (cussent != null) {
            info.setCussent(cussent);
        }
        info.setCustomerNumber((String)entry.get("customerNumber"));
        if (entry.get("originalAmount") != null) {
            info.setOriginalAmount((Double)entry.get("originalAmount"));
        }
        if (entry.get("debitAmount") != null) {
            info.setDebitAmount((Double)entry.get("debitAmount"));
        }
        if (entry.get("creditAmount") != null) {
            info.setCreditAmount((Double)entry.get("creditAmount"));
        }
        if ((localRate = (Double)entry.get("localRate")) != null) {
            info.setLocalRate(localRate);
        }
        if (entry.get("qty") != null) {
            info.setQty((Double)entry.get("qty"));
        }
        if (entry.get("price") != null) {
            info.setPrice((Double)entry.get("price"));
        }
        if ((asstSeq = (Integer)entry.get("asstSeq")) != null) {
            info.setAsstSeq(asstSeq);
        }
        info.setAssistAbstract((String)entry.get("assistAbstract"));
        String strAssistBizDate = (String)entry.get("assistBizDate");
        if (strAssistBizDate != null && strAssistBizDate.trim().length() > 0) {
            info.setAssistBizDate(DF.parse(strAssistBizDate.trim()));
        }
        if ((strAssistEndDate = (String)entry.get("assistEndDate")) != null && strAssistEndDate.trim().length() > 0) {
            info.setAssistEndDate(DF.parse(strAssistEndDate.trim()));
        }
        info.setSettlementType((String)entry.get("settlementType"));
        info.setSettlementNumber((String)entry.get("settlementNumber"));
        info.setBizNumber((String)entry.get("bizNumber"));
        info.setInvoiceNumber((String)entry.get("invoiceNumber"));
        info.setAsstActType1((String)entry.get("asstActType1"));
        info.setAsstActNumber1((String)entry.get("asstActNumber1"));
        info.setAsstActName1((String)entry.get("asstActName1"));
        info.setAsstActType2((String)entry.get("asstActType2"));
        info.setAsstActNumber2((String)entry.get("asstActNumber2"));
        info.setAsstActName2((String)entry.get("asstActName2"));
        info.setAsstActType3((String)entry.get("asstActType3"));
        info.setAsstActNumber3((String)entry.get("asstActNumber3"));
        info.setAsstActName3((String)entry.get("asstActName3"));
        info.setAsstActType4((String)entry.get("asstActType4"));
        info.setAsstActNumber4((String)entry.get("asstActNumber4"));
        info.setAsstActName4((String)entry.get("asstActName4"));
        info.setAsstActType5((String)entry.get("asstActType5"));
        info.setAsstActNumber5((String)entry.get("asstActNumber5"));
        info.setAsstActName5((String)entry.get("asstActName5"));
        info.setAsstActType6((String)entry.get("asstActType6"));
        info.setAsstActNumber6((String)entry.get("asstActNumber6"));
        info.setAsstActName6((String)entry.get("asstActName6"));
        info.setAsstActType7((String)entry.get("asstActType7"));
        info.setAsstActNumber7((String)entry.get("asstActNumber7"));
        info.setAsstActName7((String)entry.get("asstActName7"));
        info.setAsstActType8((String)entry.get("asstActType8"));
        info.setAsstActNumber8((String)entry.get("asstActNumber8"));
        info.setAsstActName8((String)entry.get("asstActName8"));
        Integer itemFlag = (Integer)entry.get("itemFlag");
        if (itemFlag != null && itemFlag == 1) {
            Double cashflowAmountRpt;
            Double cashflowAmountLocal;
            Double cashflowAmountOriginal;
            info.setItemFlag(itemFlag);
            Integer oppAccountSeq = (Integer)entry.get("oppAccountSeq");
            if (oppAccountSeq != null) {
                info.setOppAccountSeq(oppAccountSeq);
            }
            info.setType((String)entry.get("type"));
            info.setPrimaryItem((String)entry.get("primaryItem"));
            Integer primaryCoef = (Integer)entry.get("primaryCoef");
            if (primaryCoef != null) {
                info.setPrimaryCoef(primaryCoef.intValue());
            }
            info.setSupplyItem((String)entry.get("supplyItem"));
            Integer supplyCoef = (Integer)entry.get("supplyCoef");
            if (supplyCoef != null) {
                info.setSupplyCoef(supplyCoef.intValue());
            }
            if ((cashflowAmountOriginal = (Double)entry.get("cashflowAmountOriginal")) != null) {
                info.setCashflowAmountOriginal(cashflowAmountOriginal);
            }
            if ((cashflowAmountLocal = (Double)entry.get("cashflowAmountLocal")) != null) {
                info.setCashflowAmountLocal(cashflowAmountLocal);
            }
            if ((cashflowAmountRpt = (Double)entry.get("cashflowAmountRpt")) != null) {
                info.setCashflowAmountRpt(cashflowAmountRpt);
            }
            info.setCashAsstActType1((String)entry.get("cashAsstActType1"));
            info.setCashAsstActNumber1((String)entry.get("cashAsstActNumber1"));
            info.setCashAsstActName1((String)entry.get("cashAsstActName1"));
            info.setCashAsstActType2((String)entry.get("cashAsstActType2"));
            info.setCashAsstActNumber2((String)entry.get("cashAsstActNumber2"));
            info.setCashAsstActName2((String)entry.get("cashAsstActName2"));
            info.setCashAsstActType3((String)entry.get("cashAsstActType3"));
            info.setCashAsstActNumber3((String)entry.get("cashAsstActNumber3"));
            info.setCashAsstActName3((String)entry.get("cashAsstActName3"));
            info.setCashAsstActType4((String)entry.get("cashAsstActType4"));
            info.setCashAsstActNumber4((String)entry.get("cashAsstActNumber4"));
            info.setCashAsstActName4((String)entry.get("cashAsstActName4"));
            info.setCashAsstActType5((String)entry.get("cashAsstActType5"));
            info.setCashAsstActNumber5((String)entry.get("cashAsstActNumber5"));
            info.setCashAsstActName5((String)entry.get("cashAsstActName5"));
            info.setCashAsstActType6((String)entry.get("cashAsstActType6"));
            info.setCashAsstActNumber6((String)entry.get("cashAsstActNumber6"));
            info.setCashAsstActName6((String)entry.get("cashAsstActName6"));
            info.setCashAsstActType7((String)entry.get("cashAsstActType7"));
            info.setCashAsstActNumber7((String)entry.get("cashAsstActNumber7"));
            info.setCashAsstActName7((String)entry.get("cashAsstActName7"));
            info.setCashAsstActType8((String)entry.get("cashAsstActType8"));
            info.setCashAsstActNumber8((String)entry.get("cashAsstActNumber8"));
            info.setCashAsstActName8((String)entry.get("cashAsstActName8"));
        }
        return info;
    }

    protected WSVoucherInfo copyVoucher(WSVoucherInfo source) {
        WSVoucherInfo copy = new WSVoucherInfo();
        copy.setCompanyNumber(source.getCompanyNumber());
        copy.setVoucherNumber(source.getVoucherNumber());
        copy.setPeriodYear(source.getPeriodYear());
        copy.setPeriodNumber(source.getPeriodNumber());
        copy.setBookedDate(source.getBookedDate());
        copy.setBizDate(source.getBizDate());
        copy.setVoucherType(source.getVoucherType());
        copy.setDescription(source.getDescription());
        copy.setVoucherAbstract(source.getVoucherAbstract());
        copy.setAttaches(source.getAttaches());
        copy.setIsCheck(source.isIsCheck());
        copy.setCreator(source.getCreator());
        copy.setAuditor(source.getAuditor());
        copy.setPoster(source.getPoster());
        copy.setImportKey(source.getImportKey());
        copy.setEntrySeq(source.getEntrySeq());
        copy.setProfitCenterNumber(source.getProfitCenterNumber());
        copy.setAccountNumber(source.getAccountNumber());
        copy.setCurrencyNumber(source.getCurrencyNumber());
        copy.setEntryDC(source.getEntryDC());
        copy.setMeasurement(source.getMeasurement());
        copy.setCussent(source.getCussent());
        copy.setCustomerNumber(source.getCustomerNumber());
        copy.setOriginalAmount(source.getOriginalAmount());
        copy.setDebitAmount(source.getDebitAmount());
        copy.setCreditAmount(source.getCreditAmount());
        copy.setLocalRate(source.getLocalRate());
        copy.setQty(source.getQty());
        copy.setPrice(source.getPrice());
        copy.setAsstSeq(source.getAsstSeq());
        copy.setAssistAbstract(source.getAssistAbstract());
        copy.setAssistBizDate(source.getAssistBizDate());
        copy.setAssistEndDate(source.getAssistEndDate());
        copy.setSettlementType(source.getSettlementType());
        copy.setSettlementNumber(source.getSettlementNumber());
        copy.setBizNumber(source.getBizNumber());
        copy.setInvoiceNumber(source.getInvoiceNumber());
        copy.setAsstActType1(source.getAsstActType1());
        copy.setAsstActNumber1(source.getAsstActNumber1());
        copy.setAsstActName1(source.getAsstActName1());
        copy.setAsstActType2(source.getAsstActType2());
        copy.setAsstActNumber2(source.getAsstActNumber2());
        copy.setAsstActName2(source.getAsstActName2());
        copy.setAsstActType3(source.getAsstActType3());
        copy.setAsstActNumber3(source.getAsstActNumber3());
        copy.setAsstActName3(source.getAsstActName3());
        copy.setAsstActType4(source.getAsstActType4());
        copy.setAsstActNumber4(source.getAsstActNumber4());
        copy.setAsstActName4(source.getAsstActName4());
        copy.setAsstActType5(source.getAsstActType5());
        copy.setAsstActNumber5(source.getAsstActNumber5());
        copy.setAsstActName5(source.getAsstActName5());
        copy.setAsstActType6(source.getAsstActType6());
        copy.setAsstActNumber6(source.getAsstActNumber6());
        copy.setAsstActName6(source.getAsstActName6());
        copy.setAsstActType7(source.getAsstActType7());
        copy.setAsstActNumber7(source.getAsstActNumber7());
        copy.setAsstActName7(source.getAsstActName7());
        copy.setAsstActType8(source.getAsstActType8());
        copy.setAsstActNumber8(source.getAsstActNumber8());
        copy.setAsstActName8(source.getAsstActName8());
        copy.setItemFlag(source.getItemFlag());
        copy.setOppAccountSeq(source.getOppAccountSeq());
        copy.setType(source.getType());
        copy.setPrimaryItem(source.getPrimaryItem());
        copy.setPrimaryCoef(source.getPrimaryCoef());
        copy.setSupplyItem(source.getSupplyItem());
        copy.setSupplyCoef(source.getSupplyCoef());
        copy.setCashflowAmountOriginal(source.getCashflowAmountOriginal());
        copy.setCashflowAmountLocal(source.getCashflowAmountLocal());
        copy.setCashflowAmountRpt(source.getCashflowAmountRpt());
        copy.setCashAsstActType1(source.getCashAsstActType1());
        copy.setCashAsstActNumber1(source.getCashAsstActNumber1());
        copy.setCashAsstActName1(source.getCashAsstActName1());
        copy.setCashAsstActType2(source.getCashAsstActType2());
        copy.setCashAsstActNumber2(source.getCashAsstActNumber2());
        copy.setCashAsstActName2(source.getCashAsstActName2());
        copy.setCashAsstActType3(source.getCashAsstActType3());
        copy.setCashAsstActNumber3(source.getCashAsstActNumber3());
        copy.setCashAsstActName3(source.getCashAsstActName3());
        copy.setCashAsstActType4(source.getCashAsstActType4());
        copy.setCashAsstActNumber4(source.getCashAsstActNumber4());
        copy.setCashAsstActName4(source.getCashAsstActName4());
        copy.setCashAsstActType5(source.getCashAsstActType5());
        copy.setCashAsstActNumber5(source.getCashAsstActNumber5());
        copy.setCashAsstActName5(source.getCashAsstActName5());
        copy.setCashAsstActType6(source.getCashAsstActType6());
        copy.setCashAsstActNumber6(source.getCashAsstActNumber6());
        copy.setCashAsstActName6(source.getCashAsstActName6());
        copy.setCashAsstActType7(source.getCashAsstActType7());
        copy.setCashAsstActNumber7(source.getCashAsstActNumber7());
        copy.setCashAsstActName7(source.getCashAsstActName7());
        copy.setCashAsstActType8(source.getCashAsstActType8());
        copy.setCashAsstActNumber8(source.getCashAsstActNumber8());
        copy.setCashAsstActName8(source.getCashAsstActName8());
        return copy;
    }

    private void doImportVouchers(WSVoucherCollection wswsvouchers, int tCount) throws Exception {
        if (this.importUI.isStop()) {
            return;
        }
        this.info("\u3000\u3000\u3000\u3000>>" + this.getString("DataProcess") + "...");
        boolean submit = "submit".equals(this.config.get("action"));
        boolean verify = "true".equals(this.config.get("verify"));
        boolean cashflow = "true".equals(this.config.get("isExpCashflow"));
        this.info("\u3000\u3000\u3000\u3000" + MessageFormat.format(this.getString("SubmitData_Rows"), wswsvouchers.size()) + "...");
        int verifyAndSave = submit ? (verify ? 3 : 2) : (verify ? 1 : 0);
        long start = System.currentTimeMillis();
        String[][] results = WSVoucherFactory.getRemoteInstance().importVoucherOfReturnID(wswsvouchers, verifyAndSave, cashflow ? 1 : 0);
        long used = System.currentTimeMillis() - start;
        int sCount = 0;
        if (results != null) {
            Object showDetail = this.config.get("showDetail");
            for (String[] result : results) {
                boolean isSucess;
                boolean bl = isSucess = result.length >= 5 && "0000".equals(result[4]);
                if (isSucess) {
                    ++sCount;
                }
                if (!"2".equals(showDetail) && (!"1".equals(showDetail) || isSucess)) continue;
                String info = "\u3000\u3000\u3000\u3000\u3000\u3000";
                if (isSucess) {
                    info = info + this.getString("Old_VoucherNumber") + result[0];
                    info = info + ", " + this.getString("Period") + result[2] + (result[3].length() == 1 ? "0" + result[3] : result[3]);
                    info = info + ", " + this.getString("VoucherType") + result[1];
                    info = info + ", " + this.getString("New_VoucherNumber") + result[6];
                    if (result.length >= 8) {
                        info = info + ", ID " + result[7];
                    }
                    this.info(info);
                    continue;
                }
                info = info + this.getString("Old_VoucherNumber") + result[0];
                info = info + ", " + this.getString("Error") + " " + result[4] + ", " + result[5];
                this.error(info);
            }
        }
        this.totalCount += tCount;
        this.sucCount += sCount;
        this.info("\u3000\u3000\u3000\u3000" + this.getString("Import_VoucherCount") + tCount + "\uff0c" + this.getString("Success_VoucherCount") + sCount);
        StringBuffer info = new StringBuffer();
        info.append("\u3000\u3000\u3000\u3000" + this.getString("This_UseTime") + used + "ms");
        this.info(info.toString());
    }

    @Override
    public void info(String msg) {
        this.importUI.info(msg);
    }

    @Override
    public void warn(String msg) {
        this.importUI.warn(msg);
    }

    @Override
    public void error(String msg) {
        this.importUI.error(msg);
    }

    @Override
    public void error(Throwable t) {
        this.importUI.error(t);
    }
}

