/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.client.AbstractVoucherPrintParamSelAcctUI;
import com.kingdee.eas.fi.gl.common.KDSpinnerCellEditor;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class VoucherPrintParamSelAcctUI
extends AbstractVoucherPrintParamSelAcctUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherPrintParamSelAcctUI.class);
    private String strAccountSelectedList;
    private boolean hasConfirm = false;
    private CompanyOrgUnitInfo vchCompany;
    public static final Color LOCKCOLOR = new Color(228, 228, 228);

    public VoucherPrintParamSelAcctUI() throws Exception {
        this.btnAddLine.setText(null);
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setText(null);
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLine.setText(null);
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddLine.setEnabled(true);
        this.btnInsertLine.setEnabled(true);
        this.btnRemoveLine.setEnabled(true);
        this.kDTable1.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == ((KDTable)e.getSource()).getColumnIndex("accountview")) {
                    VoucherPrintParamSelAcctUI.this.kDTable1.getCell(e.getRowIndex(), "accountview").setValue(e.getValue());
                    AccountViewInfo account = (AccountViewInfo)e.getValue();
                    AccountViewInfo oldAccount = (AccountViewInfo)e.getOldValue();
                    final IRow row = VoucherPrintParamSelAcctUI.this.kDTable1.getRow(e.getRowIndex());
                    if (account != null) {
                        if (oldAccount != null && account.equals((Object)oldAccount)) {
                            return;
                        }
                        int maxLevel = account.getLevel();
                        final SpinnerNumberModel sm = new SpinnerNumberModel(1, 1, maxLevel, 1);
                        sm.addChangeListener(new ChangeListener(){

                            @Override
                            public void stateChanged(ChangeEvent e) {
                                row.getCell("controllevel").setValue(sm.getValue());
                            }
                        });
                        KDSpinnerCellEditor sce = new KDSpinnerCellEditor(sm);
                        sce.setEditable(true);
                        row.getCell("controllevel").setValue((Object)new Integer(1));
                        row.getCell("controllevel").setEditor((ICellEditor)sce);
                        row.getCell("controllevel").getStyleAttributes().setLocked(false);
                        row.getCell("controllevel").getStyleAttributes().setBackground(Color.WHITE);
                    } else {
                        VoucherPrintParamSelAcctUI.this.lockLevle(row);
                    }
                }
            }

            public void editValueChanged(KDTEditEvent e) {
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("COMPANY") != null) {
            this.vchCompany = (CompanyOrgUnitInfo)this.getUIContext().get("COMPANY");
        }
        this.kDTable1.checkParsed();
        this.setTabelData();
    }

    private CompanyOrgUnitInfo getVchCompany() {
        if (this.vchCompany == null) {
            return SysContext.getSysContext().getCurrentFIUnit();
        }
        return this.vchCompany;
    }

    private void lockLevle(IRow row) {
        row.getCell("controllevel").setValue(null);
        StyleAttributes sa = row.getCell("controllevel").getStyleAttributes();
        sa.setLocked(true);
        sa.setBackground(LOCKCOLOR);
        sa.setPattern(Pattern.Solid);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.kDTable1.addRow();
        CompanyOrgUnitInfo company = this.getVchCompany();
        AccountTableInfo accountTable = company.getAccountTable();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, company, filter);
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setSelector((KDPromptSelector)apb);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        bizPromptBox.setEntityViewInfo(evi);
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$helpCode$;$number$;$name$");
        bizPromptBox.setDisplayFormat("$number$ $name$");
        bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        bizPromptBox.setEnabledMultiSelection(false);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
        row.getCell("accountview").setEditor((ICellEditor)editor);
        this.lockLevle(row);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager sm = this.kDTable1.getSelectManager();
        int indexrow = sm.getActiveRowIndex();
        if (indexrow == -1) {
            return;
        }
        IRow row = this.kDTable1.addRow(indexrow);
        CompanyOrgUnitInfo company = this.getVchCompany();
        AccountTableInfo accountTable = company.getAccountTable();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, company, filter);
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setSelector((KDPromptSelector)apb);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        bizPromptBox.setEntityViewInfo(evi);
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$helpCode$;$number$;$name$");
        bizPromptBox.setDisplayFormat("$number$ $name$");
        bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        bizPromptBox.setEnabledMultiSelection(false);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
        row.getCell("accountview").setEditor((ICellEditor)editor);
        this.lockLevle(row);
        sm.removeAll(false);
        sm.select(row.getRowIndex(), -1);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager sm = this.kDTable1.getSelectManager();
        int indexrow = sm.getActiveRowIndex();
        int rowCount = this.kDTable1.getRowCount();
        this.kDTable1.removeRow(indexrow);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        StringBuffer str = new StringBuffer();
        int rows = this.kDTable1.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IRow row = this.kDTable1.getRow(i);
            if (row == null) continue;
            AccountViewInfo account = (AccountViewInfo)row.getCell("accountview").getValue();
            Integer level = (Integer)row.getCell("controllevel").getValue();
            if (account == null || level == null) continue;
            str.append(account.getNumber()).append(" ").append(account.getId()).append("|").append(level).append(",");
        }
        if (str.length() > 0) {
            str.deleteCharAt(str.length() - 1);
            this.strAccountSelectedList = str.toString();
        } else {
            this.strAccountSelectedList = "";
        }
        this.hasConfirm = true;
        this.actionExitCurrent_actionPerformed(e);
    }

    public String getStrAccountSelectedList() {
        return this.strAccountSelectedList;
    }

    public boolean isHasConfirm() {
        return this.hasConfirm;
    }

    public void setTabelData() {
        Map uic = this.getUIContext();
        this.strAccountSelectedList = (String)uic.get("strAccountSelectedList");
        if (this.strAccountSelectedList == null || "".equals(this.strAccountSelectedList.trim())) {
            try {
                this.actionAddLine_actionPerformed(null);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            return;
        }
        IAccountView accountView = null;
        String[] accountLevels = this.strAccountSelectedList.split("\\,");
        for (int i = 0; i < accountLevels.length; ++i) {
            String[] accountLeve = accountLevels[i].split("\\|");
            String[] accounts = accountLeve[0].split("\\ ");
            String accountId = accounts[1];
            int level = Integer.parseInt(accountLeve[1]);
            AccountViewInfo accInfo = null;
            try {
                accountView = AccountViewFactory.getRemoteInstance();
                BOSUuid accID = BOSUuid.read((String)accountId);
                ObjectUuidPK objectUUidPK = new ObjectUuidPK(accID);
                accInfo = accountView.getAccountViewInfo((IObjectPK)objectUUidPK);
            }
            catch (BOSException e1) {
                logger.error((Object)e1);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            if (accInfo == null) continue;
            final IRow row = this.kDTable1.addRow();
            CompanyOrgUnitInfo company = this.getVchCompany();
            AccountTableInfo accountTable = company.getAccountTable();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
            fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTable.getId().toString()));
            AccountPromptBox apb = new AccountPromptBox((IUIObject)this, company, filter);
            KDBizPromptBox bizPromptBox = new KDBizPromptBox();
            bizPromptBox.setSelector((KDPromptSelector)apb);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            bizPromptBox.setEntityViewInfo(evi);
            bizPromptBox.setEditable(true);
            bizPromptBox.setEditFormat("$number$");
            bizPromptBox.setCommitFormat("$helpCode$;$number$;$name$");
            bizPromptBox.setDisplayFormat("$number$ $name$");
            bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
            bizPromptBox.setEnabledMultiSelection(false);
            KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
            row.getCell("accountview").setEditor((ICellEditor)editor);
            row.getCell("accountview").setValue((Object)accInfo);
            int maxLevel = accInfo.getLevel();
            final SpinnerNumberModel sm = new SpinnerNumberModel(level, 1, maxLevel, 1);
            sm.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    row.getCell("controllevel").setValue(sm.getValue());
                }
            });
            KDSpinnerCellEditor sce = new KDSpinnerCellEditor(sm);
            sce.setEditable(true);
            row.getCell("controllevel").setValue((Object)new Integer(level));
            row.getCell("controllevel").setEditor((ICellEditor)sce);
            row.getCell("controllevel").getStyleAttributes().setLocked(false);
            row.getCell("controllevel").getStyleAttributes().setBackground(Color.WHITE);
        }
    }
}

