/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.util.CashflowF7Util;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.CashFlowDirectFactory;
import com.kingdee.eas.fi.gl.CashFlowDirectUtil;
import com.kingdee.eas.fi.gl.CashFlowUtils;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ICashFlowDirect;
import com.kingdee.eas.fi.gl.TAccountCashflowInfo;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.AbstractVoucherSetCashflowUI;
import com.kingdee.eas.fi.gl.client.CashVoucherFilterUI;
import com.kingdee.eas.fi.gl.client.VoucherEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class VoucherSetCashflowUI
extends AbstractVoucherSetCashflowUI {
    private static final long serialVersionUID = 1536903258253721339L;
    private static final Logger logger = CoreUIObject.getLogger(VoucherSetCashflowUI.class);
    IUIWindow uiWindow = null;
    private boolean isDirty = false;
    private List copyCFCol = null;
    private Map origCFCol = null;
    private CashFlowItemInfo assignedCFItem = null;
    private boolean isSimpleMode = false;
    protected HashMap hmDynamicColumnInfo = new HashMap();
    protected HashMap hmDynamicPromptBox = new HashMap();
    protected HashMap hmDynamicDatabaseInfo = new HashMap();
    private Map saveResult = new HashMap();
    protected CompanyOrgUnitInfo company;

    @Override
    public void storeFields() {
    }

    public boolean checkBeforeWindowClosing() {
        if (this.isDirty) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (0 == result) {
                try {
                    this.actionSave_actionPerformed(null);
                    return false;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            } else if (2 == result) {
                return false;
            }
        }
        return super.checkBeforeWindowClosing();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        KDTEditManager emAsst;
        KDTEditManager emMain = this.tblMain.getEditManager();
        if (emMain.isEditing()) {
            emMain.stopEditing();
        }
        if ((emAsst = this.tblAssist.getEditManager()).isEditing()) {
            emAsst.stopEditing();
        }
        int rowCount = this.tblMain.getRowCount();
        int rowIndex = -1;
        ArrayList<TAccountCashflowInfo> modifyCFCol = new ArrayList<TAccountCashflowInfo>();
        IRow row = null;
        String hintMsg = null;
        GlParam glParam = GlParam.getGlParams(null, (String)"GL_102", (String)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        int isCfAssistRequired = glParam.getInt("GL_102");
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getStyleAttributes().isHided()) continue;
            TAccountCashflowInfo cashflow = (TAccountCashflowInfo)row.getUserObject();
            CashFlowItemInfo pi = (CashFlowItemInfo)row.getCell("primItem").getValue();
            if (pi == null) {
                rowIndex = i;
                hintMsg = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"missingPI");
                break;
            }
            if (pi.isIsEnable() && pi.getAsstAccount() != null) {
                AssistantHGInfo hg = (AssistantHGInfo)row.getCell("assGrp").getValue();
                if (CashflowTypeEnum.OUT.equals(row.getCell("type").getValue()) && isCfAssistRequired != 0) {
                    modifyCFCol.add(cashflow);
                    continue;
                }
                if (hg == null && (isCfAssistRequired == 0 || CashflowTypeEnum.IN.equals(row.getCell("type").getValue()) && isCfAssistRequired == 1)) {
                    rowIndex = i;
                    hintMsg = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"missingASSGRP");
                    break;
                }
                if (hg != null) {
                    Object[] info = CashFlowDirectUtil.getCachedColumnInfo(this.hmDynamicColumnInfo, pi.getAsstAccount().getId().toString());
                    int inAttrCount = 0;
                    VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])info[0];
                    for (int j = 0; j < assItemCols.length; ++j) {
                        String key = assItemCols[j].getMappingPropName();
                        if (hg.get(key) == null) {
                            if (isCfAssistRequired != 0 && (!CashflowTypeEnum.IN.equals(row.getCell("type").getValue()) || isCfAssistRequired != 1)) continue;
                            rowIndex = i;
                            hintMsg = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"missingASSGRP");
                            break;
                        }
                        if ("companyOrg".equalsIgnoreCase(key)) {
                            ++inAttrCount;
                            continue;
                        }
                        if (!"customer".equalsIgnoreCase(key) && !"provider".equalsIgnoreCase(key)) continue;
                        Object o = hg.get(key);
                        if (o instanceof CustomerInfo && (((CustomerInfo)o).isIsInternalCompany() || ((CustomerInfo)o).getInternalCompany() != null)) {
                            ++inAttrCount;
                        }
                        if (!(o instanceof SupplierInfo) || !((SupplierInfo)o).isIsInternalCompany() && ((SupplierInfo)o).getInternalCompany() == null) continue;
                        ++inAttrCount;
                    }
                    if (inAttrCount == 0 && CashflowTypeEnum.IN.equals(row.getCell("type").getValue()) && isCfAssistRequired == 2) {
                        rowIndex = i;
                        hintMsg = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.CashflowEditResource", (String)"missingASSGRP");
                        break;
                    }
                }
            }
            modifyCFCol.add(cashflow);
        }
        if (rowIndex > -1) {
            MsgBox.showWarning((Component)((Object)this), hintMsg);
            KDTSelectManager sm = this.tblMain.getSelectManager();
            sm.removeAll(false);
            sm.select(rowIndex, 1);
            this.tblMain.scrollToVisible(rowIndex, -1);
            return;
        }
        Map ctx = this.getUIContext();
        HashMap saveParam = new HashMap();
        saveParam.putAll((Map)ctx.get("saveParam"));
        HashMap<String, TAccountCashflowInfo> saveCashflowRecords = new HashMap<String, TAccountCashflowInfo>();
        Iterator it = modifyCFCol.iterator();
        TAccountCashflowInfo newInfo = null;
        TAccountCashflowInfo origInfo = null;
        while (it.hasNext()) {
            newInfo = (TAccountCashflowInfo)it.next();
            origInfo = (TAccountCashflowInfo)this.origCFCol.get(newInfo.getId());
            origInfo.setCashflowItemId(newInfo.getCashflowItemId());
            origInfo.setCashflowItemLongNumber(newInfo.getCashflowItemLongNumber());
            origInfo.setCashflowItemName(newInfo.getCashflowItemName());
            origInfo.setCashflowItemNumber(newInfo.getCashflowItemNumber());
            origInfo.setDirection(newInfo.getDirection());
            origInfo.setCfiAssistId(newInfo.getCfiAssistId());
            origInfo.setCfiAssistDisplayNameGroup(newInfo.getCfiAssistDisplayNameGroup());
            origInfo.setCfType(newInfo.getCfType());
            saveCashflowRecords.put(origInfo.getId(), origInfo);
        }
        saveParam.put("CashflowRecords", saveCashflowRecords);
        CashFlowDirectUtil.handleBeforeSave(saveCashflowRecords);
        boolean isAssignCashFlowItem = "assignCashFlowItem".equals(saveParam.get("action"));
        try {
            Map result = VoucherSetCashflowUI.getBizInterface().saveCashflowItem(saveParam);
            this.saveResult.putAll((Map)result.get("result"));
            this.isDirty = false;
            String msgHeader = this.getResource("save_cashflowitem_success");
            Integer sendSuccCount = (Integer)result.get("sendSuccCount");
            StringBuilder detail = new StringBuilder(this.getResource("send_cfreq_success_count"));
            if (isAssignCashFlowItem) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)msgHeader, (String)MessageFormat.format(detail.toString(), sendSuccCount), (int)1);
            } else {
                int coverFailureCount;
                String coverFailureDetail = result.get("coverFailureDetail") == null ? "" : (String)result.get("coverFailureDetail");
                int n = coverFailureCount = result.get("coverFailureCount") == null ? 0 : (Integer)result.get("coverFailureCount");
                if (coverFailureCount > 0) {
                    detail.append(this.getResource("uncovered_cashflow_count")).append("\r\n").append(coverFailureDetail);
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)msgHeader, (String)MessageFormat.format(detail.toString(), sendSuccCount, coverFailureCount), (int)1);
            }
        }
        catch (BOSException exception) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowIndirectUI.CASHFLOW_ASSIGN_FAILED"), (String)exception.getCause().getMessage(), (int)2);
            SysUtil.abort();
        }
    }

    protected void fetchInitData() throws Exception {
        Map ctx = this.getUIContext();
        Map param = (Map)ctx.get("saveParam");
        this.origCFCol = (Map)param.get("CashflowRecords");
        this.copyCFCol = new ArrayList();
        Iterator it = this.origCFCol.values().iterator();
        TAccountCashflowInfo info = null;
        while (it.hasNext()) {
            info = (TAccountCashflowInfo)it.next();
            this.copyCFCol.add(info.clone());
        }
        this.assignedCFItem = (CashFlowItemInfo)param.get("CashFlowItemInfo");
        Object objIsSimpleMode = GlUtils.getParamByKey(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString(), "GL_0152");
        this.isSimpleMode = "0".equals(String.valueOf(objIsSimpleMode));
    }

    protected void initTableStyle() throws EASBizException, BOSException {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(1);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.setDefaultRowHeight(30);
        IColumn oppPiCol = this.tblMain.getColumn("primItem");
        IColumn oppAssGrpCol = this.tblMain.getColumn("assGrp");
        IColumn oppAmntCol = this.tblMain.getColumn("amount");
        IColumn oppTypeCol = this.tblMain.getColumn("type");
        oppAmntCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        Map ctx = this.getUIContext();
        Map param = (Map)ctx.get("saveParam");
        String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        this.company = GlUtils.getCompanyById(null, companyID);
        int pre = 2;
        if (param.get("currencyInfo") != null) {
            CurrencyInfo cy = (CurrencyInfo)param.get("currencyInfo");
            pre = "22222222-2222-2222-2222-222222222222DEB58FDC".equals(cy.getId().toString()) ? this.company.getReportCurrency().getPrecision() : ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(cy.getId().toString()) ? this.company.getBaseCurrency().getPrecision() : cy.getPrecision());
        }
        oppAmntCol.getStyleAttributes().setNumberFormat(GlUtils.getDecimalFormat(pre));
        KDBizPromptBox bizPiPromptBox = new KDBizPromptBox();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("type", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isProfit", (Object)new Integer(0)));
        CashflowF7Util.assignCashflowF7((KDBizPromptBox)bizPiPromptBox, (FilterInfo)filter, (CoreUIObject)this);
        oppPiCol.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPiPromptBox));
        FilterInfo filter4Tree = new FilterInfo();
        FilterItemCollection fic4tree = filter4Tree.getFilterItems();
        fic4tree.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        if (filter != null) {
            try {
                filter4Tree.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        this.getUIContext().put("filter4Tree", filter4Tree);
        ObjectValueRender normalObjectRender = new ObjectValueRender();
        normalObjectRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
        oppPiCol.setRenderer((IBasicRender)normalObjectRender);
        oppAssGrpCol.getStyleAttributes().setHided(false);
        oppAssGrpCol.setWidth(120);
        KDComboBox box = new KDComboBox(CashflowTypeEnum.getEnumList().toArray());
        box.putClientProperty((Object)"jump", (Object)"false");
        box.removeItem((Object)CashflowTypeEnum.NONE);
        box.setSelectedItem((Object)CashflowTypeEnum.OUT);
        KDTDefaultCellEditor typeCombo = new KDTDefaultCellEditor((JComboBox)box);
        oppTypeCol.setEditor((ICellEditor)typeCombo);
    }

    public void onLoad() throws Exception {
        this.tblAssist.setEditable(true);
        this.fetchInitData();
        this.initTableStyle();
        this.tblMain.getColumn("assGrp").setWidth(-1);
        this.tblMain.getColumn("assGrp").getStyleAttributes().setHided(true);
        super.onLoad();
        this.loadFields();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setEnabled(true);
    }

    public void initListener() {
        super.initListener();
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent evt) {
                VoucherSetCashflowUI.this.actionTblMainEditStop(evt);
            }
        });
        this.tblAssist.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){
            IRow selectedRow = null;

            public void editStarting(KDTEditEvent evt) {
                int rowIndex = VoucherSetCashflowUI.this.tblMain.getSelectManager().get() == null ? 0 : VoucherSetCashflowUI.this.tblMain.getSelectManager().get().getTop();
                this.selectedRow = VoucherSetCashflowUI.this.tblMain.getRow(rowIndex);
            }

            public void editStopped(KDTEditEvent evt) {
                VoucherSetCashflowUI.this.actionTblAssistEditStop(evt, this.selectedRow);
            }
        });
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    VoucherSetCashflowUI.this.tblMain_tableClicked(e);
                }
                catch (Exception exc) {
                    VoucherSetCashflowUI.this.handUIException(exc);
                }
            }
        });
        this.tblMain.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                VoucherSetCashflowUI.this.afterActiveCellChanged(VoucherSetCashflowUI.this.tblMain, e);
            }
        });
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int index;
        IRow row;
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2 && (row = this.tblMain.getRow(index = this.tblMain.getSelectManager().get().getTop())) != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)((String)row.getCell("id").getValue()));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)VoucherEditUI.getEditUIMode((CoreUIObject)this)).create(VoucherInfo.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    private void afterActiveCellChanged(KDTable tbl, KDTActiveCellEvent e) {
        if (e.getRowIndex() != e.getPrevRowIndex()) {
            IRow selectedRow;
            KDTEditManager em = this.tblAssist.getEditManager();
            if (em.isEditing()) {
                em.stopEditing();
            }
            if ((selectedRow = tbl.getRow(e.getRowIndex())) == null) {
                this.splitPane.remove((Component)this.ctnAssist);
                this.splitPane.setDividerLocation(1.0);
                this.splitPane.validate();
                return;
            }
            VoucherInfo.DynamicColumnInfo[] cfiItemCols = null;
            CashFlowItemInfo newitem = (CashFlowItemInfo)selectedRow.getCell("primItem").getValue();
            if (newitem != null && newitem.isIsEnable() && newitem.getAsstAccount() != null) {
                Object[] cfiInfo = CashFlowDirectUtil.getCachedColumnInfo(this.hmDynamicColumnInfo, newitem.getAsstAccount());
                cfiItemCols = (VoucherInfo.DynamicColumnInfo[])cfiInfo[0];
            }
            this.loadCashFlowRecord(selectedRow, cfiItemCols);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void loadFields() {
        IRow row = null;
        for (int i = 0; i < this.copyCFCol.size(); ++i) {
            TAccountCashflowInfo recordInfo = (TAccountCashflowInfo)this.copyCFCol.get(i);
            row = this.tblMain.addRow();
            row.setUserObject((Object)recordInfo);
            row.getCell("assGrp").setValue(null);
            recordInfo.setCfiAssistId(null);
            recordInfo.setCfiAssistDisplayNameGroup(null);
            row.getCell("id").setValue((Object)recordInfo.getVoucherId());
            row.getCell("bookedDate").setValue((Object)recordInfo.getVoucherBookedDate());
            row.getCell("period").setValue((Object)(recordInfo.getVoucherPeriodYear() + "-" + recordInfo.getVoucherPeriodNumber()));
            row.getCell("number").setValue((Object)(recordInfo.getVoucherTypeName() + "-" + recordInfo.getVoucherNumber()));
            row.getCell("entry.id").setValue((Object)recordInfo.getEntryId());
            row.getCell("entry.dc").setValue((Object)(recordInfo.isEntryDebit() ? EntryDC.DEBIT : EntryDC.CREDIT));
            row.getCell("seq").setValue((Object)("" + recordInfo.getOpposingEntrySeq()));
            row.getCell("abstract").setValue((Object)recordInfo.getOpposingEntryDescription());
            row.getCell("entry.account").setValue((Object)(recordInfo.getEntryAccountNumber() + recordInfo.getEntryAccountLongName()));
            row.getCell("oppEntry.id").setValue((Object)recordInfo.getOpposingEntryId());
            row.getCell("oppEntry.dc").setValue((Object)(recordInfo.isOpposingEntryDebit() ? EntryDC.DEBIT : EntryDC.CREDIT));
            String opp = recordInfo.getOpposingEntryAccountNumber() + recordInfo.getOpposingEntryAccountLongName();
            if (recordInfo.getAccountAssistLongNameGroup() != null) {
                opp = opp + " (" + recordInfo.getAccountAssistLongNameGroup() + ")";
            }
            row.getCell("oppEntry.account").setValue((Object)opp);
            row.getCell("amount").setValue((Object)recordInfo.getOriginalAmount());
            if (this.assignedCFItem != null) {
                row.getCell("primItem").setValue((Object)this.assignedCFItem);
                this.storeCf(row, i, false, this.assignedCFItem);
            } else {
                this.splitPane.remove((Component)this.ctnAssist);
                this.splitPane.setDividerLocation(1.0);
                this.splitPane.validate();
            }
            row.getCell("type").setValue((Object)recordInfo.getCfType());
        }
    }

    protected static ICashFlowDirect getBizInterface() throws BOSException {
        return CashFlowDirectFactory.getRemoteInstance();
    }

    private void actionTblMainEditStop(KDTEditEvent evt) {
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getValue();
        IRow curRow = this.tblMain.getRow(evt.getRowIndex());
        if (!GlUtils.isEqual(newValue, oldValue)) {
            KDTable table = (KDTable)evt.getSource();
            int row = evt.getRowIndex();
            int col = evt.getColIndex();
            String colKey = table.getColumnKey(col);
            if ("primItem".equals(colKey)) {
                CashFlowItemInfo newitem = (CashFlowItemInfo)newValue;
                if (newValue != null) {
                    int result = 0;
                    if (this.tblMain.getRowCount() > 1) {
                        result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"209_VoucherSetCashflowUI"));
                    }
                    if (0 == result) {
                        this.storeCf(curRow, row, true, newitem);
                    } else {
                        this.storeCf(curRow, row, false, newitem);
                    }
                } else {
                    this.splitPane.remove((Component)this.ctnAssist);
                    this.splitPane.setDividerLocation(1.0);
                    this.splitPane.validate();
                    curRow.getCell("assGrp").setValue(null);
                }
            } else if ("type".equals(colKey)) {
                TAccountCashflowInfo info = (TAccountCashflowInfo)curRow.getUserObject();
                info.setCfType((CashflowTypeEnum)newValue);
            }
            this.isDirty = true;
        }
    }

    private void actionTblAssistEditStop(KDTEditEvent evt, IRow selectedRow) {
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getValue();
        TAccountCashflowInfo info = (TAccountCashflowInfo)selectedRow.getUserObject();
        CashFlowItemInfo item = (CashFlowItemInfo)selectedRow.getCell("primItem").getValue();
        IRow asstRow = this.tblAssist.getRow(evt.getRowIndex());
        if (!GlUtils.isEqual(newValue, oldValue) && item != null) {
            try {
                AssistantHGInfo group = CashFlowDirectUtil.confirmAssGrp(item.getAsstAccount(), asstRow, this.hmDynamicColumnInfo);
                selectedRow.getCell("assGrp").setValue((Object)group);
                if (group != null) {
                    info.setCfiAssistId(group.getId().toString());
                    info.setCfiAssistDisplayNameGroup(group.getDisplayNameGroup());
                    Object[] cainfo = CashFlowDirectUtil.getCachedColumnInfo(this.hmDynamicColumnInfo, item.getAsstAccount());
                    VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])cainfo[0];
                    CashflowTypeEnum type = CashflowTypeEnum.OUT;
                    for (int i = 0; i < assItemCols.length; ++i) {
                        VoucherInfo.DynamicColumnInfo colInfo = assItemCols[i];
                        if ("companyOrg".equals(colInfo.getMappingPropName())) {
                            if (group.get(colInfo.getMappingPropName()) == null) continue;
                            type = CashflowTypeEnum.IN;
                            continue;
                        }
                        if ("customer".equals(colInfo.getMappingPropName())) {
                            if (newValue instanceof CustomerInfo) {
                                CustomerInfo customer = (CustomerInfo)newValue;
                                if (customer.getInternalCompany() == null) continue;
                                type = CashflowTypeEnum.IN;
                                continue;
                            }
                            CustomerInfo customerInfo = (CustomerInfo)group.get(colInfo.getMappingPropName());
                            if (customerInfo == null || customerInfo.getInternalCompany() == null && !customerInfo.isIsInternalCompany()) continue;
                            type = CashflowTypeEnum.IN;
                            continue;
                        }
                        if (!"provider".equals(colInfo.getMappingPropName())) continue;
                        if (newValue instanceof SupplierInfo) {
                            SupplierInfo supplier = (SupplierInfo)newValue;
                            if (supplier.getInternalCompany() == null) continue;
                            type = CashflowTypeEnum.IN;
                            continue;
                        }
                        SupplierInfo supplierInfo = (SupplierInfo)group.get(colInfo.getMappingPropName());
                        if (supplierInfo == null || supplierInfo.getInternalCompany() == null && !supplierInfo.isIsInternalCompany()) continue;
                        type = CashflowTypeEnum.IN;
                    }
                    info.setCfType(type);
                } else {
                    info.setCfiAssistId(null);
                    info.setCfiAssistDisplayNameGroup(null);
                    info.setCfType(CashflowTypeEnum.OUT);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        selectedRow.getCell("type").setValue((Object)info.getCfType());
    }

    protected void storeCf(IRow curRow, int rowIndex, boolean all, CashFlowItemInfo newitem) {
        IRow row;
        VoucherInfo.DynamicColumnInfo[] cfiItemCols = null;
        if (newitem.isIsEnable() && newitem.getAsstAccount() != null) {
            Object[] cfiInfo = CashFlowDirectUtil.getCachedColumnInfo(this.hmDynamicColumnInfo, newitem.getAsstAccount());
            cfiItemCols = (VoucherInfo.DynamicColumnInfo[])cfiInfo[0];
        }
        if (!all) {
            row = this.tblMain.getRow(rowIndex);
            this.handleRowData(row, newitem, cfiItemCols);
        } else {
            row = null;
            int rowCount = this.tblMain.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                row = this.tblMain.getRow(i);
                if (row.getStyleAttributes().isHided()) continue;
                this.handleRowData(row, newitem, cfiItemCols);
            }
        }
        this.loadCashFlowRecord(curRow, cfiItemCols);
    }

    private void handleRowData(IRow row, CashFlowItemInfo newitem, VoucherInfo.DynamicColumnInfo[] cfiItemCols) {
        Object[] asstInfo;
        boolean isEnable = newitem.isIsEnable();
        TAccountCashflowInfo info = (TAccountCashflowInfo)row.getUserObject();
        int pc = 1;
        CashFlowDirection direct = newitem.getDirection();
        if (info.isEntryDebit() && CashFlowDirection.OUT.equals((Object)direct) || !info.isEntryDebit() && CashFlowDirection.IN.equals((Object)direct)) {
            pc = -1;
        }
        info.setCashflowItemId(newitem.getId().toString());
        info.setCashflowItemLongNumber(newitem.getLongNumber());
        info.setCashflowItemName(newitem.getName());
        info.setCashflowItemNumber(newitem.getNumber());
        info.setDirection(newitem.getDirection());
        row.getCell("primItem").setValue((Object)newitem);
        BigDecimal coefficient = pc == 1 ? GlUtils.one : GlUtils.negone;
        row.getCell("amount").setValue((Object)info.getOriginalAmount().multiply(coefficient));
        row.getCell("assGrp").setValue(null);
        row.getCell("assGrp").setUserObject(null);
        if (isEnable && (asstInfo = CashFlowDirectUtil.getCachedColumnInfo(this.hmDynamicColumnInfo, info.getAccountAssistTypeId())) != null) {
            VoucherInfo.DynamicColumnInfo[] asstItemCols = (VoucherInfo.DynamicColumnInfo[])asstInfo[0];
            this.autoSetActTypeValue(row, info, info.getAccountAssistId(), asstItemCols, newitem.getAsstAccount(), cfiItemCols, this.isSimpleMode);
        }
        row.getCell("type").setValue((Object)info.getCfType());
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.uiWindow == null) {
            UIContext uiContext = new UIContext((Object)this);
            this.uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.client.CashVoucherFilterUI", (Map)uiContext, null, OprtState.EDIT);
        }
        this.uiWindow.show();
        CashVoucherFilterUI ui = (CashVoucherFilterUI)this.uiWindow.getUIObject();
        List filter = ui.getFilter();
        if (filter == null) {
            return;
        }
        int rowCount = this.tblMain.getRowCount();
        IRow row = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            StyleAttributes style = row.getStyleAttributes();
            TAccountCashflowInfo info = (TAccountCashflowInfo)row.getUserObject();
            style.setHided(false);
            for (int j = 0; j < filter.size(); ++j) {
                Object[] filterInfo = (Object[])filter.get(j);
                if (filterInfo[2] == null) continue;
                if (filterInfo[0].equals("voucherType")) {
                    if (filterInfo[1].equals("equal")) {
                        if (!info.getVoucherTypeName().equals(filterInfo[2])) {
                            style.setHided(true);
                            continue;
                        }
                    } else if (info.getVoucherTypeName().indexOf(filterInfo[2].toString()) < 0) {
                        style.setHided(true);
                        continue;
                    }
                }
                if (filterInfo[0].equals("voucherNumber")) {
                    if (filterInfo[1].equals("equal")) {
                        if (!info.getVoucherNumber().equals(filterInfo[2])) {
                            style.setHided(true);
                            continue;
                        }
                    } else if (info.getVoucherNumber().indexOf(filterInfo[2].toString()) < 0) {
                        style.setHided(true);
                        continue;
                    }
                }
                if (!filterInfo[0].equals("abstract")) continue;
                if (info.getOpposingEntryDescription() == null) {
                    style.setHided(true);
                    continue;
                }
                if (filterInfo[1].equals("equal")) {
                    if (info.getOpposingEntryDescription().equals(filterInfo[2])) continue;
                    style.setHided(true);
                    continue;
                }
                if (info.getOpposingEntryDescription().indexOf(filterInfo[2].toString()) >= 0) continue;
                style.setHided(true);
            }
        }
        IRow searchRow = null;
        int selectIdx = -1;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            searchRow = this.tblMain.getRow(i);
            if (searchRow == null || searchRow.getStyleAttributes() == null || searchRow.getStyleAttributes().isHided()) continue;
            selectIdx = i;
            break;
        }
        if (selectIdx == -1) {
            this.tblMain.getEditManager().editCellAt(-5, 0);
        } else {
            this.tblMain.getEditManager().editCellAt(selectIdx, 0);
        }
    }

    private void autoSetActTypeValue(IRow curRow, TAccountCashflowInfo info, String hgId, VoucherInfo.DynamicColumnInfo[] asstItemCols, AsstAccountInfo cfiTypeGroup, VoucherInfo.DynamicColumnInfo[] cfiItemCols, boolean isSimpleMode) {
        Object objCompany;
        CustomerInfo customerFromCompany;
        SupplierInfo supplierFromCompany;
        CustomerInfo customerFromBizAnalysisCode;
        SupplierInfo supplierFromBizAnalysisCode;
        boolean isCompanyToProvider;
        boolean isCompanyToCustomer;
        boolean isCompanyToCustomerAndProvider;
        boolean isProviderToCustomer;
        boolean isCustomerToProvider;
        boolean isExistsCfProvider;
        boolean isExistsCfCustomer;
        boolean isExistsOppCompany;
        boolean isExistsOppProvider;
        boolean isExistsOppCustomer;
        AssistantHGInfo assGrp;
        block90: {
            block89: {
                if (!isSimpleMode) {
                    return;
                }
                if (StringUtils.isEmpty((String)hgId) || cfiTypeGroup == null || StringUtils.isEmpty((String)cfiTypeGroup.getId().toString()) || asstItemCols == null || asstItemCols.length == 0 || cfiItemCols == null || cfiItemCols.length == 0) {
                    return;
                }
                assGrp = null;
                try {
                    assGrp = GlUtils.dynamicLoadAssistangHG(null, this.hmDynamicDatabaseInfo, hgId, asstItemCols);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                if (assGrp == null) {
                    return;
                }
                isExistsOppCustomer = false;
                isExistsOppProvider = false;
                isExistsOppCompany = false;
                isExistsCfCustomer = false;
                isExistsCfProvider = false;
                isCustomerToProvider = false;
                isProviderToCustomer = false;
                isCompanyToCustomerAndProvider = false;
                isCompanyToCustomer = false;
                isCompanyToProvider = false;
                supplierFromBizAnalysisCode = null;
                customerFromBizAnalysisCode = null;
                supplierFromCompany = null;
                customerFromCompany = null;
                for (VoucherInfo.DynamicColumnInfo oppCol : cfiItemCols) {
                    if ("customer".equals(oppCol.getMappingPropName())) {
                        isExistsCfCustomer = true;
                    }
                    if (!"provider".equals(oppCol.getMappingPropName())) continue;
                    isExistsCfProvider = true;
                }
                for (VoucherInfo.DynamicColumnInfo oppCol : asstItemCols) {
                    if ("customer".equals(oppCol.getMappingPropName())) {
                        isExistsOppCustomer = true;
                    }
                    if ("provider".equals(oppCol.getMappingPropName())) {
                        isExistsOppProvider = true;
                    }
                    if (!"companyOrg".equals(oppCol.getMappingPropName())) continue;
                    isExistsOppCompany = true;
                }
                if (isExistsOppCustomer && !isExistsOppProvider && isExistsCfProvider) {
                    isCustomerToProvider = true;
                    Object objCustomer = assGrp.get("customer");
                    if (objCustomer instanceof CustomerInfo) {
                        CustomerInfo customer = (CustomerInfo)objCustomer;
                        if (customer.getBizAnalysisCode() == null) {
                            isCustomerToProvider = false;
                        } else {
                            try {
                                EntityViewInfo view = CashFlowUtils.getBizAnalysisCodeView(customer.getBizAnalysisCode().getId().toString());
                                SupplierCollection supplies = SupplierFactory.getRemoteInstance().getSupplierCollection(view);
                                if (supplies.size() == 1) {
                                    supplierFromBizAnalysisCode = supplies.get(0);
                                    break block89;
                                }
                                isCustomerToProvider = false;
                            }
                            catch (BOSException e) {
                                logger.error((Object)"invoke CFAsstautoSetByBizAnalysisCode error", (Throwable)e);
                            }
                        }
                    } else {
                        isCustomerToProvider = false;
                    }
                }
            }
            if (!isExistsOppCustomer && isExistsOppProvider && isExistsCfCustomer) {
                isProviderToCustomer = true;
                Object objSupplier = assGrp.get("provider");
                if (objSupplier instanceof SupplierInfo) {
                    SupplierInfo supplier = (SupplierInfo)objSupplier;
                    if (supplier.getBizAnalysisCode() == null) {
                        isProviderToCustomer = false;
                    } else {
                        try {
                            EntityViewInfo view = CashFlowUtils.getBizAnalysisCodeView(supplier.getBizAnalysisCode().getId().toString());
                            CustomerCollection customers = CustomerFactory.getRemoteInstance().getCustomerCollection(view);
                            if (customers.size() == 1) {
                                customerFromBizAnalysisCode = customers.get(0);
                                break block90;
                            }
                            isProviderToCustomer = false;
                        }
                        catch (BOSException e) {
                            logger.error((Object)"invoke CFAsstautoSetByBizAnalysisCode error", (Throwable)e);
                        }
                    }
                } else {
                    isProviderToCustomer = false;
                }
            }
        }
        if (isExistsOppCompany && (objCompany = assGrp.get("companyOrg")) instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)objCompany;
            String internalCompanyId = companyOrgUnitInfo.getId().toString();
            try {
                Map<String, Object> customerMap;
                if (!isExistsOppProvider && !isExistsOppCustomer && (isExistsCfProvider || isExistsCfCustomer)) {
                    Map<String, Object> supplierMap;
                    Map<String, Object> customerMap2;
                    boolean isCustomerNotNull = false;
                    boolean isSupplierNotNull = false;
                    if (isExistsCfCustomer && (customerMap2 = CashFlowUtils.getCustomerInfo(null, internalCompanyId, this.company, null)).size() == 1) {
                        customerFromCompany = (CustomerInfo)customerMap2.values().toArray()[0];
                        isCustomerNotNull = true;
                    }
                    if (isExistsCfProvider && (supplierMap = CashFlowUtils.getSuppliersInfo(null, internalCompanyId, this.company, null)).size() == 1) {
                        supplierFromCompany = (SupplierInfo)supplierMap.values().toArray()[0];
                        isSupplierNotNull = true;
                    }
                    isCompanyToCustomerAndProvider = isSupplierNotNull || isCustomerNotNull;
                } else if (isExistsOppCustomer && !isExistsOppProvider && isExistsCfProvider) {
                    Map<String, Object> supplierMap = CashFlowUtils.getSuppliersInfo(null, internalCompanyId, this.company, null);
                    if (supplierMap.size() == 1) {
                        supplierFromCompany = (SupplierInfo)supplierMap.values().toArray()[0];
                        isCompanyToProvider = true;
                    }
                } else if (isExistsOppProvider && !isExistsOppCustomer && isExistsCfCustomer && (customerMap = CashFlowUtils.getCustomerInfo(null, internalCompanyId, this.company, null)).size() == 1) {
                    customerFromCompany = (CustomerInfo)customerMap.values().toArray()[0];
                    isCompanyToCustomer = true;
                }
            }
            catch (Exception e) {
                logger.error((Object)"invoke findCustomerAndSupplier error", (Throwable)e);
            }
        }
        CashflowTypeEnum cfType = CashflowTypeEnum.OUT;
        AssistantHGInfo group = new AssistantHGInfo();
        boolean isAllNull = true;
        group.setAsstAccount(cfiTypeGroup);
        for (int i = 0; i < cfiItemCols.length; ++i) {
            String key = cfiItemCols[i].getMappingPropName();
            Object value = assGrp.get(key);
            if ("companyOrg".equals(key)) {
                SupplierInfo supplier;
                CustomerInfo customer;
                if (value == null && (customer = (CustomerInfo)assGrp.get("customer")) != null && customer.getInternalCompany() != null) {
                    value = customer.getInternalCompany();
                }
                if (value == null && (supplier = (SupplierInfo)assGrp.get("provider")) != null && supplier.getInternalCompany() != null) {
                    value = supplier.getInternalCompany();
                }
                if (value != null) {
                    info.setCfType(CashflowTypeEnum.IN);
                    cfType = CashflowTypeEnum.IN;
                } else {
                    info.setCfType(CashflowTypeEnum.OUT);
                }
            } else if ("customer".equals(key)) {
                if (value != null) {
                    Object objCustomer = assGrp.get("customer");
                    if (objCustomer instanceof CustomerInfo) {
                        CustomerInfo customer = (CustomerInfo)objCustomer;
                        if (customer.getInternalCompany() != null) {
                            info.setCfType(CashflowTypeEnum.IN);
                            cfType = CashflowTypeEnum.IN;
                        } else {
                            info.setCfType(CashflowTypeEnum.OUT);
                        }
                    } else {
                        info.setCfType(CashflowTypeEnum.OUT);
                    }
                } else {
                    info.setCfType(CashflowTypeEnum.OUT);
                }
                if (value == null && isProviderToCustomer) {
                    if (customerFromBizAnalysisCode.getInternalCompany() != null) {
                        info.setCfType(CashflowTypeEnum.IN);
                        cfType = CashflowTypeEnum.IN;
                    } else {
                        info.setCfType(CashflowTypeEnum.OUT);
                    }
                }
                if (value == null && (isCompanyToCustomer || isCompanyToCustomerAndProvider)) {
                    info.setCfType(CashflowTypeEnum.IN);
                }
            } else if ("provider".equals(key)) {
                if (value != null) {
                    Object objSupplier = assGrp.get("provider");
                    if (objSupplier instanceof SupplierInfo) {
                        SupplierInfo supplier = (SupplierInfo)objSupplier;
                        if (supplier.getInternalCompany() != null) {
                            info.setCfType(CashflowTypeEnum.IN);
                            cfType = CashflowTypeEnum.IN;
                        } else {
                            info.setCfType(CashflowTypeEnum.OUT);
                        }
                    } else {
                        info.setCfType(CashflowTypeEnum.OUT);
                    }
                }
                if (value == null && isCustomerToProvider) {
                    if (supplierFromBizAnalysisCode.getInternalCompany() != null) {
                        info.setCfType(CashflowTypeEnum.IN);
                        cfType = CashflowTypeEnum.IN;
                    } else {
                        info.setCfType(CashflowTypeEnum.OUT);
                    }
                }
                if (value == null && (isCompanyToProvider || isCompanyToCustomerAndProvider)) {
                    info.setCfType(CashflowTypeEnum.IN);
                    cfType = CashflowTypeEnum.IN;
                }
            } else if (!CashflowTypeEnum.IN.equals((Object)info.getCfType())) {
                info.setCfType(CashflowTypeEnum.OUT);
            }
            group.put(key, value);
            if (value != null) {
                isAllNull = false;
            }
            if (isCustomerToProvider && key.equals("provider")) {
                group.put(key, (Object)supplierFromBizAnalysisCode);
                if (supplierFromBizAnalysisCode != null) {
                    isAllNull = false;
                }
            }
            if (isProviderToCustomer && key.equals("customer")) {
                group.put(key, (Object)customerFromBizAnalysisCode);
                if (customerFromBizAnalysisCode != null) {
                    isAllNull = false;
                }
            }
            if (isCompanyToCustomer && key.equals("customer")) {
                group.put(key, (Object)customerFromCompany);
                if (customerFromCompany != null) {
                    isAllNull = false;
                }
            }
            if (isCompanyToProvider && key.equals("provider")) {
                group.put(key, (Object)supplierFromCompany);
                if (supplierFromCompany != null) {
                    isAllNull = false;
                }
            }
            if (!isCompanyToCustomerAndProvider) continue;
            if (key.equals("customer")) {
                group.put(key, (Object)customerFromCompany);
            } else if (key.equals("provider")) {
                group.put(key, (Object)supplierFromCompany);
            }
            if (supplierFromCompany == null && customerFromCompany == null) continue;
            isAllNull = false;
        }
        if (cfType.equals((Object)CashflowTypeEnum.IN)) {
            info.setCfType(CashflowTypeEnum.IN);
        } else {
            info.setCfType(CashflowTypeEnum.OUT);
        }
        if (isAllNull) {
            curRow.getCell("assGrp").setValue(null);
            info.setCfiAssistId(null);
            info.setCfType(CashflowTypeEnum.OUT);
        } else {
            try {
                AssistantHGInfo hg = VoucherFacadeFactory.getRemoteInstance().confirmAssGrp(group, cfiTypeGroup.getId().toString(), cfiItemCols);
                if (hg == null) {
                    group = null;
                } else {
                    group.setId(hg.getId());
                    info.setCfiAssistDisplayNameGroup(hg.getDisplayNameGroup());
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
            curRow.getCell("assGrp").setValue((Object)group);
            if (group != null) {
                info.setCfiAssistId(group.getId().toString());
            }
        }
    }

    private void loadCashFlowRecord(IRow entryRow, VoucherInfo.DynamicColumnInfo[] cfiItemCols) {
        this.tblAssist.removeRows();
        if (cfiItemCols == null || cfiItemCols.length == 0) {
            this.splitPane.remove((Component)this.ctnAssist);
            this.splitPane.setDividerLocation(1.0);
            this.splitPane.validate();
            entryRow.getCell("assGrp").setValue(null);
            entryRow.getCell("type").getStyleAttributes().setLocked(true);
            entryRow.getCell("type").setValue((Object)CashflowTypeEnum.OUT);
            return;
        }
        entryRow.getCell("type").getStyleAttributes().setLocked(false);
        this.splitPane.add((Component)this.ctnAssist, (Object)"bottom");
        this.splitPane.setDividerLocation(0.8);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setHasDividerPointer(true);
        this.splitPane.validate();
        this.tblAssist.checkParsed(true);
        this.tblAssist.getSelectManager().setSelectMode(1);
        AssistantHGInfo assGrp = (AssistantHGInfo)entryRow.getCell("assGrp").getValue();
        IRow header = this.tblAssist.getHeadRow(0);
        IRow asstRow = this.tblAssist.addRow();
        for (int i = 0; i < cfiItemCols.length; ++i) {
            String key = cfiItemCols[i].getMappingPropName();
            IColumn col = this.tblAssist.addColumn(i);
            col.setKey(key);
            col.setWidth(230);
            header.getCell(key).setValue((Object)cfiItemCols[i].getColName());
            FilterInfo filter = null;
            if (key.equals("customer") || key.equals("provider")) {
                filter = new FilterInfo();
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("internalCompany.id", null, CompareType.NOTEQUALS));
            }
            col.setEditor(CashFlowDirectUtil.getCellEditor(this.hmDynamicPromptBox, cfiItemCols[i], filter, (CoreUIObject)this));
            if (assGrp == null) continue;
            asstRow.getCell(key).setValue(assGrp.get(key));
        }
    }

    public Map getSaveResult() {
        return this.saveResult;
    }

    public String getResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowTAccountUI", (String)resKey);
    }
}

