/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client.asstf7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.DelegationPartsEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.org.client.f7.OrgUnitDelegationF7;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.asstf7.AsstF7Utils;
import com.kingdee.eas.fi.gl.client.asstf7.DefaultProcessor;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.rpt.client.GLRptUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AdminOrgProcessor
extends DefaultProcessor {
    private boolean isChooseAsstCom = false;
    private boolean isOrgPermission = false;
    private boolean isBizUnit = false;

    public void doProcessor(CoreUIObject ui, KDBizPromptBox bizPromptBox, AsstActTypeInfo atInfo, CompanyOrgUnitInfo[] companys, GLF7Parameter param) {
        super.doProcessor(ui, bizPromptBox, atInfo, companys, param);
        bizPromptBox.setCommitFormat("$simpleName$;$description$;$code$;$number$;$name$");
        this.initGLParam();
        this.isBizUnit = companys[0].isIsBizUnit();
        if (this.isChoosePersonByCompany()) {
            bizPromptBox.setDefaultF7UIName(null);
            OrgUnitDelegationF7 oudF7 = new OrgUnitDelegationF7(bizPromptBox, DelegationPartsEnum.THE_FROM_UNIT, OrgType.Admin, true);
            List companyIdList = new ArrayList();
            String companyId = companys[0].getId().toString();
            boolean unMaster = !BooksUtil.isMasterBook(null, (String)companyId);
            Set companyIdSet = GLRptUtils.getCompanyIdSet(companys);
            if (unMaster) {
                try {
                    Set masterCompanyIdSet = GlUtils.getMasterCompanyIdSet(companyIdSet);
                    companyIdList = this.getIdList(masterCompanyIdSet);
                    companyIdList.addAll(companyIdSet);
                }
                catch (BOSException e) {
                    ui.handUIException((Throwable)e);
                }
            } else {
                companyIdList = this.getIdList(companyIdSet);
            }
            oudF7.setTheGivenOrgUnits(companyIdList, OrgType.Company);
            try {
                oudF7.setDataPermission("Admin_View");
            }
            catch (Exception e) {
                ui.handUIException((Throwable)e);
            }
            oudF7.setDoNotUseUserOrgRangeAsFilter();
            oudF7.setIncludeSelfWhenSelfIsAlsoOfTheWantedType();
            try {
                bizPromptBox.getEntityViewInfo().getFilter().mergeFilter(this.getFilter(), "AND");
            }
            catch (BOSException e) {
                ui.handUIException((Throwable)e);
            }
        } else {
            NewAdminF7 f7 = new NewAdminF7((IUIObject)ui){

                protected FilterInfo handleRuntimeOuterFilterInfo() throws BOSException {
                    FilterInfo filter = super.handleRuntimeOuterFilterInfo();
                    if (AdminOrgProcessor.this.getParam().isOnlyLeaf()) {
                        FilterInfo leafFilter = new FilterInfo();
                        leafFilter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)"select org.fid from t_org_admin org where org.fisleaf = 1 and org.fid = \"ORGSTRUCTURE\".funitid", CompareType.EXISTS));
                        if (filter == null) {
                            filter = leafFilter;
                        } else {
                            filter.mergeFilter(leafFilter, "AND");
                        }
                    }
                    if (AdminOrgProcessor.this.getParam().getFilter() != null) {
                        if (filter == null) {
                            filter = AdminOrgProcessor.this.getParam().getFilter();
                        } else {
                            filter.mergeFilter(AdminOrgProcessor.this.getParam().getFilter(), "AND");
                        }
                    }
                    return filter;
                }
            };
            f7.setDataPermission("Admin_View");
            if (this.isChooseAsstCom || !this.isOrgPermission) {
                f7.setNeedAddOrgRange(false);
            } else {
                f7.setNeedAddOrgRange(true);
            }
            f7.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
            if (AsstF7Utils.isAdminOrgByCU(this.getParam())) {
                f7.setIsCUFilter(true);
            } else {
                f7.setIsCUFilter(false);
            }
            if (ui.getOprtState() != null && (ui.getOprtState().equals(OprtState.ADDNEW) || ui.getOprtState().equals(OprtState.EDIT) || ui.getOprtState().equals(OprtState.COPYADDNEW))) {
                f7.setContainSealUp(false);
            } else {
                f7.setContainSealUp(true);
            }
            f7.setMultiSelect(bizPromptBox.isEnabledMultiSelection());
            bizPromptBox.setSelector((KDPromptSelector)f7);
        }
    }

    protected FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        if (!this.getParam().isUnUse()) {
            fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
            fic.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
        }
        if (this.isChoosePersonByCompany()) {
            fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1), CompareType.EQUALS));
        } else {
            if (this.getParam().isOnlyLeaf()) {
                fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
            }
            if (AsstF7Utils.isAdminOrgByCU(this.getParam())) {
                fic.add(new FilterItemInfo("CU.id", (Object)GLRptUtils.getCUIdSet(GLRptUtils.getCompanyIdSet(this.getCompanys())), CompareType.INCLUDE));
            }
            if (this.getUi().getOprtState() != null && (this.getUi().getOprtState().equals(OprtState.ADDNEW) || this.getUi().getOprtState().equals(OprtState.EDIT) || this.getUi().getOprtState().equals(OprtState.COPYADDNEW))) {
                fic.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
            }
        }
        if (this.getParam().getFilter() != null) {
            try {
                filter.mergeFilter(this.getParam().getFilter(), "and");
            }
            catch (Exception e) {
                this.getUi().handUIException((Throwable)e);
            }
        }
        return filter;
    }

    private void initGLParam() {
        String[] paramList = new String[]{"GL_043", "GL_069"};
        String companyId = this.getParam().isEditUI() ? this.getCompanys()[0].getId().toString() : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        try {
            GlParam glParam = GlParam.getGlParams(null, (String[])paramList, (String)companyId);
            this.isChooseAsstCom = glParam.getBoolean("GL_069");
            this.isOrgPermission = glParam.getBoolean("GL_043");
        }
        catch (Exception e) {
            this.getUi().handUIException((Throwable)e);
        }
    }

    private boolean isChoosePersonByCompany() {
        return this.isBizUnit && this.isChooseAsstCom;
    }

    protected String getQueryInfo() {
        if (!this.isChoosePersonByCompany()) {
            return "com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery4AsstAcct";
        }
        return null;
    }

    protected OrgViewType getOrgViewType() {
        return OrgViewType.ADMIN;
    }
}

