/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client.asstf7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.asstf7.BankAccountChangeListener;
import com.kingdee.eas.fi.gl.client.asstf7.DefaultProcessor;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.rpt.client.GLRptUtils;
import java.util.Set;

public class BankAccountProcessor
extends DefaultProcessor {
    protected void initListener() {
        super.initListener();
        BankAccountChangeListener l = new BankAccountChangeListener();
        l.init(this.getUi(), this.getAtInfo(), this.getCompanys()[0], this.getParam());
        this.addAsstDataChangeListener(l);
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection selector = super.getSelector();
        selector.add(new SelectorItemInfo("bank.id"));
        selector.add(new SelectorItemInfo("bank.number"));
        selector.add(new SelectorItemInfo("bank.longNumber"));
        selector.add(new SelectorItemInfo("bank.displayName"));
        selector.add(new SelectorItemInfo("bank.name"));
        selector.add(new SelectorItemInfo("isByCurrency"));
        return selector;
    }

    public void doProcessor(CoreUIObject ui, KDBizPromptBox bizPromptBox, AsstActTypeInfo atInfo, CompanyOrgUnitInfo[] companys, GLF7Parameter param) {
        super.doProcessor(ui, bizPromptBox, atInfo, companys, param);
        bizPromptBox.setCommitFormat("$simpleCode$;$number$;$name$");
        bizPromptBox.setQueryInfo(this.getQueryInfo());
    }

    protected FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        try {
            if (this.getParam().isEditUI()) {
                String companyid = this.getCompanys()[0].getId().toString();
                GlParam glParam = GlParam.getGlParams(null, (String)"GL_0155", (String)companyid);
                boolean isCashEquivalentFilterAccount = glParam.getBoolean("GL_0155");
                filter = GlUtils.getBankAccountFilter(null, companyid, this.getParam().getAccountId(), isCashEquivalentFilterAccount);
            } else {
                filter = BankAccountProcessor.getMultiCompanyBankAccountFilter(this.getCompanys());
            }
            FilterItemCollection fic = filter.getFilterItems();
            StringBuffer maskString = new StringBuffer();
            if (filter.getMaskString() != null) {
                maskString.append(filter.getMaskString());
            }
            int index = filter.getFilterItems().size();
            if (this.getUi().getOprtState() != null && (this.getUi().getOprtState().equals(OprtState.ADDNEW) || this.getUi().getOprtState().equals(OprtState.EDIT) || this.getUi().getOprtState().equals(OprtState.COPYADDNEW))) {
                fic.add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
                maskString.append(" AND #").append(index++);
            }
            if (this.getParam().getCurrencyId() != null) {
                fic.add(new FilterItemInfo("isByCurrency", (Object)1));
                fic.add(new FilterItemInfo("currency.id", (Object)this.getParam().getCurrencyId()));
                fic.add(new FilterItemInfo("isByCurrency", (Object)0));
                maskString.append(" and ((#").append(index++).append(" and #").append(index++).append(") or #").append(index++).append(")");
            }
            filter.setMaskString(maskString.toString());
            if (this.getParam().getFilter() != null) {
                filter.mergeFilter(this.getParam().getFilter(), "and");
            }
        }
        catch (Exception e) {
            this.getUi().handUIException((Throwable)e);
        }
        return filter;
    }

    protected String getQueryInfo() {
        return "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";
    }

    public static FilterInfo getMultiCompanyBankAccountFilter(CompanyOrgUnitInfo[] companys) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        if (companys == null || companys.length == 0) {
            return filter;
        }
        FilterItemCollection fic = filter.getFilterItems();
        if (companys[0].isIsBizUnit()) {
            boolean unMaster;
            Set companyIdSet = GLRptUtils.getCompanyIdSet(companys);
            StringBuffer maskString = new StringBuffer();
            int index = 0;
            String companyId = companys[0].getId().toString();
            boolean bl = unMaster = !BooksUtil.isMasterBook(null, (String)companyId);
            if (unMaster) {
                fic.add(new FilterItemInfo("company.id", (Object)companyIdSet, CompareType.INCLUDE));
                Set masterCompanyIdSet = GlUtils.getMasterCompanyIdSet(companyIdSet);
                fic.add(new FilterItemInfo("company.id", (Object)masterCompanyIdSet, CompareType.INCLUDE));
                maskString.append(" (#").append(index++).append(" or #").append(index++).append(")");
            } else {
                fic.add(new FilterItemInfo("company.id", (Object)companyIdSet, CompareType.INCLUDE));
                maskString.append(" #").append(index++);
            }
            filter.setMaskString(maskString.toString());
        } else {
            fic.add(new FilterItemInfo("company.id", (Object)companys[0].getId().toString()));
        }
        return filter;
    }

    protected String getCacheKey() {
        String key = super.getCacheKey();
        if (this.getParam().getAccountId() != null) {
            key = this.getParam().getCurrencyId() != null ? key + this.getParam().getAccountId() + this.getParam().getCurrencyId() : key + this.getParam().getAccountId();
        }
        return key;
    }
}

