/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client.asstf7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.client.AcctCussentInitUI;
import com.kingdee.eas.fi.gl.client.asstf7.AsstDataChangeListener;
import com.kingdee.eas.fi.gl.client.asstf7.AsstF7Utils;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.rpt.client.GLRptUtils;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public class CustomerChangeListener
extends AsstDataChangeListener {
    private boolean isChooseAsstCom = false;
    private boolean isOrgPermission = false;
    private boolean isBizUnit = false;

    public void init(CoreUIObject ui, AsstActTypeInfo typeInfo, CompanyOrgUnitInfo company, GLF7Parameter param) {
        super.init(ui, typeInfo, company, param);
        this.initGLParam();
        this.isBizUnit = this.getCompany().isIsBizUnit();
    }

    public void asstDataChanged(DataChangeEvent eventObj) {
        DataBaseInfo info = (DataBaseInfo)eventObj.getNewValue();
        if (info == null) {
            return;
        }
        String adminType = this.getAdminOrgType();
        String personType = this.getPersonType();
        if (!this.checkCellIsNull(adminType) && !this.checkCellIsNull(personType)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelector());
        view.setFilter(this.getFilter(info));
        CustomerCompanyInfoCollection col = null;
        try {
            col = CustomerCompanyInfoFactory.getRemoteInstance().getCustomerCompanyInfoCollection(view);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.getUi().handUIException((Throwable)e);
        }
        if (col != null && col.size() > 0) {
            PersonInfo person;
            if (this.checkCellIsNull(adminType)) {
                AdminOrgUnitInfo adminOrg = col.get(0).getAdminOrgUnit();
                try {
                    if (adminOrg != null && this.isAdminOrgIsInRanger(adminOrg.getId().toString()) && this.isContainAsstAct(adminType)) {
                        this.setAdminOrgAndPersonByCustomer((DataBaseInfo)adminOrg);
                    }
                }
                catch (EASBizException e) {
                    this.getUi().handUIException((Throwable)e);
                }
                catch (BOSException e) {
                    this.getUi().handUIException((Throwable)e);
                }
            }
            if (this.checkCellIsNull(personType) && (person = col.get(0).getOperationer()) != null) {
                MetaDataPK pk = MetaDataPK.create((String)this.getPersonQueryInfo());
                IQueryExecutor exec2 = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
                EntityViewInfo existView = new EntityViewInfo();
                existView.setFilter(this.getPersonFilter(person.getId().toString()));
                exec2.setObjectView(existView);
                try {
                    IRowSet row = exec2.executeQuery();
                    if (row != null && row.size() != 0 && this.isContainAsstAct(personType)) {
                        this.setAdminOrgAndPersonByCustomer((DataBaseInfo)person);
                    }
                }
                catch (Exception e) {
                    this.getUi().handUIException((Throwable)e);
                }
            }
        }
    }

    private boolean isContainAsstAct(String type) {
        if (!(this.getUi() instanceof AcctCussentInitUI)) {
            return true;
        }
        AcctCussentInitUI acctCussentInitUI = (AcctCussentInitUI)this.getUi();
        AccountViewInfo selectedAccout = acctCussentInitUI.getSelectedAccout();
        if (null == selectedAccout || null == acctCussentInitUI.getAsstActTypes(selectedAccout)) {
            return false;
        }
        AsstActTypeCollection asstTypes = acctCussentInitUI.getAsstActTypes(selectedAccout);
        for (int i = 0; i < asstTypes.size(); ++i) {
            if (!asstTypes.get(i).getAsstHGAttribute().contains(type)) continue;
            return true;
        }
        return false;
    }

    private boolean checkCellIsNull(String mappingTye) {
        ICell cell = null;
        if ("adminOrg".equals(mappingTye)) {
            cell = this.getCell("adminOrg");
        }
        if ("person".equals(mappingTye)) {
            cell = this.getCell("person");
        }
        return cell != null && cell.getValue() == null;
    }

    private String getAdminOrgType() {
        String type = null;
        ICell cell = this.getCell("adminOrg");
        if (cell != null) {
            type = "adminOrg";
        }
        return type;
    }

    private String getPersonType() {
        String type = null;
        ICell cell = this.getCell("person");
        if (cell != null) {
            type = "person";
        }
        return type;
    }

    public void setAdminOrgAndPersonByCustomer(DataBaseInfo info) {
        if (info == null) {
            return;
        }
        ICell cell = null;
        if (info instanceof AdminOrgUnitInfo) {
            cell = this.getCell("adminOrg");
        } else if (info instanceof PersonInfo) {
            cell = this.getCell("person");
            info.setString("displayName", (String)info.get("name"));
            info.setString("longNumber", (String)info.get("number"));
        }
        if (cell != null && cell.getValue() == null) {
            cell.setValue((Object)info);
        }
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("operationer.id"));
        sic.add(new SelectorItemInfo("operationer.number"));
        sic.add(new SelectorItemInfo("operationer.name"));
        sic.add(new SelectorItemInfo("operationer.longNumber"));
        if (this.getParam().isShowAsstDetail()) {
            sic.add(new SelectorItemInfo("operationer.displayName"));
        }
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.longNumber"));
        if (this.getParam().isShowAsstDetail()) {
            sic.add(new SelectorItemInfo("adminOrgUnit.displayName"));
        }
        return sic;
    }

    private FilterInfo getFilter(DataBaseInfo info) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("customer.id", info.get("id")));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.getCompany().getId().toString()));
        return filter;
    }

    private void initGLParam() {
        if (this.getParam().isEditUI()) {
            String[] paramList = new String[]{"GL_043", "GL_069"};
            String companyId = this.getCompany().getId().toString();
            try {
                GlParam glParam = GlParam.getGlParams(null, (String[])paramList, (String)companyId);
                this.isOrgPermission = glParam.getBoolean("GL_043");
                this.isChooseAsstCom = glParam.getBoolean("GL_069");
            }
            catch (Exception e) {
                this.getUi().handUIException((Throwable)e);
            }
        } else {
            if (this.isBizUnit) {
                try {
                    IGLGeneralFacade facade = GLGeneralFacadeFactory.getRemoteInstance();
                    CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[]{this.getCompany()};
                    this.isChooseAsstCom = facade.isChooseAsstCom(GLRptUtils.getCompanyIdSet(companys));
                }
                catch (BOSException e) {
                    this.getUi().handUIException((Throwable)e);
                }
            } else {
                this.isChooseAsstCom = false;
            }
            this.isOrgPermission = false;
        }
    }

    private FilterInfo getPersonFilter(String personid) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[]{this.getCompany()};
        String permisionSql = null;
        fic.add(new FilterItemInfo("id", (Object)personid, CompareType.EQUALS));
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (this.getParam().isEditUI()) {
            fic.add(new FilterItemInfo("Person.deletedStatus", (Object)1, CompareType.EQUALS));
        }
        if (this.isChoosePersonByCompany()) {
            fic.add(new FilterItemInfo("FI.id", (Object)this.getCompany().getId().toString(), CompareType.EQUALS));
        } else if (this.isOrgPermission) {
            permisionSql = " select org.FId from T_ORG_Admin org INNER JOIN T_PM_OrgRange orgRange ON org.FID = orgRange.FOrgID WHERE orgRange.FType = 20 and orgRange.FUserID='" + userID + "'";
        } else if (AsstF7Utils.isPersonByCU(this.getParam()) && !this.isChooseAsstCom) {
            fic.add(new FilterItemInfo("CU2.id", (Object)GLRptUtils.getCUIdSet(GLRptUtils.getCompanyIdSet(companys)), CompareType.INCLUDE));
            fic.add(new FilterItemInfo("CU2.id", null, CompareType.NOTEQUALS));
        }
        if (this.getParam().getFilter() != null) {
            try {
                filter.mergeFilter(this.getParam().getFilter(), "and");
            }
            catch (Exception e) {
                this.getUi().handUIException((Throwable)e);
            }
        }
        System.out.println(filter.toString());
        return filter;
    }

    private String getPersonQueryInfo() {
        if (this.isChoosePersonByCompany()) {
            return "com.kingdee.eas.basedata.person.app.PersonFIQuery";
        }
        return "com.kingdee.eas.basedata.person.app.PersonQuery";
    }

    private boolean isAdminOrgIsInRanger(String adminid) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        String permisionSql = null;
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (adminid.equals(this.getCompany().getId().toString())) {
            return true;
        }
        if (this.isChooseAsstCom) {
            FilterInfo orFilter = new FilterInfo();
            orFilter.getFilterItems().add(new FilterItemInfo("toUnit.id", (Object)this.getCompany().getId().toString()));
            orFilter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)new Integer(1)));
            orFilter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)new Integer(0)));
            OrgUnitRelationCollection orColl = OrgUnitRelationFactory.getRemoteInstance().getOrgUnitRelationCollection(EntityViewInfo.getInstance((FilterInfo)orFilter, null, null));
            int j = orColl.size();
            for (int i = 0; i < j; ++i) {
                idSet.add(orColl.get(i).getFromUnit().getId().toString());
            }
        } else if (this.isOrgPermission) {
            Map map = PermissionFactory.getRemoteInstance().getAuthorizedOrgs((IObjectPK)new ObjectUuidPK(userID), OrgType.Admin, null, null, null);
            if (map != null) {
                idSet.clear();
                idSet.addAll(new HashSet(map.keySet()));
            }
            permisionSql = " and id in (select forgid from t_pm_orgrange where fuserid = '" + userID + "' and ftype = " + 20 + ")";
        } else if (AsstF7Utils.isAdminOrgByCU(this.getParam())) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.getCompany().getCU().getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("isFreeze", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("isleaf", (Object)1));
        if (idSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        }
        String rule = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(userID), (IObjectPK)new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4"), "Admin_View");
        String sql = "select id where id in (" + rule + ")";
        if (!this.isChooseAsstCom && this.isOrgPermission) {
            sql = sql + permisionSql;
        }
        IObjectPK[] pks = FullOrgUnitFactory.getRemoteInstance().getPKList(sql);
        HashSet<IObjectPK> set = new HashSet<IObjectPK>();
        if (pks != null) {
            set.addAll(new HashSet<IObjectPK>(Arrays.asList(pks)));
            if (set.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)adminid, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        AdminOrgUnitCollection colAdmin = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(view);
        return colAdmin != null && colAdmin.size() > 0;
    }

    private boolean isChoosePersonByCompany() {
        return this.isBizUnit && this.isChooseAsstCom;
    }
}

