/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client.asstf7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.person.client.FIPersonPromptBox;
import com.kingdee.eas.basedata.person.client.PersonF7UIHelper;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.basedata.person.parser.PersonParser;
import com.kingdee.eas.basedata.person.parser.PersonParserForGL069;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IGLGeneralFacade;
import com.kingdee.eas.fi.gl.client.asstf7.AsstF7Utils;
import com.kingdee.eas.fi.gl.client.asstf7.DefaultProcessor;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.client.asstf7.PersonChangeListener;
import com.kingdee.eas.fi.gl.rpt.client.GLRptUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class PersonProcessor
extends DefaultProcessor {
    private static final Logger logger = Logger.getLogger(PersonProcessor.class);
    private boolean isChooseAsstCom = false;
    private boolean isOrgPermission = false;
    private boolean isBizUnit = false;

    public void doProcessor(CoreUIObject ui, KDBizPromptBox bizPromptBox, AsstActTypeInfo atInfo, CompanyOrgUnitInfo[] companys, GLF7Parameter param) {
        boolean unMaster;
        String companyId = companys[0].getId().toString();
        boolean bl = unMaster = !BooksUtil.isMasterBook(null, (String)companyId);
        if (unMaster) {
            HashSet<CompanyOrgUnitInfo> newCompanySet = new HashSet<CompanyOrgUnitInfo>();
            for (int i = 0; i < companys.length; ++i) {
                newCompanySet.add(companys[i]);
                try {
                    String mainOrgId = companys[i].getMainOrg().getId().toString();
                    CompanyOrgUnitInfo mainOrg = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)mainOrgId)));
                    newCompanySet.add(mainOrg);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            companys = newCompanySet.toArray(new CompanyOrgUnitInfo[newCompanySet.size()]);
        }
        super.doProcessor(ui, bizPromptBox, atInfo, companys, param);
        this.isBizUnit = companys[0].isIsBizUnit();
        bizPromptBox.setCommitFormat("$number$;$name$;$idNum$");
        this.initGLParam();
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(this.getFilter());
        if (this.getParam().isEditUI()) {
            entityView.getFilter().getFilterItems().add(new FilterItemInfo("Person.deletedStatus", (Object)1, CompareType.EQUALS));
        }
        bizPromptBox.setEntityViewInfo(entityView);
        bizPromptBox.setQueryInfo(this.getQueryInfo());
        if (this.isChoosePersonByCompany()) {
            HashMap map = new HashMap();
            PersonParser personParser = new PersonParser(bizPromptBox);
            try {
                FIPersonPromptBox personf7 = new FIPersonPromptBox((IUIObject)ui, map);
                personf7.setCompanys(companys);
                personf7.setIsSingleSelect(false);
                if (this.getParam().isEditUI()) {
                    personf7.setShowDelPersonChk(false);
                }
                bizPromptBox.setCommitParser((IParser)personParser);
                personf7.setEnabledMultiSelection(bizPromptBox.isEnabledMultiSelection());
                bizPromptBox.setSelector((KDPromptSelector)personf7);
            }
            catch (Exception er) {
                logger.error((Object)er);
            }
        } else {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("TASK_ARRANGE", false);
            PersonPromptBox personf7 = new PersonPromptBox((IUIObject)ui, map);
            CtrlUnitInfo[] cus = GLRptUtils.getCUS(companys);
            personf7.setCUs(cus);
            if (this.isOrgPermission) {
                if (AsstF7Utils.isPersonByCU(param)) {
                    personf7.showUserAndCuRangeAdminOrg();
                } else {
                    personf7.showUserRangAdminOrg();
                    if (this.getParam().isEditUI()) {
                        try {
                            String sql = PersonF7UIHelper.getUserRangeAdminOrgSql();
                            if (sql != null && sql.trim().length() > 0) {
                                HashSet<String> adminids = new HashSet<String>();
                                IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
                                while (rs.next()) {
                                    String adminid = rs.getString("FId");
                                    adminids.add(adminid);
                                }
                                entityView.getFilter().getFilterItems().add(new FilterItemInfo("ADMINORGUNIT.id", adminids, CompareType.INCLUDE));
                            }
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else if (AsstF7Utils.isPersonByCU(param)) {
                personf7.setCUs(cus);
            } else {
                personf7.showAllAdmin();
            }
            if (param.isEditUI()) {
                personf7.setShowDelPersonChk(false);
            }
            if (bizPromptBox.isEnabledMultiSelection()) {
                personf7.setIsSingleSelect(false);
            }
            personf7.setEnabledMultiSelection(bizPromptBox.isEnabledMultiSelection());
            bizPromptBox.setCommitParser((IParser)new PersonParserForGL069(bizPromptBox));
            bizPromptBox.setSelector((KDPromptSelector)personf7);
        }
    }

    protected void initListener() {
        super.initListener();
        PersonChangeListener l = new PersonChangeListener();
        l.init(this.getUi(), this.getAtInfo(), this.getCompanys()[0], this.getParam());
        this.addAsstDataChangeListener(l);
    }

    private void initGLParam() {
        if (this.getParam().isEditUI()) {
            String[] paramList = new String[]{"GL_043", "GL_069"};
            String companyId = this.getCompanys()[0].getId().toString();
            try {
                GlParam glParam = GlParam.getGlParams(null, (String[])paramList, (String)companyId);
                this.isOrgPermission = glParam.getBoolean("GL_043");
                this.isChooseAsstCom = glParam.getBoolean("GL_069");
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                this.getUi().handUIException((Throwable)e);
            }
        } else {
            if (this.isBizUnit) {
                try {
                    IGLGeneralFacade facade = GLGeneralFacadeFactory.getRemoteInstance();
                    this.isChooseAsstCom = facade.mutilOrgParamValue(GLRptUtils.getCompanyIdSet(this.getCompanys()), "GL_069");
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    this.getUi().handUIException((Throwable)e);
                }
            } else {
                this.isChooseAsstCom = false;
            }
            this.isOrgPermission = false;
        }
    }

    protected FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        if (this.isChoosePersonByCompany()) {
            fic.add(new FilterItemInfo("FI.id", (Object)GLRptUtils.getCompanyIdSet(this.getCompanys()), CompareType.INCLUDE));
            fic.add(new FilterItemInfo("TYPERELATION.fromType", (Object)0, CompareType.EQUALS));
            fic.add(new FilterItemInfo("TYPERELATION.toType", (Object)1, CompareType.EQUALS));
        } else if (AsstF7Utils.isPersonByCU(this.getParam()) && !this.isChooseAsstCom) {
            fic.add(new FilterItemInfo("CU2.id", (Object)GLRptUtils.getCUIdSet(GLRptUtils.getCompanyIdSet(this.getCompanys())), CompareType.INCLUDE));
            fic.add(new FilterItemInfo("CU2.id", null, CompareType.NOTEQUALS));
        }
        if (this.getParam().getFilter() != null) {
            try {
                filter.mergeFilter(this.getParam().getFilter(), "and");
            }
            catch (Exception e) {
                this.getUi().handUIException((Throwable)e);
            }
        }
        if (this.isChoosePersonByCompany()) {
            try {
                HashSet<String> adminOrgIds = new HashSet<String>();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("toUnit.id", (Object)GLRptUtils.getCompanyIdSet(this.getCompanys()), CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)0));
                filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
                view.setFilter(filterInfo);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("fromUnit");
                view.setSelector(selector);
                OrgUnitRelationCollection coll = OrgUnitRelationFactory.getRemoteInstance().getOrgUnitRelationCollection(view);
                for (int i = 0; i < coll.size(); ++i) {
                    adminOrgIds.add(coll.get(i).getFromUnit().getId().toString());
                }
                if (adminOrgIds.size() > 0) {
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("gkAdmin.id", adminOrgIds, CompareType.INCLUDE));
                    filter.mergeFilter(filterInfo, "or");
                }
            }
            catch (BOSException e) {
                this.getUi().handUIException((Throwable)e);
            }
        }
        return filter;
    }

    protected String getQueryInfo() {
        return "com.kingdee.eas.basedata.person.app.AllPersonQuery2";
    }

    private boolean isChoosePersonByCompany() {
        return this.isBizUnit && this.isChooseAsstCom;
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = super.getSelector();
        if (this.getParam().isShowAsstDetail()) {
            sic.add(new SelectorItemInfo("browseGroup.displayName"));
        }
        return sic;
    }
}

