/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.client.asstf7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.client.asstf7.AsstDataChangeListener;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7handler;
import java.util.Iterator;

public class RegionChangeListener
extends AsstDataChangeListener {
    private AsstAccountInfo asstAccountInfo;

    public void init(CoreUIObject ui, AsstActTypeInfo typeInfo, CompanyOrgUnitInfo company, GLF7Parameter params) {
        super.init(ui, typeInfo, company, params);
        if (params != null && this.getParam().getAsstAccountId() != null) {
            try {
                this.asstAccountInfo = this.getAsstAccountInfo(this.getParam().getAsstAccountId());
            }
            catch (Exception e) {
                ui.handUIException((Throwable)e);
            }
        }
    }

    private AsstActTypeInfo getBankAccountAsstActTypeInfo() {
        if (this.asstAccountInfo == null) {
            return null;
        }
        Iterator it = this.asstAccountInfo.getAsstActGpDt().iterator();
        while (it.hasNext()) {
            AsstActTypeInfo asstActTypeInfo = ((AsstActGroupDetailInfo)it.next()).getAsstActType();
            if (!asstActTypeInfo.getAsstHGAttribute().equalsIgnoreCase("bankAccount")) continue;
            return asstActTypeInfo;
        }
        return null;
    }

    private AsstAccountInfo getAsstAccountInfo(String asstAccountId) throws EASBizException, BOSException {
        if (asstAccountId == null) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("asstActGpDt.asstActType.*"));
        return AsstAccountFactory.getRemoteInstance().getAsstAccountInfo((IObjectPK)new ObjectUuidPK(asstAccountId), selector);
    }

    public void asstDataChanged(DataChangeEvent eventObj) {
        ICell cell = this.getCell("bankAccount");
        if (cell == null) {
            return;
        }
        BankInfo bank = (BankInfo)eventObj.getNewValue();
        AsstActTypeInfo bankAccountActTypeInfo = this.getBankAccountAsstActTypeInfo();
        if (bankAccountActTypeInfo == null) {
            return;
        }
        String bankid = bank == null ? null : bank.getId().toString();
        try {
            KDBizPromptBox bizPromptBox = this.getBankAccountF7(bankAccountActTypeInfo, bankid);
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizPromptBox));
            if (bank != null) {
                cell.setValue(null);
            }
        }
        catch (Exception e) {
            this.getUi().handUIException((Throwable)e);
        }
    }

    private KDBizPromptBox getBankAccountF7(AsstActTypeInfo bankAccountActTypeInfo, String bankid) throws CloneNotSupportedException {
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setDisplayFormat("$number$;$name$");
        bizPromptBox.setCommitFormat("$number$;$name$");
        FilterInfo filter = new FilterInfo();
        if (bankid != null) {
            filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)bankid));
        }
        GLF7Parameter f7Param = this.getParam().clone();
        f7Param.setFilter(filter);
        GLF7handler.assignSelector((CoreUIObject)this.getUi(), (KDBizPromptBox)bizPromptBox, (AsstActTypeInfo)bankAccountActTypeInfo, (CompanyOrgUnitInfo)this.getCompany(), (GLF7Parameter)f7Param);
        return bizPromptBox;
    }
}

