/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.eas.base.param.INewParamAfterDeal;
import com.kingdee.eas.base.param.INewParamCheck;
import com.kingdee.eas.base.param.IParamAfterDeal;
import com.kingdee.eas.base.param.IParamCheck;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.IParamSetModify;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AccountBooksException;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLParamFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAcctCussentHistory;
import com.kingdee.eas.fi.gl.ParamException;
import com.kingdee.eas.fi.gl.app.GlAcctCussentGlFlagDeal;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GLParamCheck
implements INewParamCheck,
INewParamAfterDeal,
IParamCheck,
IParamAfterDeal,
IParamSetModify {
    private static final Log log = LogFactory.getLog(GLParamCheck.class);
    private static Map validatorMap = new HashMap();

    public boolean setParamModify(Context ctx, ParamInfo paramInfo) throws BOSException, EASBizException {
        return false;
    }

    public void check(Context ctx, ParamItemCollection modelCol) throws BOSException, EASBizException {
        if (modelCol == null || modelCol.size() == 0) {
            return;
        }
        String number = modelCol.get(0).getKeyID().getNumber();
        Object validator = validatorMap.get(number);
        if (log.isDebugEnabled()) {
            log.debug((Object)("GLParamCheck: Parameter:" + number + "; OrgCount:" + modelCol.size() + "; validator:" + validator));
        }
        if (validator != null) {
            try {
                if (validator instanceof MultiOrgValidator) {
                    ((MultiOrgValidator)validator).check(ctx, modelCol);
                } else if (validator instanceof SingleOrgValidator) {
                    for (int i = 0; i < modelCol.size(); ++i) {
                        ((SingleOrgValidator)validator).check(ctx, modelCol.get(i));
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
    }

    public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
        String number = model.getKeyID().getNumber();
        Object validator = validatorMap.get(number);
        if (log.isDebugEnabled()) {
            log.debug((Object)("GLParamCheck: Parameter:" + number + "; validator:" + validator));
        }
        if (validator != null) {
            try {
                if (validator instanceof SingleOrgValidator) {
                    ((SingleOrgValidator)validator).check(ctx, model);
                } else if (validator instanceof MultiOrgValidator) {
                    ParamItemCollection modelCol = new ParamItemCollection();
                    modelCol.add(model);
                    ((MultiOrgValidator)validator).check(ctx, modelCol);
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
    }

    public void afterDeal(Context ctx, ParamItemCollection modelCol) throws BOSException, EASBizException {
    }

    public void afterDeal(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
    }

    private static void checkBookParam(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
        String companyid = BooksUtil.getCurrentMasterCompanyID((Context)ctx);
        if (BooksUtil.isMasterBook((Context)ctx)) {
            String numberName = model.getKeyID().getNumber() + model.getKeyID().getName();
            boolean hasEnableRule = BooksUtil.hasEnableBooksRule((Context)ctx, (String)companyid, null);
            if (hasEnableRule) {
                throw new ParamException(ParamException.OTHERRULE, new Object[]{numberName});
            }
        } else {
            HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
            hmParamIn.put("GL_028", new ObjectUuidPK(companyid));
            hmParamIn.put("GL_052", new ObjectUuidPK(companyid));
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
            if (model.getKeyID().getNumber().equals("GL_028") && !model.getValue().equals(hmAllParam.get("GL_028").toString())) {
                throw new AccountBooksException(AccountBooksException.PARAMNOTSAME, new Object[]{BooksUtil.getCurrentBook((Context)ctx).getName(), model.getKeyID().getNumber()});
            }
            if (model.getKeyID().getNumber().equals("GL_052")) {
                int masterModel = Integer.valueOf(hmAllParam.get("GL_052").toString());
                int bookModel = new Integer(model.getValue());
                if (bookModel != masterModel) {
                    throw new AccountBooksException(AccountBooksException.PARAMNOTSAME, new Object[]{BooksUtil.getCurrentBook((Context)ctx).getName(), model.getKeyID().getNumber()});
                }
            }
        }
    }

    private static String getOrgIdList(ParamItemCollection modelCol) {
        StringBuffer idList = new StringBuffer();
        for (int i = 0; i < modelCol.size(); ++i) {
            idList.append('\'').append(modelCol.get(i).getOrgUnitID().getId().toString()).append("',");
        }
        if (idList.length() > 0) {
            idList.deleteCharAt(idList.length() - 1);
        }
        return idList.toString();
    }

    private static void checkParamValue(Context ctx, ParamItemInfo model, String paramNumber, String expectedValue, NumericExceptionSubItem paramException) throws EASBizException, BOSException {
        ObjectUuidPK orgUnitId = new ObjectUuidPK(model.getOrgUnitID().getId());
        String value = ParamManager.getParamValue((Context)ctx, (IObjectPK)orgUnitId, (String)paramNumber);
        if (value == null) {
            throw new GLException(GLException.NOPARAM, new Object[]{paramNumber});
        }
        if (!value.equals(expectedValue)) {
            throw new ParamException(paramException);
        }
    }

    static {
        validatorMap.put("GL_008", new Validator_GL008());
        validatorMap.put("GL_028", new Validator_GL028());
        validatorMap.put("GL_052", new Validator_GL052());
        validatorMap.put("GL_0521", new Validator_GL0521());
        validatorMap.put("G010", new Validator_GL010());
        validatorMap.put("G012", new Validator_GL012());
        validatorMap.put("GL_070", new Validator_GL070());
        validatorMap.put("GL_071", new Validator_GL071());
        validatorMap.put("GL_072", new Validator_GL072());
        validatorMap.put("GL_075", new Validator_GL075());
        validatorMap.put("GL_098", new Validator_GL098());
        validatorMap.put("GL_099", new Validator_GL099());
        validatorMap.put("GLG01_2", new Validator_GLG01_2());
        validatorMap.put("G001", new Validator_GL001());
        validatorMap.put("GL_108", new Validator_GL108());
    }

    private static class Validator_GL108
    implements SingleOrgValidator {
        private Validator_GL108() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException, SQLException {
            String orgUnitId = model.getOrgUnitID().getId().toString();
            HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
            hmParamIn.put("GL_111", new ObjectUuidPK(orgUnitId));
            hmParamIn.put("GL_108", new ObjectUuidPK(orgUnitId));
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
            boolean voucherProcess = Boolean.valueOf(hmAllParam.get("GL_111").toString());
            boolean oldModle = Boolean.valueOf(hmAllParam.get("GL_108").toString());
            boolean toModle = new Boolean(model.getValue());
            if (toModle && !oldModle && !voucherProcess) {
                throw new ParamException(ParamException.COMMON_VOUCHER_PROCESS_DISABLE);
            }
        }
    }

    private static class Validator_GL001
    implements SingleOrgValidator {
        private Validator_GL001() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException, SQLException {
            HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
            hmParamIn.put("G001", null);
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
            boolean oldModle = Boolean.valueOf(hmAllParam.get("G001").toString());
            boolean toModle = new Boolean(model.getValue());
            if (!CompanyOrgUnitFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"))) {
                throw new ParamException(ParamException.NOTCOMPANYORG_NOEDITING);
            }
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
            if (toModle && !oldModle && company.getReportCurrency() != null) {
                GLParamFacadeFactory.getLocalInstance(ctx).dealRptCurrency();
            }
        }
    }

    private static class Validator_GLG01_2
    implements SingleOrgValidator {
        private Validator_GLG01_2() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException, SQLException {
            String orgUnitId = model.getOrgUnitID().getId().toString();
            HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
            hmParamIn.put("GLG01_2", new ObjectUuidPK(orgUnitId));
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
            IRowSet rs = null;
            int audited = 0;
            int posted = 1;
            int submited = 2;
            String sql = "";
            int oldModle = Integer.valueOf(hmAllParam.get("GLG01_2").toString());
            int toModle = new Integer(model.getValue());
            if (oldModle == toModle) {
                return;
            }
            if (oldModle == audited && toModle == submited) {
                sql = "select top 1 fcompanyid from t_gl_voucher where fcompanyid=? and fbizstatus=1";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgUnitId});
                if (rs.next()) {
                    throw new ParamException(ParamException.HAS_SUBMIT_VCH);
                }
            } else if (oldModle == posted && toModle == submited ? (rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "select top 1 fcompanyid from t_gl_voucher where fcompanyid=? and (fbizstatus=1 or fbizstatus=3)"), (Object[])new Object[]{orgUnitId})).next() : oldModle == posted && toModle == audited && (rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "select top 1 fcompanyid from t_gl_voucher where fcompanyid=? and fbizstatus=3"), (Object[])new Object[]{orgUnitId})).next()) {
                throw new ParamException(ParamException.HAS_POST_VCH);
            }
        }
    }

    private static class Validator_GL099
    implements SingleOrgValidator {
        private Validator_GL099() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException, SQLException {
            GLParamCheck.checkParamValue(ctx, model, "GL_032", "false", ParamException.VCH_USE_WF);
        }
    }

    private static class Validator_GL098
    implements SingleOrgValidator {
        private Validator_GL098() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws EASBizException, BOSException {
            boolean isQty;
            if (model.getValue().equals("true") && !(isQty = GlUtils.getQtyAsstParam(ctx))) {
                throw new ParamException(ParamException.CHECK_PARAM_AEGIS_ASSISTUNIT);
            }
        }
    }

    private static class Validator_GL075
    implements SingleOrgValidator {
        private Validator_GL075() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException, SQLException {
            GLParamCheck.checkParamValue(ctx, model, "GL_032", "false", ParamException.VCH_USE_WF);
            GLParamCheck.checkParamValue(ctx, model, "GL_029", "true", ParamException.BG_CTRL_DISABLE);
            String orgUnitId = model.getOrgUnitID().getId().toString();
            String sql = "select top 1 fid from t_gl_voucher where fcompanyid=? and fbizstatus=1";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgUnitId});
            if (rs.next()) {
                throw new ParamException(ParamException.SUBMIT_VCH_EXISTS);
            }
        }
    }

    private static class Validator_GL072
    implements SingleOrgValidator {
        private Validator_GL072() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException, SQLException {
            GLParamCheck.checkParamValue(ctx, model, "G001", "true", ParamException.RPT_NOT_ENABLE);
        }
    }

    private static class Validator_GL071
    implements SingleOrgValidator {
        private Validator_GL071() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException, SQLException {
            GLParamCheck.checkParamValue(ctx, model, "GL_0152", "0", ParamException.NEED_SIMPLE);
            GLParamCheck.checkParamValue(ctx, model, "GL_070", "true", ParamException.CFPARAM_NOT_ENABLE);
        }
    }

    private static class Validator_GL070
    implements SingleOrgValidator {
        private Validator_GL070() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException, SQLException {
            if (model.getValue().equals("true")) {
                GLParamCheck.checkParamValue(ctx, model, "GL_0152", "0", ParamException.NEED_SIMPLE);
            }
        }
    }

    private static class Validator_GL012
    implements SingleOrgValidator {
        private Validator_GL012() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException, SQLException {
            String sql = "select top 1 fid from t_bks_accountrule where fisenable=1 ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                throw new ParamException(ParamException.OTHERRULE, new Object[]{model.getKeyID().getNumber()});
            }
        }
    }

    private static class Validator_GL010
    implements SingleOrgValidator {
        private Validator_GL010() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException, SQLException {
            boolean isQty = GlUtils.getQtyAsstParam(ctx);
            if (isQty && !"true".equals(model.getKeyID().getDefaultValue())) {
                throw new ParamException(ParamException.ASSTQTY);
            }
        }
    }

    private static class Validator_GL0521
    implements SingleOrgValidator {
        private Validator_GL0521() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException, SQLException {
            String orgUnitId = model.getOrgUnitID().getId().toString();
            HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
            hmParamIn.put("GL_028", new ObjectUuidPK(orgUnitId));
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
            boolean allowcussent = Boolean.valueOf(hmAllParam.get("GL_028").toString());
            if (!allowcussent) {
                throw new ParamException(ParamException.ENABLE_ALLOW_CUSSENT_FIRST);
            }
        }
    }

    private static class Validator_GL052
    implements SingleOrgValidator {
        private Validator_GL052() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException, SQLException {
            String orgUnitId = model.getOrgUnitID().getId().toString();
            HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
            hmParamIn.put("GL_028", new ObjectUuidPK(orgUnitId));
            hmParamIn.put("GL_052", new ObjectUuidPK(orgUnitId));
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
            boolean allowcussent = Boolean.valueOf(hmAllParam.get("GL_028").toString());
            int oldModle = Integer.parseInt(hmAllParam.get("GL_052").toString());
            int toMode = Integer.parseInt(model.getValue());
            if (oldModle == toMode) {
                return;
            }
            if (!allowcussent) {
                throw new ParamException(ParamException.ENABLE_ALLOW_CUSSENT_FIRST);
            }
            ISystemStatusCtrol iSysStatusCtr = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            boolean b = iSysStatusCtr.isRelatedAccount(orgUnitId, SystemEnum.ACCOUNTSPAYABLE);
            if (b && model.getValue().equals("0")) {
                throw new ParamException(ParamException.CHECK_MODIFY_CUSSENT_PAY1);
            }
            b = iSysStatusCtr.isRelatedAccount(orgUnitId, SystemEnum.ACCOUNTSRECEIVABLE);
            if (b && model.getValue().equals("0")) {
                throw new ParamException(ParamException.CHECK_MODIFY_CUSSENT_REV1);
            }
            GLParamCheck.checkBookParam(ctx, model);
            IRowSet rs = null;
            String sql = "select fid from t_bd_systemstatusctrol where fcompanyid=? and FACPeriodID is null and fsystemstatusid=(select fid from t_bd_systemstatus where fname=6)";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgUnitId});
            IAcctCussentHistory factory = AcctCussentHistoryFactory.getLocalInstance(ctx);
            if (rs.next()) {
                factory.changeVerifyMode(orgUnitId, oldModle, toMode, null, null);
            } else {
                PeriodInfo startPeriod = iSysStatusCtr.getStartPeriod(6, orgUnitId);
                PeriodInfo currentPeriod = iSysStatusCtr.getCacheCurrentPeriod(6, orgUnitId);
                if (startPeriod == null) {
                    throw new ParamException(ParamException.CHECK_MODIFY_GLSTARTPERIOD);
                }
                factory.changeVerifyMode(orgUnitId, oldModle, toMode, startPeriod, currentPeriod);
            }
        }
    }

    private static class Validator_GL028
    implements SingleOrgValidator {
        private Validator_GL028() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException, SQLException {
            String orgUnitId = model.getOrgUnitID().getId().toString();
            ISystemStatusCtrol iSysStatusCtr = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            GLParamCheck.checkBookParam(ctx, model);
            SystemStatusCtrolCollection ctrols = null;
            PeriodInfo acPeriod = null;
            ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection("select acPeriod.* where systemStatus.name=6 and company.id='" + orgUnitId + "'");
            PeriodInfo periodInfo = acPeriod = ctrols.size() > 0 && ctrols.get(0).getAcPeriod() != null ? ctrols.get(0).getAcPeriod() : null;
            if (acPeriod == null && (acPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx))) == null) {
                throw new ParamException(ParamException.CHECK_MODIFY_GLSTARTPERIOD);
            }
            int year = acPeriod.getPeriodYear();
            int periodNumber = acPeriod.getPeriodNumber();
            PeriodInfo currentPeriod = iSysStatusCtr.getCacheCurrentPeriod(6, orgUnitId);
            IRowSet rs = null;
            if (currentPeriod == null) {
                String sqlStr = "select top 1 FNAME_L2 from T_ORG_BASEUNIT where FID=?";
                rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr, (Object[])new Object[]{orgUnitId});
                String name = "";
                if (rs.next()) {
                    name = rs.getString("FNAME_L2");
                }
                throw new ParamException(ParamException.NOPERIOD_NOW, new Object[]{name});
            }
            if ("true".equals(model.getValue())) {
                String sql = "select top 1 fid from t_bd_systemstatusctrol where fcompanyid=? and FACPeriodID is not null and fsystemstatusid=(select fid from t_bd_systemstatus where fname=6)";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgUnitId});
                if (rs.next()) {
                    throw new ParamException(ParamException.CHECK_MODIFY_ACCTCUSSENT2);
                }
                if (acPeriod.getId().toString().equals(currentPeriod.getId().toString())) {
                    sql = "select top 1 fcompanyid from t_gl_voucher where fcompanyid=? ";
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgUnitId});
                    if (rs.next()) {
                        throw new ParamException(ParamException.CHECK_MODIFY_ACCTCUSSENT2);
                    }
                } else {
                    sql = "select top 1 fcompanyid from t_gl_voucher where fcompanyid=? and (FBizStatus=0 or FPeriodID in (select fid from t_bd_period where (fperiodyear>? or (fperiodyear=? and fperiodnumber>=?)))) ";
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgUnitId, currentPeriod.getPeriodYear(), currentPeriod.getPeriodYear(), currentPeriod.getPeriodNumber()});
                    if (rs.next()) {
                        throw new ParamException(ParamException.CHECK_MODIFY_ACCTCUSSENT2);
                    }
                    DbUtil.execute((Context)ctx, (String)"update t_bd_systemstatusctrol set FACPeriodID = ? where FACPeriodID is null and fcompanyid=? and fsystemstatusid=(select fid from t_bd_systemstatus where fname=6)", (Object[])new Object[]{currentPeriod.getId().toString(), orgUnitId});
                }
                GlAcctCussentGlFlagDeal glAcctCussentGlFlagDeal = new GlAcctCussentGlFlagDeal();
                glAcctCussentGlFlagDeal.gl028ChangeToTrue(ctx, orgUnitId, currentPeriod);
            } else {
                String sql = "SELECT TOP 1 fcompanyid FROM t_gl_voucher  voucher INNER join   T_bd_period period on  voucher.fperiodId = period.fid  WHERE fcompanyid = ? and  period.fperiodyear >= ? and period.fperiodnumber >= ?  ";
                sql = sql + " union all select top 1 fcompanyid from t_bd_systemstatusctrol where fcompanyid=? and FACPeriodID is not null and FACPeriodID!=fcurrentperiodid and fsystemstatusid=(select fid from t_bd_systemstatus where fname=6)";
                rs = DbUtil.executeQuery((Context)ctx, (String)(sql = sql + " union all SELECT TOP 1 fcompanyid FROM t_gl_acctcussent  WHERE fcompanyid = ? AND FISINIT = 1   and foriginalamount <> 0"), (Object[])new Object[]{orgUnitId, year, periodNumber, orgUnitId, orgUnitId});
                if (rs.next()) {
                    throw new ParamException(ParamException.CHECK_MODIFY_ACCTCUSSENT3);
                }
                DbUtil.execute((Context)ctx, (String)"update t_bd_systemstatusctrol set FACPeriodID = null where FACPeriodID is not null and fcompanyid=? and fsystemstatusid=(select fid from t_bd_systemstatus where fname=6)", (Object[])new Object[]{orgUnitId});
                GlAcctCussentGlFlagDeal glAcctCussentGlFlagDeal = new GlAcctCussentGlFlagDeal();
                glAcctCussentGlFlagDeal.gl028ChangeToFalse(ctx, orgUnitId);
            }
        }
    }

    private static class Validator_GL008
    implements MultiOrgValidator {
        private Validator_GL008() {
        }

        @Override
        public void check(Context ctx, ParamItemCollection modelCol) throws BOSException, EASBizException, SQLException {
            String orgIdList = GLParamCheck.getOrgIdList(modelCol);
            IRowSet rs = null;
            StringBuffer sql = new StringBuffer().append("select top 1 fid from t_gl_voucher where fcompanyid in (").append(orgIdList).append(") \n").append("union all \n").append("select top 1 faccountid from t_gl_initaccountbalance where forgunitid in (").append(orgIdList).append(") \n").append("union all \n").append("select top 1 faccountid from t_gl_initassistbalance where forgunitid in (").append(orgIdList).append(") \n").append("union all \n").append("select top 1 fid from t_gl_acctcussent where fcompanyid in (").append(orgIdList).append(") \n");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
            if (rs.next()) {
                throw new ParamException(ParamException.CHECK_MODIFY_FOREIGNCURRENCY);
            }
        }
    }

    private static interface MultiOrgValidator {
        public void check(Context var1, ParamItemCollection var2) throws BOSException, EASBizException, SQLException;
    }

    private static interface SingleOrgValidator {
        public void check(Context var1, ParamItemInfo var2) throws BOSException, EASBizException, SQLException;
    }
}

