/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common;

import com.kingdee.bos.Context;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GLResUtil {
    public static final String GLRES = "com.kingdee.eas.fi.gl.GLXResource";
    private static ThreadVarManager vm = new ThreadVarManager();

    public static String getRes(String resName, String resKey) {
        Locale locale = vm.get();
        return ResourceBase.getString((String)resName, (String)resKey, (Locale)locale);
    }

    public static String getRes(String resKey, Locale locale) {
        return ResourceBase.getString((String)GLRES, (String)resKey, (Locale)locale);
    }

    public static String getRes(String resKey) {
        return GLResUtil.getRes(GLRES, resKey);
    }

    public static String getRes(String resKey, Context ctx) {
        return GLResUtil.getRes(GLRES, resKey, ctx);
    }

    public static String getRes(String resName, String resKey, Context ctx) {
        return ResourceBase.getString((String)resName, (String)resKey, (Locale)ctx.getOriginLocale());
    }

    public static void setLocale(Locale locale) {
        vm.set(locale);
    }

    public static void setLocale(Context ctx) {
        vm.set(ctx.getLocale());
    }

    static class ThreadVarManager {
        private Map varMap = new HashMap();
        private Monitor m = new Monitor();
        private static final long interval = 10000L;
        private static final long life = 60000L;

        private ThreadVarManager() {
            this.m.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(Locale locale) {
            Map map = this.varMap;
            synchronized (map) {
                LT v = new LT();
                v.locale = locale;
                v.lastVisitTamp = System.currentTimeMillis();
                this.varMap.put(Thread.currentThread(), v);
            }
        }

        public Locale get() {
            LT v = (LT)this.varMap.get(Thread.currentThread());
            if (v == null) {
                Locale locale = SysContext.getSysContext().getLocale();
                this.set(locale);
                return locale;
            }
            v.lastVisitTamp = System.currentTimeMillis();
            return v.locale;
        }

        public void finalize() throws Throwable {
            this.varMap.clear();
            this.m.terminal();
            super.finalize();
        }

        class Monitor
        extends Thread {
            boolean terminal = false;

            Monitor() {
            }

            public void terminal() {
                this.terminal = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!this.terminal) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Map map = ThreadVarManager.this.varMap;
                    synchronized (map) {
                        HashMap<Thread, LT> newMap = new HashMap<Thread, LT>();
                        long now = System.currentTimeMillis();
                        for (Thread k : ThreadVarManager.this.varMap.keySet()) {
                            LT v = (LT)ThreadVarManager.this.varMap.get(k);
                            if (now - v.lastVisitTamp > 60000L) continue;
                            newMap.put(k, v);
                        }
                        ThreadVarManager.this.varMap.clear();
                        ThreadVarManager.this.varMap = newMap;
                    }
                }
            }
        }

        class LT {
            Locale locale;
            long lastVisitTamp;

            LT() {
            }
        }
    }
}

