/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.client.AssitantUtil;
import com.kingdee.eas.basedata.assistant.client.BankF7Selector;
import com.kingdee.eas.basedata.assistant.client.CashFlowF7Sys;
import com.kingdee.eas.basedata.assistant.client.CashFlowItemF7Selector;
import com.kingdee.eas.basedata.assistant.client.F7ProjectUI;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.framework.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AuxAccountUtils;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.MainDataParser;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI;
import com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.DelegationPartsEnum;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7WithDataPerm;
import com.kingdee.eas.basedata.org.client.f7.CostCenterF7WithDataPerm;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.basedata.org.client.f7.NewProfitCenterF7;
import com.kingdee.eas.basedata.org.client.f7.NewPurchaseF7;
import com.kingdee.eas.basedata.org.client.f7.NewSaleF7;
import com.kingdee.eas.basedata.org.client.f7.NewStorageF7;
import com.kingdee.eas.basedata.org.client.f7.OrgUnitDelegationF7;
import com.kingdee.eas.basedata.org.client.f7.ProfitCenterF7WithDataPerm;
import com.kingdee.eas.basedata.org.client.f7.PurchaseF7WithDataPerm;
import com.kingdee.eas.basedata.org.client.f7.SaleF7WithDataPerm;
import com.kingdee.eas.basedata.org.client.f7.StorageF7WithDataPerm;
import com.kingdee.eas.basedata.person.client.FIPersonPromptBox;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.IAcountScheme;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.RptMultiColumnDesignUI;
import com.kingdee.eas.fi.gl.client.VoucherAsstDataChangeListener;
import com.kingdee.eas.fi.gl.client.VoucherEditBaseUI;
import com.kingdee.eas.fi.gl.client.VoucherEditParam;
import com.kingdee.eas.fi.gl.common.GLBizF7Assign;
import com.kingdee.eas.fi.gl.common.GLOrgUtil;
import com.kingdee.eas.fi.gl.common.IGLf7Utils;
import com.kingdee.eas.framework.FrameWorkUtils;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLf7UtilsImpl
implements IGLf7Utils {
    private static final Logger logger = Logger.getLogger(GLf7UtilsImpl.class);
    private static boolean isPersonByCU = false;
    private static boolean isAdminOrgByCU = false;
    private static boolean isOrgPermission = false;
    private static boolean hasCPNumber = true;
    private static boolean isChooseAsstCom = true;
    private static boolean isCashEquivalentFilterAccount = false;

    private static void setParam(CoreUIObject ui) {
        GLf7UtilsImpl.getOrgPermission(ui);
        GLf7UtilsImpl.setEditParam(ui);
    }

    private static void setParam(CoreUIObject ui, String companyId) {
        GLf7UtilsImpl.getOrgPermission(ui, companyId);
        GLf7UtilsImpl.setEditParam(ui, companyId);
    }

    private static void setEditParam(CoreUIObject ui, String companyId) {
        VoucherEditParam editParam = null;
        if (ui == null) {
            editParam = VoucherEditParam.getInstance();
        } else {
            Map ctx = ui.getUIContext();
            editParam = (VoucherEditParam)ctx.get("VOUCHER_EDIT_PARAMS");
            if (editParam == null) {
                editParam = ui instanceof VoucherEditBaseUI ? ((VoucherEditBaseUI)ui).getEditParam() : VoucherEditParam.getInstance();
                ctx.put("VOUCHER_EDIT_PARAMS", editParam);
            }
        }
        isPersonByCU = editParam.getIsPersonByCU();
        isAdminOrgByCU = editParam.isAdminOrgByCU();
        hasCPNumber = editParam.isUseCPNumber();
    }

    private static void setEditParam(CoreUIObject ui) {
        VoucherEditParam editParam = null;
        if (ui == null) {
            editParam = VoucherEditParam.getInstance();
        } else {
            Map ctx = ui.getUIContext();
            editParam = (VoucherEditParam)ctx.get("VOUCHER_EDIT_PARAMS");
            if (editParam == null) {
                editParam = ui instanceof VoucherEditBaseUI ? ((VoucherEditBaseUI)ui).getEditParam() : VoucherEditParam.getInstance();
                ctx.put("VOUCHER_EDIT_PARAMS", editParam);
            }
        }
        isPersonByCU = editParam.getIsPersonByCU();
        isAdminOrgByCU = editParam.isAdminOrgByCU();
        hasCPNumber = editParam.isUseCPNumber();
    }

    public static FilterInfo getOrgFilterInfo(String cuid, OrgViewType orgType, FilterInfo filter) {
        try {
            HashMap map = OrgF7InnerUtils.getAuthorizedOrgViewIDs((IObjectPK)new ObjectUuidPK(cuid), (OrgViewType)orgType, null, null, null);
            if (map != null) {
                Object[] ids = map.keySet().toArray();
                StringBuffer strFilter = new StringBuffer("");
                for (int i = 0; i < ids.length; ++i) {
                    String id = ids[i].toString();
                    if (i > 0) {
                        strFilter.append(",");
                    }
                    strFilter.append(id);
                }
                FilterInfo filterID = new FilterInfo();
                filterID.getFilterItems().add(new FilterItemInfo("id", (Object)strFilter.toString(), CompareType.INCLUDE));
                filter.mergeFilter(filterID, "and");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filter;
    }

    private static void getOrgPermission(CoreUIObject ui) {
        Map paramsOrgPerm;
        block10: {
            paramsOrgPerm = null;
            String comid = GLf7UtilsImpl.getCurrentMasterCompanyID(ui);
            CompanyOrgUnitInfo company = GLf7UtilsImpl.getFICompany(ui);
            String companyid = company.getId().toString();
            if (comid != null && !companyid.equals(comid)) {
                companyid = comid;
            }
            try {
                if (ui == null) {
                    HashMap<String, String> hmParamIn = new HashMap<String, String>();
                    hmParamIn.put("GL_043", companyid);
                    hmParamIn.put("GL_069", companyid);
                    hmParamIn.put("GL_0155", companyid);
                    paramsOrgPerm = ParamControlFactory.getRemoteInstance().getParamHashMap(hmParamIn);
                } else {
                    Map ctx = ui.getUIContext();
                    paramsOrgPerm = (Map)ctx.get("PARAMS_ORG_PERMISSION");
                    if (paramsOrgPerm == null) {
                        HashMap<String, String> hmParamIn = new HashMap<String, String>();
                        hmParamIn.put("GL_043", companyid);
                        hmParamIn.put("GL_069", companyid);
                        hmParamIn.put("GL_0155", companyid);
                        paramsOrgPerm = ParamControlFactory.getRemoteInstance().getParamHashMap(hmParamIn);
                        ctx.put("PARAMS_ORG_PERMISSION", paramsOrgPerm);
                    }
                }
            }
            catch (Exception ex) {
                if (ui == null) break block10;
                ui.handUIException((Throwable)ex);
            }
        }
        if (paramsOrgPerm != null) {
            if (paramsOrgPerm.get("GL_043") != null) {
                isOrgPermission = Boolean.valueOf(paramsOrgPerm.get("GL_043").toString());
            }
            if (paramsOrgPerm.get("GL_069") != null) {
                isChooseAsstCom = Boolean.valueOf(paramsOrgPerm.get("GL_069").toString());
            }
            if (paramsOrgPerm.get("GL_0155") != null) {
                isCashEquivalentFilterAccount = Boolean.valueOf(paramsOrgPerm.get("GL_0155").toString());
            }
        }
    }

    private static void getOrgPermission(CoreUIObject ui, String companyId) {
        Map paramsOrgPerm;
        block9: {
            paramsOrgPerm = null;
            String comid = GLf7UtilsImpl.getCurrentMasterCompanyID(null, companyId);
            if (comid != null && !companyId.equals(comid)) {
                companyId = comid;
            }
            try {
                if (ui == null) {
                    HashMap<String, String> hmParamIn = new HashMap<String, String>();
                    hmParamIn.put("GL_043", companyId);
                    hmParamIn.put("GL_069", companyId);
                    hmParamIn.put("GL_0155", companyId);
                    paramsOrgPerm = ParamControlFactory.getRemoteInstance().getParamHashMap(hmParamIn);
                } else {
                    Map ctx = ui.getUIContext();
                    paramsOrgPerm = (Map)ctx.get("PARAMS_ORG_PERMISSION");
                    HashMap<String, String> hmParamIn = new HashMap<String, String>();
                    hmParamIn.put("GL_043", companyId);
                    hmParamIn.put("GL_069", companyId);
                    hmParamIn.put("GL_0155", companyId);
                    paramsOrgPerm = ParamControlFactory.getRemoteInstance().getParamHashMap(hmParamIn);
                    ctx.put("PARAMS_ORG_PERMISSION", paramsOrgPerm);
                }
            }
            catch (Exception ex) {
                if (ui == null) break block9;
                ui.handUIException((Throwable)ex);
            }
        }
        if (paramsOrgPerm != null) {
            if (paramsOrgPerm.get("GL_043") != null) {
                isOrgPermission = Boolean.valueOf(paramsOrgPerm.get("GL_043").toString());
            }
            if (paramsOrgPerm.get("GL_069") != null) {
                isChooseAsstCom = Boolean.valueOf(paramsOrgPerm.get("GL_069").toString());
            }
            if (paramsOrgPerm.get("GL_0155") != null) {
                isCashEquivalentFilterAccount = Boolean.valueOf(paramsOrgPerm.get("GL_0155").toString());
            }
        }
    }

    public void assignSelector(KDBizPromptBox bizPromptBox, GeneralAsstActTypeGroupInfo grp, String mappingFieldName, boolean isForCompany, String acctid, CoreUIObject ui, boolean useLongNumber) {
        this.assignSelector(bizPromptBox, grp, mappingFieldName, isForCompany, true, acctid, ui, false, useLongNumber);
    }

    public void assignSelector(KDBizPromptBox bizPromptBox, GeneralAsstActTypeGroupInfo grp, String mappingFieldName, boolean isForCompany, String acctid, CoreUIObject ui, boolean isEditUI, boolean useLongNumber) {
        this.assignSelector(bizPromptBox, grp, mappingFieldName, isForCompany, true, acctid, ui, isEditUI, useLongNumber);
    }

    public void assignSelector(KDBizPromptBox bizPromptBox, GeneralAsstActTypeGroupInfo grp, String mappingFieldName, boolean isForCompany, boolean onlyLeaf, String acctid, CoreUIObject ui, boolean useLongNumber) {
        this.assignSelector(bizPromptBox, grp, mappingFieldName, isForCompany, true, acctid, ui, false, useLongNumber);
    }

    public void assignSelector(KDBizPromptBox bizPromptBox, GeneralAsstActTypeGroupInfo grp, String mappingFieldName, boolean isForCompany, boolean onlyLeaf, boolean isShowSealCost, String acctid, CoreUIObject ui) {
        this.assignSelector(bizPromptBox, grp, mappingFieldName, isForCompany, true, false, true, acctid, null, ui, false, null, true);
    }

    public void assignSelector(KDBizPromptBox bizPromptBox, GeneralAsstActTypeGroupInfo grp, String mappingFieldName, boolean isForCompany, boolean onlyLeaf, String acctid, CoreUIObject ui, boolean isEditUI, boolean useLongNumber) {
        this.assignSelector(bizPromptBox, grp, mappingFieldName, isForCompany, onlyLeaf, acctid, ui, isEditUI, null, useLongNumber);
    }

    public static void assignSelector(KDBizPromptBox bizPromptBox, GeneralAsstActTypeGroupInfo grp, String mappingFieldName, boolean isForCompany, boolean onlyLeaf, String acctid, CoreUIObject ui, boolean isEditUI, boolean useLongNumber, String curCompanyId) {
        GLf7UtilsImpl.assignSelector(bizPromptBox, grp, mappingFieldName, isForCompany, onlyLeaf, acctid, ui, isEditUI, null, useLongNumber, curCompanyId);
    }

    public static void assignSelector(KDBizPromptBox bizPromptBox, GeneralAsstActTypeGroupInfo grp, String mappingFieldName, boolean isForCompany, boolean onlyLeaf, String acctid, CoreUIObject ui, boolean isEditUI, FilterInfo filter, boolean useLongNumber, String curCompanyId) {
        GLf7UtilsImpl.assignSelector(bizPromptBox, grp, mappingFieldName, isForCompany, onlyLeaf, false, false, acctid, null, ui, isEditUI, filter, true, useLongNumber, curCompanyId);
    }

    public void assignSelector(KDBizPromptBox bizPromptBox, GeneralAsstActTypeGroupInfo grp, String mappingFieldName, boolean isForCompany, boolean onlyLeaf, String acctid, CoreUIObject ui, boolean isEditUI, FilterInfo filter, boolean useLongNumber) {
        this.assignSelector(bizPromptBox, grp, mappingFieldName, isForCompany, onlyLeaf, false, false, acctid, null, ui, isEditUI, filter, true, useLongNumber);
    }

    public void assignSelector(KDBizPromptBox bizPromptBox, GeneralAsstActTypeGroupInfo grp, String mappingFieldName, boolean isForCompany, boolean onlyLeaf, String acctid, String curId, CoreUIObject ui, boolean isEditUI, boolean useLongNumber) {
        this.assignSelector(bizPromptBox, grp, mappingFieldName, isForCompany, onlyLeaf, false, false, acctid, curId, ui, isEditUI, null, true, useLongNumber);
    }

    public void assignSelector(KDBizPromptBox bizPromptBox, AsstActTypeInfo asstActTypeInfo, boolean onlyLeaf, boolean isUnUse, boolean isShowSealCost, String acctid, String curId, CoreUIObject ui, boolean isEditUI, FilterInfo f) {
        this.assignSelector(bizPromptBox, asstActTypeInfo.getGlAsstActTypeGrp(), asstActTypeInfo.getAsstHGAttribute(), asstActTypeInfo.isIsForCompany(), onlyLeaf, isUnUse, isShowSealCost, acctid, curId, ui, isEditUI, f, true, asstActTypeInfo.isUseLongNumber());
    }

    public void assignSelector(KDBizPromptBox bizPromptBox, VoucherInfo.DynamicColumnInfo colInfo, boolean onlyLeaf, String acctid, String curId, CoreUIObject ui, boolean isEditUI) {
        this.assignSelector(bizPromptBox, colInfo.getGrp(), colInfo.getMappingPropName(), colInfo.getIsForCompany(), onlyLeaf, false, false, acctid, curId, ui, isEditUI, null, colInfo.isUseLongNumber());
    }

    public void assignSelector(KDBizPromptBox bizPromptBox, GeneralAsstActTypeGroupInfo grp, String mappingFieldName, boolean isForCompany, boolean onlyLeaf, boolean isUnUse, boolean isShowSealCost, String acctid, String curId, CoreUIObject ui, boolean isEditUI, FilterInfo f, boolean useLongNumber) {
        this.assignSelector(bizPromptBox, grp, mappingFieldName, isForCompany, onlyLeaf, isUnUse, isShowSealCost, acctid, curId, ui, isEditUI, f, true, useLongNumber);
    }

    public void assignSelector(KDBizPromptBox bizPromptBox, GeneralAsstActTypeGroupInfo grp, String mappingFieldName, boolean isForCompany, boolean onlyLeaf, String acctid, CoreUIObject ui, boolean useLongNumber, String curCompanyId) {
        GLf7UtilsImpl.assignSelector(bizPromptBox, grp, mappingFieldName, isForCompany, true, acctid, ui, false, useLongNumber, curCompanyId);
    }

    public void assignSelector(KDBizPromptBox bizPromptBox, GeneralAsstActTypeGroupInfo grp, String mappingFieldName, boolean isForCompany, boolean onlyLeaf, boolean isUnUse, boolean isShowSealCost, String acctid, String curId, CoreUIObject ui, boolean isEditUI, FilterInfo f, boolean needListener, boolean useLongNumber) {
        FilterInfo fic;
        EntityViewInfo view;
        GLf7UtilsImpl.setParam(ui);
        CompanyOrgUnitInfo company = GLf7UtilsImpl.getFICompany(ui);
        String companyid = company.getId().toString();
        boolean isMasterBook = GLf7UtilsImpl.isMasterBook(ui);
        if (ui.getUIContext().get("COMPANYINFOID") != null) {
            companyid = ui.getUIContext().get("COMPANYINFOID").toString();
        }
        String cuid = company.getCU().getId().toString();
        if (company.getCU().getLongNumber() == null) {
            SelectorItemCollection sel = new SelectorItemCollection();
            sel.add("id");
            sel.add("longNumber");
            try {
                CtrlUnitInfo info = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cuid), sel);
                company.getCU().setLongNumber(info.getLongNumber());
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        bizPromptBox.setCurrentMainBizOrgUnit((OrgUnitInfo)company, OrgType.Company);
        boolean isBizUint = company.isIsBizUnit();
        EntityViewInfo v = new EntityViewInfo();
        SorterItemCollection s = v.getSorter();
        SorterItemInfo st = new SorterItemInfo("number");
        s.add(st);
        if (isForCompany && !mappingFieldName.equals("person") && !"CurProject".equalsIgnoreCase(mappingFieldName)) {
            FilterInfo filter = new FilterInfo();
            v.setFilter(filter);
            FilterItemCollection fic2 = filter.getFilterItems();
            fic2.add(new FilterItemInfo("company.id", (Object)companyid));
            fic2.add(new FilterItemInfo("company.id", null));
            String mbId = GLf7UtilsImpl.getCurrentMasterCompanyID(ui);
            if (!isMasterBook && mbId != null && !mbId.equals(companyid)) {
                fic2.add(new FilterItemInfo("company.id", (Object)mbId));
                filter.setMaskString("#0 OR #1 OR #2");
            } else {
                filter.setMaskString("#0 OR #1");
            }
        }
        bizPromptBox.setEntityViewInfo(v);
        SelectorItemCollection sic = bizPromptBox.getSelectorCollection();
        if (sic == null) {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            if (grp != null) {
                sic.add(new SelectorItemInfo("longNumber"));
            }
            bizPromptBox.setSelectorCollection(sic);
        }
        if (mappingFieldName != null && (mappingFieldName.equals("customer") || mappingFieldName.equals("provider") || mappingFieldName.equals("supplier"))) {
            sic.add(new SelectorItemInfo("browseGroup.id"));
            sic.add(new SelectorItemInfo("browseGroup.displayName"));
        }
        if (grp != null) {
            AuxAccountUtils.assignGeneralBizPromptBox((KDBizPromptBox)bizPromptBox, (String)grp.getId().toString(), (isUnUse || ui.getOprtState() == null || !ui.getOprtState().equals(OprtState.ADDNEW) && !ui.getOprtState().equals(OprtState.EDIT) && !ui.getOprtState().equals(OprtState.COPYADDNEW) ? 1 : 0) != 0, (CoreUIObject)ui);
            view = bizPromptBox.getEntityViewInfo();
            fic = view.getFilter();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
            try {
                fic.mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            bizPromptBox.getSelectorCollection().add("isLeaf");
        } else if (mappingFieldName != null) {
            FilterInfo filter;
            SorterItemCollection sorc;
            EntityViewInfo view2;
            SelectorItemCollection selectorCollection;
            if (mappingFieldName.equals("customer")) {
                selectorCollection = new SelectorItemCollection();
                selectorCollection.add(new SelectorItemInfo("id"));
                selectorCollection.add(new SelectorItemInfo("number"));
                selectorCollection.add(new SelectorItemInfo("name"));
                selectorCollection.add(new SelectorItemInfo("browseGroup.id"));
                selectorCollection.add(new SelectorItemInfo("browseGroup.displayName"));
                bizPromptBox.setSelectorCollection(selectorCollection);
                if (hasCPNumber) {
                    bizPromptBox.setCommitFormat("$number$");
                } else {
                    bizPromptBox.setCommitFormat("$mnemonicCode$;$number$;$name$;$mobile$");
                }
                view2 = new EntityViewInfo();
                SorterItemCollection sorc2 = view2.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc2.add(sort);
                FilterInfo filter2 = new FilterInfo();
                view2.setFilter(filter2);
                FilterItemCollection fic3 = filter2.getFilterItems();
                if (!isUnUse) {
                    fic3.add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                }
                filter2.appendFilterItem("companyOrgUnit.id", (Object)companyid);
                try {
                    FilterInfo Dfilter = GlWebServiceUtil.getDFilterInfo((IDataBaseD)CustomerFactory.getRemoteInstance(), cuid);
                    if (Dfilter != null) {
                        filter2.mergeFilter(Dfilter, "and");
                    }
                    if (f != null) {
                        filter2.mergeFilter(f, "and");
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                bizPromptBox.setEntityViewInfo(view2);
                try {
                    Context mainOrgContext = null;
                    try {
                        mainOrgContext = new Context();
                        FrameWorkUtils.switchOrg((Context)mainOrgContext, (String)company.getId().toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    GeneralKDPromptSelectorAdaptor gks = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7CustomerTreeDetailListUI(), (Object)ui, null, "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery", "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQueryWithDefaultStandard");
                    gks.setQueryProperty("mobile", "and");
                    gks.setNeedShowUnUsed(isUnUse);
                    gks.setMainOrgContext(mainOrgContext);
                    if (ui instanceof RptMultiColumnDesignUI) {
                        gks.setNeedShowUnUsed(true);
                    }
                    gks.setIsMultiSelect(bizPromptBox.isEnabledMultiSelection());
                    GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)gks);
                }
                catch (Exception er) {
                    logger.error((Object)er);
                }
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQueryWithDefaultStandard");
            } else if (mappingFieldName.equals("provider") || mappingFieldName.equals("supplier")) {
                selectorCollection = new SelectorItemCollection();
                selectorCollection.add(new SelectorItemInfo("id"));
                selectorCollection.add(new SelectorItemInfo("number"));
                selectorCollection.add(new SelectorItemInfo("name"));
                selectorCollection.add(new SelectorItemInfo("browseGroup.id"));
                selectorCollection.add(new SelectorItemInfo("browseGroup.displayName"));
                bizPromptBox.setSelectorCollection(selectorCollection);
                if (hasCPNumber) {
                    bizPromptBox.setCommitFormat("$number$");
                } else {
                    bizPromptBox.setCommitFormat("$mnemonicCode$;$number$;$name$;$mobile$");
                }
                view2 = new EntityViewInfo();
                SorterItemCollection sorc3 = view2.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc3.add(sort);
                FilterInfo filter3 = new FilterInfo();
                view2.setFilter(filter3);
                FilterItemCollection fic4 = filter3.getFilterItems();
                if (!isUnUse) {
                    fic4.add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                }
                filter3.appendFilterItem("companyOrgUnit.id", (Object)companyid);
                try {
                    FilterInfo Dfilter = GlWebServiceUtil.getDFilterInfo((IDataBaseD)SupplierFactory.getRemoteInstance(), cuid);
                    if (Dfilter != null) {
                        filter3.mergeFilter(Dfilter, "and");
                    }
                    if (f != null) {
                        filter3.mergeFilter(f, "and");
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                bizPromptBox.setEntityViewInfo(view2);
                try {
                    Context mainOrgContext = null;
                    try {
                        mainOrgContext = new Context();
                        FrameWorkUtils.switchOrg((Context)mainOrgContext, (String)company.getId().toString());
                    }
                    catch (Exception gks) {
                        // empty catch block
                    }
                    GeneralKDPromptSelectorAdaptor gks = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7SupplierTreeDetailListUI(), (Object)ui, null, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery", "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQueryWithDefaultStandard");
                    gks.setQueryProperty("mobile", "and");
                    gks.setMainOrgContext(mainOrgContext);
                    if (ui instanceof RptMultiColumnDesignUI) {
                        gks.setNeedShowUnUsed(true);
                    }
                    gks.setNeedShowUnUsed(isUnUse);
                    gks.setIsMultiSelect(bizPromptBox.isEnabledMultiSelection());
                    GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)gks);
                }
                catch (Exception er) {
                    logger.error((Object)er);
                }
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQueryWithDefaultStandard");
            } else if (mappingFieldName.equals("material")) {
                FilterInfo filter4 = v.getFilter();
                fic = filter4.getFilterItems();
                if (!isUnUse && isEditUI) {
                    fic.add(new FilterItemInfo("status", (Object)new Integer(1)));
                    fic.add(new FilterItemInfo("FIInfo.status", (Object)new Integer(1)));
                }
                filter4.appendFilterItem("orgUnit.id", (Object)companyid);
                try {
                    FilterInfo Dfilter = GlWebServiceUtil.getDFilterInfo((IDataBaseD)MaterialFactory.getRemoteInstance(), cuid);
                    if (Dfilter != null) {
                        filter4.mergeFilter(Dfilter, "and");
                    }
                    if (f != null) {
                        filter4.mergeFilter(f, "and");
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                bizPromptBox.setCommitParser((IParser)new MainDataParser(bizPromptBox));
                bizPromptBox.setCommitFormat("$helpCode$;$number$;$name$");
                try {
                    Context mainOrgContext = null;
                    try {
                        mainOrgContext = new Context();
                        FrameWorkUtils.switchOrg((Context)mainOrgContext, (String)company.getId().toString());
                    }
                    catch (Exception filter3) {
                        // empty catch block
                    }
                    GeneralKDPromptSelectorAdaptor gks = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7MaterialTreeListUI(), (Object)ui, "C79FC042", "com.kingdee.eas.basedata.master.material.app.F7MaterialFIQuery", "materialGroup.id", "orgUnit.id", "com.kingdee.eas.basedata.master.material.app.F7MaterialFINoGroupQuery");
                    gks.setMainOrgContext(mainOrgContext);
                    gks.setIsMultiSelect(bizPromptBox.isEnabledMultiSelection());
                    GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)gks);
                }
                catch (Exception er) {
                    logger.error((Object)er);
                }
                sic.add(new SelectorItemInfo("baseUnit.name"));
                sic.add(new SelectorItemInfo("baseUnit.number"));
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("materialGroup.id"));
                sic.add(new SelectorItemInfo("materialGroup.displayName"));
            } else if (mappingFieldName.equals("person")) {
                if (isBizUint && isChooseAsstCom) {
                    bizPromptBox.setCommitFormat("$number$;$name$;$idNum$");
                    HashMap map = new HashMap();
                    String fiId = GLf7UtilsImpl.getCurrentMasterCompanyID(ui);
                    try {
                        FIPersonPromptBox personf7 = new FIPersonPromptBox((IUIObject)ui, map);
                        personf7.setFI(fiId);
                        personf7.setIsSingleSelect(true);
                        if (isEditUI) {
                            personf7.setShowDelPersonChk(false);
                        }
                        GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)personf7);
                    }
                    catch (Exception er) {
                        logger.error((Object)er);
                    }
                    bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonFIQuery");
                    EntityViewInfo view3 = new EntityViewInfo();
                    SorterItemCollection sorc4 = view3.getSorter();
                    SorterItemInfo sort = new SorterItemInfo("number");
                    sorc4.add(sort);
                    FilterInfo filter5 = new FilterInfo();
                    view3.setFilter(filter5);
                    FilterItemCollection fic5 = filter5.getFilterItems();
                    fic5.add(new FilterItemInfo("fi.id", (Object)fiId));
                    bizPromptBox.setEntityViewInfo(view3);
                } else {
                    bizPromptBox.setCommitFormat("$number$;$name$;$idNum$");
                    PersonPromptBox personf7 = new PersonPromptBox((IUIObject)ui, null);
                    if (isOrgPermission) {
                        if (isPersonByCU) {
                            personf7.showUserAndCuRangeAdminOrg();
                        } else {
                            personf7.showUserRangAdminOrg();
                        }
                    } else if (isPersonByCU) {
                        personf7.setCU(cuid);
                    } else {
                        personf7.showAllAdmin();
                    }
                    if (isEditUI) {
                        personf7.setShowDelPersonChk(false);
                    }
                    try {
                        personf7.setEnabledMultiSelection(bizPromptBox.isEnabledMultiSelection());
                        GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)personf7);
                    }
                    catch (Exception er) {
                        logger.error((Object)er);
                    }
                    bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
                    if (isPersonByCU) {
                        view2 = new EntityViewInfo();
                        SorterItemCollection sorc5 = view2.getSorter();
                        SorterItemInfo sort = new SorterItemInfo("number");
                        sorc5.add(sort);
                        FilterInfo filter6 = new FilterInfo();
                        view2.setFilter(filter6);
                        FilterItemCollection fic6 = filter6.getFilterItems();
                        if (!isChooseAsstCom) {
                            fic6.add(new FilterItemInfo("CU2.id", (Object)cuid));
                            fic6.add(new FilterItemInfo("CU2.id", null, CompareType.NOTEQUALS));
                        }
                        bizPromptBox.setEntityViewInfo(view2);
                    }
                }
            } else if (mappingFieldName.equals("adminOrg")) {
                bizPromptBox.setCommitFormat("$simpleName$;$description$;$code$;$number$;$name$");
                view = new EntityViewInfo();
                sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter7 = new FilterInfo();
                view.setFilter(filter7);
                FilterItemCollection fic7 = filter7.getFilterItems();
                if (!isUnUse) {
                    fic7.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
                    fic7.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
                }
                bizPromptBox.setEntityViewInfo(view);
                if (isBizUint && isChooseAsstCom) {
                    bizPromptBox.setDefaultF7UIName(null);
                    OrgUnitDelegationF7 oudF7 = new OrgUnitDelegationF7(bizPromptBox, DelegationPartsEnum.THE_FROM_UNIT, OrgType.Admin);
                    String comid = GLf7UtilsImpl.getCurrentMasterCompanyID(ui);
                    if (!isMasterBook && comid != null && !comid.equals(companyid)) {
                        companyid = comid;
                    }
                    oudF7.setTheGivenOrgUnit(companyid, OrgType.Company);
                    try {
                        oudF7.setDataPermission("Admin_View");
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                    }
                    oudF7.setDoNotUseUserOrgRangeAsFilter();
                    oudF7.setIncludeSelfWhenSelfIsAlsoOfTheWantedType();
                    bizPromptBox.setCommitFormat("$simpleName$;$description$;$code$;$number$;$name$");
                    filter7 = bizPromptBox.getEntityViewInfo().getFilter();
                    fic7 = filter7.getFilterItems();
                    fic7.add(new FilterItemInfo("isLeaf", (Object)new Integer(1), CompareType.EQUALS));
                    int size = filter7.getFilterItems().size() - 1;
                    filter7.setMaskString("(" + filter7.getMaskString() + ")  and #" + size);
                } else {
                    if (onlyLeaf) {
                        fic7.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                    }
                    bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery4AsstAcct");
                    NewAdminF7 f7 = new NewAdminF7((IUIObject)ui);
                    f7.setDataPermission("Admin_View");
                    if (isChooseAsstCom || !isOrgPermission) {
                        f7.setNeedAddOrgRange(false);
                    } else {
                        f7.setNeedAddOrgRange(true);
                    }
                    f7.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
                    if (isAdminOrgByCU) {
                        fic7.add(new FilterItemInfo("CU.id", (Object)cuid));
                        f7.setIsCUFilter(true);
                    } else {
                        f7.setIsCUFilter(false);
                    }
                    if (ui.getOprtState() != null && (ui.getOprtState().equals(OprtState.ADDNEW) || ui.getOprtState().equals(OprtState.EDIT) || ui.getOprtState().equals(OprtState.COPYADDNEW))) {
                        fic7.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
                        f7.setContainSealUp(false);
                    } else {
                        f7.setContainSealUp(true);
                    }
                    f7.setMultiSelect(bizPromptBox.isEnabledMultiSelection());
                    GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)f7);
                }
                sic.add(new SelectorItemInfo("isLeaf"));
                sic.add(new SelectorItemInfo("displayName"));
                sic.add(new SelectorItemInfo("longNumber"));
            } else if (mappingFieldName.equals("project")) {
                view = new EntityViewInfo();
                sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter8 = new FilterInfo();
                view.setFilter(filter8);
                FilterItemCollection fic8 = filter8.getFilterItems();
                StringBuffer maskString = new StringBuffer();
                int index = 0;
                if (isEditUI) {
                    fic8.add(new FilterItemInfo("status", (Object)new Integer(2), CompareType.NOTEQUALS));
                    maskString.append("#").append(index++);
                }
                if (onlyLeaf) {
                    fic8.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                    if (maskString.length() > 0) {
                        maskString.append(" and #").append(index++);
                    } else {
                        maskString.append("#").append(index++);
                    }
                }
                if ("true".equals(AssitantUtil.getProjectIsolateParam())) {
                    fic8.add(new FilterItemInfo("company.id", (Object)GLf7UtilsImpl.getFICompany(ui).getId()));
                    if (maskString.length() > 0) {
                        maskString.append(" and #").append(index++);
                    } else {
                        maskString.append("#").append(index++);
                    }
                }
                filter8.setMaskString(maskString.toString());
                sic.add(new SelectorItemInfo("isLeaf"));
                sic.add(new SelectorItemInfo("displayName"));
                GeneralKDPromptSelectorAdaptor adaptor = null;
                try {
                    Context mainOrgContext = new Context();
                    FrameWorkUtils.switchOrg((Context)mainOrgContext, (String)company.getId().toString());
                    adaptor = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7ProjectUI(), (Object)ui, "com.kingdee.eas.basedata.assistant.app.F7ProjectQuery");
                    adaptor.setMainOrgContext(mainOrgContext);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                adaptor.setIsMultiSelect(bizPromptBox.isEnabledMultiSelection());
                GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, adaptor);
                bizPromptBox.setEntityViewInfo(view);
            } else if (mappingFieldName.equals("saleOrg") || mappingFieldName.equals("profitOrg") || mappingFieldName.equals("purchaseOrg") || mappingFieldName.equals("storeageOrg") || mappingFieldName.equals("companyOrg") || mappingFieldName.equals("orgUnit") || mappingFieldName.equals("costOrg")) {
                bizPromptBox.setCommitFormat("$code$;$number$;$name$");
                view = new EntityViewInfo();
                sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter9 = new FilterInfo();
                view.setFilter(filter9);
                FilterItemCollection fic9 = filter9.getFilterItems();
                fic9.add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("isLeaf"));
                sic.add(new SelectorItemInfo("isBizUnit"));
                sic.add(new SelectorItemInfo("displayName"));
                bizPromptBox.setEntityViewInfo(view);
                if (isBizUint && isChooseAsstCom && !mappingFieldName.equals("companyOrg")) {
                    GLf7UtilsImpl.setDelegationF7(bizPromptBox, mappingFieldName, ui, companyid, isMasterBook);
                } else {
                    GLf7UtilsImpl.setOrgF7(bizPromptBox, mappingFieldName, isShowSealCost, ui, cuid, fic9);
                }
            } else if ("bank".equalsIgnoreCase(mappingFieldName)) {
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7LeafBankQuery");
                GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)new BankF7Selector((IUIObject)ui, bizPromptBox));
            } else if ("bankAccount".equalsIgnoreCase(mappingFieldName)) {
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
                sic.add(new SelectorItemInfo("bankAccountNumber"));
                sic.add(new SelectorItemInfo("isByCurrency"));
                sic.add(new SelectorItemInfo("bank.name"));
                view = new EntityViewInfo();
                sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter10 = new FilterInfo();
                try {
                    filter10 = GlUtils.getBankAccountFilter(null, GLf7UtilsImpl.getFICompany(ui).getId().toString(), acctid, isCashEquivalentFilterAccount);
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                FilterItemCollection fic10 = filter10.getFilterItems();
                String maskString = filter10.getMaskString();
                int index = filter10.getFilterItems().size();
                if (curId != null) {
                    fic10.add(new FilterItemInfo("currency.id", (Object)curId));
                    fic10.add(new FilterItemInfo("currency.id", null));
                    maskString = maskString + " AND ( #" + index++ + " OR #" + index++ + ")";
                }
                if (ui.getOprtState() != null && (ui.getOprtState().equals(OprtState.ADDNEW) || ui.getOprtState().equals(OprtState.EDIT) || ui.getOprtState().equals(OprtState.COPYADDNEW))) {
                    fic10.add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
                    maskString = maskString + " AND #" + index++;
                }
                filter10.setMaskString(maskString);
                view.setFilter(filter10);
                bizPromptBox.setEntityViewInfo(view);
            } else if ("ntType".equalsIgnoreCase(mappingFieldName)) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic11 = filter.getFilterItems();
                if (isEditUI) {
                    fic11.add(new FilterItemInfo("isUsed", (Object)new Integer(1)));
                }
                bizPromptBox.setEntityViewInfo(view);
            } else if ("region".equalsIgnoreCase(mappingFieldName)) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic12 = filter.getFilterItems();
                if (isEditUI) {
                    fic12.add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
                }
                bizPromptBox.setEntityViewInfo(view);
            } else if ("city".equalsIgnoreCase(mappingFieldName)) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic13 = filter.getFilterItems();
                if (isEditUI) {
                    fic13.add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
                }
                bizPromptBox.setEntityViewInfo(view);
            } else if ("fpItem".equalsIgnoreCase(mappingFieldName)) {
                view = new EntityViewInfo();
                sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter11 = new FilterInfo();
                view.setFilter(filter11);
                FilterItemCollection fic14 = filter11.getFilterItems();
                fic14.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                bizPromptBox.setEntityViewInfo(view);
            } else if ("innerAccount".equalsIgnoreCase(mappingFieldName)) {
                bizPromptBox.setQueryInfo("com.kingdee.eas.fm.fs.F7InnerAccountQuery");
                view = new EntityViewInfo();
                sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter12 = new FilterInfo();
                view.setFilter(filter12);
                FilterItemCollection fic15 = filter12.getFilterItems();
                if (isEditUI) {
                    fic15.add(new FilterItemInfo("closed", (Object)new Integer(0)));
                }
                if (isForCompany) {
                    try {
                        if (BankFactory.getRemoteInstance().isClearinghouseCompany(companyid)) {
                            fic15.add(new FilterItemInfo("company.id", (Object)companyid));
                        } else {
                            fic15.add(new FilterItemInfo("applyUnit.id", (Object)companyid));
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
                bizPromptBox.setEntityViewInfo(view);
            } else if (mappingFieldName.equals("cashFlowItem")) {
                CashFlowItemF7Selector f7 = new CashFlowItemF7Selector((IUIObject)ui, bizPromptBox);
                f7.setMulti(bizPromptBox.isEnabledMultiSelection());
                GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)f7);
            } else {
                GLBizF7Assign.assignSelector(bizPromptBox, grp, mappingFieldName, isForCompany, onlyLeaf, false, acctid, curId, ui, isEditUI, f, useLongNumber);
            }
        }
        if (onlyLeaf && needListener && bizPromptBox.getClientProperty((Object)"VoucherAsstDataChangeListener") == null) {
            VoucherAsstDataChangeListener ls = new VoucherAsstDataChangeListener(ui, mappingFieldName, isPersonByCU, useLongNumber);
            bizPromptBox.addDataChangeListener((DataChangeListener)ls);
            bizPromptBox.putClientProperty((Object)"VoucherAsstDataChangeListener", (Object)ls);
        }
        if (useLongNumber && (sic = bizPromptBox.getSelectorCollection()) != null) {
            sic.add(new SelectorItemInfo("longNumber"));
        }
    }

    public static void assignSelector(KDBizPromptBox bizPromptBox, GeneralAsstActTypeGroupInfo grp, String mappingFieldName, boolean isForCompany, boolean onlyLeaf, boolean isUnUse, boolean isShowSealCost, String acctid, String curId, CoreUIObject ui, boolean isEditUI, FilterInfo f, boolean needListener, boolean useLongNumber, String companyId) {
        GLf7UtilsImpl.setParam(ui, companyId);
        boolean isMasterBook = BooksUtil.isMasterBook(null);
        if (ui.getUIContext().get("COMPANYINFOID") != null) {
            companyId = ui.getUIContext().get("COMPANYINFOID").toString();
        }
        boolean isBizUint = false;
        CompanyOrgUnitInfo curCompanyInfo = null;
        SelectorItemCollection selColl = new SelectorItemCollection();
        selColl.add(new SelectorItemInfo("*"));
        selColl.add(new SelectorItemInfo("CU.*"));
        try {
            curCompanyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selColl);
            isBizUint = curCompanyInfo.isIsBizUnit();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        String cuid = curCompanyInfo.getCU().getId().toString();
        EntityViewInfo v = new EntityViewInfo();
        SorterItemCollection s = v.getSorter();
        SorterItemInfo st = new SorterItemInfo("number");
        s.add(st);
        if (isForCompany && !mappingFieldName.equals("person") && !"CurProject".equalsIgnoreCase(mappingFieldName)) {
            FilterInfo filter = new FilterInfo();
            v.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("company.id", (Object)companyId));
            fic.add(new FilterItemInfo("company.id", null));
            String mbId = GLf7UtilsImpl.getCurrentMasterCompanyID(ui);
            if (!isMasterBook && mbId != null && !mbId.equals(companyId)) {
                fic.add(new FilterItemInfo("company.id", (Object)mbId));
                filter.setMaskString("#0 OR #1 OR #2");
            } else {
                filter.setMaskString("#0 OR #1");
            }
        }
        bizPromptBox.setEntityViewInfo(v);
        SelectorItemCollection sic = bizPromptBox.getSelectorCollection();
        if (sic == null) {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            if (grp != null) {
                sic.add(new SelectorItemInfo("longNumber"));
            }
            bizPromptBox.setSelectorCollection(sic);
        }
        if (mappingFieldName != null) {
            FilterInfo filter;
            FilterItemCollection fic;
            FilterInfo filter2;
            SorterItemCollection sorc;
            EntityViewInfo view;
            if (mappingFieldName.equals("customer")) {
                if (hasCPNumber) {
                    bizPromptBox.setCommitFormat("$number$");
                } else {
                    bizPromptBox.setCommitFormat("$mnemonicCode$;$number$;$name$;$mobile$");
                }
                view = new EntityViewInfo();
                sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter3 = new FilterInfo();
                view.setFilter(filter3);
                FilterItemCollection fic2 = filter3.getFilterItems();
                if (!isUnUse) {
                    fic2.add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                }
                filter3.appendFilterItem("companyOrgUnit.id", (Object)companyId);
                try {
                    FilterInfo Dfilter = GlWebServiceUtil.getDFilterInfo((IDataBaseD)CustomerFactory.getRemoteInstance(), cuid);
                    if (Dfilter != null) {
                        filter3.mergeFilter(Dfilter, "and");
                    }
                    if (f != null) {
                        filter3.mergeFilter(f, "and");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                bizPromptBox.setEntityViewInfo(view);
                try {
                    GeneralKDPromptSelectorAdaptor gks = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7CustomerTreeDetailListUI(), (Object)ui, null, "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery", "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQueryWithDefaultStandard");
                    gks.setQueryProperty("mobile", "and");
                    gks.setNeedShowUnUsed(isUnUse);
                    gks.setCUId(cuid);
                    Context mainOrgContext = new Context();
                    FrameWorkUtils.switchOrg((Context)mainOrgContext, (String)companyId);
                    gks.setMainOrgContext(mainOrgContext);
                    if (ui instanceof RptMultiColumnDesignUI) {
                        gks.setNeedShowUnUsed(true);
                    }
                    GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)gks);
                }
                catch (Exception er) {
                    er.printStackTrace();
                }
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQueryWithDefaultStandard");
            } else if (mappingFieldName.equals("provider")) {
                if (hasCPNumber) {
                    bizPromptBox.setCommitFormat("$number$");
                } else {
                    bizPromptBox.setCommitFormat("$mnemonicCode$;$number$;$name$;$mobile$");
                }
                view = new EntityViewInfo();
                sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter4 = new FilterInfo();
                view.setFilter(filter4);
                FilterItemCollection fic3 = filter4.getFilterItems();
                if (!isUnUse) {
                    fic3.add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                }
                filter4.appendFilterItem("companyOrgUnit.id", (Object)companyId);
                try {
                    FilterInfo Dfilter = GlWebServiceUtil.getDFilterInfo((IDataBaseD)SupplierFactory.getRemoteInstance(), cuid);
                    if (Dfilter != null) {
                        filter4.mergeFilter(Dfilter, "and");
                    }
                    if (f != null) {
                        filter4.mergeFilter(f, "and");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                bizPromptBox.setEntityViewInfo(view);
                try {
                    GeneralKDPromptSelectorAdaptor gks = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7SupplierTreeDetailListUI(), (Object)ui, null, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery", "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQueryWithDefaultStandard");
                    gks.setQueryProperty("mobile", "and");
                    gks.setCUId(cuid);
                    Context mainOrgContext = new Context();
                    FrameWorkUtils.switchOrg((Context)mainOrgContext, (String)companyId);
                    gks.setMainOrgContext(mainOrgContext);
                    if (ui instanceof RptMultiColumnDesignUI) {
                        gks.setNeedShowUnUsed(true);
                    }
                    gks.setNeedShowUnUsed(isUnUse);
                    GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)gks);
                }
                catch (Exception er) {
                    er.printStackTrace();
                }
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQueryWithDefaultStandard");
            } else if (mappingFieldName.equals("material")) {
                filter2 = v.getFilter();
                fic = filter2.getFilterItems();
                if (!isUnUse) {
                    fic.add(new FilterItemInfo("status", (Object)new Integer(1)));
                    fic.add(new FilterItemInfo("FIInfo.status", (Object)new Integer(1)));
                }
                filter2.appendFilterItem("orgUnit.id", (Object)companyId);
                try {
                    FilterInfo Dfilter = GlWebServiceUtil.getDFilterInfo((IDataBaseD)MaterialFactory.getRemoteInstance(), cuid);
                    if (Dfilter != null) {
                        filter2.mergeFilter(Dfilter, "and");
                    }
                    if (f != null) {
                        filter2.mergeFilter(f, "and");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                bizPromptBox.setCommitFormat("$helpCode$;$number$;$name$");
                try {
                    F7MaterialTreeListUI f7MaterialUI = new F7MaterialTreeListUI();
                    f7MaterialUI.setFilterCUID(curCompanyInfo.getCU().getId().toString());
                    GeneralKDPromptSelectorAdaptor generalKDPromptSelectorAdaptor = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)f7MaterialUI, (Object)ui, "C79FC042", "com.kingdee.eas.basedata.master.material.app.F7MaterialFIQuery", "materialGroup.id", "orgUnit.id", "com.kingdee.eas.basedata.master.material.app.F7MaterialFINoGroupQuery");
                    generalKDPromptSelectorAdaptor.setCUId(curCompanyInfo.getCU().getId().toString());
                    Context mainOrgContext = new Context();
                    FrameWorkUtils.switchOrg((Context)mainOrgContext, (String)companyId);
                    generalKDPromptSelectorAdaptor.setMainOrgContext(mainOrgContext);
                    GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)generalKDPromptSelectorAdaptor);
                }
                catch (Exception er) {
                    er.printStackTrace();
                }
                sic.add(new SelectorItemInfo("baseUnit.name"));
                sic.add(new SelectorItemInfo("baseUnit.number"));
            } else if (mappingFieldName.equals("person")) {
                if (isBizUint && isChooseAsstCom) {
                    bizPromptBox.setCommitFormat("$number$;$name$;$idNum$");
                    HashMap map = new HashMap();
                    String fiId = GLf7UtilsImpl.getCurrentMasterCompanyID(null, companyId);
                    try {
                        FIPersonPromptBox personf7 = new FIPersonPromptBox((IUIObject)ui, map);
                        personf7.setFI(fiId);
                        personf7.setIsSingleSelect(true);
                        GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)personf7);
                    }
                    catch (Exception er) {
                        er.printStackTrace();
                    }
                    bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonFIQuery");
                    EntityViewInfo view2 = new EntityViewInfo();
                    SorterItemCollection sorc2 = view2.getSorter();
                    SorterItemInfo sort = new SorterItemInfo("number");
                    sorc2.add(sort);
                    FilterInfo filter5 = new FilterInfo();
                    view2.setFilter(filter5);
                    FilterItemCollection fic4 = filter5.getFilterItems();
                    fic4.add(new FilterItemInfo("fi.id", (Object)fiId));
                    bizPromptBox.setEntityViewInfo(view2);
                } else {
                    bizPromptBox.setCommitFormat("$number$;$name$;$idNum$");
                    PersonPromptBox personf7 = new PersonPromptBox((IUIObject)ui, null);
                    personf7.showAllChildren();
                    personf7.setCU(cuid);
                    personf7.setExpandAdmin(companyId);
                    if (isOrgPermission) {
                        if (isPersonByCU) {
                            personf7.showUserAndCuRangeAdminOrg();
                        } else {
                            personf7.showUserRangAdminOrg();
                        }
                    } else if (isPersonByCU) {
                        personf7.setCU(cuid);
                    } else {
                        personf7.showAllAdmin();
                    }
                    try {
                        GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)personf7);
                    }
                    catch (Exception er) {
                        er.printStackTrace();
                    }
                    bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
                    if (isPersonByCU) {
                        EntityViewInfo view3 = new EntityViewInfo();
                        SorterItemCollection sorc3 = view3.getSorter();
                        SorterItemInfo sort = new SorterItemInfo("number");
                        sorc3.add(sort);
                        FilterInfo filter6 = new FilterInfo();
                        view3.setFilter(filter6);
                        FilterItemCollection fic5 = filter6.getFilterItems();
                        if (!isChooseAsstCom) {
                            fic5.add(new FilterItemInfo("CU2.id", (Object)cuid));
                            fic5.add(new FilterItemInfo("CU2.id", null, CompareType.NOTEQUALS));
                        }
                        bizPromptBox.setEntityViewInfo(view3);
                    }
                }
            } else if (mappingFieldName.equals("adminOrg")) {
                bizPromptBox.setCommitFormat("$simpleName$;$description$;$code$;$number$;$name$");
                view = new EntityViewInfo();
                sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter7 = new FilterInfo();
                view.setFilter(filter7);
                FilterItemCollection fic6 = filter7.getFilterItems();
                if (!isUnUse) {
                    fic6.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
                    fic6.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
                }
                bizPromptBox.setEntityViewInfo(view);
                if (isBizUint && isChooseAsstCom) {
                    bizPromptBox.setDefaultF7UIName(null);
                    OrgUnitDelegationF7 oudF7 = new OrgUnitDelegationF7(bizPromptBox, DelegationPartsEnum.THE_FROM_UNIT, OrgType.Admin);
                    String comid = GLf7UtilsImpl.getCurrentMasterCompanyID(null, companyId);
                    if (!isMasterBook && comid != null && !comid.equals(companyId)) {
                        companyId = comid;
                    }
                    oudF7.setTheGivenOrgUnit(companyId, OrgType.Company);
                    oudF7.setDoNotUseUserOrgRangeAsFilter();
                    oudF7.setIncludeSelfWhenSelfIsAlsoOfTheWantedType();
                    bizPromptBox.setCommitFormat("$simpleName$;$description$;$code$;$number$;$name$");
                    filter7 = bizPromptBox.getEntityViewInfo().getFilter();
                    fic6 = filter7.getFilterItems();
                    fic6.add(new FilterItemInfo("isLeaf", (Object)new Integer(1), CompareType.EQUALS));
                    int size = filter7.getFilterItems().size() - 1;
                    filter7.setMaskString("(" + filter7.getMaskString() + ")  and #" + size);
                } else {
                    if (onlyLeaf) {
                        fic6.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                    }
                    bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery4AsstAcct");
                    NewAdminF7 f7 = new NewAdminF7((IUIObject)ui);
                    if (!isOrgPermission) {
                        f7.setUsePerm(false);
                    } else {
                        f7.setUsePerm(true);
                    }
                    f7.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
                    if (isAdminOrgByCU) {
                        fic6.add(new FilterItemInfo("CU.id", (Object)cuid));
                        f7.setIsCUFilter(true);
                    } else {
                        f7.setIsCUFilter(false);
                    }
                    if (ui.getOprtState() != null && (ui.getOprtState().equals(OprtState.ADDNEW) || ui.getOprtState().equals(OprtState.EDIT) || ui.getOprtState().equals(OprtState.COPYADDNEW))) {
                        fic6.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
                        f7.setContainSealUp(false);
                    } else {
                        f7.setContainSealUp(false);
                    }
                    GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)f7);
                }
                sic.add(new SelectorItemInfo("isLeaf"));
                sic.add(new SelectorItemInfo("displayName"));
                sic.add(new SelectorItemInfo("longNumber"));
            } else if (mappingFieldName.equals("project")) {
                view = new EntityViewInfo();
                sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter8 = new FilterInfo();
                view.setFilter(filter8);
                FilterItemCollection fic7 = filter8.getFilterItems();
                StringBuffer maskString = new StringBuffer();
                int index = 0;
                if (isEditUI) {
                    fic7.add(new FilterItemInfo("status", (Object)new Integer(2), CompareType.NOTEQUALS));
                    maskString.append("#").append(index++);
                }
                if (onlyLeaf) {
                    fic7.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                    if (maskString.length() > 0) {
                        maskString.append(" and #").append(index++);
                    } else {
                        maskString.append("#").append(index++);
                    }
                }
                if ("true".equals(AssitantUtil.getProjectIsolateParam())) {
                    fic7.add(new FilterItemInfo("company.id", (Object)companyId));
                    if (maskString.length() > 0) {
                        maskString.append(" and #").append(index++);
                    } else {
                        maskString.append("#").append(index++);
                    }
                }
                filter8.setMaskString(maskString.toString());
                sic.add(new SelectorItemInfo("isLeaf"));
                sic.add(new SelectorItemInfo("displayName"));
                GeneralKDPromptSelectorAdaptor adaptor = null;
                try {
                    adaptor = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7ProjectUI(), (Object)ui, "com.kingdee.eas.basedata.assistant.app.F7ProjectQuery");
                    adaptor.setCUId(cuid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, adaptor);
                bizPromptBox.setEntityViewInfo(view);
            } else if (mappingFieldName.equals("saleOrg") || mappingFieldName.equals("profitOrg") || mappingFieldName.equals("purchaseOrg") || mappingFieldName.equals("storeageOrg") || mappingFieldName.equals("companyOrg") || mappingFieldName.equals("orgUnit") || mappingFieldName.equals("costOrg")) {
                bizPromptBox.setCommitFormat("$code$;$number$;$name$");
                view = new EntityViewInfo();
                sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter9 = new FilterInfo();
                view.setFilter(filter9);
                FilterItemCollection fic8 = filter9.getFilterItems();
                fic8.add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("isLeaf"));
                sic.add(new SelectorItemInfo("isBizUnit"));
                sic.add(new SelectorItemInfo("displayName"));
                bizPromptBox.setEntityViewInfo(view);
                if (isBizUint && isChooseAsstCom && !mappingFieldName.equals("companyOrg")) {
                    Object orgType = mappingFieldName.equals("saleOrg") ? OrgType.Sale : (mappingFieldName.equals("profitOrg") ? OrgType.ProfitCenter : (mappingFieldName.equals("purchaseOrg") ? OrgType.Purchase : (mappingFieldName.equals("storeageOrg") ? OrgType.Storage : (mappingFieldName.equals("companyOrg") ? OrgType.Company : (mappingFieldName.equals("costOrg") ? OrgType.CostCenter : (mappingFieldName.equals("orgUnit") ? OrgType.Company : null))))));
                    String comid = GLf7UtilsImpl.getCurrentMasterCompanyID(null, companyId);
                    if (!isMasterBook && comid != null && !comid.equals(companyId)) {
                        companyId = comid;
                    }
                    bizPromptBox.setDefaultF7UIName(null);
                    OrgUnitDelegationF7 oudF7 = new OrgUnitDelegationF7(bizPromptBox, DelegationPartsEnum.THE_FROM_UNIT, orgType);
                    oudF7.setTheGivenOrgUnit(companyId, OrgType.Company);
                    oudF7.setNeedUserOrgRangeAsFilter(false);
                    oudF7.setIncludeSelfWhenSelfIsAlsoOfTheWantedType();
                    bizPromptBox.setCommitFormat("$code$;$number$;$name$");
                    if (OprtState.ADDNEW.equals(ui.getOprtState()) || OprtState.EDIT.equals(ui.getOprtState()) || OprtState.COPYADDNEW.equals(ui.getOprtState())) {
                        FilterInfo filterInfo = bizPromptBox.getEntityViewInfo().getFilter();
                        FilterInfo sealUpFilterInfo = new FilterInfo();
                        sealUpFilterInfo.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(1), CompareType.NOTEQUALS));
                        try {
                            filterInfo.mergeFilter(sealUpFilterInfo, "and");
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                        bizPromptBox.getEntityViewInfo().setFilter(filterInfo);
                    }
                } else {
                    CompanyF7WithDataPerm f7 = null;
                    if (mappingFieldName.equals("companyOrg") || mappingFieldName.equals("orgUnit")) {
                        bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery4AsstAcct");
                        f7 = new CompanyF7WithDataPerm((IUIObject)ui);
                        f7.disablePerm();
                        if (curCompanyInfo.isIsAssistantOrg()) {
                            f7.setShowAssistantOrg(true);
                        }
                        f7.showCheckBoxOfShowingAllOUs();
                        f7.setIsCUFilter(false);
                    } else {
                        if (!mappingFieldName.equals("costOrg") || mappingFieldName.equals("costOrg") && isAdminOrgByCU) {
                            fic8.add(new FilterItemInfo("CU.id", (Object)cuid));
                        }
                        if (mappingFieldName.equals("costOrg")) {
                            bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterOrgUnitQuery4AsstAcct");
                            f7 = new CostCenterF7WithDataPerm((IUIObject)ui);
                            f7.setIsShowContainSealUp(isShowSealCost);
                            if (!isOrgPermission) {
                                f7.disablePerm();
                            } else {
                                filter9 = GLf7UtilsImpl.getOrgFilterInfo(cuid, OrgViewType.COSTCENTER, filter9);
                            }
                        } else if (mappingFieldName.equals("saleOrg")) {
                            bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery4AsstAcct");
                            f7 = new SaleF7WithDataPerm((IUIObject)ui);
                            if (!isOrgPermission) {
                                f7.disablePerm();
                            } else {
                                filter9 = GLf7UtilsImpl.getOrgFilterInfo(cuid, OrgViewType.SALE, filter9);
                            }
                        } else if (mappingFieldName.equals("profitOrg")) {
                            bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.ProfitCenterOrgUnitQuery4AsstAcct");
                            f7 = new ProfitCenterF7WithDataPerm((IUIObject)ui);
                            if (!isOrgPermission) {
                                f7.disablePerm();
                            } else {
                                filter9 = GLf7UtilsImpl.getOrgFilterInfo(cuid, OrgViewType.PROFITCENTER, filter9);
                            }
                        } else if (mappingFieldName.equals("purchaseOrg")) {
                            bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery4AsstAcct");
                            f7 = new PurchaseF7WithDataPerm((IUIObject)ui);
                            if (!isOrgPermission) {
                                f7.disablePerm();
                            } else {
                                filter9 = GLf7UtilsImpl.getOrgFilterInfo(cuid, OrgViewType.PURCHASE, filter9);
                            }
                        } else if (mappingFieldName.equals("storeageOrg")) {
                            bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery4AsstAcct");
                            f7 = new StorageF7WithDataPerm((IUIObject)ui);
                            if (!isOrgPermission) {
                                f7.disablePerm();
                            } else {
                                filter9 = GLf7UtilsImpl.getOrgFilterInfo(cuid, OrgViewType.STORAGE, filter9);
                            }
                        }
                        if (f7 != null) {
                            if (isAdminOrgByCU) {
                                fic8.add(new FilterItemInfo("CU.id", (Object)cuid));
                                f7.setIsCUFilter(true);
                            } else {
                                f7.showCheckBoxOfShowingAllOUs();
                                f7.setIsCUFilter(false);
                            }
                        }
                    }
                    if (f7 != null) {
                        if (ui.getOprtState() != null && (ui.getOprtState().equals(OprtState.ADDNEW) || ui.getOprtState().equals(OprtState.EDIT) || ui.getOprtState().equals(OprtState.COPYADDNEW))) {
                            fic8.add(new FilterItemInfo("isSealUp", (Object)0));
                            f7.setIsShowContainSealUp(false);
                            f7.setContainSealUp(false);
                        } else {
                            f7.setIsShowContainSealUp(true);
                            f7.setContainSealUp(false);
                        }
                    }
                    GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)f7);
                }
            } else if ("bank".equalsIgnoreCase(mappingFieldName)) {
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7LeafBankQuery");
                GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)new BankF7Selector((IUIObject)ui, bizPromptBox));
            } else if ("bankAccount".equalsIgnoreCase(mappingFieldName)) {
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
                sic.add(new SelectorItemInfo("bankAccountNumber"));
                sic.add(new SelectorItemInfo("isByCurrency"));
                sic.add(new SelectorItemInfo("bank.name"));
                view = new EntityViewInfo();
                sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter10 = new FilterInfo();
                view.setFilter(filter10);
                String maskString = "";
                int index = 0;
                boolean unMaster = !GLf7UtilsImpl.getBook(null, companyId).isIsMaster();
                FilterItemCollection fic9 = filter10.getFilterItems();
                if (unMaster) {
                    String mastercompanyid = GLf7UtilsImpl.getCurrentMasterCompanyID(null, companyId);
                    fic9.add(new FilterItemInfo("company.id", (Object)mastercompanyid));
                    maskString = maskString + " (#0 or #1) ";
                    index = 2;
                } else {
                    maskString = maskString + "  #0 ";
                    index = 1;
                }
                if (ui.getUIContext().get("bankAccountCompanyIds") != null) {
                    Set idSet = (Set)ui.getUIContext().get("bankAccountCompanyIds");
                    fic9.add(new FilterItemInfo("company.id", (Object)idSet, CompareType.INCLUDE));
                } else {
                    fic9.add(new FilterItemInfo("company.id", (Object)companyId));
                }
                try {
                    IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
                    if (acctid != null && (!unMaster || unMaster && BooksUtil.isSameAccountTable(null))) {
                        SelectorItemCollection sicAcct = new SelectorItemCollection();
                        sicAcct.add(new SelectorItemInfo("id"));
                        sicAcct.add(new SelectorItemInfo("longnumber"));
                        sicAcct.add(new SelectorItemInfo("isBank"));
                        sicAcct.add(new SelectorItemInfo("isCashEquivalent"));
                        sicAcct.add(new SelectorItemInfo("accountTableID.id"));
                        AccountViewInfo account = iAccountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(acctid), sicAcct);
                        if (account.isIsBank() || isCashEquivalentFilterAccount && account.isIsCashEquivalent()) {
                            CompanyOrgUnitInfo masterOrg = curCompanyInfo.getMainOrg();
                            if (unMaster && masterOrg != null) {
                                EntityViewInfo evi = new EntityViewInfo();
                                evi.getSelector().add(new SelectorItemInfo("id"));
                                evi.getSelector().add(new SelectorItemInfo("longNumber"));
                                evi.getSelector().add(new SelectorItemInfo("accountTableID.id"));
                                FilterInfo fi = new FilterInfo();
                                evi.setFilter(fi);
                                fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)account.getLongNumber()));
                                fi.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)masterOrg.getId().toString()));
                                fi.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)account.getAccountTableID().getId().toString()));
                                AccountViewCollection avColl = iAccountView.getAccountViewCollection(evi);
                                if (avColl != null && avColl.size() > 0) {
                                    fic9.add(new FilterItemInfo("account.id", (Object)acctid));
                                    fic9.add(new FilterItemInfo("account.id", (Object)avColl.get(0).getId().toString()));
                                    maskString = maskString + " AND (#" + index++ + " or #" + index++ + ")";
                                } else {
                                    fic9.add(new FilterItemInfo("account.id", (Object)acctid));
                                    maskString = maskString + " AND #" + index++;
                                }
                            } else {
                                fic9.add(new FilterItemInfo("account.id", (Object)acctid));
                                maskString = maskString + " AND #" + index++;
                            }
                        } else {
                            acctid = null;
                        }
                    } else if (acctid != null && unMaster && !BooksUtil.isSameAccountTable(null)) {
                        SelectorItemCollection sicAcct = new SelectorItemCollection();
                        sicAcct.add(new SelectorItemInfo("isBank"));
                        sicAcct.add(new SelectorItemInfo("isCashEquivalent"));
                        sicAcct.add(new SelectorItemInfo("accountTableID"));
                        AccountViewInfo account = iAccountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(acctid), sicAcct);
                        AccountViewInfo accountMaster = AccountUtils.getSrcAccountViewByRef(null, (AccountViewInfo)account, (CompanyOrgUnitInfo)curCompanyInfo.getMainOrg(), (CompanyOrgUnitInfo)curCompanyInfo);
                        if (account.isIsBank() || isCashEquivalentFilterAccount && account.isIsCashEquivalent()) {
                            fic9.add(new FilterItemInfo("account.id", (Object)acctid));
                            maskString = maskString + " AND (#" + index++;
                            if (accountMaster != null && accountMaster.isIsBank() || isCashEquivalentFilterAccount && account.isIsCashEquivalent()) {
                                fic9.add(new FilterItemInfo("account.id", (Object)accountMaster.getId()));
                                maskString = maskString + " OR #" + index++;
                            }
                            maskString = maskString + ")";
                        } else {
                            acctid = null;
                        }
                    }
                }
                catch (Exception e) {
                    ui.handUIException((Throwable)e);
                }
                if (curId != null) {
                    fic9.add(new FilterItemInfo("currency.id", (Object)curId));
                    fic9.add(new FilterItemInfo("currency.id", null));
                    maskString = maskString + " AND ( #" + index++ + " OR #" + index++ + ")";
                }
                if (ui.getOprtState() != null && (ui.getOprtState().equals(OprtState.ADDNEW) || ui.getOprtState().equals(OprtState.EDIT) || ui.getOprtState().equals(OprtState.COPYADDNEW))) {
                    fic9.add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
                    maskString = maskString + " AND #" + index++;
                }
                filter10.setMaskString(maskString);
                bizPromptBox.setEntityViewInfo(view);
            } else if ("room".equalsIgnoreCase(mappingFieldName) || "building".equalsIgnoreCase(mappingFieldName)) {
                filter2 = new FilterInfo();
                fic = filter2.getFilterItems();
                if (!sic.contains(new SelectorItemInfo("displayName"))) {
                    sic.add(new SelectorItemInfo("displayName"));
                }
                v.setFilter(filter2);
            } else if ("CurProject".equalsIgnoreCase(mappingFieldName)) {
                boolean unMaster;
                filter2 = new FilterInfo();
                fic = filter2.getFilterItems();
                if (!sic.contains(new SelectorItemInfo("longNumber"))) {
                    sic.add(new SelectorItemInfo("longNumber"));
                }
                SorterItemCollection sorc4 = v.getSorter();
                SorterItemInfo sort = new SorterItemInfo("longNumber");
                sorc4.remove(sorc4.get(0));
                sorc4.add(sort);
                v.setFilter(filter2);
                String maskString = "";
                boolean bl = unMaster = !GLf7UtilsImpl.getBook(null, companyId).isIsMaster();
                if (isForCompany) {
                    try {
                        if (!BankFactory.getRemoteInstance().isClearinghouseCompany(companyId)) {
                            if (unMaster) {
                                String mastercompanyid = GLf7UtilsImpl.getCurrentMasterCompanyID(null, companyId);
                                fic.add(new FilterItemInfo("fullOrgUnit.id", (Object)companyId));
                                fic.add(new FilterItemInfo("fullOrgUnit.id", (Object)mastercompanyid));
                                maskString = maskString + " (#0 or #1) ";
                            } else {
                                fic.add(new FilterItemInfo("fullOrgUnit.id", (Object)companyId));
                                maskString = maskString + "  #0 ";
                            }
                            filter2.setMaskString(maskString);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if ("ntType".equalsIgnoreCase(mappingFieldName)) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic10 = filter.getFilterItems();
                if (isEditUI) {
                    fic10.add(new FilterItemInfo("isUsed", (Object)new Integer(1)));
                }
                bizPromptBox.setEntityViewInfo(view);
            } else if ("region".equalsIgnoreCase(mappingFieldName)) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic11 = filter.getFilterItems();
                if (isEditUI) {
                    fic11.add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
                }
                bizPromptBox.setEntityViewInfo(view);
            } else if ("fpItem".equalsIgnoreCase(mappingFieldName)) {
                view = new EntityViewInfo();
                sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter11 = new FilterInfo();
                view.setFilter(filter11);
                FilterItemCollection fic12 = filter11.getFilterItems();
                fic12.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
                bizPromptBox.setEntityViewInfo(view);
            } else if ("innerAccount".equalsIgnoreCase(mappingFieldName)) {
                bizPromptBox.setQueryInfo("com.kingdee.eas.fm.fs.F7InnerAccountQuery");
                view = new EntityViewInfo();
                sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter12 = new FilterInfo();
                view.setFilter(filter12);
                FilterItemCollection fic13 = filter12.getFilterItems();
                if (isEditUI) {
                    fic13.add(new FilterItemInfo("closed", (Object)new Integer(0)));
                }
                if (isForCompany) {
                    try {
                        if (BankFactory.getRemoteInstance().isClearinghouseCompany(companyId)) {
                            fic13.add(new FilterItemInfo("company.id", (Object)companyId));
                        } else {
                            fic13.add(new FilterItemInfo("applyUnit.id", (Object)companyId));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                bizPromptBox.setEntityViewInfo(view);
            } else if (mappingFieldName.equals("cashFlowItem")) {
                GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)new CashFlowItemF7Selector((IUIObject)ui, bizPromptBox));
            } else {
                GLBizF7Assign.assignSelector(bizPromptBox, grp, mappingFieldName, isForCompany, onlyLeaf, false, acctid, curId, ui, isEditUI, f, useLongNumber);
                bizPromptBox.setCurrentCtrlUnit(curCompanyInfo.getCU());
            }
        }
        if (onlyLeaf && needListener && bizPromptBox.getClientProperty((Object)"VoucherAsstDataChangeListener") == null) {
            VoucherAsstDataChangeListener ls = new VoucherAsstDataChangeListener(ui, mappingFieldName, isPersonByCU, useLongNumber);
            bizPromptBox.addDataChangeListener((DataChangeListener)ls);
            bizPromptBox.putClientProperty((Object)"VoucherAsstDataChangeListener", (Object)ls);
        }
        if (useLongNumber && (sic = bizPromptBox.getSelectorCollection()) != null) {
            sic.add(new SelectorItemInfo("longNumber"));
        }
    }

    private static void assignSelector(KDPromptBox promptBox, KDPromptSelector selector) {
        promptBox.setSelector(selector);
    }

    public void assignAccount(KDBizPromptBox bizAccountPromptBox, FilterInfo fi, CoreUIObject ui) {
        KDPromptSelector selector;
        CompanyOrgUnitInfo com = GLf7UtilsImpl.getFICompany(ui);
        bizAccountPromptBox.setEditable(true);
        bizAccountPromptBox.setEditFormat("$number$");
        bizAccountPromptBox.setDisplayFormat("$number$");
        bizAccountPromptBox.setCommitFormat("$helpCode$;$number$;$name$");
        bizAccountPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("AC"));
        sic.add(new SelectorItemInfo("control"));
        sic.add(new SelectorItemInfo("isCash"));
        sic.add(new SelectorItemInfo("isBank"));
        sic.add(new SelectorItemInfo("isCashEquivalent"));
        sic.add(new SelectorItemInfo("hasUserProperty"));
        sic.add(new SelectorItemInfo("isGFreeze"));
        sic.add(new SelectorItemInfo("isCFreeze"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("PLType"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("measureUnitID.number"));
        sic.add(new SelectorItemInfo("measureUnitID.name"));
        sic.add(new SelectorItemInfo("measureUnitID.coefficient"));
        sic.add(new SelectorItemInfo("measureUnitGroupID.id"));
        sic.add(new SelectorItemInfo("accountTypeID.property"));
        sic.add(new SelectorItemInfo("CAA.id"));
        bizAccountPromptBox.setSelectorCollection(sic);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)com.getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)com.getAccountTable().getId().toString()));
        filter.setMaskString("#0 AND #1 AND #2 AND #3   AND #4");
        if (fi != null) {
            try {
                filter.mergeFilter(fi, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        bizAccountPromptBox.setEntityViewInfo(view);
        filter = new FilterInfo();
        fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)com.getId().toString()));
        fic.add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)com.getAccountTable().getId().toString()));
        filter.setMaskString("#0 AND #1 AND #2   AND #3 ");
        if (fi != null) {
            try {
                filter.mergeFilter(fi, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        if ((selector = bizAccountPromptBox.getSelector()) == null) {
            bizAccountPromptBox.setSelector((KDPromptSelector)new AccountPromptBox((IUIObject)ui, com, filter, false, true));
        }
    }

    public void assignCashflowF7(KDBizPromptBox bizPiPromptBox, FilterInfo fi, CoreUIObject ui) {
        bizPiPromptBox.setEditable(true);
        bizPiPromptBox.setDisplayFormat("$name$");
        bizPiPromptBox.setEditFormat("$number$");
        bizPiPromptBox.setCommitFormat("$number$;$name$");
        bizPiPromptBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CashFlowQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isDealActivity"));
        sic.add(new SelectorItemInfo("direction"));
        sic.add(new SelectorItemInfo("isFreeze"));
        sic.add(new SelectorItemInfo("isEnable"));
        sic.add(new SelectorItemInfo("asstAccount.id"));
        bizPiPromptBox.setSelectorCollection(sic);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        if (fi != null) {
            try {
                filter.mergeFilter(fi, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        CashFlowF7Sys gapb = new CashFlowF7Sys((IUIObject)ui, null, filter);
        bizPiPromptBox.setSelector((KDPromptSelector)gapb);
        bizPiPromptBox.setEntityViewInfo(view);
    }

    public void assignSelector(KDBizPromptBox bizPromptBox, AsstActTypeInfo t, CoreUIObject ui) {
        bizPromptBox.setQueryInfo(t.getDefaultQueryName());
        bizPromptBox.setDefaultF7UIName(t.getDefaultF7UI());
        this.assignSelector(bizPromptBox, t.getGlAsstActTypeGrp(), t.getAsstHGAttribute(), t.isIsForCompany(), true, null, ui, false, t.isUseLongNumber());
    }

    public void assignSelector(KDBizPromptBox bizPromptBox, AsstActTypeInfo t, CoreUIObject ui, boolean needListener) {
        bizPromptBox.setQueryInfo(t.getDefaultQueryName());
        bizPromptBox.setDefaultF7UIName(t.getDefaultF7UI());
        this.assignSelector(bizPromptBox, t.getGlAsstActTypeGrp(), t.getAsstHGAttribute(), t.isIsForCompany(), true, false, false, null, null, ui, false, null, needListener, t.isUseLongNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignSelectorForFA(KDBizPromptBox bizPromptBox, AsstActTypeInfo t, CoreUIObject ui) {
        bizPromptBox.setQueryInfo(t.getDefaultQueryName());
        bizPromptBox.setDefaultF7UIName(t.getDefaultF7UI());
        GLf7UtilsImpl.setParam(ui);
        boolean isChooseAsstComCopy = isChooseAsstCom;
        isChooseAsstCom = false;
        try {
            this.assignSelector(bizPromptBox, t.getGlAsstActTypeGrp(), t.getAsstHGAttribute(), t.isIsForCompany(), true, null, ui, false, t.isUseLongNumber());
        }
        catch (Exception exception) {
        }
        finally {
            isChooseAsstCom = isChooseAsstComCopy;
        }
    }

    public void assignInnerCustomer(KDBizPromptBox bizPromptBox, VoucherInfo.DynamicColumnInfo colInfo, String cuid, FilterInfo f, CoreUIObject ui) {
        this.assignInnerCustomer(bizPromptBox, colInfo.getGrp(), colInfo.getMappingPropName(), cuid, f, ui, colInfo.isUseLongNumber());
    }

    public void assignInnerCustomer(KDBizPromptBox bizPromptBox, GeneralAsstActTypeGroupInfo grp, String mappingFieldName, String cuid, FilterInfo f, CoreUIObject ui, boolean useLongNumber) {
        SelectorItemCollection sic = bizPromptBox.getSelectorCollection();
        String companyid = GLf7UtilsImpl.getFICompany(ui).getId().toString();
        if (ui.getUIContext().get("COMPANYINFOID") != null) {
            companyid = ui.getUIContext().get("COMPANYINFOID").toString();
        }
        boolean hasListener = false;
        if (sic == null) {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            bizPromptBox.setSelectorCollection(sic);
        }
        if (mappingFieldName != null) {
            EntityViewInfo view;
            if (mappingFieldName.equals("customer")) {
                bizPromptBox.setCommitFormat("$mnemonicCode$;$number$;$name$");
                view = new EntityViewInfo();
                SorterItemCollection sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                filter.appendFilterItem("companyOrgUnit.id", (Object)companyid);
                sic.add(new SelectorItemInfo("isInternalCompany"));
                try {
                    FilterInfo Dfilter = GlWebServiceUtil.getDFilterInfo((IDataBaseD)CustomerFactory.getRemoteInstance(), cuid);
                    if (Dfilter != null) {
                        filter.mergeFilter(Dfilter, "and");
                    }
                    if (f != null) {
                        filter.mergeFilter(f, "and");
                    }
                    bizPromptBox.setEntityViewInfo(view);
                    GeneralKDPromptSelectorAdaptor gks = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7CustomerTreeDetailListUI(), (Object)ui, null, "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery", "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQueryWithDefaultStandard");
                    gks.setQueryProperty("mobile", "and");
                    Context mainOrgContext = new Context();
                    FrameWorkUtils.switchOrg((Context)mainOrgContext, (String)companyid);
                    gks.setMainOrgContext(mainOrgContext);
                    GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)gks);
                }
                catch (Exception er) {
                    logger.error((Object)er);
                }
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQueryWithDefaultStandard");
            } else if (mappingFieldName.equals("provider")) {
                bizPromptBox.setCommitFormat("$mnemonicCode$;$number$;$name$");
                view = new EntityViewInfo();
                SorterItemCollection sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                filter.appendFilterItem("companyOrgUnit.id", (Object)companyid);
                sic.add(new SelectorItemInfo("isInternalCompany"));
                try {
                    FilterInfo Dfilter = GlWebServiceUtil.getDFilterInfo((IDataBaseD)SupplierFactory.getRemoteInstance(), cuid);
                    if (Dfilter != null) {
                        filter.mergeFilter(Dfilter, "and");
                    }
                    if (f != null) {
                        filter.mergeFilter(f, "and");
                    }
                    bizPromptBox.setEntityViewInfo(view);
                    GeneralKDPromptSelectorAdaptor gks = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, (Component)new F7SupplierTreeDetailListUI(), (Object)ui, null, "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery", "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQueryWithDefaultStandard");
                    gks.setQueryProperty("mobile", "and");
                    Context mainOrgContext = new Context();
                    FrameWorkUtils.switchOrg((Context)mainOrgContext, (String)companyid);
                    gks.setMainOrgContext(mainOrgContext);
                    GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)gks);
                }
                catch (Exception er) {
                    logger.error((Object)er);
                }
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQueryWithDefaultStandard");
            } else if (mappingFieldName.equals("companyOrg")) {
                view = new EntityViewInfo();
                SorterItemCollection sorc = view.getSorter();
                SorterItemInfo sort = new SorterItemInfo("number");
                sorc.add(sort);
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("isLeaf"));
                sic.add(new SelectorItemInfo("isBizUnit"));
                sic.add(new SelectorItemInfo("displayName"));
                bizPromptBox.setEntityViewInfo(view);
                NewCompanyF7 f7 = null;
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery4AsstAcct");
                f7 = new NewCompanyF7((IUIObject)ui);
                f7.setDataPermission("Company_View");
                if (isChooseAsstCom || !isOrgPermission) {
                    f7.setNeedAddOrgRange(false);
                } else {
                    f7.setNeedAddOrgRange(true);
                }
                f7.showCheckBoxOfShowingAllOUs();
                bizPromptBox.setSelector((KDPromptSelector)f7);
            } else if (grp != null) {
                AuxAccountUtils.assignGeneralBizPromptBox((KDBizPromptBox)bizPromptBox, (String)grp.getId().toString(), (boolean)false, (CoreUIObject)ui);
            } else {
                this.assignSelector(bizPromptBox, null, mappingFieldName, false, null, ui, useLongNumber);
                hasListener = true;
            }
            if (!hasListener) {
                VoucherAsstDataChangeListener ls = new VoucherAsstDataChangeListener(ui, mappingFieldName, isPersonByCU, useLongNumber);
                bizPromptBox.addDataChangeListener((DataChangeListener)ls);
            }
        }
    }

    private static void setOrgF7(KDBizPromptBox bizPromptBox, String mappingFieldName, boolean isShowSealCost, CoreUIObject ui, String cuid, FilterItemCollection fic) {
        NewCompanyF7 f7 = null;
        OrgViewType orgViewType = OrgViewType.COMPANY;
        if (mappingFieldName.equals("companyOrg") || mappingFieldName.equals("orgUnit")) {
            bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery4AsstAcct");
            f7 = new NewCompanyF7((IUIObject)ui);
            f7.setDataPermission("Company_View");
            f7.setContainSealUp(isShowSealCost);
            if (GLf7UtilsImpl.getFICompany(ui).isIsAssistantOrg()) {
                f7.setShowAssistantOrg(true);
            }
            f7.setIsCUFilter(false);
        } else {
            if (!mappingFieldName.equals("costOrg") || mappingFieldName.equals("costOrg") && isAdminOrgByCU) {
                fic.add(new FilterItemInfo("CU.id", (Object)cuid));
            }
            if (mappingFieldName.equals("costOrg")) {
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterOrgUnitQuery4AsstAcct");
                f7 = new NewCostCenterF7((IUIObject)ui);
                f7.setDataPermission("CostCenter_View");
                f7.setContainSealUp(isShowSealCost);
                orgViewType = OrgViewType.COSTCENTER;
            } else if (mappingFieldName.equals("saleOrg")) {
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery4AsstAcct");
                f7 = new NewSaleF7((IUIObject)ui);
                f7.setDataPermission("Sale_View");
                orgViewType = OrgViewType.SALE;
            } else if (mappingFieldName.equals("profitOrg")) {
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.ProfitCenterOrgUnitQuery4AsstAcct");
                f7 = new NewProfitCenterF7((IUIObject)ui);
                f7.setDataPermission("ProfitCenter_View");
                orgViewType = OrgViewType.PROFITCENTER;
            } else if (mappingFieldName.equals("purchaseOrg")) {
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery4AsstAcct");
                f7 = new NewPurchaseF7((IUIObject)ui);
                f7.setDataPermission("Purchase_View");
                orgViewType = OrgViewType.PURCHASE;
            } else if (mappingFieldName.equals("storeageOrg")) {
                bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery4AsstAcct");
                f7 = new NewStorageF7((IUIObject)ui);
                f7.setDataPermission("Storage_View");
                orgViewType = OrgViewType.STORAGE;
            }
            if (f7 != null) {
                if (isAdminOrgByCU) {
                    fic.add(new FilterItemInfo("CU.id", (Object)cuid));
                    f7.setIsCUFilter(true);
                } else {
                    f7.showCheckBoxOfShowingAllOUs();
                    f7.setIsCUFilter(false);
                }
            }
        }
        if (f7 != null) {
            if (ui.getOprtState() != null && (ui.getOprtState().equals(OprtState.ADDNEW) || ui.getOprtState().equals(OprtState.EDIT) || ui.getOprtState().equals(OprtState.COPYADDNEW) || ui.getOprtState().equals(OprtState.VIEW))) {
                fic.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
                f7.setContainSealUp(false);
            } else {
                f7.setContainSealUp(true);
            }
            if (isChooseAsstCom || !isOrgPermission) {
                f7.setNeedAddOrgRange(false);
            } else {
                f7.setNeedAddOrgRange(true);
            }
            f7.setMultiSelect(bizPromptBox.isEnabledMultiSelection());
        }
        GLf7UtilsImpl.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)f7);
        if (isOrgPermission) {
            try {
                HashMap map = GLOrgUtil.getAuthorizedOrgViewIDs(null, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), orgViewType, null, null, null);
                Set keySet = map.keySet();
                bizPromptBox.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private static void setDelegationF7(KDBizPromptBox bizPromptBox, String mappingFieldName, CoreUIObject ui, String companyid, boolean isMasterBook) {
        OrgType orgType = GLf7UtilsImpl.getOrgType(mappingFieldName);
        String comid = GLf7UtilsImpl.getCurrentMasterCompanyID(ui);
        if (!isMasterBook && comid != null && !comid.equals(companyid)) {
            companyid = comid;
        }
        bizPromptBox.setDefaultF7UIName(null);
        OrgUnitDelegationF7 oudF7 = new OrgUnitDelegationF7(bizPromptBox, DelegationPartsEnum.THE_FROM_UNIT, orgType);
        oudF7.setTheGivenOrgUnit(companyid, OrgType.Company);
        oudF7.setDoNotUseUserOrgRangeAsFilter();
        oudF7.setIncludeSelfWhenSelfIsAlsoOfTheWantedType();
        bizPromptBox.setCommitFormat("$code$;$number$;$name$");
        if (OprtState.ADDNEW.equals(ui.getOprtState()) || OprtState.EDIT.equals(ui.getOprtState()) || OprtState.COPYADDNEW.equals(ui.getOprtState())) {
            FilterInfo filterInfo = bizPromptBox.getEntityViewInfo().getFilter();
            FilterInfo sealUpFilterInfo = new FilterInfo();
            sealUpFilterInfo.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(1), CompareType.NOTEQUALS));
            try {
                filterInfo.mergeFilter(sealUpFilterInfo, "and");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            bizPromptBox.getEntityViewInfo().setFilter(filterInfo);
        }
    }

    private static OrgType getOrgType(String mappingFieldName) {
        Object orgType = mappingFieldName.equals("saleOrg") ? OrgType.Sale : (mappingFieldName.equals("profitOrg") ? OrgType.ProfitCenter : (mappingFieldName.equals("purchaseOrg") ? OrgType.Purchase : (mappingFieldName.equals("storeageOrg") ? OrgType.Storage : (mappingFieldName.equals("companyOrg") ? OrgType.Company : (mappingFieldName.equals("costOrg") ? OrgType.CostCenter : (mappingFieldName.equals("orgUnit") ? OrgType.Company : null))))));
        return orgType;
    }

    private static CompanyOrgUnitInfo getFICompany(CoreUIObject ui) {
        CompanyOrgUnitInfo company = null;
        company = ui.getUIContext().get("COMPANY") != null ? (CompanyOrgUnitInfo)ui.getUIContext().get("COMPANY") : SysContext.getSysContext().getCurrentFIUnit();
        return company;
    }

    private static String getCurrentMasterCompanyID(CoreUIObject ui) {
        CompanyOrgUnitInfo company = GLf7UtilsImpl.getFICompany(ui);
        if (company != null) {
            return company.getId().toString();
        }
        return BooksUtil.getCurrentMasterCompanyID(null);
    }

    private static boolean isMasterBook(CoreUIObject ui) {
        CompanyOrgUnitInfo company = GLf7UtilsImpl.getFICompany(ui);
        if (company != null) {
            return true;
        }
        return BooksUtil.isMasterBook(null);
    }

    private static boolean isSameAccountTable(CoreUIObject ui) {
        CompanyOrgUnitInfo company = GLf7UtilsImpl.getFICompany(ui);
        if (company != null) {
            return true;
        }
        return BooksUtil.isSameAccountTable(null);
    }

    public static AcountSchemeInfo getBook(Context ctx, String companyId) {
        AcountSchemeInfo book = null;
        try {
            IAcountScheme getBizInterface = null;
            if (ctx == null) {
                getBizInterface = AcountSchemeFactory.getRemoteInstance();
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                book = company != null && company.getAccountScheme() != null && company.getAccountScheme().getId() != null ? (AcountSchemeInfo)getBizInterface.getValue((IObjectPK)new ObjectUuidPK(company.getAccountScheme().getId())) : AcountSchemeFactory.getRemoteInstance().getMasterScheme();
            } else {
                getBizInterface = AcountSchemeFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                book = company != null && company.getAccountScheme() != null && company.getAccountScheme().getId() != null ? (AcountSchemeInfo)getBizInterface.getValue((IObjectPK)new ObjectUuidPK(company.getAccountScheme().getId())) : AcountSchemeFactory.getLocalInstance((Context)ctx).getMasterScheme();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return book;
    }

    public static String getCurrentMasterCompanyID(Context ctx, String companyId) {
        CompanyOrgUnitInfo currentCompany = null;
        AcountSchemeInfo currentBook = GLf7UtilsImpl.getBook(ctx, companyId);
        try {
            if (ctx == null) {
                if (currentBook == null || currentBook.isIsMaster()) {
                    currentCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                } else {
                    currentCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId)).getMainOrg();
                    if (currentCompany != null) {
                        return currentCompany.getId().toString();
                    }
                }
            } else if (currentBook == null || currentBook.isIsMaster()) {
                currentCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            } else {
                currentCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId)).getMainOrg();
                if (currentCompany != null) {
                    return currentCompany.getId().toString();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return currentCompany != null ? currentCompany.getId().toString() : null;
    }
}

