/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class SQLUtil {
    private static final Logger logger = Logger.getLogger(SQLUtil.class);

    public static String getPeriodCondition(String yearField, String periodField, int[] periodRange) {
        StringBuffer sql = new StringBuffer();
        if (periodRange[0] == periodRange[2]) {
            sql.append(yearField).append("=").append(periodRange[0]);
            if (periodRange[1] == periodRange[3]) {
                sql.append(" and " + periodField + "=").append(periodRange[1]);
            } else {
                sql.append(" and " + periodField + ">=").append(periodRange[1]).append(" and " + periodField + "<=").append(periodRange[3]);
            }
        } else {
            sql.append("(" + yearField + ">").append(periodRange[0]).append(" or (" + yearField + "=").append(periodRange[0]).append(" and " + periodField + ">=").append(periodRange[1]).append("))");
            sql.append(" and (" + yearField + "<").append(periodRange[2]).append(" or (" + yearField + "=").append(periodRange[2]).append(" and " + periodField + "<=").append(periodRange[3]).append("))");
        }
        return sql.toString();
    }

    public static String getPeriodHeCondition(String yearField, String periodField, int[] periodRange) {
        StringBuffer sql = new StringBuffer();
        sql.append(yearField).append("=").append(periodRange[0]);
        sql.append(" and " + periodField + "=").append(periodRange[1]);
        return sql.toString();
    }

    public static String getPeriodCondition(String periodField, int[] periodRange) {
        StringBuffer sql = new StringBuffer();
        if (periodRange[0] == periodRange[1]) {
            sql.append(periodField).append("=").append(periodRange[0]);
        } else {
            sql.append(periodField + ">=").append(periodRange[0]);
            sql.append(" and " + periodField + "<=").append(periodRange[1]);
        }
        return sql.toString();
    }

    public static String createAutoRangeCondition(String fieldName, String from, String to) {
        if (from == null && to == null) {
            return "(1=1)";
        }
        if (from != null && to != null) {
            int res = from.compareTo(to);
            if (res == 0) {
                return fieldName + "='" + SQLUtil.maskSqlParamValue(from) + "'";
            }
            if (res > 0) {
                String buf = from;
                from = to;
                to = buf;
            }
        }
        StringBuffer sql = new StringBuffer();
        boolean hasFrom = false;
        if (from != null) {
            sql.append(fieldName).append(">='" + SQLUtil.maskSqlParamValue(from) + "'");
            hasFrom = true;
        }
        if (to != null) {
            if (hasFrom) {
                sql.append(" and ");
            }
            sql.append(fieldName).append("<='" + SQLUtil.maskSqlParamValue(to) + "'");
        }
        return sql.toString();
    }

    public static String createAutoRangeCondition(String fieldName, int from, int to) {
        StringBuffer sql = new StringBuffer();
        if (from == to) {
            sql.append(fieldName).append("=").append(from);
        } else {
            sql.append(fieldName).append(">=").append(Math.min(from, to)).append(" and ").append(fieldName).append("<=").append(Math.max(from, to));
        }
        return sql.toString();
    }

    public static String transSelectIntoToSelectTopSql(String sql, int topCount) {
        String KEY_INTO = " into ";
        String KEY_SELECT = "select ";
        String buf = sql.toLowerCase();
        int intoIndex = buf.indexOf(" into ");
        int selectIndex = buf.indexOf("select ");
        if (intoIndex == -1 || selectIndex == -1) {
            throw new RuntimeException("Incorrect sql:" + sql);
        }
        char[] chs = buf.toCharArray();
        boolean hasBeginScan = false;
        int tableNameEndIndex = 0;
        for (int i = intoIndex + " into ".length(); i < chs.length; ++i) {
            if (chs[i] != ' ' && !hasBeginScan) {
                hasBeginScan = true;
                continue;
            }
            if (chs[i] != ' ' || !hasBeginScan) continue;
            tableNameEndIndex = i - 1;
            break;
        }
        StringBuffer result = new StringBuffer();
        result.append(sql.substring(0, selectIndex + "select ".length()));
        if (topCount >= 0) {
            result.append("top ").append(topCount).append(" ");
        }
        result.append(sql.substring(selectIndex + "select ".length(), intoIndex));
        result.append(sql.substring(tableNameEndIndex + 1));
        return result.toString();
    }

    public static String parseSelectIntoTableName(String sql) {
        String KEY_INTO = "into ";
        String buf = sql.toLowerCase();
        int intoIndex = buf.indexOf("into ");
        if (intoIndex == -1) {
            throw new RuntimeException("Incorrect sql:" + sql);
        }
        char[] chs = buf.toCharArray();
        boolean hasBeginScan = false;
        int tableNameBeginIndex = 0;
        for (int i = intoIndex + "into ".length(); i < chs.length; ++i) {
            if (chs[i] != ' ' && !hasBeginScan) {
                hasBeginScan = true;
                tableNameBeginIndex = i;
                continue;
            }
            if (chs[i] != ' ' && chs[i] != '\n' || !hasBeginScan) continue;
            return sql.substring(tableNameBeginIndex, i);
        }
        return sql.substring(tableNameBeginIndex);
    }

    public static String arrayToInList(String[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("(");
        for (int i = 0; i < array.length; ++i) {
            sql.append("'" + SQLUtil.maskSqlParamValue(array[i]) + "',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    public static String[] listStringToStringArray(List lstId) {
        if (lstId.size() <= 0) {
            return null;
        }
        String[] arrAtring = new String[lstId.size()];
        for (int i = 0; i < lstId.size(); ++i) {
            arrAtring[i] = lstId.get(i).toString();
        }
        return arrAtring;
    }

    public static String listObjectToInString(List lstObj) {
        List lstId = SQLUtil.getIdListFromObjectList(lstObj);
        if (lstId.size() <= 0) {
            return "('')";
        }
        String[] arrAtring = new String[lstId.size()];
        for (int i = 0; i < lstId.size(); ++i) {
            arrAtring[i] = lstId.get(i).toString();
        }
        return SQLUtil.arrayToInList(arrAtring);
    }

    public static String[] listObjectToStringArray(List lstObj) {
        List lstId = SQLUtil.getIdListFromObjectList(lstObj);
        if (lstId.size() <= 0) {
            return null;
        }
        String[] arrAtring = new String[lstId.size()];
        for (int i = 0; i < lstId.size(); ++i) {
            arrAtring[i] = lstId.get(i).toString();
        }
        return arrAtring;
    }

    public static List getIdListFromObjectList(List lstObj) {
        ArrayList<String> lstId = new ArrayList<String>();
        for (ObjectBaseInfo obj : lstObj) {
            lstId.add(obj.getId().toString());
        }
        return lstId;
    }

    public static String collection2InList(Collection col) {
        if (col == null || col.size() == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("(");
        Iterator it = col.iterator();
        while (it.hasNext()) {
            sql.append("'" + SQLUtil.maskSqlParamValue((String)it.next()) + "',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    public static String maskSqlParamValue(String value) {
        if (value != null) {
            return value.replaceAll("'", "''");
        }
        return value;
    }

    public static String applyTopLimit(String sql, int topCount) {
        StringBuffer sb = new StringBuffer();
        sb.append("select top ").append(topCount).append(" * from (" + sql + ") as ").append(SQLUtil.getSqlTableAliasName(sql));
        return sb.toString();
    }

    public static String applyLimit(String sql, String orderByFieldName, boolean asc, int index, int length) {
        StringBuffer sb = new StringBuffer();
        sb.append("select top ").append(length).append(" * from (");
        sb.append("select top ").append(index + length).append(" * from (");
        sb.append(sql);
        sb.append(") as ").append(SQLUtil.getSqlTableAliasName(sb.toString()));
        sb.append(" order by ").append(orderByFieldName).append(" desc ");
        sb.append(") as ").append(SQLUtil.getSqlTableAliasName(sb.toString()));
        sb.append(" order by ").append(orderByFieldName).append(" ");
        sb.append(asc ? "desc" : "asc");
        sb.insert(0, "select * from (");
        sb.append(") as ").append(SQLUtil.getSqlTableAliasName(sb.toString()));
        sb.append(" order by ").append(orderByFieldName).append(" ");
        sb.append(asc ? "asc" : "desc");
        return sb.toString();
    }

    public static String applyCountSql(String sql) {
        StringBuffer sb = new StringBuffer();
        sb.append("select count(1) from (").append(sql).append(") as ").append(SQLUtil.getSqlTableAliasName(sql));
        return sb.toString();
    }

    public static String applySelectIntoTableSql(String tableName, String sql) {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(tableName).append(" select * from (").append(sql).append(") as ").append(SQLUtil.getSqlTableAliasName(sql));
        return sb.toString();
    }

    public static String getSqlTableAliasName(String sql) {
        String tempName = "ALIAS_";
        String buf = sql.toUpperCase();
        int i = 0;
        while (buf.indexOf("ALIAS_" + i) != -1) {
            ++i;
        }
        return "ALIAS_" + i;
    }

    public static String buildCreateTableString(String tableName, ResultSetMetaData rsm) throws SQLException {
        return DBUtil.getKSQLDialect().buildCreateTableString(tableName, rsm);
    }

    public static byte[] getBytes(Object object) {
        byte[] bytes = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            bytes = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return bytes;
    }

    public static Object getObject(byte[] bytes) {
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        return object;
    }

    public static String stringArrayToString(String[] ids) {
        StringBuffer strIds = new StringBuffer();
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0) {
                    strIds.append(",");
                }
                strIds.append("'").append(ids[i]).append("'");
            }
        }
        return strIds.toString();
    }

    public static String stringListToString(List ids) {
        StringBuffer strIds = new StringBuffer();
        if (ids != null) {
            for (int i = 0; i < ids.size(); ++i) {
                if (i > 0) {
                    strIds.append(",");
                }
                strIds.append("'").append((String)ids.get(i)).append("'");
            }
        }
        return strIds.toString();
    }

    public static Set stringArrayToSet(Object[] ids) {
        HashSet<String> setIds = new HashSet<String>();
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                setIds.add(ids[i].toString());
            }
        }
        return setIds;
    }

    public static Set buildPeriodNumbers(int startYear, int startMonth, int endYear, int endMonth) {
        HashSet<Integer> numbers = new HashSet<Integer>();
        if (startYear * 100 + startMonth > endYear * 100 + endMonth) {
            numbers.add(-1);
        }
        for (int year = startYear; year <= endYear; ++year) {
            int maxMonth;
            int n = maxMonth = year == endYear ? endMonth : 13;
            for (int month = year == startYear ? startMonth : 1; month <= maxMonth; ++month) {
                numbers.add(year * 100 + month);
            }
        }
        return numbers;
    }

    public static String buildPeriodNumbersInSql(int startYear, int startMonth, int endYear, int endMonth) {
        StringBuffer sql = new StringBuffer();
        sql.append("(");
        Set numbers = SQLUtil.buildPeriodNumbers(startYear, startMonth, endYear, endMonth);
        Iterator it = numbers.iterator();
        while (it.hasNext()) {
            sql.append(it.next()).append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    public static String buildPeriodNumbersInSql(boolean isFromBeginPeriod, GLRptBaseCondition cond) throws EASBizException, BOSException {
        int startYear = cond.getPeriodYearStart();
        int startMonth = cond.getPeriodNumberStart();
        int endYear = cond.getPeriodYearEnd();
        int endMonth = cond.getPeriodNumberEnd();
        if (isFromBeginPeriod) {
            PeriodInfo currPeriod = null;
            currPeriod = cond.getProfitCenters() != null ? cond.getProfitCenterCurrPeriod() : cond.getCurrPeriod();
            if (currPeriod != null && currPeriod.getNumber() < startYear * 100 + startMonth) {
                startYear = currPeriod.getPeriodYear();
                startMonth = currPeriod.getPeriodNumber();
            }
        }
        return SQLUtil.buildPeriodNumbersInSql(startYear, startMonth, endYear, endMonth);
    }

    public static boolean isQueryByCurrency(GLRptBaseCondition cond) {
        return !cond.isAllCurrency() && !"11111111-1111-1111-1111-111111111111DEB58FDC".equals(cond.getCurrencyID()) && !"22222222-2222-2222-2222-222222222222DEB58FDC".equals(cond.getCurrencyID());
    }

    public static String buildPeriodNumbersInSql(GLRptBaseCondition cond) throws EASBizException, BOSException {
        return SQLUtil.buildPeriodNumbersInSql(true, cond);
    }

    public static Set buildPeriodNumbers(boolean isFromBeginPeriod, GLRptBaseCondition cond) throws EASBizException, BOSException {
        int startYear = cond.getPeriodYearStart();
        int startMonth = cond.getPeriodNumberStart();
        int endYear = cond.getPeriodYearEnd();
        int endMonth = cond.getPeriodNumberEnd();
        if (isFromBeginPeriod) {
            PeriodInfo currPeriod = null;
            currPeriod = cond.getProfitCenters() != null ? cond.getProfitCenterCurrPeriod() : cond.getCurrPeriod();
            if (currPeriod != null && currPeriod.getNumber() < startYear * 100 + startMonth) {
                startYear = currPeriod.getPeriodYear();
                startMonth = currPeriod.getPeriodNumber();
            }
        }
        return SQLUtil.buildPeriodNumbers(startYear, startMonth, endYear, endMonth);
    }

    public static Set buildPeriodNumbers(GLRptBaseCondition cond) throws EASBizException, BOSException {
        return SQLUtil.buildPeriodNumbers(true, cond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSupportCharIndexToLike(Context ctx) {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            boolean bl = DbType.isOracle((int)dbType) || 3 == dbType || 5 == dbType;
            return bl;
        }
        catch (SQLException e) {
            logger.error((Object)"Query database type error!", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOracle(Context ctx) {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            boolean bl = DbType.isOracle((int)dbType);
            return bl;
        }
        catch (SQLException e) {
            logger.error((Object)"Query database type error!", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMSSQLSERVER(Context ctx) {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            boolean bl = 3 == dbType;
            return bl;
        }
        catch (SQLException e) {
            logger.error((Object)"Query database type error!", (Throwable)e);
        }
        finally {
            if (conn != null) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDB2(Context ctx) {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            boolean bl = 1 == dbType;
            return bl;
        }
        catch (SQLException e) {
            logger.error((Object)"Query database type error!", (Throwable)e);
        }
        finally {
            if (conn != null) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPG(Context ctx) {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            boolean bl = 5 == dbType;
            return bl;
        }
        catch (SQLException e) {
            logger.error((Object)"Query database type error!", (Throwable)e);
        }
        finally {
            if (conn != null) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isKingBase(Context ctx) {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            boolean bl = 12 == dbType;
            return bl;
        }
        catch (SQLException e) {
            logger.error((Object)"Query database type error!", (Throwable)e);
        }
        finally {
            if (conn != null) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDM(Context ctx) {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            boolean bl = 11 == dbType;
            return bl;
        }
        catch (SQLException e) {
            logger.error((Object)"Query database type error!", (Throwable)e);
        }
        finally {
            if (conn != null) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return false;
    }

    public static String getIdsSql(String[] ids) {
        return SQLUtil.getIdsSql((Object[])ids);
    }

    public static String getIdsSql(Object[] ids) {
        if (ids == null) {
            return null;
        }
        if (ids.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            sb.append("'").append(ids[i].toString()).append("'").append(",");
        }
        if (sb.length() > 0) {
            sb.insert(0, "(");
            sb.setCharAt(sb.length() - 1, ')');
        }
        return sb.toString();
    }

    public static String getComplexViewMerging(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        hmParamIn.put("GL_ComplexViewMerging", null);
        IParamControl pc = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        Object value = hmAllParam.get("GL_ComplexViewMerging");
        if (value != null) {
            String str = value.toString().trim();
            if ("0".equals(str)) {
                return "true";
            }
            if ("1".equals(str)) {
                return "false";
            }
            if ("2".equals(str)) {
                return "";
            }
        }
        return "false";
    }

    public static String buildMarkSQL(int count) {
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        return "(" + sql.toString() + ")";
    }

    public static String buildHint(String source) {
        if (source != null && source.trim().length() > 0) {
            if ((source = source.trim()).contains(";") || source.contains("/*+") || source.contains("*/")) {
                return "";
            }
            String[] strs = source.toLowerCase().split("\\s+");
            HashSet<String> set = new HashSet<String>();
            for (String str : strs) {
                set.add(str);
            }
            if (set.contains("create") || set.contains("drop") || set.contains("delete") || set.contains("truncate") || set.contains("update") || set.contains("alter")) {
                return "";
            }
            return "/*+ " + source + " */";
        }
        return "";
    }
}

