/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common;

import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.SerializableByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public class SqlParameter2
extends HashMap {
    private int index = 1;
    private DecimalFormat df = new DecimalFormat("0.##########");

    public SqlParameter2() {
    }

    public SqlParameter2(int initialCapacity) {
        super(initialCapacity);
    }

    public SqlParameter2(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public SqlParameter2(Map m) {
        super(m);
    }

    public void addValue(int value) {
        Object[] val = new Object[]{SQLType.INT, new Integer(value)};
        this.put(new Integer(this.index), val);
        ++this.index;
    }

    public void addValue(Object value) {
        Object[] val = new Object[]{null, value};
        this.put(new Integer(this.index), val);
        ++this.index;
    }

    public void addValueVarchar(String value) {
        Object[] val = new Object[]{SQLType.VARCHAR, value};
        this.put(new Integer(this.index), val);
        ++this.index;
    }

    public void addValueChar(String value) {
        Object[] val = new Object[]{SQLType.CHAR, value};
        this.put(new Integer(this.index), val);
        ++this.index;
    }

    public void addValueId(CoreBaseInfo value) {
        Object[] val = new Object[]{SQLType.CHAR, value == null ? null : value.getId().toString()};
        this.put(new Integer(this.index), val);
        ++this.index;
    }

    public void addValue(int index, SQLType type, Object value) {
        Object[] val = new Object[]{type, value};
        this.put(new Integer(index), val);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    @Override
    public void clear() {
        super.clear();
        this.index = 1;
    }

    public void putToStatement(PreparedStatement stmt) throws SQLException {
        for (Object keyValue : this.keySet()) {
            if (keyValue == null) continue;
            int index = (Integer)keyValue;
            Object[] val = (Object[])this.get(keyValue);
            if (val[0] != null && (val[0].equals(SQLType.VARCHAR) || val[0].equals(SQLType.CHAR))) {
                byte[] value = ((String)val[1]).getBytes();
                SerializableByteArrayInputStream is = new SerializableByteArrayInputStream(value);
                stmt.setAsciiStream(index, (InputStream)is, value.length);
                continue;
            }
            if (val[0] != null && val[0].equals(SQLType.INT)) {
                stmt.setInt(index, (Integer)val[1]);
                continue;
            }
            if (val[1] instanceof Integer) {
                stmt.setInt(index, (Integer)val[1]);
                continue;
            }
            if (val[1] != null && BigDecimal.class.isInstance(val[1])) {
                stmt.setBigDecimal(index, (BigDecimal)val[1]);
                continue;
            }
            stmt.setObject(index, val[1]);
        }
    }

    private String getParameterValueString(Object obj) {
        if (obj == null) {
            return "Null";
        }
        Class<?> objClass = obj.getClass();
        if (objClass == String.class) {
            return "'" + obj.toString() + "'";
        }
        if (objClass == Timestamp.class) {
            StringBuffer sb = new StringBuffer("{");
            sb.append(DateFormat.getDateTimeInstance().format((Timestamp)obj));
            sb.append("}");
            return sb.toString();
        }
        if (objClass == Date.class) {
            return "{ts'" + obj.toString() + " 00:00:00'}";
        }
        if (objClass == Double.class) {
            return this.df.format((Double)obj);
        }
        if (objClass == Float.class) {
            return this.df.format(((Float)obj).floatValue());
        }
        return obj.toString();
    }

    public String sql(String sql) {
        return this.getSqlWithParameters(sql);
    }

    public String getSqlWithParameters(String sql) {
        int parameterIndex;
        StringBuffer sqlWithParameters = new StringBuffer(sql);
        int index = 1;
        while ((parameterIndex = sqlWithParameters.indexOf("?")) >= 0) {
            sqlWithParameters.deleteCharAt(parameterIndex);
            sqlWithParameters.insert(parameterIndex, "#" + index);
            ++index;
        }
        for (Object keyValue : this.keySet()) {
            if (keyValue == null) continue;
            int keyIndex = (Integer)keyValue;
            String strIndex = "#" + keyIndex;
            int sqlIndex = sqlWithParameters.indexOf(strIndex);
            if (sqlIndex <= 0) continue;
            Object[] val = (Object[])this.get(keyValue);
            sqlWithParameters.replace(sqlIndex, sqlIndex + strIndex.length(), this.getParameterValueString(val[1]));
        }
        return sqlWithParameters.toString();
    }
}

