/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common.print;

import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.print.FrugalPrintManager;
import com.kingdee.bos.ctrl.kdf.table.print.IRetrieveDataListener;
import com.kingdee.bos.ctrl.print.IConfigChangeListener;
import com.kingdee.eas.fi.gl.common.print.IRequestTableData;
import com.kingdee.eas.fi.gl.rpt.client.GLRptSubLedgerUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class MultiPrintModel
implements IRetrieveDataListener,
IConfigChangeListener {
    private static final Logger logger = Logger.getLogger(MultiPrintModel.class);
    private Component parentWindow;
    private List miList = new ArrayList();
    private KDTable tbl;
    private boolean firstUse = true;
    private IRequestTableData requestData;
    FrugalPrintManager manager = null;
    float bodyTopMargin = 0.0f;
    boolean optionSwapPage = false;

    public KDTable getTable() {
        return this.tbl;
    }

    public void addVarParser(String name, Map headVarMap) {
        PrintModelItem pm = new PrintModelItem();
        pm.name = name;
        pm.var = headVarMap;
        this.miList.add(pm);
    }

    public void setManager(FrugalPrintManager manager) {
        this.manager = manager;
    }

    public FrugalPrintManager getManager() {
        return this.manager;
    }

    public void setTable(KDTable tblMain) {
        this.tbl = tblMain;
        this.manager.setParent(this.parentWindow);
        this.manager.setTable(tblMain);
        if (this.firstUse) {
            Element jobE;
            Element e = this.tbl.getPrintManager().toXmlElement();
            if (e != null && (jobE = e.getChild("printjob")) != null) {
                jobE.removeChild("headerfooter");
            }
            this.manager.fromXmlElement(e);
            this.firstUse = false;
        }
        if (!this.optionSwapPage) {
            this.manager.setFrugalPrint(true);
        } else {
            this.manager.setFrugalPrint(false);
        }
    }

    public void addTreePath(String name, Object path) {
        this.getPrintModelItem((String)name).treePath = path;
    }

    public void addPrintJob(String name, KDTable tbl, Map headVarMap) {
        PrintModelItem pm = new PrintModelItem();
        pm.name = name;
        HashMap myVar = new HashMap();
        myVar.putAll(headVarMap);
        this.miList.add(pm);
    }

    public HeadFootModel getFooter(String jobname) {
        HeadFootModel footer = null;
        Page page = this.tbl.getPrintManager().getFooter();
        if (page != null) {
            page = this.parserHeader(jobname, page);
            footer = this.manager.parseHeadFootPage2Model(page);
        }
        return footer;
    }

    public HeadFootModel getHeader(String jobname) {
        HeadFootModel header = null;
        Page page = this.tbl.getPrintManager().getHeader();
        if (page != null) {
            page = this.parserHeader(jobname, page);
            header = this.manager.parseHeadFootPage2Model(page);
        }
        return header;
    }

    public Page parserHeader(String jobname, Page page) {
        HeadFootModel model = this.manager.parseHeadFootPage2Model(page);
        if (model == null) {
            return null;
        }
        List rowList = model.getRowList();
        Map parser = this.getPrintModelItem((String)jobname).var;
        if (parser != null) {
            int size = rowList.size();
            for (int i = 0; i < size; ++i) {
                HeadFootRow row = (HeadFootRow)rowList.get(i);
                String text = row.getText();
                ArrayList strList = this.manager.parseVariantText(text);
                StringBuffer sb = new StringBuffer();
                int size2 = strList.size();
                for (int j = 0; j < size2; ++j) {
                    String str = (String)strList.get(j);
                    if (str == null) continue;
                    int len = str.length();
                    if (len > 2 && str.charAt(0) == '&' && str.charAt(1) == '[') {
                        String temp = (String)parser.get(str.substring(2));
                        if (temp != null) {
                            sb.append(temp);
                            continue;
                        }
                        sb.append(str + "]");
                        continue;
                    }
                    sb.append(str);
                }
                row.setText(sb.toString());
            }
        }
        return this.manager.parseModel2HeadFootPage(model);
    }

    private PrintModelItem getPrintModelItem(String name) {
        int n = this.miList.size();
        for (int i = 0; i < n; ++i) {
            PrintModelItem pmi = (PrintModelItem)this.miList.get(i);
            if (!name.equals(pmi.name)) continue;
            return pmi;
        }
        PrintModelItem pm = new PrintModelItem();
        pm.name = name;
        this.miList.add(pm);
        return pm;
    }

    public KDTable getTableByName(String name) {
        return this.tbl;
    }

    public void fillTableData(String jobID) {
        Object treePath = this.getPrintModelItem((String)jobID).treePath;
        if (this.requestData != null) {
            try {
                if (this.requestData instanceof GLRptSubLedgerUI) {
                    ((GLRptSubLedgerUI)this.requestData).setPrintFlag(true);
                    this.requestData.requestTableData(treePath);
                    ((GLRptSubLedgerUI)this.requestData).setPrintFlag(false);
                } else {
                    this.requestData.requestTableData(treePath);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            this.requestData.confirmEnd();
        } else {
            logger.error((Object)"multiTable Print error:no IRequestTableDate");
        }
    }

    public Component getParentWindow() {
        return this.parentWindow;
    }

    public void setParentWindow(Component parentWindow) {
        this.parentWindow = parentWindow;
    }

    public String[] getTableNames() {
        int size = this.miList.size();
        String[] names = new String[size];
        for (int i = 0; i < size; ++i) {
            PrintModelItem pmi = (PrintModelItem)this.miList.get(i);
            names[i] = pmi.name;
        }
        return names;
    }

    public int getTableCount() {
        return this.miList.size();
    }

    public String getTableName(int i) {
        return ((PrintModelItem)this.miList.get((int)i)).name;
    }

    public void beginPrint() {
    }

    public void beginPreview() {
    }

    public void configChanged() {
        Element e = this.manager.toXmlElement();
        this.tbl.getPrintManager().fromXmlElement(e);
        if (!this.optionSwapPage) {
            this.tbl.getPrintManager().setBodyTopMargin(this.bodyTopMargin);
        }
        this.configOver();
    }

    public void configOver() {
        this.manager.clearHeader();
    }

    public void setRequestData(IRequestTableData requestData) {
        this.requestData = requestData;
    }

    public void setOptionSwapPage(boolean optionSwapPage) {
        this.optionSwapPage = optionSwapPage;
    }

    public void configWillChange() {
        this.manager.setHeaderFooterToConfigUI();
    }

    class PrintModelItem {
        String name;
        Map var;
        Page header = null;
        Page footer = null;
        Object treePath;

        PrintModelItem() {
        }

        public String toString() {
            return this.name;
        }
    }
}

