/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common.toolkit.dbmono;

public class Lexer {
    private StringBuffer s;
    private int i;
    private int e;

    public Lexer(String ss) {
        this.s = new StringBuffer(ss.replaceAll("\\r", ""));
        this.i = 0;
        this.e = this.s.length() - 1;
    }

    public void reset() {
        this.i = 0;
    }

    public boolean eof() {
        return this.i > this.e;
    }

    public int pos() {
        return this.i;
    }

    public char next() {
        return this.s.charAt(this.i++);
    }

    public void back() {
        --this.i;
    }

    private String spaceToken() {
        int from = this.pos();
        int len = 0;
        block3: while (!this.eof()) {
            char ch = this.next();
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++len;
                    continue block3;
                }
            }
            this.back();
            return this.s.substring(from, from + len);
        }
        return this.s.substring(from, from + len);
    }

    public String nextToken() {
        boolean inQuote = false;
        char quote = '\u0000';
        int from = this.pos();
        int len = 0;
        block5: while (!this.eof()) {
            char ch = this.next();
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (inQuote) {
                        ++len;
                        continue block5;
                    }
                    this.back();
                    if (len == 0) {
                        return this.spaceToken();
                    }
                    return this.s.substring(from, from + len);
                }
                case '\"': 
                case '\'': {
                    if (len == 0) {
                        quote = ch;
                        inQuote = true;
                        ++len;
                        continue block5;
                    }
                    if (inQuote) {
                        ++len;
                        if (quote != ch) continue block5;
                        inQuote = false;
                        return this.s.substring(from, from + len);
                    }
                    ++len;
                    continue block5;
                }
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ';': 
                case '=': 
                case '@': {
                    if (inQuote) {
                        ++len;
                        continue block5;
                    }
                    if (len == 0) {
                        return String.valueOf(ch);
                    }
                    this.back();
                    return this.s.substring(from, from + len);
                }
            }
            ++len;
        }
        return this.s.substring(from, from + len);
    }
}

