/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common.toolkit.dbmono;

import com.kingdee.eas.fi.gl.common.toolkit.dbmono.Lexer;
import com.kingdee.eas.fi.gl.common.toolkit.dbmono.TokenType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.apache.log4j.Logger;

public class SQLEditor
extends JTextPane {
    private static final Logger logger = Logger.getLogger(SQLEditor.class);

    public SQLEditor() {
        this.init();
    }

    private void init() {
        this.getCaret().setBlinkRate(500);
        this.setFont(TokenType.font);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new UpdateDocumentAttributeThread(e.getOffset(), e.getLength()));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new UpdateDocumentAttributeThread(e.getOffset(), 0));
            }
        });
    }

    public String getExecuteSql() {
        String sql = this.getSelectedText();
        if (sql == null || sql.length() == 0) {
            return this.getText();
        }
        return sql;
    }

    private int getLineHeadPos(int offset) throws BadLocationException {
        String s = this.getDocument().getText(0, offset);
        for (int i = offset - 1; i >= 0; --i) {
            char ch = s.charAt(i);
            if (ch != '\r' && ch != '\n') continue;
            return i + 1;
        }
        return 0;
    }

    private int getLineEndPos(int offset) throws BadLocationException {
        String s = this.getDocument().getText(offset, this.getDocument().getLength() - offset);
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if (ch != '\r' && ch != '\n') continue;
            return offset + i;
        }
        return offset + n;
    }

    class UpdateDocumentAttributeThread
    implements Runnable {
        int offset;
        int len;

        UpdateDocumentAttributeThread(int offset, int len) {
            this.offset = offset;
            this.len = len;
        }

        @Override
        public void run() {
            try {
                Token t;
                int ffrom = SQLEditor.this.getLineHeadPos(this.offset);
                int fto = SQLEditor.this.getLineEndPos(this.offset + this.len);
                StyledDocument sd = SQLEditor.this.getStyledDocument();
                Lexer lex = new Lexer(SQLEditor.this.getDocument().getText(ffrom, fto - ffrom));
                ArrayList<Token> list = new ArrayList<Token>();
                while (!lex.eof()) {
                    t = new Token();
                    t.from = lex.pos() + ffrom;
                    t.token = lex.nextToken();
                    t.len = t.token.length();
                    list.add(t);
                }
                boolean setted = true;
                int n = list.size();
                block3: for (int i = 0; i < n; ++i) {
                    Token et;
                    setted = false;
                    t = (Token)list.get(i);
                    if (t.isEmpty()) continue;
                    if ("-".equals(t.token) && this.match("-", list, i + 1)) {
                        int to = SQLEditor.this.getLineEndPos(t.from + t.len);
                        sd.setCharacterAttributes(t.from, to, TokenType.commentAttr, true);
                        for (int j = i + 1; j < n; ++j) {
                            et = (Token)list.get(j);
                            if (et.from + et.len < to) continue;
                            i = j;
                            continue block3;
                        }
                        continue;
                    }
                    if ("/".equals(t.token) && this.match("*", list, i + 1)) {
                        int ei = i + 1;
                        while ((ei = this.searchNextToken("*", list, ei + 1)) != -1) {
                            if (!this.match("/", list, ei + 1)) continue;
                            et = (Token)list.get(ei + 1);
                            sd.setCharacterAttributes(t.from, et.from + et.len - t.from, TokenType.commentAttr, true);
                            i = ei + 1;
                            setted = true;
                            break;
                        }
                    }
                    if (setted) continue;
                    sd.setCharacterAttributes(t.from, t.len, TokenType.getSimpleAttributeSet(t.token), true);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }

        private boolean match(String token, List ts, int index) {
            return ts.size() > index && token.equals(((Token)ts.get((int)index)).token);
        }

        private int searchNextToken(String token, List ts, int from) {
            int n = ts.size();
            for (int i = from; i < n; ++i) {
                Token t = (Token)ts.get(i);
                if (!token.equals(t.token)) continue;
                return i;
            }
            return -1;
        }

        class Token {
            String token;
            int from;
            int len;

            Token() {
            }

            boolean isEmpty() {
                return this.token.trim().length() == 0;
            }

            public String toString() {
                return this.token;
            }
        }
    }
}

