/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common.toolkit.portscan;

import com.kingdee.eas.fi.gl.common.toolkit.portscan.PortExplorer;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PortScanner
extends JFrame {
    private JPanel topPanel = new JPanel();
    private JPanel bottomPanel = new JPanel();
    private JPanel mainPanel = new JPanel();
    private JTextField jtIp = new JTextField();
    private JTextField jtPort = new JTextField();
    private JButton jbScan = new JButton("scan");
    private JTextArea jtInfo = new JTextArea();
    private JProgressBar jpb = new JProgressBar();
    private JLabel jlInfo = new JLabel("-");
    private List searchResult = new ArrayList();

    public PortScanner() {
        this.jbInit();
        this.init();
    }

    private void init() {
        this.jtInfo.setEditable(false);
        this.jtIp.setText("192.168.19.244");
        this.jtPort.setText("50000");
        this.jpb.setMaximum(10);
        this.jtIp.setToolTipText("IP range, eg. 192.168.19.1-255");
        this.jtPort.setToolTipText("Port range, eg. 1-1024");
        this.jbScan.setToolTipText("scan active port");
        this.setDefaultCloseOperation(2);
    }

    private void jbInit() {
        this.setTitle("PortScanner");
        this.setSize(640, 400);
        this.jtIp.setPreferredSize(new Dimension(250, 25));
        this.jtPort.setPreferredSize(new Dimension(150, 25));
        this.topPanel.add(new JLabel("IP range:"));
        this.topPanel.add(this.jtIp);
        this.topPanel.add(new JLabel("  Port range:"));
        this.topPanel.add(this.jtPort);
        this.topPanel.add(this.jbScan);
        this.getContentPane().setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)new JScrollPane(this.jtInfo), "Center");
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add((Component)this.jlInfo, "North");
        this.bottomPanel.add((Component)this.jpb, "Center");
        this.getContentPane().add((Component)this.topPanel, "North");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.jbScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PortScanner.this.startScan();
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setVisible(true);
    }

    private void reset() {
        this.jtInfo.setText(null);
        this.jpb.setValue(0);
        this.searchResult.clear();
    }

    private void addSearchResult(String value) {
        this.searchResult.add(value);
    }

    private void startScan() {
        this.reset();
        this.jbScan.setEnabled(false);
        new Thread(new ScanRunnable()).start();
    }

    public static void main(String[] args) {
        new PortScanner();
    }

    class ScanRunnable
    implements Runnable {
        ScanRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String ip = PortScanner.this.jtIp.getText().trim();
            String port = PortScanner.this.jtPort.getText().trim();
            try {
                DetectedThread t;
                int j;
                int i = port.indexOf(45);
                int portFrom = 0;
                int portTo = 0;
                if (i >= 0) {
                    portFrom = Integer.parseInt(port.substring(0, i));
                    if (portFrom > (portTo = Integer.parseInt(port.substring(i + 1)))) {
                        int buf = portFrom;
                        portFrom = portTo;
                        portTo = buf;
                    }
                } else {
                    portTo = portFrom = Integer.parseInt(port);
                }
                i = ip.lastIndexOf(46);
                String baseIp = ip.substring(0, i);
                String rangeIp = ip.substring(i + 1);
                i = rangeIp.indexOf(45);
                ArrayList<DetectedThread> threadList = new ArrayList<DetectedThread>();
                if (i >= 0) {
                    int to;
                    int from = Integer.parseInt(rangeIp.substring(0, i));
                    if (from > (to = Integer.parseInt(rangeIp.substring(i + 1)))) {
                        int buf = from;
                        from = to;
                        to = buf;
                    }
                    PortScanner.this.jpb.setMaximum((to - from + 1) * (portTo - portFrom + 1));
                    for (j = from; j <= to && j <= 255; ++j) {
                        int kk = portTo - portFrom + 1;
                        for (int k = 0; k < kk; ++k) {
                            t = new DetectedThread(baseIp + "." + j, portFrom + k);
                            t.start();
                            threadList.add(t);
                        }
                    }
                } else {
                    PortScanner.this.jpb.setMaximum(portTo - portFrom + 1);
                    int kk = portTo - portFrom + 1;
                    for (int k = 0; k < kk; ++k) {
                        t = new DetectedThread(ip, portFrom + k);
                        t.start();
                        threadList.add(t);
                    }
                }
                int n = threadList.size();
                int overCount = 0;
                while (overCount < n) {
                    overCount = 0;
                    for (j = 0; j < n; ++j) {
                        t = (DetectedThread)threadList.get(j);
                        if (!t.isOver()) continue;
                        ++overCount;
                    }
                    PortScanner.this.jpb.setValue(overCount);
                    Thread.sleep(500L);
                }
            }
            catch (Exception e) {
                StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"413_PortScanner"));
                sb.append(e.getMessage());
                this.sendMsg(sb.toString());
            }
            finally {
                PortScanner.this.jbScan.setEnabled(true);
                this.setProcessInfo("-");
                this.scanComplete();
            }
        }

        private void scanComplete() {
            int n = PortScanner.this.searchResult.size();
            this.sendMsg("\n\n===scan result [" + n + "]===");
            for (int i = 0; i < n; ++i) {
                this.sendMsg("\n" + PortScanner.this.searchResult.get(i));
            }
            this.sendMsg("\n");
        }

        private void sendMsg(String msg) {
            PortScanner.this.jtInfo.append(msg);
            PortScanner.this.jtInfo.setCaretPosition(PortScanner.this.jtInfo.getDocument().getLength());
        }

        private void setProcessInfo(String msg) {
            PortScanner.this.jlInfo.setText(msg);
        }

        class DetectedThread
        extends Thread {
            String ip;
            int port;
            boolean over = false;

            public DetectedThread(String ip, int port) {
                this.ip = ip;
                this.port = port;
            }

            public boolean isOver() {
                return this.over;
            }

            @Override
            public void run() {
                String msg = "detecting " + this.ip + ":" + this.port + "...";
                ScanRunnable.this.setProcessInfo(msg);
                boolean b = PortExplorer.isActive(this.ip, this.port);
                ScanRunnable.this.setProcessInfo(this.ip + ":" + this.port + "  " + b + " over.");
                ScanRunnable.this.sendMsg(b + "\t" + this.ip + ":" + this.port + (b ? " -------------" : "") + "\n");
                if (b) {
                    PortScanner.this.addSearchResult(this.ip + ":" + this.port);
                }
                this.over = true;
            }
        }
    }
}

