/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common.toolkit.sqlscript;

import com.kingdee.eas.fi.gl.common.toolkit.sqlscript.LineItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LineStat {
    private Map map = new HashMap();

    public void put(String line, int lineNo, String fileName) {
        String lineKey = this.buildLineKey(line);
        if (lineKey.length() == 0) {
            return;
        }
        LineItem li = new LineItem();
        li.setLineKey(lineKey);
        if (this.map.containsKey(lineKey)) {
            li = (LineItem)this.map.get(lineKey);
            li.addSameLine(fileName, lineNo);
            li.incCount();
        } else {
            li.setLine(line);
            li.addSameLine(fileName, lineNo);
            li.incCount();
            this.map.put(lineKey, li);
        }
    }

    private String buildLineKey(String line) {
        StringBuffer sb = new StringBuffer();
        char[] chs = line.toCharArray();
        int n = chs.length;
        for (int i = 0; i < n; ++i) {
            if (chs[i] == ' ' || chs[i] == ',' || chs[i] == ';' || chs[i] == '\t') continue;
            sb.append(chs[i]);
        }
        return sb.toString().toLowerCase();
    }

    public List getRepeatList(String pattern, String excludedString, int repeatCount, boolean lineToLowerFirst) {
        ArrayList<LineItem> list = new ArrayList<LineItem>();
        for (LineItem li : this.map.values()) {
            if (li.getCount() < repeatCount || !(lineToLowerFirst ? li.getLine().toLowerCase() : li.getLine()).matches(pattern)) continue;
            if (excludedString != null && excludedString.length() > 0) {
                if ((lineToLowerFirst ? li.getLine().toLowerCase() : li.getLine()).indexOf(excludedString) != -1) continue;
                list.add(li);
                continue;
            }
            list.add(li);
        }
        return list;
    }
}

