/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common.toolkit.tablemonitor;

import com.kingdee.eas.fi.gl.common.toolkit.tablemonitor.TableMonitorListener;
import com.kingdee.eas.util.client.EASResource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class TableMonitorThread
extends Thread {
    private static final Logger logger = Logger.getLogger(TableMonitorThread.class);
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:ms");
    private boolean terminate = false;
    private String sql = null;
    private long interval = 0L;
    private List listenerList = new ArrayList(1);
    private boolean hasParseHead = false;
    private String lastMsg = null;
    private String tablePattern = "[\\w]+";
    private int tableNameColumn = 0;
    private boolean execDropTable = false;

    public TableMonitorThread(String sql, long interval) {
        this.sql = sql;
        this.interval = interval;
    }

    public void postDropTableCommand(String tablePattern, int tableNameColumn) {
        this.tablePattern = tablePattern;
        this.tableNameColumn = tableNameColumn;
        this.execDropTable = true;
    }

    @Override
    public void run() {
    }

    public void addTableMonitorListener(TableMonitorListener l) {
        this.listenerList.add(l);
    }

    private void notifyListener(String msg) {
        if (msg != null) {
            int n = this.listenerList.size();
            for (int i = 0; i < n; ++i) {
                ((TableMonitorListener)this.listenerList.get(i)).tableChange(msg);
            }
        }
    }

    public void terminate() {
        this.terminate = true;
    }

    private String parseTableChangedMsg(ResultSet rs) throws Exception {
        String msg;
        StringBuffer sb = new StringBuffer();
        ResultSetMetaData rsm = rs.getMetaData();
        int col = rsm.getColumnCount();
        int rowIndex = 1;
        while (rs.next()) {
            sb.append(rowIndex++).append("\t");
            for (int i = 1; i <= col; ++i) {
                sb.append(rs.getObject(i)).append("\t");
            }
            sb.append("\n");
        }
        if (rowIndex == 1) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"474_TableMonitorThread"));
        }
        if ((msg = sb.toString()).equals(this.lastMsg)) {
            return null;
        }
        this.lastMsg = msg;
        sb.setLength(0);
        if (!this.hasParseHead) {
            this.hasParseHead = true;
            sb.append("NO\t");
            for (int i = 1; i <= col; ++i) {
                sb.append(rsm.getColumnName(i)).append("\t");
            }
            sb.append("\n------------------------------------------------------\n");
        }
        sb.append("#Timestamp " + sdf.format(new Date()) + "\n" + msg);
        return sb.toString();
    }

    private void close(Connection con, Statement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

