/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.cslacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.BizClient;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GLResource;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.cslacct.util.Constant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ClientHelper {
    public static CompanyOrgUnitInfo getCurCompany() throws BOSException {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (company == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"CURCOMPANYISNULL"));
            SysUtil.abort();
        }
        return company;
    }

    public static UserInfo getCurUser() {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        return user;
    }

    public static boolean isAvailabilityForWfInstance(String bizObjectId) throws WfException {
        BizClient bizClient;
        AssignmentInfo[] assigns;
        boolean isTrue = false;
        if (bizObjectId != null && bizObjectId.length() != 0 && (assigns = (bizClient = BizClient.newInstance((String)UIConfig.getUrl())).checkAssignmentInfos(bizObjectId, ClientHelper.getCurUser().getId().toString())) != null && assigns.length != 0 && assigns[0] != null) {
            isTrue = true;
        }
        return isTrue;
    }

    public static Timestamp createFilterDate(Date d) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static PeriodInfo getGLCurrentPeriod(String companyId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.GENERALLEDGER.getValue())));
        fic.add(new FilterItemInfo("company.id", (Object)companyId));
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
        sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
        sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
        sic.add(new SelectorItemInfo("currentPeriod.endDate"));
        ISystemStatusCtrol ctrl = SystemStatusCtrolFactory.getRemoteInstance();
        SystemStatusCtrolCollection col = ctrl.getSystemStatusCtrolCollection(view);
        PeriodInfo prd = null;
        if (col.size() == 1) {
            prd = col.get(0).getCurrentPeriod();
        }
        if (prd == null) {
            throw new ReportException(ReportException.CURRENCY_PERIOD_ERROR);
        }
        return prd;
    }

    public static void setSelectedById(KDComboBox list, Object v) {
        if (v == null || list.getItemCount() == 0) {
            return;
        }
        String srcId = null;
        String targId = null;
        CoreBaseInfo coreObject = null;
        if (v instanceof CoreBaseInfo) {
            coreObject = (CoreBaseInfo)v;
            srcId = coreObject.getId().toString();
        } else {
            srcId = v.toString();
        }
        Object o = null;
        int count = list.getItemCount();
        for (int i = 0; i < count; ++i) {
            o = list.getItemAt(i);
            if (o == null) continue;
            if (o instanceof CoreBaseInfo) {
                coreObject = (CoreBaseInfo)o;
                targId = coreObject.getId().toString();
            } else {
                targId = o.toString();
            }
            if (!srcId.equalsIgnoreCase(targId)) continue;
            list.setSelectedIndex(i);
        }
    }

    public static void refreshCompany(KDComboBox list, CompanyOrgUnitCollection companys) throws BOSException {
        if (companys == null) {
            ClientHelper.refreshCompany(list);
        } else {
            ClientHelper.refreshList(list, (IObjectCollection)companys);
        }
    }

    public static void refreshCompany(KDComboBox list) throws BOSException {
        ClientHelper.refreshList(list, (IObjectCollection)ClientHelper.getDefaultCompanys());
    }

    public static void refreshList(KDComboBox list, IObjectCollection datas) {
        list.removeAllItems();
        list.addItem((Object)Constant.SELECTALLITEM);
        if (datas != null) {
            Iterator itor = datas.iterator();
            while (itor.hasNext()) {
                list.addItem(itor.next());
            }
        }
    }

    public static void refreshCurrency(KDComboBox list) throws EASBizException, BOSException {
        ClientHelper.refreshList(list, (IObjectCollection)ClientHelper.getDefaultCurrencys());
    }

    public static void refreshCurrency(KDComboBox list, CurrencyCollection currencys) throws EASBizException, BOSException {
        if (currencys == null) {
            ClientHelper.refreshCurrency(list);
        } else {
            ClientHelper.refreshList(list, (IObjectCollection)currencys);
        }
    }

    public static CompanyOrgUnitCollection getCompanys(String companySql) throws BOSException {
        if (companySql == null || "".equals(companySql)) {
            return null;
        }
        ICompanyOrgUnit ie = null;
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)companySql, CompareType.INNER));
        filter.setMaskString(" #0 ");
        view.setFilter(filter);
        ie = CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitCollection companys = ie.getCompanyOrgUnitCollection(view);
        return companys;
    }

    public static CompanyOrgUnitCollection getDefaultCompanys() throws BOSException {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        String sql = " select ftargcompanyid  from t_csl_requisition where fsrccompanyid= '" + company.getId().toString() + "'";
        sql = sql + " union ";
        sql = sql + " select fsrccompanyid  from t_csl_requisition where ftargcompanyid= '" + company.getId().toString() + "'";
        return ClientHelper.getCompanys(sql);
    }

    public static CompanyOrgUnitCollection getDefaultCompanys(CompanyOrgUnitInfo[] companys) throws BOSException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < companys.length; ++i) {
            if (i != 0) {
                sb.append(",");
            } else {
                sb.append("(");
            }
            sb.append("'");
            sb.append(companys[i].getId().toString());
            sb.append("'");
            if (i != companys.length - 1) continue;
            sb.append(")");
        }
        ICompanyOrgUnit ie = null;
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        String sql = " select ftargcompanyid  from t_csl_requisition where fsrccompanyid in " + sb.toString() + "";
        sql = sql + " union ";
        sql = sql + " select fsrccompanyid  from t_csl_requisition where ftargcompanyid in " + sb.toString() + "";
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        filter.setMaskString(" #0 ");
        view.setFilter(filter);
        ie = CompanyOrgUnitFactory.getRemoteInstance();
        return ie.getCompanyOrgUnitCollection(view);
    }

    public static CurrencyCollection getDefaultCurrencys() throws EASBizException, BOSException {
        ICurrency ie = null;
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        ie = CurrencyFactory.getRemoteInstance();
        CurrencyCollection currencys = ie.getCurrencyCollection(view, true);
        return currencys;
    }

    public static void refreshEnumList(KDComboBox list, Iterator itor) {
        list.removeAllItems();
        if (itor != null) {
            while (itor.hasNext()) {
                list.addItem(itor.next());
            }
        }
    }

    public static void activeTableRow(int rowIndex, KDTable tb) {
        if (tb != null && rowIndex >= 0) {
            tb.checkParsed();
            if (tb.getRow(rowIndex) != null) {
                tb.getSelectManager().select(rowIndex, 0);
            }
        }
    }

    public static String getStandardFilterTitle(String uiKey) {
        return uiKey + " - " + GLResource.getResourceString("ConditionFilter");
    }

    public static void refreshCompanyF7(KDBizPromptBox listTargCompany, NewCompanyF7 f7, CompanyOrgUnitCollection companys, String companyQueryStr) throws BOSException {
        String esql;
        f7.setCurrentCUID("00000000-0000-0000-0000-000000000000CCE7AED4");
        StringBuffer strFilter = new StringBuffer("");
        HashMap<String, Boolean> ids = new HashMap<String, Boolean>();
        if (companys != null) {
            int size = companys.size();
            for (int i = 0; i < size; ++i) {
                strFilter.append("'").append(companys.get(i).getId().toString()).append("',");
                ids.put(companys.get(i).getId().toString(), Boolean.FALSE);
            }
        }
        if (strFilter.length() > 1) {
            strFilter.deleteCharAt(strFilter.length() - 1);
            esql = "\"BASEUNIT\".Fid in (" + strFilter.toString() + ") ";
            String osql = " unit.id in (" + strFilter.toString() + ") ";
            f7.setExtraTreeFilters(esql);
            FilterInfo oFilter = new FilterInfo();
            FilterItemCollection oFic = oFilter.getFilterItems();
            oFic.add(new FilterItemInfo(osql));
            f7.setOuterFilterInfo(oFilter);
        } else {
            esql = "\"BASEUNIT\".Fid is null ";
            f7.setExtraTreeFilters(esql);
            FilterInfo oFilter = new FilterInfo();
            FilterItemCollection oFic = oFilter.getFilterItems();
            oFic.add(new FilterItemInfo("id", null, CompareType.EMPTY));
            f7.setOuterFilterInfo(oFilter);
        }
        f7.setIsCUFilter(false);
        f7.setNeedAddOrgRange(false);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("simpleName"));
        view.getSelector().add(new SelectorItemInfo("accountTable.name"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE, CompareType.EQUALS));
        if (ids.keySet().size() > 0) {
            fic.add(new FilterItemInfo("id", new HashSet(ids.keySet()), CompareType.INCLUDE));
        } else {
            fic.add(new FilterItemInfo("id", null, CompareType.EMPTY));
        }
        filter.setMaskString(" #0 and #1");
        view.setFilter(filter);
        listTargCompany.setSelector((KDPromptSelector)f7);
        listTargCompany.setEntityViewInfo(view);
        listTargCompany.setValue(null);
        listTargCompany.setEditFormat("$number$ $name$");
        listTargCompany.setDisplayFormat("$name$");
        listTargCompany.setCommitFormat("$number$;$name$");
        if (companyQueryStr == null || "".equals(companyQueryStr)) {
            companyQueryStr = "com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery4AsstAcct";
        }
        listTargCompany.setQueryInfo(companyQueryStr);
    }

    public static void refreshCompanyF7(KDBizPromptBox listTargCompany, NewCompanyF7 f7, CompanyOrgUnitInfo[] company) throws BOSException {
        CompanyOrgUnitCollection companys = null;
        companys = company == null ? ClientHelper.getDefaultCompanys() : ClientHelper.getDefaultCompanys(company);
        ClientHelper.refreshCompanyF7(listTargCompany, f7, companys, null);
    }
}

