/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.cslacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.client.CompanyTreePromptBox;
import com.kingdee.eas.fi.gl.cslacct.IRequisitionAuditFacade;
import com.kingdee.eas.fi.gl.cslacct.ReqStatusEnum;
import com.kingdee.eas.fi.gl.cslacct.RequisitionAuditFacadeFactory;
import com.kingdee.eas.fi.gl.cslacct.client.AbstractReqCheckFilterUI;
import com.kingdee.eas.fi.gl.cslacct.client.ClientHelper;
import com.kingdee.eas.fi.gl.cslacct.client.CycleController;
import com.kingdee.eas.fi.gl.cslacct.client.IReqCheckCondition;
import com.kingdee.eas.fi.gl.cslacct.client.ReqConditionVisitor;
import com.kingdee.eas.fi.gl.cslacct.util.Constant;
import com.kingdee.eas.fi.gl.cslacct.util.Helper;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.constant.Constable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;

public class ReqCheckFilterUI
extends AbstractReqCheckFilterUI {
    private static final long serialVersionUID = 2407805269051806334L;
    public static final String REQCHKFILTER_KEY_SRCCOMPANY = "srcCompany.id";
    public static final String REQCHKFILTER_KEY_SRCCOMPANY_SET = "srcCompanyIdSet";
    public static final String REQCHKFILTER_KEY_TARGCOMPANY = "company.id";
    public static final String REQCHKFILTER_KEY_CURRENCY = "currency.id";
    public static final String REQCHKFILTER_KEY_ACCOUNT = "account.number";
    public static final String REQCHKFILTER_KEY_ACCOUNT_RECIVE = "accountNumberForRecive";
    public static final String REQCHKFILTER_KEY_DATE = "createTime";
    public static final String REQCHKFILTER_KEY_FROMPIYEAR = "fromPiYear";
    public static final String REQCHKFILTER_KEY_TOPIYEAR = "toPiYear";
    public static final String REQCHKFILTER_KEY_FROMPINUM = "fromPiNum";
    public static final String REQCHKFILTER_KEY_TOPINUM = "toPiNum";
    public static final String REQCHKFILTER_KEY_STARTDATE = "startDate";
    public static final String REQCHKFILTER_KEY_ENDDATE = "endDate";
    public static final String REQCHKFILTER_KEY_STATUS = "reqstatus";
    public static final String REQCHKFILTER_KEY_ISSEND = "issend";
    public static final String REQCHKFILTER_KEY_ISACCEPT = "isaccept";
    public static final String REQCHKFILTER_KEY_ACCOUNTTABLE = "accountTable";
    public static final String CWGXRESOURCE = "com.kingdee.eas.fi.gl.client.CWGXResource";
    public static final String REQCHKFILTER_KEY_INCLUDEAVOID = "isAvoidCheck";
    public static final String CREATOR_NAME = "creator.name";
    private Set MultiSelectCompanys = null;
    private CurrencyCollection currencys = null;
    private CompanyOrgUnitInfo company = null;
    public boolean isDivisionSource = false;
    public static final String strResource = "com.kingdee.eas.fi.gl.cslacct.GRBizResource";
    private PeriodInfo curPeriod = null;
    private GlUtils.AccountPeriodInfo accountPeriod = null;
    private Map initData = null;
    public static final int BY_DATE = 64;
    public static final int SINGLE_PERIOD = 128;
    public static final int SAME_YEAR = 256;
    public static final int DIFF_YEAR = 512;
    private boolean needUnconfirmStatus = false;

    public ReqCheckFilterUI(boolean needUnconfirmStatus, Map initData) throws Exception {
        this.needUnconfirmStatus = needUnconfirmStatus;
        this.startDate.setSupportedEmpty(false);
        this.endDate.setSupportedEmpty(false);
        this.initData = initData;
    }

    private void initCompanyF7() {
        this.bpCompany.setEditable(true);
        EntityViewInfo companyView = new EntityViewInfo();
        companyView.setSelector(GlUtils.getCompanySic());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        companyView.setFilter(filter);
        this.bpCompany.setEntityViewInfo(companyView);
        this.bpCompany.setSelector(this.getCompanySelector());
        this.bpCompany.setCommitFormat("$simpleName$;$description$;$code$;$number$;$name$");
        this.bpCompany.setQueryInfo("com.kingdee.eas.fi.gl.app.CompanyOrgUnitQuery");
        this.bpCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                try {
                    if (ReqCheckFilterUI.this.isCompanyChanged(event)) {
                        ReqCheckFilterUI.this.companyChanged();
                    }
                }
                catch (Exception e) {
                    ReqCheckFilterUI.this.handUIException(e);
                }
            }
        });
    }

    protected CompanyOrgUnitInfo[] getCompanys() {
        Object company = this.bpCompany.getValue();
        if (company instanceof CompanyOrgUnitInfo) {
            return new CompanyOrgUnitInfo[]{(CompanyOrgUnitInfo)company};
        }
        if (this.bpCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            CompanyOrgUnitInfo[] companys = (CompanyOrgUnitInfo[])this.bpCompany.getValue();
            Arrays.sort(companys, new Comparator<CompanyOrgUnitInfo>(){

                @Override
                public int compare(CompanyOrgUnitInfo o1, CompanyOrgUnitInfo o2) {
                    return o1.getLongNumber().compareTo(o2.getLongNumber());
                }
            });
            return companys;
        }
        if (this.bpCompany.getValue() instanceof Object[]) {
            Object[] companyObjs = (Object[])this.bpCompany.getValue();
            return this.toObjectArray2CompanyArray(companyObjs);
        }
        return null;
    }

    private CompanyOrgUnitInfo[] toObjectArray2CompanyArray(Object[] companyObjs) {
        ArrayList<Object> companyList = new ArrayList<Object>();
        for (int i = 0; i < companyObjs.length; ++i) {
            if (!(companyObjs[i] instanceof CompanyOrgUnitInfo)) continue;
            companyList.add(companyObjs[i]);
        }
        if (companyList.isEmpty()) {
            return null;
        }
        Collections.sort(companyList, new Comparator<CompanyOrgUnitInfo>(){

            @Override
            public int compare(CompanyOrgUnitInfo o1, CompanyOrgUnitInfo o2) {
                return o1.getLongNumber().compareTo(o2.getLongNumber());
            }
        });
        CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[companyList.size()];
        return companyList.toArray(companys);
    }

    protected void companyChanged() throws Exception {
        boolean isEnable = this.getCompanys() != null;
        this.spnYearFrom.setEnabled(isEnable);
        this.spnPeriodFrom.setEnabled(isEnable);
        this.spnYearTo.setEnabled(isEnable);
        this.spnPeriodTo.setEnabled(isEnable);
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        if (companys != null && companys.length == 1) {
            AccountTableInfo acct = companys[0].getAccountTable();
            this.setSelectedItem(this.bpAccount, acct);
        }
        Object accountTable = this.bpAccount.getSelectedItem();
        this.listAccount.setEnabled(isEnable && accountTable != null);
        if (isEnable) {
            this.setPeriodRange();
        }
        this.accountTableChanged();
        this.refreshCompanyF7();
        this.refreshlistStatus();
    }

    private void refreshlistStatus() {
        Object item;
        int i;
        ReqStatusEnum old = (ReqStatusEnum)this.listStatus.getSelectedItem();
        ClientHelper.refreshEnumList(this.listStatus, ReqStatusEnum.iterator());
        int size = this.listStatus.getItemCount();
        for (i = 0; i < size; ++i) {
            item = this.listStatus.getItemAt(i);
            if (ReqStatusEnum.CANCELLATION != item) continue;
            this.listStatus.removeItemAt(i);
            break;
        }
        if (!this.needUnconfirmStatus || this.needUnconfirmStatus && !this.getAudiParam()) {
            size = this.listStatus.getItemCount();
            for (i = 0; i < size; ++i) {
                item = this.listStatus.getItemAt(i);
                if (ReqStatusEnum.UNAUDIT != item) continue;
                if (old == ReqStatusEnum.UNAUDIT) {
                    old = ReqStatusEnum.UNCHECKED;
                }
                this.listStatus.removeItemAt(i);
                break;
            }
        }
        this.listStatus.setSelectedItem((Object)old);
    }

    protected Set getCompanyIdSet() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        HashSet<String> idSet = new HashSet<String>();
        if (companys == null) {
            return idSet;
        }
        for (int i = 0; i < companys.length; ++i) {
            idSet.add(companys[i].getId().toString());
        }
        return idSet;
    }

    public CompanyOrgUnitInfo getFirstCompany() {
        if (this.company != null) {
            return this.company;
        }
        try {
            StringBuffer companyFilter = new StringBuffer();
            boolean isGroup = GlUtils.isGroupControl(null, "GLG01");
            if (isGroup) {
                ParamItemInfo paramItemInfo = ParamControlFactory.getRemoteInstance().getParamItemByNumberAndOrg("GLG01", null);
                if (!Boolean.valueOf(paramItemInfo.getValue()).booleanValue()) {
                    companyFilter.append(" and 1 != 1");
                }
            } else {
                companyFilter.append(" and cp.fid in (select FORGUNITID from t_bas_param pm inner join t_bas_paramitem pmi on pmi.fkeyid = pm.fid where pm.fnumber = 'GLG01' and pmi.fvalue_").append(SysContext.getSysContext().getLocale().toString()).append(" = 'true')");
            }
            this.company = GLGeneralFacadeFactory.getRemoteInstance().getFirstCompany(this.getPermissionItem(), companyFilter.toString());
            return this.company;
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    protected void setAccountF7Filter() {
        try {
            AccountTableInfo accountTable = (AccountTableInfo)this.bpAccount.getSelectedItem();
            CompanyOrgUnitInfo[] companys = this.getCompanys();
            if (accountTable == null || companys == null) {
                return;
            }
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("ACNotice", (Object)new Integer(1)));
            CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
            for (int i = 0; i < companys.length; ++i) {
                companyColl.add(companys[i]);
            }
            AccountPromptBox apb = new AccountPromptBox((IUIObject)this, companyColl, accountTable, filter, false, false, false);
            apb.setAccountViewUIName("com.kingdee.eas.fi.gl.client.AcctCussentF7AccountViewUI");
            this.listAccount.setSelector((KDPromptSelector)apb);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void setPeriodRange() {
        CompanyOrgUnitInfo company;
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        if (companys == null && (company = this.getFirstCompany()) != null) {
            companys = new CompanyOrgUnitInfo[]{company};
        }
        if (companys != null) {
            for (int i = 0; i < companys.length; ++i) {
                companyColl.add(companys[i]);
            }
        }
        boolean isPeriodEnable = !companyColl.isEmpty();
        this.spnYearFrom.setEnabled(isPeriodEnable);
        this.spnPeriodFrom.setEnabled(isPeriodEnable);
        this.spnYearTo.setEnabled(isPeriodEnable);
        this.spnPeriodTo.setEnabled(isPeriodEnable);
        this.startDate.setEnabled(isPeriodEnable);
        this.endDate.setEnabled(isPeriodEnable);
        if (isPeriodEnable) {
            try {
                Map pdRang = VoucherFacadeFactory.getRemoteInstance().getPeriodRange(companyColl, null);
                PeriodEntity pe = new PeriodEntity(pdRang);
                SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spnYearFrom, (KDSpinner)this.spnPeriodFrom, (KDSpinner)this.spnYearTo, (KDSpinner)this.spnPeriodTo, (boolean)false, (boolean)false);
                PeriodEntity p = pe.getQueryPeriod();
                int curYear = p.getCurrentYear();
                int cuePeriod = p.getCurrentPeriod();
                PeriodInfo curPeriodInfo = PeriodFactory.getRemoteInstance().getPeriodInfo(curYear, cuePeriod, companys[0].getAccountPeriodType());
                if (curPeriodInfo == null) {
                    Date now = new Date();
                    this.startDate.setValue((Object)now);
                    this.endDate.setValue((Object)now);
                } else {
                    Date now = new Date();
                    this.startDate.setValue((Object)curPeriodInfo.getBeginDate());
                    this.endDate.setValue((Object)now);
                }
            }
            catch (Exception e) {
                this.spnYearFrom.setEnabled(false);
                this.spnYearTo.setEnabled(false);
                this.spnPeriodFrom.setEnabled(false);
                this.spnPeriodTo.setEnabled(false);
                this.startDate.setEnabled(false);
                this.endDate.setEnabled(false);
                e.printStackTrace();
            }
        }
    }

    private boolean verifySelectedDateRange(Date from, Date to, CompanyOrgUnitCollection companyColl) throws EASBizException, BOSException {
        Map pdRang = VoucherFacadeFactory.getRemoteInstance().getPeriodRange(companyColl, null);
        PeriodEntity pe = new PeriodEntity(pdRang);
        if (pe == null || pe.getUsedPeriod() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowTAccountUI", (String)"unavailablePeriod"));
            return false;
        }
        int maxYear = pe.getUsedPeriod().getMaxYear();
        int maxPeriod = pe.getUsedPeriod().getMaxPeriod(maxYear);
        int minYear = pe.getUsedPeriod().getMinYear();
        int minPeriod = pe.getUsedPeriod().getMinPeriod(minYear);
        try {
            PeriodTypeInfo periodType = companyColl.get(0).getAccountPeriodType();
            PeriodInfo maxPeriodInfo = this.getPeriod(maxYear, maxPeriod, periodType.getId().toString());
            PeriodInfo minPeriodInfo = this.getPeriod(minYear, minPeriod, periodType.getId().toString());
            if (maxPeriodInfo == null || minPeriodInfo == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowTAccountUI", (String)"unavailablePeriod"));
                return false;
            }
            if (from.before(minPeriodInfo.getBeginDate())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.CashFlowTAccountUI", (String)"notLessThanStartPeriod"));
                this.startDate.requestFocus();
                return false;
            }
            return true;
        }
        catch (BOSException e) {
            this.handUIException(e);
            return false;
        }
    }

    private PeriodInfo getPeriod(int periodYear, int periodNumber, String periodTypeId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodTypeId, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        PeriodInfo info = null;
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    private CompanyOrgUnitInfo[] dealNullCompany() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        if (companys == null) {
            CompanyOrgUnitInfo company = this.getFirstCompany();
            if (company == null) {
                company = SysContext.getSysContext().getCurrentFIUnit();
            }
            companys = new CompanyOrgUnitInfo[]{company};
        }
        return companys;
    }

    protected boolean isCompanyChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            return e.getOldValue() != null;
        }
        if (e.getOldValue() == null) {
            return true;
        }
        return !this.isCompanyEquals(e.getNewValue(), e.getOldValue());
    }

    protected boolean isCompanyEquals(Object newObject, Object oldObject) {
        if (newObject instanceof Object[] && oldObject instanceof Object[] && Arrays.toString((Object[])newObject).equalsIgnoreCase(Arrays.toString((Object[])oldObject))) {
            return true;
        }
        if (newObject instanceof CompanyOrgUnitInfo && oldObject instanceof CompanyOrgUnitInfo) {
            return ((CompanyOrgUnitInfo)newObject).getId().equals((Object)((CompanyOrgUnitInfo)oldObject).getId());
        }
        return false;
    }

    private String getCompanyIdFilter() {
        StringBuffer companyIdStr = new StringBuffer();
        try {
            companyIdStr.append(GLGeneralFacadeFactory.getRemoteInstance().getCompanyIDSQL(this.getPermissionItem(), null, true));
            boolean isGroup = GlUtils.isGroupControl(null, "GLG01");
            if (isGroup) {
                ParamItemInfo paramItemInfo = ParamControlFactory.getRemoteInstance().getParamItemByNumberAndOrg("GLG01", null);
                if (!Boolean.valueOf(paramItemInfo.getValue()).booleanValue()) {
                    companyIdStr.append(" and 1 != 1");
                }
            } else {
                companyIdStr.append(" and cp.fid in (select FORGUNITID from t_bas_param pm inner join t_bas_paramitem pmi on pmi.fkeyid = pm.fid where pm.fnumber = 'GLG01' and pmi.fvalue_").append(SysContext.getSysContext().getLocale().toString()).append(" = 'true')");
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return companyIdStr.toString();
    }

    protected boolean canMultiSelectCompany() {
        CoreUI baseUI = (CoreUI)this.getUIContext().get("Owner");
        String uiParam = (String)baseUI.getUIContext().get("UIClassParam");
        return !GlUtils.isEmpty(uiParam) && "FSSC".equalsIgnoreCase(uiParam);
    }

    protected void initAccountTableComboBox() throws Exception {
        this.bpAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                try {
                    if (event.getStateChange() == 1 || ReqCheckFilterUI.this.bpAccount.getSelectedItem() == null) {
                        ReqCheckFilterUI.this.accountTableChanged();
                    }
                }
                catch (Exception e) {
                    ReqCheckFilterUI.this.handUIException(e);
                }
            }
        });
        AccountTableCollection accountTables = (AccountTableCollection)this.initData.get(REQCHKFILTER_KEY_ACCOUNTTABLE);
        Vector accountTableList = this.toVector((AbstractObjectCollection)accountTables);
        accountTableList.add(0, null);
        this.bpAccount.setModel(new DefaultComboBoxModel(accountTableList));
    }

    private Vector toVector(AbstractObjectCollection coll) {
        if (coll == null) {
            return null;
        }
        Vector v = new Vector();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            v.add(it.next());
        }
        return v;
    }

    private boolean isMultiSelectCompany() {
        return !SysContext.getSysContext().getCurrentFIUnit().isIsBizUnit() && this.isSupportUnion() || this.canMultiSelectCompany();
    }

    protected KDPromptSelector getCompanySelector() {
        if (this.isMultiSelectCompany()) {
            return new CompanyTreePromptBox((CoreUIObject)this, null, this.bpCompany, this.getPermissionItem(), true, " cp.fid in (" + this.getCompanyIdFilter() + ")");
        }
        NewCompanyF7 companySelector = new NewCompanyF7((IUIObject)this);
        companySelector.setShowAssistantOrg(false);
        companySelector.setIsCUFilter(false);
        companySelector.setShowVirtual(false);
        companySelector.setContainSealUp(false);
        companySelector.setNeedAddAssistant(true);
        companySelector.setOuterFilterInfo(this.getCompanyFilterInfo());
        companySelector.setExtraTreeFilters("\"STRUCTURE\".FUnitID in (" + this.getCompanyIdFilter() + ")");
        return companySelector;
    }

    private FilterInfo getCompanyFilterInfo() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("unit.id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        return filter;
    }

    protected boolean isSupportUnion() {
        return false;
    }

    protected String getPermissionItem() {
        return (String)this.initData.get("permissionItem");
    }

    protected boolean isUnionQuery() {
        return !SysContext.getSysContext().getCurrentFIUnit().isIsBizUnit() && this.isSupportUnion();
    }

    protected void setSelectedItem(KDComboBox comboBox, Object value) {
        if (value == null) {
            comboBox.setSelectedItem(null);
            return;
        }
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            DataBaseInfo info;
            Object object = comboBox.getItemAt(i);
            if (value == object) {
                comboBox.setSelectedIndex(i);
                break;
            }
            if (!(value instanceof DataBaseInfo) || !(object instanceof DataBaseInfo) || (info = (DataBaseInfo)object) == null || !((DataBaseInfo)value).getId().equals((Object)info.getId())) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    public void onLoad() throws Exception {
        this.bpCompany.setEnabledMultiSelection(true);
        this.company = (CompanyOrgUnitInfo)this.initData.get("CurCompany");
        if (this.company == null) {
            this.company = this.getFirstCompany();
        }
        this.accountPeriod = (GlUtils.AccountPeriodInfo)this.initData.get("CurAccountPeriod");
        this.currencys = (CurrencyCollection)this.initData.get("Currency");
        this.refresh();
        super.onLoad();
        if (this.isDivisionSource) {
            this.chkReceive.setVisible(true);
            this.chkSend.setVisible(true);
            this.chkSend.setSelected(true);
            this.accountNumberForRecive.setEditable(false);
        } else {
            this.chkReceive.setVisible(false);
            this.chkSend.setVisible(false);
        }
        this.initCompanyF7();
        this.initAccountTableComboBox();
        this.companyChanged();
        this.pnlByPeriod.setVisible(true);
        this.pnlByDate.setVisible(false);
        this.setPeriodRange();
    }

    public boolean verify() {
        Date dateend;
        Date datestart;
        if (this.getCompanys() == null) {
            this.bpCompany.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"104_HGReplaceToolUI"));
            return false;
        }
        if (this.radByDate.isSelected() && (datestart = (Date)this.startDate.getValue()).after(dateend = (Date)this.endDate.getValue())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"4_ReqCheckFilterUI"));
            return false;
        }
        return true;
    }

    private boolean verifyViewPermission() {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        StringBuffer errOrg = new StringBuffer();
        try {
            Map mapOrgWithPerm = GLGeneralFacadeFactory.getRemoteInstance().getOrgWithPerm(this.getPermissionItem(), companys);
            for (int i = 0; i < companys.length; ++i) {
                CompanyOrgUnitInfo company = companys[i];
                if (mapOrgWithPerm.containsKey(company.getId().toString())) continue;
                if (errOrg.length() > 0) {
                    errOrg.append(",");
                }
                errOrg.append(company.getName());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (errOrg.length() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)CWGXRESOURCE, (String)"solutionNotValid"), errOrg.toString()));
            return false;
        }
        return true;
    }

    public void clear() {
        try {
            this.refresh();
        }
        catch (EASBizException e) {
            super.handUIException((Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
            SysUtil.abort();
        }
        CompanyOrgUnitInfo firstCompany = this.getFirstCompany();
        if (firstCompany != null) {
            this.bpCompany.setValue((Object)new CompanyOrgUnitInfo[]{firstCompany});
        } else {
            this.bpCompany.setValue(null);
        }
        if (firstCompany != null && firstCompany.getAccountTable() != null) {
            this.setSelectedItem(this.bpAccount, firstCompany);
        }
        this.chkSend.setSelected(true);
        this.chkReceive.setSelected(false);
        this.radByPeriod.doClick();
        this.chkIncludeAvoid.setSelected(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.setParam(RptFilterUtils.toObjectFromRptFilterMap((Object)RptParamsUtil.getFromCustomerParams((CustomerParams)cp)));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            SysUtil.abort();
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        RptParamsUtil.setToCustomerParams((CustomerParams)cp, (Object)RptFilterUtils.toRptFilterMapFromObject((Object)this.getParam()));
        return cp;
    }

    public Object getParam() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.bpCompany.getValue() != null) {
            params.put(REQCHKFILTER_KEY_SRCCOMPANY, this.bpCompany.getValue());
        }
        params.put(REQCHKFILTER_KEY_ACCOUNTTABLE, this.bpAccount.getSelectedItem());
        if (this.listTargCompany.getValue() != null) {
            params.put(REQCHKFILTER_KEY_TARGCOMPANY, this.listTargCompany.getValue());
        }
        if (this.listCurrecny.getSelectedItem() != null) {
            params.put(REQCHKFILTER_KEY_CURRENCY, this.listCurrecny.getSelectedItem());
        }
        if (this.listAccount.getValue() != null) {
            params.put(REQCHKFILTER_KEY_ACCOUNT, this.listAccount.getValue());
        }
        if (this.accountNumberForRecive.getText() != null && !"".equals(this.accountNumberForRecive.getText())) {
            params.put(REQCHKFILTER_KEY_ACCOUNT_RECIVE, this.accountNumberForRecive.getText());
        }
        if (this.listStatus.getSelectedItem() != null) {
            params.put(REQCHKFILTER_KEY_STATUS, this.listStatus.getSelectedItem());
        }
        if (this.startDate.getValue() != null) {
            params.put(REQCHKFILTER_KEY_STARTDATE, this.startDate.getValue());
        }
        if (this.spnYearFrom.getValue() != null) {
            params.put(REQCHKFILTER_KEY_FROMPIYEAR, this.spnYearFrom.getValue());
        }
        if (this.spnYearTo.getValue() != null) {
            params.put(REQCHKFILTER_KEY_TOPIYEAR, this.spnYearTo.getValue());
        }
        if (this.spnPeriodFrom.getValue() != null) {
            params.put(REQCHKFILTER_KEY_FROMPINUM, this.spnPeriodFrom.getValue());
        }
        if (this.spnPeriodTo.getValue() != null) {
            params.put(REQCHKFILTER_KEY_TOPINUM, this.spnPeriodTo.getValue());
        }
        if (this.endDate.getValue() != null) {
            params.put(REQCHKFILTER_KEY_ENDDATE, this.endDate.getValue());
        }
        params.put(REQCHKFILTER_KEY_ISSEND, new Integer(this.chkSend.getSelected()));
        params.put(REQCHKFILTER_KEY_ISACCEPT, new Integer(this.chkReceive.getSelected()));
        params.put("isRadByPeriod", this.getFlag() + "");
        params.put(REQCHKFILTER_KEY_INCLUDEAVOID, new Boolean(this.chkIncludeAvoid.isSelected()));
        return params;
    }

    public void setParam(Object param) {
        Constable v;
        if (param == null) {
            return;
        }
        Map params = (Map)param;
        if (params.containsKey("isRadByPeriod") && params.get("isRadByPeriod").equals(String.valueOf(64))) {
            this.radByDate.setSelected(true);
            this.radByPeriod.setSelected(false);
            this.radByDate.doClick();
        } else {
            this.radByDate.setSelected(false);
            this.radByPeriod.setSelected(true);
            this.radByPeriod.doClick();
        }
        if (params.containsKey(REQCHKFILTER_KEY_SRCCOMPANY)) {
            Object obj = params.get(REQCHKFILTER_KEY_SRCCOMPANY);
            if (obj instanceof Object[]) {
                Object[] objs = (Object[])obj;
                CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[objs.length];
                System.arraycopy(objs, 0, companys, 0, objs.length);
                companys = this.filterCompany(companys);
                this.bpCompany.setValue((Object)companys);
            } else if (obj instanceof CompanyOrgUnitInfo) {
                this.bpCompany.setValue(obj);
            }
        } else {
            this.bpCompany.setValue((Object)new CompanyOrgUnitInfo[]{this.getFirstCompany()});
        }
        if (params.get(REQCHKFILTER_KEY_ACCOUNTTABLE) != null) {
            this.bpAccount.setSelectedItem(params.get(REQCHKFILTER_KEY_ACCOUNTTABLE));
        } else {
            this.setSelectedItem(this.bpAccount, null);
        }
        if (params.containsKey(REQCHKFILTER_KEY_TARGCOMPANY)) {
            this.listTargCompany.setValue(params.get(REQCHKFILTER_KEY_TARGCOMPANY));
        } else {
            this.listTargCompany.setValue(null);
        }
        if (params.containsKey(REQCHKFILTER_KEY_ACCOUNT)) {
            this.listAccount.setValue(params.get(REQCHKFILTER_KEY_ACCOUNT));
        } else {
            this.listAccount.setValue(null);
        }
        if (params.containsKey(REQCHKFILTER_KEY_ACCOUNT_RECIVE)) {
            this.accountNumberForRecive.setText(params.get(REQCHKFILTER_KEY_ACCOUNT_RECIVE).toString());
        } else {
            this.accountNumberForRecive.setText(null);
        }
        if (params.containsKey(REQCHKFILTER_KEY_CURRENCY)) {
            this.listCurrecny.setSelectedItem(params.get(REQCHKFILTER_KEY_CURRENCY));
        }
        if (params.containsKey(REQCHKFILTER_KEY_STATUS)) {
            this.listStatus.setSelectedItem(params.get(REQCHKFILTER_KEY_STATUS));
        }
        if (params.containsKey(REQCHKFILTER_KEY_FROMPIYEAR)) {
            this.spnYearFrom.setValue(params.get(REQCHKFILTER_KEY_FROMPIYEAR));
        }
        if (params.containsKey(REQCHKFILTER_KEY_TOPIYEAR)) {
            this.spnYearTo.setValue(params.get(REQCHKFILTER_KEY_TOPIYEAR));
        }
        if (params.containsKey(REQCHKFILTER_KEY_FROMPINUM)) {
            this.spnPeriodFrom.setValue(params.get(REQCHKFILTER_KEY_FROMPINUM));
        }
        if (params.containsKey(REQCHKFILTER_KEY_TOPINUM)) {
            this.spnPeriodTo.setValue(params.get(REQCHKFILTER_KEY_TOPINUM));
        }
        if (params.containsKey(REQCHKFILTER_KEY_STARTDATE)) {
            this.startDate.setValue(params.get(REQCHKFILTER_KEY_STARTDATE));
        }
        if (params.containsKey(REQCHKFILTER_KEY_ENDDATE)) {
            this.endDate.setValue(params.get(REQCHKFILTER_KEY_ENDDATE));
        }
        if (params.containsKey(REQCHKFILTER_KEY_ISSEND)) {
            v = (Integer)params.get(REQCHKFILTER_KEY_ISSEND);
            this.chkSend.setSelected(((Integer)v).intValue(), false);
        }
        if (params.containsKey(REQCHKFILTER_KEY_ISACCEPT)) {
            v = (Integer)params.get(REQCHKFILTER_KEY_ISACCEPT);
            this.chkReceive.setSelected(((Integer)v).intValue(), false);
        }
        if (params.containsKey(REQCHKFILTER_KEY_INCLUDEAVOID)) {
            v = (Boolean)params.get(REQCHKFILTER_KEY_INCLUDEAVOID);
            this.chkIncludeAvoid.setSelected(((Boolean)v).booleanValue());
        }
    }

    private CompanyOrgUnitInfo[] filterCompany(CompanyOrgUnitInfo[] companys) {
        HashSet<String> companyIdSet = new HashSet<String>();
        if (companys == null || companys.length <= 0) {
            return null;
        }
        for (int i = 0; i < companys.length; ++i) {
            companyIdSet.add(companys[i].getId().toString());
        }
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)this.getCompanyIdFilter(), CompareType.INNER));
        fic.add(new FilterItemInfo("id", companyIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(GlUtils.getCompanySic());
        CompanyOrgUnitCollection collection = null;
        try {
            collection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        if (collection.size() == 0) {
            return null;
        }
        Object[] obj = collection.toArray();
        CompanyOrgUnitInfo[] companyArray = new CompanyOrgUnitInfo[obj.length];
        System.arraycopy(obj, 0, companyArray, 0, obj.length);
        return companyArray;
    }

    public FilterInfo getFilterInfo() {
        int index = 0;
        StringBuffer maskString = new StringBuffer("");
        this.filterInfo = new FilterInfo();
        int flag = this.getFlag();
        if ((flag & 0x40) == 0) {
            FilterItemCollection fic = this.filterInfo.getFilterItems();
            Integer yearFrom = (Integer)this.spnYearFrom.getValue();
            Integer periodFrom = (Integer)this.spnPeriodFrom.getValue();
            Integer yearTo = (Integer)this.spnYearTo.getValue();
            Integer periodTo = (Integer)this.spnPeriodTo.getValue();
            maskString.append("(");
            if ((flag & 0x80) != 0) {
                fic.add(new FilterItemInfo("period.periodYear", (Object)yearFrom));
                fic.add(new FilterItemInfo("period.periodNumber", (Object)periodFrom));
                maskString.append("#" + index++ + " AND ");
                maskString.append("#" + index++ + ")");
            } else if ((flag & 0x100) != 0) {
                fic.add(new FilterItemInfo("period.periodYear", (Object)yearFrom));
                fic.add(new FilterItemInfo("period.periodNumber", (Object)periodFrom, CompareType.GREATER_EQUALS));
                fic.add(new FilterItemInfo("period.periodNumber", (Object)periodTo, CompareType.LESS_EQUALS));
                maskString.append("#" + index++ + " AND ");
                maskString.append("#" + index++ + " AND ");
                maskString.append("#" + index++ + ")");
            } else {
                fic.add(new FilterItemInfo("period.periodYear", (Object)yearFrom));
                fic.add(new FilterItemInfo("period.periodNumber", (Object)periodFrom, CompareType.GREATER_EQUALS));
                fic.add(new FilterItemInfo("period.periodYear", (Object)yearFrom, CompareType.GREATER));
                fic.add(new FilterItemInfo("period.periodYear", (Object)yearTo));
                fic.add(new FilterItemInfo("period.periodNumber", (Object)periodTo, CompareType.LESS_EQUALS));
                fic.add(new FilterItemInfo("period.periodYear", (Object)yearTo, CompareType.LESS));
                maskString.append("((#" + index++ + " AND ");
                maskString.append("#" + index++ + ") OR ");
                maskString.append("#" + index++ + ") AND ");
                maskString.append("((#" + index++ + " AND ");
                maskString.append("#" + index++ + ") OR ");
                maskString.append("#" + index++ + "))");
            }
        } else {
            Date startDate = (Date)this.startDate.getValue();
            Date endDate = (Date)this.endDate.getValue();
            if (startDate == null || endDate == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"5_ReqCheckFilterUI"));
                SysUtil.abort();
            }
            if (startDate != null) {
                FilterItemInfo filterItemStartDate = new FilterItemInfo(REQCHKFILTER_KEY_DATE, (Object)Helper.getFilterDate(startDate, REQCHKFILTER_KEY_STARTDATE), CompareType.GREATER);
                this.filterInfo.getFilterItems().add(filterItemStartDate);
                maskString.append(" #" + index++);
            }
            if (endDate != null) {
                FilterItemInfo filterItemEndDate = new FilterItemInfo(REQCHKFILTER_KEY_DATE, (Object)Helper.getFilterDate(endDate, REQCHKFILTER_KEY_ENDDATE), CompareType.LESS);
                this.filterInfo.getFilterItems().add(filterItemEndDate);
                if (maskString.length() > 0) {
                    maskString.append(" And #" + index++);
                } else {
                    maskString.append(" #" + index++);
                }
            }
        }
        ReqStatusEnum status = (ReqStatusEnum)this.listStatus.getSelectedItem();
        if (!status.equals((Object)ReqStatusEnum.ALL)) {
            boolean isAudit;
            Integer statusValue = new Integer(status.getValue());
            if ((status == ReqStatusEnum.UNCHECKED || status == ReqStatusEnum.UNAUDIT) && (isAudit = this.getAudiParam())) {
                Boolean reqAudit = Boolean.FALSE;
                if (status == ReqStatusEnum.UNCHECKED) {
                    reqAudit = Boolean.TRUE;
                }
                this.filterInfo.getFilterItems().add(new FilterItemInfo("isAudit", (Object)reqAudit, CompareType.EQUALS));
                if (maskString.length() > 0) {
                    maskString.append(" And #" + index++);
                } else {
                    maskString.append(" #" + index++);
                }
                statusValue = new Integer(1);
            }
            FilterItemInfo filterItemStatus = new FilterItemInfo(REQCHKFILTER_KEY_STATUS, (Object)statusValue, CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemStatus);
            if (maskString.length() > 0) {
                maskString.append(" And #" + index++);
            } else {
                maskString.append(" #" + index++);
            }
        }
        index = this.setCompanyFilter(maskString, index);
        if (this.listCurrecny.getSelectedItem() != null && !this.listCurrecny.getSelectedItem().toString().equalsIgnoreCase(Constant.SELECTALLITEM)) {
            FilterItemInfo filterItemCurrency = new FilterItemInfo(REQCHKFILTER_KEY_CURRENCY, (Object)((CurrencyInfo)this.listCurrecny.getSelectedItem()).getId().toString(), CompareType.EQUALS);
            this.filterInfo.getFilterItems().add(filterItemCurrency);
            if (maskString.length() > 0) {
                maskString.append(" And #" + index++);
            } else {
                maskString.append(" #" + index++);
            }
        }
        if (this.listAccount.getValue() != null) {
            Object obj = this.listAccount.getValue();
            String accountNum = null;
            if (obj instanceof AccountViewInfo) {
                accountNum = ((AccountViewInfo)obj).getNumber();
            } else if (obj instanceof String) {
                accountNum = (String)obj;
            }
            if (accountNum != null) {
                FilterItemInfo filterItemAccount = new FilterItemInfo(REQCHKFILTER_KEY_ACCOUNT, (Object)accountNum, CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemAccount);
                if (maskString.length() > 0) {
                    maskString.append(" And #" + index++);
                } else {
                    maskString.append(" #" + index++);
                }
            }
        }
        this.filterInfo.setMaskString(maskString.toString());
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo view) {
        if (view == null || view.getFilter() == null || view.getFilter().getFilterItems() == null || view.getFilter().getFilterItems().size() == 0) {
            return;
        }
        FilterItemCollection fic = view.getFilter().getFilterItems();
        boolean index = false;
    }

    private int setCompany(FilterItemCollection fic, int index) {
        CompanyOrgUnitInfo[] companys = null;
        if (fic.get(index).getPropertyName().equals(REQCHKFILTER_KEY_SRCCOMPANY)) {
            EntityViewInfo companyView = new EntityViewInfo();
            companyView.setSelector(GlUtils.getCompanySic());
            Object companyId = fic.get(index).getCompareValue();
            Set<Object> companyIdSet = null;
            if (companyId instanceof String) {
                companyIdSet = new HashSet<Object>();
                companyIdSet.add(companyId);
            } else {
                companyIdSet = (Set)fic.get(index).getCompareValue();
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", companyIdSet, CompareType.INCLUDE));
            companyView.setFilter(filter);
            try {
                CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(companyView);
                companys = new CompanyOrgUnitInfo[companyColl.size()];
                for (int i = 0; i < companys.length; ++i) {
                    companys[i] = companyColl.get(i);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            ++index;
        } else {
            companys = this.dealNullCompany();
        }
        this.setCompanys(companys);
        return index;
    }

    protected void setCompanys(CompanyOrgUnitInfo[] companys) {
        this.bpCompany.setValue((Object)companys);
    }

    private int setCompanyFilter(StringBuffer maskString, int index) {
        boolean isMulti = this.isMultiSelectCompany();
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        if (companys == null) {
            companys = new CompanyOrgUnitInfo[]{this.getFirstCompany()};
        }
        Set<String> companyIdSet = new HashSet();
        if (isMulti && this.needUnconfirmStatus && this.getAudiParam()) {
            companyIdSet = this.MultiSelectCompanys;
        } else {
            for (int i = 0; companys != null && i < companys.length; ++i) {
                if (companys[i] == null) continue;
                companyIdSet.add(companys[i].getId().toString());
            }
        }
        CompanyOrgUnitInfo srcCompany = companys == null ? null : companys[0];
        CompanyOrgUnitInfo targCompany = null;
        if (this.listTargCompany.getValue() != null) {
            targCompany = (CompanyOrgUnitInfo)this.listTargCompany.getValue();
        }
        int received = this.chkReceive.getSelected();
        int sended = this.chkSend.getSelected();
        if (received == 32 && sended == 16) {
            FilterItemInfo filterItemTargCompany;
            if (targCompany != null) {
                FilterItemInfo filterItemCompany = new FilterItemInfo(REQCHKFILTER_KEY_SRCCOMPANY, (Object)targCompany.getId(), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemCompany);
                maskString.append(" And #" + index++);
            }
            if (!isMulti) {
                if (srcCompany != null) {
                    filterItemTargCompany = new FilterItemInfo(REQCHKFILTER_KEY_TARGCOMPANY, (Object)srcCompany.getId(), CompareType.EQUALS);
                    this.filterInfo.getFilterItems().add(filterItemTargCompany);
                    maskString.append(" And #" + index++);
                }
            } else if (companyIdSet.size() > 0) {
                filterItemTargCompany = new FilterItemInfo(REQCHKFILTER_KEY_TARGCOMPANY, companyIdSet, CompareType.INCLUDE);
                this.filterInfo.getFilterItems().add(filterItemTargCompany);
                maskString.append(" And #" + index++);
            }
        } else if (received == 16 && sended == 32) {
            FilterItemInfo filterItemCompany;
            if (!isMulti) {
                if (srcCompany != null) {
                    filterItemCompany = new FilterItemInfo(REQCHKFILTER_KEY_SRCCOMPANY, (Object)srcCompany.getId(), CompareType.EQUALS);
                    this.filterInfo.getFilterItems().add(filterItemCompany);
                    maskString.append(" And #" + index++);
                }
            } else if (companyIdSet.size() > 0) {
                filterItemCompany = new FilterItemInfo(REQCHKFILTER_KEY_SRCCOMPANY, companyIdSet, CompareType.INCLUDE);
                this.filterInfo.getFilterItems().add(filterItemCompany);
                maskString.append(" And #" + index++);
            }
            if (targCompany != null) {
                FilterItemInfo filterItemTargCompany = new FilterItemInfo(REQCHKFILTER_KEY_TARGCOMPANY, (Object)targCompany.getId(), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemTargCompany);
                maskString.append(" And #" + index++);
            }
        } else if (received == 32 && sended == 32) {
            FilterItemInfo filterItemCompany = null;
            FilterItemInfo filterItemCompany1 = null;
            FilterItemInfo filterItemTargCompany = null;
            FilterItemInfo filterItemTargCompany1 = null;
            if (!isMulti) {
                if (srcCompany != null) {
                    filterItemCompany = new FilterItemInfo(REQCHKFILTER_KEY_SRCCOMPANY, (Object)srcCompany.getId(), CompareType.EQUALS);
                    filterItemTargCompany1 = new FilterItemInfo(REQCHKFILTER_KEY_TARGCOMPANY, (Object)srcCompany.getId(), CompareType.EQUALS);
                }
            } else if (companyIdSet.size() > 0) {
                filterItemCompany = new FilterItemInfo(REQCHKFILTER_KEY_SRCCOMPANY, companyIdSet, CompareType.INCLUDE);
                filterItemTargCompany1 = new FilterItemInfo(REQCHKFILTER_KEY_TARGCOMPANY, companyIdSet, CompareType.INCLUDE);
            }
            if (targCompany != null) {
                filterItemTargCompany = new FilterItemInfo(REQCHKFILTER_KEY_TARGCOMPANY, (Object)targCompany.getId(), CompareType.EQUALS);
                filterItemCompany1 = new FilterItemInfo(REQCHKFILTER_KEY_SRCCOMPANY, (Object)targCompany.getId(), CompareType.EQUALS);
            }
            if (srcCompany != null || targCompany != null) {
                maskString.append(" AND ((");
            }
            if (srcCompany != null) {
                this.filterInfo.getFilterItems().add(filterItemCompany);
                maskString.append(" #" + index++);
            }
            if (targCompany != null && srcCompany != null) {
                maskString.append(" AND ");
            }
            if (targCompany != null) {
                this.filterInfo.getFilterItems().add(filterItemTargCompany);
                maskString.append(" #" + index++);
            }
            if (srcCompany != null || targCompany != null) {
                maskString.append(")");
            }
            if (srcCompany != null || targCompany != null) {
                maskString.append(" OR (");
            }
            if (targCompany != null) {
                this.filterInfo.getFilterItems().add(filterItemCompany1);
                maskString.append(" #" + index++);
            }
            if (targCompany != null && srcCompany != null) {
                maskString.append(" AND ");
            }
            if (srcCompany != null) {
                this.filterInfo.getFilterItems().add(filterItemTargCompany1);
                maskString.append(" #" + index++);
            }
            if (srcCompany != null || targCompany != null) {
                maskString.append("))");
            }
        } else {
            FilterItemInfo filterItemCompany;
            if (!isMulti) {
                if (srcCompany != null) {
                    filterItemCompany = new FilterItemInfo(REQCHKFILTER_KEY_SRCCOMPANY, (Object)srcCompany.getId(), CompareType.EQUALS);
                    this.filterInfo.getFilterItems().add(filterItemCompany);
                    maskString.append(" And #" + index++);
                }
            } else if (srcCompany != null) {
                filterItemCompany = new FilterItemInfo(REQCHKFILTER_KEY_SRCCOMPANY, companyIdSet, CompareType.INCLUDE);
                this.filterInfo.getFilterItems().add(filterItemCompany);
                maskString.append(" And #" + index++);
            }
            if (targCompany != null) {
                FilterItemInfo filterItemTargCompany = new FilterItemInfo(REQCHKFILTER_KEY_TARGCOMPANY, (Object)targCompany.getId(), CompareType.EQUALS);
                this.filterInfo.getFilterItems().add(filterItemTargCompany);
                maskString.append(" And #" + index++);
            }
        }
        return index;
    }

    private void refresh() throws EASBizException, BOSException {
        this.refreshDate();
        this.refreshCompanyF7();
        ClientHelper.refreshCurrency(this.listCurrecny, this.currencys);
        this.refreshlistStatus();
        this.listStatus.setSelectedItem((Object)ReqStatusEnum.UNCHECKED);
        this.setAccountF7Filter();
        this.listAccount.setEditFormat("$number$");
        this.listAccount.setCommitFormat("$helpCode$;$number$;$name$");
        this.listAccount.setDisplayFormat("$number$ - $name$");
        this.listAccount.setValue(null);
        this.listAccount.setCommitParser((IParser)new AccountViewParser(this.listAccount));
    }

    private void refreshCompanyF7() throws BOSException {
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        if (companys == null || companys.length == 0) {
            this.listTargCompany.setValue(null);
            this.listTargCompany.setEnabled(false);
        } else {
            this.listTargCompany.setEnabled(true);
        }
        NewCompanyF7 f7 = new NewCompanyF7((IUIObject)this);
        ClientHelper.refreshCompanyF7(this.listTargCompany, f7, companys);
    }

    private void refreshDate() throws EASBizException, BOSException {
        this.setPeriodRange();
    }

    public void refreshCompany(KDComboBox list) throws BOSException {
        CompanyOrgUnitInfo[] companys = this.dealNullCompany();
        CompanyOrgUnitCollection companyCollection = ClientHelper.getDefaultCompanys(companys);
        ClientHelper.refreshCompany(list, companyCollection);
    }

    private Map getSelectedValues() {
        Map<String, CompanyOrgUnitInfo> v = new HashMap();
        Object o = this.getParam();
        if (o != null && o instanceof Map) {
            v = (Map)o;
            try {
                v.put(REQCHKFILTER_KEY_SRCCOMPANY, ClientHelper.getCurCompany());
            }
            catch (BOSException e) {
                super.handUIException((Throwable)e);
            }
            this.setSelectedValue(this.listCurrecny, REQCHKFILTER_KEY_CURRENCY, v);
        }
        return v;
    }

    private void setSelectedValue(KDComboBox list, String keyString, Map v) {
        if (list.getItemCount() >= 0 && list.getSelectedItem() != null && list.getSelectedItem().toString().equalsIgnoreCase(Constant.SELECTALLITEM)) {
            v.put(keyString, list.getItemAt(0));
        }
    }

    public IReqCheckCondition conditionVisitior() throws BOSException {
        Map<String, CompanyOrgUnitInfo> value = new HashMap<String, String>();
        Object o = this.getParam();
        if (o != null && o instanceof Map) {
            value = (Map)o;
            if (value.get(REQCHKFILTER_KEY_SRCCOMPANY) == null) {
                value.put(REQCHKFILTER_KEY_SRCCOMPANY, ClientHelper.getCurCompany());
            } else {
                Object obj = value.get(REQCHKFILTER_KEY_SRCCOMPANY);
                if (obj instanceof CompanyOrgUnitInfo[]) {
                    CompanyOrgUnitInfo[] comapanys = (CompanyOrgUnitInfo[])obj;
                    value.put(REQCHKFILTER_KEY_SRCCOMPANY, comapanys[0]);
                } else if (obj instanceof CompanyOrgUnitInfo) {
                    value.put(REQCHKFILTER_KEY_SRCCOMPANY, (CompanyOrgUnitInfo)obj);
                }
            }
        }
        if (this.listTargCompany.getValue() == null) {
            value.put(REQCHKFILTER_KEY_TARGCOMPANY, (CompanyOrgUnitInfo)Constant.SELECTALLITEM);
        }
        ReqConditionVisitor visitor = new ReqConditionVisitor(value);
        return visitor;
    }

    public IReqCheckCondition conditionIteratedVisitior() {
        String v;
        CycleController cyc = new CycleController();
        if (this.listCurrecny.getSelectedItem() != null && Constant.SELECTALLITEM.equalsIgnoreCase(v = this.listCurrecny.getSelectedItem().toString())) {
            cyc.putElements(REQCHKFILTER_KEY_CURRENCY, (IObjectCollection)this.currencys);
        }
        ReqConditionVisitor visitor = new ReqConditionVisitor(this.getSelectedValues());
        try {
            if (cyc.size() != 0) {
                cyc.first();
            }
            visitor.addCycleController(cyc);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        return visitor;
    }

    public int getFlag() {
        int flag = 0;
        if (this.radByDate.isSelected()) {
            flag |= 0x40;
        } else {
            Integer yearFrom = (Integer)this.spnYearFrom.getValue();
            Integer periodFrom = (Integer)this.spnPeriodFrom.getValue();
            Integer yearTo = (Integer)this.spnYearTo.getValue();
            Integer periodTo = (Integer)this.spnPeriodTo.getValue();
            flag = yearFrom.equals(yearTo) ? (periodFrom.equals(periodTo) ? (flag |= 0x80) : (flag |= 0x100)) : (flag |= 0x200);
        }
        return flag;
    }

    @Override
    protected void radByPeriod_stateChanged(ChangeEvent e) throws Exception {
        if (this.radByPeriod.isSelected()) {
            this.pnlByPeriod.setVisible(true);
            this.pnlByDate.setVisible(false);
        }
    }

    @Override
    protected void radByDate_stateChanged(ChangeEvent e) throws Exception {
        if (this.radByDate.isSelected()) {
            this.pnlByPeriod.setVisible(false);
            this.pnlByDate.setVisible(true);
        }
    }

    @Override
    protected void chkReceive_stateChanged(ChangeEvent e) throws Exception {
        if (!this.chkReceive.isSelected() && !this.chkSend.isSelected()) {
            this.chkReceive.setSelected(true);
        }
    }

    @Override
    protected void chkSend_stateChanged(ChangeEvent e) throws Exception {
        if (!this.chkReceive.isSelected() && !this.chkSend.isSelected()) {
            this.chkSend.setSelected(true);
        }
    }

    public String getStartPeriod() {
        Integer yearFrom = (Integer)this.spnYearFrom.getValue();
        Integer periodFrom = (Integer)this.spnPeriodFrom.getValue();
        return yearFrom + "." + periodFrom;
    }

    public String getEndPeriod() {
        Integer yearTo = (Integer)this.spnYearTo.getValue();
        Integer periodTo = (Integer)this.spnPeriodTo.getValue();
        return yearTo + "." + periodTo;
    }

    public String getStartDate() {
        Locale locale = SysContext.getSysContext().getLocale();
        DateFormat df = DateFormat.getDateInstance(1, locale);
        Date date = (Date)this.startDate.getValue();
        return df.format(date);
    }

    public String getEndDate() {
        Locale locale = SysContext.getSysContext().getLocale();
        DateFormat df = DateFormat.getDateInstance(1, locale);
        Date date = (Date)this.endDate.getValue();
        return df.format(date);
    }

    protected void accountTableChanged() throws Exception {
        AccountTableInfo account = (AccountTableInfo)this.bpAccount.getSelectedItem();
        boolean b = account != null && this.getCompanys() != null;
        this.listAccount.setEnabled(b);
        this.listAccount.setValue(null);
        this.setAccountF7Filter();
    }

    private boolean getAudiParam() {
        Set isAuditSet = null;
        CompanyOrgUnitInfo[] companys = this.dealNullCompany();
        ArrayList<String> companyIdList = new ArrayList<String>(companys.length);
        for (int i = 0; i < companys.length; ++i) {
            companyIdList.add(companys[i].getId().toString());
        }
        try {
            IRequisitionAuditFacade audit = RequisitionAuditFacadeFactory.getRemoteInstance();
            isAuditSet = audit.getRequisitionAuditParams(companyIdList);
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        if (isAuditSet == null) {
            return false;
        }
        this.MultiSelectCompanys = isAuditSet;
        return true;
    }

    public AccountTableInfo getAccountTable() {
        return (AccountTableInfo)this.bpAccount.getSelectedItem();
    }

    public CompanyOrgUnitInfo[] getCompanyOrgUnitInfos() {
        return this.getCompanys();
    }
}

