/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.cslacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.CheckSchemeParam;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.cslacct.CheckViewInfo;
import com.kingdee.eas.fi.gl.cslacct.IReqCheck;
import com.kingdee.eas.fi.gl.cslacct.IRequisitionCheck;
import com.kingdee.eas.fi.gl.cslacct.ReqCheckCondition;
import com.kingdee.eas.fi.gl.cslacct.ReqCheckType;
import com.kingdee.eas.fi.gl.cslacct.ReqStatusEnum;
import com.kingdee.eas.fi.gl.cslacct.RequisitionCheckFactory;
import com.kingdee.eas.fi.gl.cslacct.RequisitionCheckInfo;
import com.kingdee.eas.fi.gl.cslacct.RequisitionException;
import com.kingdee.eas.fi.gl.cslacct.RequisitionFactory;
import com.kingdee.eas.fi.gl.cslacct.VoucherCheckInfo;
import com.kingdee.eas.fi.gl.cslacct.client.AbstractReqCheckTempletUI;
import com.kingdee.eas.fi.gl.cslacct.client.AutoReqProcessUI;
import com.kingdee.eas.fi.gl.cslacct.client.ClientHelper;
import com.kingdee.eas.fi.gl.cslacct.client.IReqCheckCondition;
import com.kingdee.eas.fi.gl.cslacct.client.ReqCheckFilterUI;
import com.kingdee.eas.fi.gl.cslacct.util.Constant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public abstract class ReqCheckTempletUI
extends AbstractReqCheckTempletUI
implements IReqCheck {
    private static final Logger logger = CoreUIObject.getLogger(ReqCheckTempletUI.class);
    public static final String REQ_TABLE_COLINDEX_ISCHECEKED = "isChecked";
    protected String requisitionId = null;
    protected boolean isFirstLoad = false;
    protected CommonQueryDialog conditionDialog = null;
    protected KDPanel conditionPanel = null;
    protected CompanyOrgUnitInfo curCompany = null;
    protected CompanyOrgUnitInfo[] companys = null;
    protected IReqCheckCondition conditionVisitor = null;
    private boolean isFirstDefaultQuery = true;
    protected boolean isAllowUnConfirm = true;
    protected Map initData = null;
    private Map checkViewsMap = null;
    protected Map reqParam = new HashMap();
    Map editParame = new HashMap();
    protected CheckSchemeParam checkSchemeParam = new CheckSchemeParam();
    private static final List<CheckViewInfo> emptyList = Collections.emptyList();
    private static final int strLimitLength = 1000;
    private static final String suffix = "......";

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionValidate_actionPerformed(ActionEvent e) throws Exception {
        super.actionValidate_actionPerformed(e);
        this.check(e);
    }

    @Override
    public void actionDiffCurrencyValidate_actionPerformed(ActionEvent e) throws Exception {
        Map checkViews;
        Collection srcCheckViews = this.getSrcCheckViews(e);
        Collection targCheckViews = this.getTargCheckViews(e);
        this.checkViewsMap = checkViews = this.validateViews(srcCheckViews, targCheckViews, true);
        Map uiCtx = super.getUIContext();
        if (uiCtx.get("is_fromVCH") != null && uiCtx.get("is_fromVCH") instanceof Boolean && ((Boolean)uiCtx.get("is_fromVCH")).booleanValue()) {
            if (checkViews != null && checkViews.size() != 0) {
                try {
                    super.actionExitCurrent_actionPerformed(e);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        } else if (checkViews != null && checkViews.size() != 0) {
            this.check(checkViews);
            this.refresh();
        }
    }

    @Override
    public void actionUnValidate_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnValidate_actionPerformed(e);
        this.cancelCheck(e);
    }

    @Override
    public void actionAutoValidate_actionPerformed(ActionEvent e) throws Exception {
        this.selectAll(true);
        Map uiCtx = super.getUIContext();
        int result = 2;
        if (uiCtx.get("is_fromVCH") != null && uiCtx.get("is_fromVCH") instanceof Boolean && ((Boolean)uiCtx.get("is_fromVCH")).booleanValue() || this.companys.length == 1) {
            result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"3_ReqCheckTempletUI"));
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"reqParam", (Object)this.reqParam);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.cslacct.client.AutoReqParamUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
            result = this.reqParam.get("isConfirm") != null && (Boolean)this.reqParam.get("isConfirm") != false ? 0 : 2;
        }
        if (result == 0) {
            super.actionAutoValidate_actionPerformed(e);
            this.autoCheck();
        } else {
            this.selectAll(false);
        }
    }

    @Override
    public void actionDiffCyAutoValidate_actionPerformed(ActionEvent e) throws Exception {
        this.selectAll(true);
        Map uiCtx = super.getUIContext();
        int result = 2;
        if (uiCtx.get("is_fromVCH") != null && uiCtx.get("is_fromVCH") instanceof Boolean && ((Boolean)uiCtx.get("is_fromVCH")).booleanValue() || this.companys.length == 1) {
            result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"4_ReqCheckTempletUI"));
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"reqParam", (Object)this.reqParam);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.gl.cslacct.client.AutoReqParamUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
            result = this.reqParam.get("isConfirm") != null && (Boolean)this.reqParam.get("isConfirm") != false ? 0 : 2;
        }
        if (result == 0) {
            super.actionAutoValidate_actionPerformed(e);
            this.autoCheck(ReqCheckType.DIFFCY);
        } else {
            this.selectAll(false);
        }
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        super.actionFilter_actionPerformed(e);
        this.showConditionDialog();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.refresh();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.selectAll(true);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearAll_actionPerformed(e);
        this.selectAll(false);
    }

    public Map getCheckViewsMap() {
        return this.checkViewsMap;
    }

    public final void check(ActionEvent e) {
        Collection srcCheckViews = this.getSrcCheckViews(e);
        Collection targCheckViews = this.getTargCheckViews(e);
        Map uiCtx = super.getUIContext();
        if (uiCtx.get("is_fromVCH") != null && uiCtx.get("is_fromVCH") instanceof Boolean && ((Boolean)uiCtx.get("is_fromVCH")).booleanValue()) {
            Map checkViews;
            this.checkViewsMap = checkViews = this.validateViews(srcCheckViews, targCheckViews);
            if (checkViews != null && checkViews.size() != 0) {
                try {
                    super.actionExitCurrent_actionPerformed(e);
                }
                catch (Exception e1) {
                    logger.error((Object)e1);
                }
            }
        } else if (uiCtx.get("is_fromReqCheck") != null && ((Boolean)uiCtx.get("is_fromReqCheck")).booleanValue()) {
            Map checkViews = this.validateViews(srcCheckViews, targCheckViews);
            if (checkViews != null && checkViews.size() != 0) {
                this.check(checkViews);
                this.refresh();
            }
        } else {
            StringBuilder errorMsg = new StringBuilder();
            List<Map> finalCheckViews = this.multiOrgReqCheck(srcCheckViews, targCheckViews, errorMsg);
            for (Map checkViewMap : finalCheckViews) {
                if (checkViewMap == null || checkViewMap.size() == 0) continue;
                this.check(checkViewMap);
            }
            if (errorMsg.length() > 0) {
                MsgBox.showInfo((String)errorMsg.toString());
            }
            this.refresh();
        }
    }

    private List<Map> multiOrgReqCheck(Collection srcCheckViews, Collection targCheckViews, StringBuilder errorMsg) {
        errorMsg = errorMsg == null ? new StringBuilder() : errorMsg;
        HashMap<String, GroupByInfo> groupMap = new HashMap<String, GroupByInfo>();
        Map<String, List<CheckViewInfo>> srcCheckViewMap = this.group(srcCheckViews, groupMap, true);
        Map<String, List<CheckViewInfo>> targCheckViewMap = this.group(targCheckViews, groupMap, false);
        ArrayList<Map> finalCheckViews = new ArrayList<Map>();
        for (Map.Entry entry : groupMap.entrySet()) {
            String key = (String)entry.getKey();
            GroupByInfo value = (GroupByInfo)entry.getValue();
            List<CheckViewInfo> srcCheckViewList = srcCheckViewMap.get(key);
            List<CheckViewInfo> targCheckViewList = targCheckViewMap.get(key);
            if (!this.checkReq(srcCheckViewList = srcCheckViewList == null ? emptyList : srcCheckViewList, targCheckViewList = targCheckViewList == null ? emptyList : targCheckViewList, value, errorMsg)) continue;
            Map checkViewMap = this.checkViews(srcCheckViewList, targCheckViewList, false, value);
            if (checkViewMap != null && checkViewMap.containsKey("error")) {
                this.createReqErrorMsg(checkViewMap.get("error").toString(), errorMsg);
                continue;
            }
            if (checkViewMap == null) continue;
            finalCheckViews.add(checkViewMap);
        }
        return finalCheckViews;
    }

    private Map<String, List<CheckViewInfo>> group(Collection checkViews, Map<String, GroupByInfo> groupMap, boolean isSrc) {
        Iterator itor = checkViews.iterator();
        HashMap<String, List<CheckViewInfo>> checkViewMap = new HashMap<String, List<CheckViewInfo>>();
        StringBuilder key = new StringBuilder();
        while (itor.hasNext()) {
            CheckViewInfo checkViewInfo = (CheckViewInfo)itor.next();
            String companyId = isSrc ? checkViewInfo.getCompany().getId().toString() : checkViewInfo.getTargCompany().getId().toString();
            String currencyId = checkViewInfo.getCurrency().getId().toString();
            key.append(companyId).append(currencyId);
            if (this.checkSchemeParam.isSameBizNumber()) {
                key.append(StringUtils.isEmpty((String)checkViewInfo.getBizNumber()) ? "" : checkViewInfo.getBizNumber());
            }
            groupMap.put(key.toString(), new GroupByInfo(isSrc ? checkViewInfo.getCompany() : checkViewInfo.getTargCompany(), checkViewInfo.getCurrency()));
            if (checkViewMap.containsKey(key.toString())) {
                ((List)checkViewMap.get(key.toString())).add(checkViewInfo);
            } else {
                ArrayList<CheckViewInfo> checkViewsNew = new ArrayList<CheckViewInfo>();
                checkViewsNew.add(checkViewInfo);
                checkViewMap.put(key.toString(), checkViewsNew);
            }
            key.setLength(0);
        }
        return checkViewMap;
    }

    private boolean checkReq(List<CheckViewInfo> srcCheckViewList, List<CheckViewInfo> targCheckViewList, GroupByInfo value, StringBuilder errorMsg) {
        boolean pass = true;
        String reqNumber = "";
        if (srcCheckViewList.size() == 1 && targCheckViewList.size() == 0) {
            reqNumber = (String)srcCheckViewList.get(0).getPropertyValueBykey("requisition.number");
            pass = false;
        } else if (srcCheckViewList.size() == 0 && targCheckViewList.size() == 1) {
            reqNumber = (String)targCheckViewList.get(0).getPropertyValueBykey("requisition.number");
            pass = false;
        }
        if (!pass) {
            String erroMsg = EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"NO_REQ_DATA", (Object[])new String[]{value.getCompany().getName(), value.getCurrency().getName(), reqNumber});
            this.createReqErrorMsg(erroMsg, errorMsg);
        }
        return pass;
    }

    private void createReqErrorMsg(String msg, StringBuilder errorMsg) {
        if (errorMsg == null) {
            return;
        }
        if (errorMsg.length() > 1000 && errorMsg.lastIndexOf(suffix) < 0) {
            errorMsg.append(suffix);
        } else if (errorMsg.lastIndexOf(suffix) < 0) {
            errorMsg.append(msg).append("\n");
        }
    }

    protected abstract Collection getSrcCheckViews(ActionEvent var1);

    protected abstract Collection getTargCheckViews(ActionEvent var1);

    protected boolean checkCompanyAndCurrency(Collection srcCheckViews, Collection targCheckViews) {
        return this.checkCompanyAndCurrency(srcCheckViews, targCheckViews, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkCompanyAndCurrency(Collection srcCheckViews, Collection targCheckViews, boolean isDiffCurrency) {
        if (srcCheckViews.size() == 0 && targCheckViews.size() == 0 || srcCheckViews.size() == 1 && targCheckViews.size() == 0 || srcCheckViews.size() == 0 && targCheckViews.size() == 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRUIResource", (String)"UIRES_NOTSELECTED"));
            return false;
        }
        CheckViewInfo v2 = null;
        String srcCompany = null;
        String srcCurrency = null;
        String srcBaseCurrency = null;
        for (CheckViewInfo v2 : srcCheckViews) {
            if (v2 == null) continue;
            if (srcCompany == null) {
                srcCompany = v2.getCompany().getId().toString();
            } else if (!srcCompany.equals(v2.getCompany().getId().toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"COMPANYISNOTSAME"));
                return false;
            }
            if (srcCurrency == null) {
                srcCurrency = v2.getCurrency().getId().toString();
            } else if (!srcCurrency.equals(v2.getCurrency().getId().toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)(isDiffCurrency ? "CURRENCYISNOTSAME_2" : "CURRENCYISNOTSAME")));
                return false;
            }
            if (!isDiffCurrency || v2.getBaseCurrency() == null) continue;
            if (srcBaseCurrency == null) {
                srcBaseCurrency = v2.getBaseCurrency().getId().toString();
                continue;
            }
            if (srcBaseCurrency.equals(v2.getBaseCurrency().getId().toString())) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"CURRENCYISNOTSAME_2"));
            return false;
        }
        String targCompany = null;
        String targCurrency = null;
        String targBaseCurrency = null;
        for (CheckViewInfo v2 : targCheckViews) {
            if (v2 == null) continue;
            if (targCompany == null) {
                targCompany = v2.getTargCompany().getId().toString();
            } else if (!targCompany.equals(v2.getTargCompany().getId().toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"COMPANYISNOTSAME"));
                return false;
            }
            if (targCurrency == null) {
                targCurrency = v2.getCurrency().getId().toString();
            } else if (!targCurrency.equals(v2.getCurrency().getId().toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)(isDiffCurrency ? "CURRENCYISNOTSAME_2" : "CURRENCYISNOTSAME")));
                return false;
            }
            if (!isDiffCurrency || v2.getBaseCurrency() == null) continue;
            if (targBaseCurrency == null) {
                targBaseCurrency = v2.getBaseCurrency().getId().toString();
                continue;
            }
            if (targBaseCurrency.equals(v2.getBaseCurrency().getId().toString())) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"CURRENCYISNOTSAME_2"));
            return false;
        }
        if (srcCompany == null && targCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"COMPANYISNOTSAME"));
            return false;
        }
        if (srcCompany != null && targCompany != null && !srcCompany.equals(targCompany)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"COMPANYISNOTSAME"));
            return false;
        }
        if (srcCurrency == null && targCurrency == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"CURRENCYISNOTSAME"));
            return false;
        }
        if (srcCurrency == null || targCurrency == null) return true;
        if (isDiffCurrency) {
            if (!srcCurrency.equals(targCurrency)) {
                if (srcBaseCurrency == null || srcBaseCurrency.equals(targBaseCurrency)) return true;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"DIFFCY_BASECYNOTSAME"));
                return false;
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"DIFFCY_CURRENCYSAME"));
            return false;
        }
        if (srcCurrency.equals(targCurrency)) return true;
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"CURRENCYISNOTSAME"));
        return false;
    }

    protected Map validateViews(Collection srcCheckViews, Collection targCheckViews) {
        return this.validateViews(srcCheckViews, targCheckViews, false);
    }

    protected Map validateViews(Collection srcCheckViews, Collection targCheckViews, boolean isDiffCurrency) {
        BigDecimal targSumValue;
        BigDecimal srcSumValue;
        if (!this.checkCompanyAndCurrency(srcCheckViews, targCheckViews, isDiffCurrency)) {
            return null;
        }
        if (this.checkSchemeParam.isSameBizNumber() && !this.checkReqBizNumberIsSame(srcCheckViews, targCheckViews)) {
            return null;
        }
        Map checkViews = null;
        Map keys = this.putCheckKeys(srcCheckViews, targCheckViews, isDiffCurrency);
        if (keys != null && this.isValidate(srcSumValue = this.caculateSumAmount(srcCheckViews.iterator(), keys, isDiffCurrency), targSumValue = this.caculateSumAmount(targCheckViews.iterator(), keys, isDiffCurrency), isDiffCurrency)) {
            checkViews = this.putCheckViews(srcCheckViews, targCheckViews, keys, isDiffCurrency);
        }
        return checkViews;
    }

    private boolean checkReqBizNumberIsSame(Collection srcCheckViews, Collection targCheckViews) {
        CheckViewInfo v2 = null;
        String bizNumber = null;
        for (CheckViewInfo v2 : srcCheckViews) {
            if (v2 == null) continue;
            if (bizNumber == null) {
                bizNumber = v2.getBizNumber();
                continue;
            }
            if (bizNumber.equals(v2.getBizNumber())) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"BIZNUMBERNOTSAME"));
            return false;
        }
        for (CheckViewInfo v2 : targCheckViews) {
            if (v2 == null) continue;
            if (bizNumber == null && v2.getBizNumber() != null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"BIZNUMBERNOTSAME"));
                return false;
            }
            if (bizNumber == null) {
                bizNumber = v2.getBizNumber();
                continue;
            }
            if (bizNumber.equals(v2.getBizNumber())) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"BIZNUMBERNOTSAME"));
            return false;
        }
        return true;
    }

    private Map checkViews(Collection srcCheckViews, Collection targCheckViews, boolean isDiffCurrency, GroupByInfo groupInfo) {
        Map<String, String> checkViews = null;
        Map keys = this.putCheckKeys(srcCheckViews, targCheckViews, isDiffCurrency);
        if (keys != null) {
            BigDecimal targSumValue;
            BigDecimal srcSumValue = this.caculateSumAmount(srcCheckViews.iterator(), keys, isDiffCurrency);
            if (this.checkAmt(srcSumValue, targSumValue = this.caculateSumAmount(targCheckViews.iterator(), keys, isDiffCurrency), isDiffCurrency)) {
                checkViews = this.putCheckViews(srcCheckViews, targCheckViews, keys, isDiffCurrency);
            } else {
                checkViews = new HashMap();
                String errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)"REQCHECK_CANNOTCHECK_2", (Object[])new String[]{groupInfo.getCompany().getName(), groupInfo.getCurrency().getName()});
                checkViews.put("error", errorMsg);
            }
        }
        return checkViews;
    }

    private boolean checkAmt(BigDecimal srcSumValue, BigDecimal targSumValue, boolean isDiffCurrency) {
        boolean isTrue = false;
        if (targSumValue != null) {
            targSumValue = targSumValue.multiply(Constant.CS);
        }
        isTrue = srcSumValue != null && targSumValue != null && srcSumValue.compareTo(targSumValue) == 0 ? true : (srcSumValue == null && targSumValue != null && targSumValue.compareTo(SysConstant.BIGZERO) == 0 || targSumValue == null && srcSumValue != null && srcSumValue.compareTo(SysConstant.BIGZERO) == 0 ? true : (srcSumValue == null && targSumValue == null ? false : false));
        return isTrue;
    }

    private Map putCheckKeys(Collection srcCheckViews, Collection targCheckViews, boolean isDiffCurrency) {
        Map keys = null;
        if (srcCheckViews != null && srcCheckViews.size() != 0) {
            keys = this.putCheckKeysByViews(srcCheckViews, true, isDiffCurrency);
        } else if (targCheckViews != null && targCheckViews.size() != 0) {
            keys = this.putCheckKeysByViews(targCheckViews, false, isDiffCurrency);
        }
        return keys;
    }

    private Map putCheckKeysByViews(Collection ls, boolean isSrc, boolean isDiffCurrency) {
        HashMap<String, String> keys = new HashMap<String, String>();
        CheckViewInfo v2 = null;
        for (CheckViewInfo v2 : ls) {
            String value;
            if (v2 == null) continue;
            if (v2.getCompany() != null) {
                value = v2.getCompany().getId().toString();
                if (keys.containsKey("srccompany.id") && !value.equals(keys.get("srccompany.id"))) {
                    super.handUIException((Throwable)((Object)new RequisitionException(RequisitionException.REQISNOTIONSENDCOMMORE)));
                    return null;
                }
                keys.put("srccompany.id", value);
            }
            if (v2.getTargCompany() != null) {
                value = v2.getTargCompany().getId().toString();
                if (keys.containsKey("targcompany.id") && !value.equals(keys.get("targcompany.id"))) {
                    super.handUIException((Throwable)((Object)new RequisitionException(RequisitionException.REQISNOTIONRECIECOMMORE)));
                    return null;
                }
                keys.put("targcompany.id", v2.getTargCompany().getId().toString());
            }
            if (isDiffCurrency) {
                if (v2.getBaseCurrency() == null) continue;
                value = v2.getBaseCurrency().getId().toString();
                if (keys.containsKey("baseCurrency.id") && !value.equals(keys.get("baseCurrency.id"))) {
                    if (isSrc) {
                        super.handUIException((Throwable)((Object)new RequisitionException(RequisitionException.REQISNOTIONSENDCURMORE)));
                    } else {
                        super.handUIException((Throwable)((Object)new RequisitionException(RequisitionException.REQISNOTIONRECIECURMORE)));
                    }
                    return null;
                }
                keys.put("baseCurrency.id", v2.getBaseCurrency().getId().toString());
                continue;
            }
            if (v2.getCurrency() == null) continue;
            value = v2.getCurrency().getId().toString();
            if (keys.containsKey("currency.id") && !value.equals(keys.get("currency.id"))) {
                if (isSrc) {
                    super.handUIException((Throwable)((Object)new RequisitionException(RequisitionException.REQISNOTIONSENDCURMORE)));
                } else {
                    super.handUIException((Throwable)((Object)new RequisitionException(RequisitionException.REQISNOTIONRECIECURMORE)));
                }
                return null;
            }
            keys.put("currency.id", v2.getCurrency().getId().toString());
        }
        if (keys.size() == 0) {
            super.handUIException((Throwable)((Object)new RequisitionException(RequisitionException.REQCANNOTGETCHECKINFO)));
            return null;
        }
        return keys;
    }

    private BigDecimal caculateSumAmount(Iterator itor, Map keys, boolean isDiffCurrency) {
        BigDecimal sumValue = null;
        CheckViewInfo chkView = null;
        while (itor.hasNext()) {
            chkView = (CheckViewInfo)itor.next();
            if (!this.checkCompany(chkView, keys) || !this.checkCurrency(chkView, keys, isDiffCurrency)) continue;
            if (sumValue == null) {
                sumValue = SysConstant.BIGZERO;
            }
            if (isDiffCurrency) {
                if (chkView.getDc().getValue() == 1) {
                    sumValue = sumValue.add(chkView.getLocalAmt().multiply(Constant.DS));
                    continue;
                }
                sumValue = sumValue.add(chkView.getLocalAmt().multiply(Constant.CS));
                continue;
            }
            if (chkView.getDc().getValue() == 1) {
                sumValue = sumValue.add(chkView.getOriginalAmount().multiply(Constant.DS));
                continue;
            }
            sumValue = sumValue.add(chkView.getOriginalAmount().multiply(Constant.CS));
        }
        return sumValue;
    }

    private boolean checkCompany(CheckViewInfo v, Map keys) {
        boolean isTrue = false;
        String srcCompanyId = v.getCompany().getId().toString();
        String targCompanyId = v.getTargCompany().getId().toString();
        String chkSrcCompanyId = keys.get("srccompany.id").toString();
        String chkTargCompanyId = keys.get("targcompany.id").toString();
        if (srcCompanyId.equalsIgnoreCase(chkSrcCompanyId) && targCompanyId.equalsIgnoreCase(chkTargCompanyId) || srcCompanyId.equalsIgnoreCase(chkTargCompanyId) && targCompanyId.equalsIgnoreCase(chkSrcCompanyId)) {
            isTrue = true;
        }
        return isTrue;
    }

    private boolean checkCurrency(CheckViewInfo v, Map keys, boolean isDiffCurrency) {
        if (isDiffCurrency) {
            String baseCurrencyId = v.getBaseCurrency().getId().toString();
            return baseCurrencyId.equalsIgnoreCase(keys.get("baseCurrency.id").toString());
        }
        String currencyId = v.getCurrency().getId().toString();
        return currencyId.equalsIgnoreCase(keys.get("currency.id").toString());
    }

    private boolean isValidate(BigDecimal srcSumValue, BigDecimal targSumValue, boolean isDiffCurrency) {
        boolean isTrue = false;
        if (targSumValue != null) {
            targSumValue = targSumValue.multiply(Constant.CS);
        }
        if (srcSumValue != null && targSumValue != null && srcSumValue.compareTo(targSumValue) == 0) {
            isTrue = true;
        } else if (srcSumValue == null && targSumValue != null && targSumValue.compareTo(SysConstant.BIGZERO) == 0 || targSumValue == null && srcSumValue != null && srcSumValue.compareTo(SysConstant.BIGZERO) == 0) {
            isTrue = true;
        } else if (srcSumValue == null && targSumValue == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRUIResource", (String)"UIRES_NOTSELECTED"));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRBizResource", (String)(isDiffCurrency ? "DIFFCY_REQCHECK_CANNOTCHECK" : "REQCHECK_CANNOTCHECK")));
        }
        return isTrue;
    }

    private Map putCheckViews(Collection srcCheckViews, Collection targCheckViews, Map keys, boolean isDiffCurrency) {
        HashMap checkViews = new HashMap();
        if (srcCheckViews.size() != 0 && targCheckViews.size() != 0) {
            ArrayList<CheckViewInfo> srcCheck = new ArrayList<CheckViewInfo>();
            Iterator itor = srcCheckViews.iterator();
            CheckViewInfo chkView = null;
            while (itor.hasNext()) {
                chkView = (CheckViewInfo)itor.next();
                if (!this.checkCompany(chkView, keys) || !this.checkCurrency(chkView, keys, isDiffCurrency)) continue;
                srcCheck.add(chkView);
            }
            checkViews.put("checkview.source", srcCheck);
            ArrayList<CheckViewInfo> targCheck = new ArrayList<CheckViewInfo>();
            itor = targCheckViews.iterator();
            chkView = null;
            while (itor.hasNext()) {
                chkView = (CheckViewInfo)itor.next();
                if (!this.checkCompany(chkView, keys) || !this.checkCurrency(chkView, keys, isDiffCurrency)) continue;
                targCheck.add(chkView);
            }
            checkViews.put("checkview.target", targCheck);
        } else {
            this.splitCheckViews(checkViews, srcCheckViews, targCheckViews, keys, isDiffCurrency);
        }
        return checkViews;
    }

    private void splitCheckViews(Map checkViews, Collection srcCheckViews, Collection targCheckViews, Map keys, boolean isDiffCurrency) {
        ArrayList<CheckViewInfo> src = new ArrayList<CheckViewInfo>();
        ArrayList<CheckViewInfo> targ = new ArrayList<CheckViewInfo>();
        Iterator itor = null;
        if (srcCheckViews.size() != 0) {
            itor = srcCheckViews.iterator();
        } else if (targCheckViews.size() != 0) {
            itor = targCheckViews.iterator();
        }
        CheckViewInfo v = null;
        BigDecimal dc = Constant.DS;
        while (itor != null && itor.hasNext()) {
            v = (CheckViewInfo)itor.next();
            if (!this.checkCompany(v, keys) || !this.checkCurrency(v, keys, isDiffCurrency)) continue;
            dc = v.getDc().getValue() == 0 ? Constant.CS : Constant.DS;
            if (isDiffCurrency) {
                if (v.getLocalAmt().multiply(dc).compareTo(SysConstant.BIGZERO) == -1) {
                    src.add(v);
                    continue;
                }
                targ.add(v);
                continue;
            }
            if (v.getOriginalAmount().multiply(dc).compareTo(SysConstant.BIGZERO) == -1) {
                src.add(v);
                continue;
            }
            targ.add(v);
        }
        checkViews.put("checkview.source", src);
        checkViews.put("checkview.target", targ);
    }

    @Override
    public void check(Map checkViews) {
        try {
            RequisitionCheckInfo info;
            String reqId;
            Object o;
            IRequisitionCheck ie = ReqCheckTempletUI.getBizInterface();
            ie.check(checkViews);
            Collection srcViews = (Collection)checkViews.get("checkview.source");
            Collection targViews = (Collection)checkViews.get("checkview.target");
            Iterator srcIter = srcViews.iterator();
            Iterator targIter = targViews.iterator();
            HashMap<String, String> pkM = new HashMap<String, String>();
            while (srcIter.hasNext()) {
                o = srcIter.next();
                if (!(o instanceof RequisitionCheckInfo) || pkM.containsKey(reqId = (info = (RequisitionCheckInfo)o).getRequisition().getId().toString())) continue;
                this.closeMessage(reqId);
                pkM.put(reqId, reqId);
            }
            while (targIter.hasNext()) {
                o = targIter.next();
                if (!(o instanceof RequisitionCheckInfo) || pkM.containsKey(reqId = (info = (RequisitionCheckInfo)o).getRequisition().getId().toString())) continue;
                this.closeMessage(reqId);
                pkM.put(reqId, reqId);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            super.handleException((Exception)((Object)e));
        }
        catch (EASBizException e) {
            super.handleException((Exception)((Object)e));
        }
    }

    private void closeMessage(String reqId) throws BOSException {
        IRequisitionCheck ie = ReqCheckTempletUI.getBizInterface();
        if (ClientHelper.isAvailabilityForWfInstance(reqId)) {
            ObjectStringPK pk = new ObjectStringPK(reqId);
            if (RequisitionFactory.getRemoteInstance().isChecked((IObjectPK)pk)) {
                ie.virtualSubmit((IObjectPK)pk);
            }
        }
    }

    public final void cancelCheck(ActionEvent e) {
        Collection srcCheckViews = this.getSrcCheckViews(e);
        Collection targCheckViews = this.getTargCheckViews(e);
        ArrayList checkViews = new ArrayList();
        checkViews.addAll(srcCheckViews);
        checkViews.addAll(targCheckViews);
        if (checkViews.size() != 0) {
            this.cancelCheck(checkViews);
            this.refresh();
        }
    }

    @Override
    public void cancelCheck(Collection checkViews) {
        try {
            if (checkViews == null) {
                return;
            }
            Collection hasVoucherCheckViews = ReqCheckTempletUI.getBizInterface().checkCollection(checkViews);
            ArrayList<CheckViewInfo> removeCollect = new ArrayList<CheckViewInfo>();
            if (hasVoucherCheckViews != null && hasVoucherCheckViews.size() > 0) {
                for (CheckViewInfo remove : hasVoucherCheckViews) {
                    for (CheckViewInfo o : checkViews) {
                        if (null == o || null == remove || !o.getCheckNumber().equals(remove.getCheckNumber())) continue;
                        removeCollect.add(o);
                    }
                }
            }
            checkViews.removeAll(removeCollect);
            ReqCheckTempletUI.getBizInterface().cancelCheck(checkViews);
            if (hasVoucherCheckViews != null && hasVoucherCheckViews.size() > 0) {
                String title = EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRUIResource", (String)"cannot_cancelcheck");
                String errmsg = EASResource.getString((String)"com.kingdee.eas.fi.gl.cslacct.GRUIResource", (String)"reqHasVouchered");
                StringBuffer errorDetail = new StringBuffer();
                for (CheckViewInfo o : hasVoucherCheckViews) {
                    errorDetail.append(MessageFormat.format(errmsg, o.getPropertyValueBykey("requisition.number"))).append("\r\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)title, (String)errorDetail.toString(), (int)2);
            }
        }
        catch (BOSException e) {
            super.handleException((Exception)((Object)e));
        }
        catch (EASBizException e) {
            super.handleException((Exception)((Object)e));
        }
    }

    @Override
    public void autoCheck() {
        this.autoCheck(ReqCheckType.COMMON);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoCheck(ReqCheckType reqCheckType) {
        block19: {
            try {
                Map uiCtx = super.getUIContext();
                if (uiCtx.get("is_fromVCH") != null && uiCtx.get("is_fromVCH") instanceof Boolean && ((Boolean)uiCtx.get("is_fromVCH")).booleanValue()) {
                    this.checkViewsMap = new HashMap();
                    this.checkViewsMap.put("isAuto", Boolean.TRUE);
                    ReqCheckCondition condition = this.getCheckCondition();
                    this.checkViewsMap.put("requisition.id", condition.getRequisitionId());
                    try {
                        super.actionExitCurrent_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        logger.error((Object)"", (Throwable)e1);
                    }
                    break block19;
                }
                final IRequisitionCheck ie = ReqCheckTempletUI.getBizInterface();
                if (this.reqParam.get("isAllCompany") != null && this.reqParam.get("isAllCompany") instanceof Boolean && ((Boolean)this.reqParam.get("isAllCompany")).booleanValue()) {
                    AutoReqProcessUI.AutoReqLongTimeProcess proc = new AutoReqProcessUI.AutoReqLongTimeProcess(){

                        @Override
                        public void doit(ReqCheckCondition condition) throws Exception {
                            condition.setCheckSchemeParam(ReqCheckTempletUI.this.checkSchemeParam);
                            ie.autoCheckByVch(condition);
                        }
                    };
                    ArrayList<ReqCheckCondition> al = new ArrayList<ReqCheckCondition>(this.companys.length);
                    int n = this.companys.length;
                    for (int i = 0; i < n; ++i) {
                        if (this.conditionVisitor == null) continue;
                        try {
                            this.conditionVisitor.setElement("srcCompany.id", this.companys[i]);
                        }
                        catch (Exception e) {
                            logger.equals(e);
                        }
                        ReqCheckCondition condition = this.conditionVisitor.toCheckCondition();
                        condition.setCheckSchemeParam(this.checkSchemeParam);
                        condition.setReqCheckType(reqCheckType);
                        al.add(condition);
                    }
                    final StringBuffer sb = new StringBuffer();
                    AutoReqProcessUI.AutoReqLongTimeProcessDoExcept doexcept = new AutoReqProcessUI.AutoReqLongTimeProcessDoExcept(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void doexcept(ReqCheckCondition condition, Exception ex) {
                            String msg = null;
                            try {
                                msg = condition.getCompany().getName() + ":";
                                if (!(ex instanceof RequisitionException)) {
                                    if (ex instanceof EASBizException || ex instanceof PermissionServiceException) {
                                        msg = msg + ex.getMessage();
                                    } else if (ex instanceof BOSException) {
                                        StringWriter sw = new StringWriter();
                                        ex.printStackTrace(new PrintWriter(sw));
                                        msg = msg + sw.toString();
                                    } else {
                                        msg = msg + ex.getMessage();
                                    }
                                }
                                logger.error((Object)msg.toString());
                            }
                            catch (Exception ex1) {
                                StringWriter sw = new StringWriter();
                                ex1.printStackTrace(new PrintWriter(sw));
                                msg = ex1.getMessage();
                                logger.error((Object)sw.toString());
                            }
                            StringBuffer stringBuffer = sb;
                            synchronized (stringBuffer) {
                                sb.append(msg);
                                sb.append("\r\n");
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void doexcept(List ids, Exception ex) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Submit Error!", (Throwable)ex);
                            }
                            String msg = ex.getMessage();
                            StringBuffer stringBuffer = sb;
                            synchronized (stringBuffer) {
                                sb.append(msg);
                                sb.append("\r\n");
                            }
                        }
                    };
                    try {
                        AutoReqProcessUI.process((IUIObject)this, proc, al, doexcept);
                    }
                    catch (Exception e) {
                        this.handUIException(e);
                    }
                    String msg = null;
                    StringBuffer stringBuffer = sb;
                    synchronized (stringBuffer) {
                        if (sb.length() > 0) {
                            msg = sb.toString();
                        }
                    }
                    if (msg != null) {
                        String title = EASResource.getString((String)"com.kingdee.eas.fi.gl.client.VoucherEditResource", (String)"OperFailed") + EASResource.getString((String)"com.kingdee.eas.fi.gl.client.VoucherEditResource", (String)"DetailInfo");
                        MsgBox.showDetailAndOK((Component)((Object)this), (String)title.toString(), (String)msg, (int)2);
                    }
                    break block19;
                }
                ReqCheckCondition condition = this.getCheckCondition();
                condition.setReqCheckType(reqCheckType);
                condition.setCheckSchemeParam(this.checkSchemeParam);
                ie.autoCheckByVch(condition);
                HashMap<String, String> pkM = new HashMap<String, String>();
                if (condition.getRequisitionId() != null) {
                    String[] ids = condition.getRequisitionId().split(",");
                    for (int i = 0; i < ids.length; ++i) {
                        if (pkM.containsKey(ids[i])) continue;
                        this.closeMessage(ids[i]);
                        pkM.put(ids[i], ids[i]);
                    }
                }
            }
            catch (EASBizException e) {
                super.handUIException((Throwable)e);
            }
            catch (BOSException e) {
                super.handUIException((Throwable)e);
            }
        }
        this.refresh();
    }

    protected abstract ReqCheckCondition getCheckCondition();

    protected void refresh() {
        this.refreshSrcData();
        this.refreshTargData();
    }

    protected abstract void refreshSrcData();

    protected abstract void refreshTargData();

    protected void selectAll(boolean isSelected) {
        this.selectTable(this.getSrcTable(), isSelected);
        this.selectTable(this.getTargetTable(), isSelected);
    }

    public void selectTable(KDTable table, boolean isSelected) {
        if (table != null) {
            int rowCount = table.getExpandedRowCount();
            IRow row = null;
            ICell cell = null;
            Boolean b = new Boolean(isSelected);
            for (int i = 0; i < rowCount; ++i) {
                row = table.getRow(i);
                if (row == null || (cell = row.getCell(this.getSelectedPosition())) == null) continue;
                cell.setValue((Object)b);
            }
        }
    }

    protected abstract KDTable getSrcTable();

    protected abstract KDTable getTargetTable();

    public final Collection getSelectedItems(KDTable tb, boolean isSelected, String t) {
        int rowStartIndex = 0;
        int rowCount = tb.getExpandedRowCount();
        IRow r = null;
        ICell c = null;
        ArrayList<CheckViewInfo> items = new ArrayList<CheckViewInfo>();
        for (int i = rowStartIndex; i < rowCount; ++i) {
            r = tb.getRow(i);
            c = tb.getCell(i, this.getSelectedPosition());
            if (c == null || c.getValue() == null || Boolean.valueOf(c.getValue().toString()) != Boolean.valueOf(true) || (c = tb.getCell(i, "reqstatus")) == null || c.getValue() == null) continue;
            BizEnumValueDTO check = (BizEnumValueDTO)c.getValue();
            if ((isSelected || !check.getName().equals(ReqStatusEnum.CHECKED.getName())) && (!isSelected || !check.getName().equals(ReqStatusEnum.UNCHECKED.getName()))) continue;
            items.add(this.getSelectedItem(r, t));
        }
        return items;
    }

    protected abstract String getSelectedPosition();

    protected abstract CheckViewInfo getSelectedItem(IRow var1, String var2);

    protected static RequisitionCheckInfo getReqCheckInfoByRow(IRow row) {
        RequisitionCheckInfo reqCheckInfo = new RequisitionCheckInfo();
        if (row == null) {
            return null;
        }
        Object value = null;
        value = ReqCheckTempletUI.getValue(row, "requisition.id");
        reqCheckInfo.setPropertyValueBykey("requisition.id", value);
        value = ReqCheckTempletUI.getValue(row, "voucher.id");
        VoucherInfo voucher = new VoucherInfo();
        voucher.setId(BOSUuid.read((String)((String)value)));
        value = ReqCheckTempletUI.getValue(row, "voucher.lastupdatetime");
        voucher.setLastUpdateTime((Timestamp)value);
        reqCheckInfo.setPropertyValueBykey("voucher.id", voucher);
        value = ReqCheckTempletUI.getValue(row, "voucher.number");
        reqCheckInfo.setPropertyValueBykey("voucher.number", value);
        value = ReqCheckTempletUI.getValue(row, "srccompany.id");
        reqCheckInfo.setPropertyValueBykey("srccompany.id", value);
        reqCheckInfo.setPropertyValueBykey("srcCompany.name", ReqCheckTempletUI.getValue(row, "srcCompany.name"));
        value = ReqCheckTempletUI.getValue(row, "targcompany.id");
        reqCheckInfo.setPropertyValueBykey("targcompany.id", value);
        reqCheckInfo.setPropertyValueBykey("targCompany.name", ReqCheckTempletUI.getValue(row, "targCompany.name"));
        value = ReqCheckTempletUI.getValue(row, "requisitionEntry.id");
        reqCheckInfo.setPropertyValueBykey("requisitionEntry.id", value);
        value = ReqCheckTempletUI.getValue(row, "currency.id");
        reqCheckInfo.setPropertyValueBykey("currency.id", value);
        reqCheckInfo.setPropertyValueBykey("currency.name", ReqCheckTempletUI.getValue(row, "currency.name"));
        value = ReqCheckTempletUI.getValue(row, "baseCurrency.id");
        reqCheckInfo.setPropertyValueBykey("baseCurrency.id", value);
        value = ReqCheckTempletUI.getValue(row, "dc");
        if (value instanceof BizEnumValueInfo) {
            value = EntryDC.getEnum((int)((BizEnumValueInfo)value).getInt());
        }
        reqCheckInfo.setPropertyValueBykey("dc", value);
        value = ReqCheckTempletUI.getValue(row, "origAmount");
        reqCheckInfo.setPropertyValueBykey("origAmount", value);
        value = ReqCheckTempletUI.getValue(row, "assistRecord.localAmount");
        reqCheckInfo.setPropertyValueBykey("assistRecord.localAmount", value);
        value = ReqCheckTempletUI.getValue(row, "assistrecord.id");
        reqCheckInfo.setPropertyValueBykey("assistrecord.id", value);
        value = ReqCheckTempletUI.getValue(row, "checkNumber");
        reqCheckInfo.setPropertyValueBykey("checkNumber", value);
        value = ReqCheckTempletUI.getValue(row, "requisition.number");
        reqCheckInfo.setPropertyValueBykey("requisition.number", value);
        value = ReqCheckTempletUI.getValue(row, "assistRecord.bizNumber");
        reqCheckInfo.setPropertyValueBykey("assistRecord.bizNumber", value);
        return reqCheckInfo;
    }

    protected static VoucherCheckInfo getVchCheckInfoByRow(IRow row) {
        VoucherCheckInfo vchCheckInfo = new VoucherCheckInfo();
        Object value = null;
        value = ReqCheckTempletUI.getValue(row, "voucher.id");
        vchCheckInfo.setPropertyValueBykey("voucher.id", value);
        value = ReqCheckTempletUI.getValue(row, "voucher.lastupdatetime");
        vchCheckInfo.setPropertyValueBykey("voucher.lastupdatetime", value);
        value = ReqCheckTempletUI.getValue(row, "voucher.number");
        vchCheckInfo.setPropertyValueBykey("voucher.number", value);
        value = ReqCheckTempletUI.getValue(row, "srccompany.id");
        vchCheckInfo.setPropertyValueBykey("srccompany.id", value);
        value = ReqCheckTempletUI.getValue(row, "targcompany.id");
        vchCheckInfo.setPropertyValueBykey("targcompany.id", value);
        value = ReqCheckTempletUI.getValue(row, "currency.id");
        vchCheckInfo.setPropertyValueBykey("currency.id", value);
        value = ReqCheckTempletUI.getValue(row, "dc");
        if (value instanceof BizEnumValueInfo) {
            value = EntryDC.getEnum((int)((BizEnumValueInfo)value).getInt());
        }
        vchCheckInfo.setPropertyValueBykey("dc", value);
        value = ReqCheckTempletUI.getValue(row, "origAmount");
        vchCheckInfo.setPropertyValueBykey("origAmount", value);
        value = ReqCheckTempletUI.getValue(row, "assistrecord.id");
        vchCheckInfo.setPropertyValueBykey("assistrecord.id", value);
        value = ReqCheckTempletUI.getValue(row, "checkNumber");
        vchCheckInfo.setPropertyValueBykey("checkNumber", value);
        return vchCheckInfo;
    }

    private static Object getValue(IRow row, String keyString) {
        ICell cell = null;
        Object keyValue = null;
        cell = row.getCell(keyString);
        if (cell != null) {
            keyValue = cell.getValue();
        }
        return keyValue;
    }

    public final void showConditionDialog() {
        if (this.getConditionDialog().show()) {
            try {
                this.conditionVisitor = this.getDefaultFilterUI().conditionVisitior();
                this.companys = ((ReqCheckFilterUI)this.getConditionPanel()).getCompanys();
                this.curCompany = this.companys[0];
                this.createCondition();
                this.refresh();
                if (((ReqCheckFilterUI)this.getConditionPanel()).conditionVisitior().visitReqStatus() == ReqStatusEnum.UNCHECKED) {
                    this.actionUnValidate.setEnabled(false);
                    this.actionValidate.setEnabled(true);
                    this.actionAutoValidate.setEnabled(true);
                } else if (((ReqCheckFilterUI)this.getConditionPanel()).conditionVisitior().visitReqStatus() == ReqStatusEnum.CHECKED) {
                    this.actionValidate.setEnabled(false);
                    this.actionAutoValidate.setEnabled(false);
                    this.actionUnValidate.setEnabled(true);
                } else if (((ReqCheckFilterUI)this.getConditionPanel()).conditionVisitior().visitReqStatus() == ReqStatusEnum.CANCELLATION) {
                    this.actionValidate.setEnabled(false);
                    this.actionUnValidate.setEnabled(false);
                    this.actionAutoValidate.setEnabled(false);
                }
            }
            catch (BOSException e) {
                super.handUIException((Throwable)e);
            }
        } else {
            SysUtil.abort();
        }
    }

    protected abstract boolean isShowConditionDialog();

    protected CommonQueryDialog getConditionDialog() {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            this.conditionDialog.setShowFilter(true);
            this.conditionDialog.setShowSorter(true);
            this.conditionDialog.setTitle(ClientHelper.getStandardFilterTitle(this.getFilterTitle()));
            this.conditionDialog.setWidth(320);
            this.conditionDialog.setHeight(302);
            this.conditionDialog.addUserPanel(this.getConditionPanel());
            this.conditionDialog.setQueryObjectPK(this.getQueryObjectPK());
            this.conditionDialog.setParentUIClassName(this.getParentUIClassName());
            CommonQueryProcessor process = this.getProperCommonProcessor();
            process.set("parentDialog", (Object)this.conditionDialog);
            this.conditionDialog.setProcessor((IProcessor)process);
        }
        return this.conditionDialog;
    }

    protected CommonQueryProcessor getProperCommonProcessor() {
        return new CommonQueryProcessor(){

            public void process() throws Exception {
                String fieldProperty = (String)this.get("CURRENT_FIELD_PROP");
                if ("reqstatus".equalsIgnoreCase(fieldProperty)) {
                    Object editor = this.get("CURRENT_EDITOR");
                    KDComboBox cmb = (KDComboBox)editor;
                    int size = cmb.getItemCount();
                    for (int i = 0; i < size; ++i) {
                        Object item = cmb.getItemAt(i);
                        if (ReqStatusEnum.UNAUDIT != item) continue;
                        cmb.removeItemAt(i);
                    }
                }
            }
        };
    }

    protected abstract IMetaDataPK getQueryObjectPK();

    protected abstract String getParentUIClassName();

    protected abstract String getFilterTitle();

    protected KDPanel getConditionPanel() {
        if (this.conditionPanel == null) {
            try {
                this.conditionPanel = new ReqCheckFilterUI(false, this.initData);
                ((ReqCheckFilterUI)this.conditionPanel).getUIContext().put("Owner", this);
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
                SysUtil.abort();
            }
        }
        return this.conditionPanel;
    }

    public void createCondition() {
        this.createSrcCondition();
        this.createTargCondition();
    }

    protected abstract void createSrcCondition();

    protected abstract void createTargCondition();

    public ReqCheckFilterUI getDefaultFilterUI() {
        ReqCheckFilterUI filterUI = null;
        if (this.conditionPanel != null) {
            filterUI = (ReqCheckFilterUI)this.conditionPanel;
        }
        return filterUI;
    }

    protected void setQueryExecutor(IQueryExecutor exec) {
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnCheckSchemeConfig.setIcon(EASResource.getIcon((String)"imgTbtn_ruleinitialize"));
        this.visibleWorkButton();
        this.enableWorkButton();
        if (((ReqCheckFilterUI)this.getConditionPanel()).conditionVisitior().visitReqStatus() == ReqStatusEnum.UNCHECKED) {
            this.actionUnValidate.setEnabled(false);
        } else if (((ReqCheckFilterUI)this.getConditionPanel()).conditionVisitior().visitReqStatus() == ReqStatusEnum.CHECKED) {
            this.actionValidate.setEnabled(false);
        } else if (((ReqCheckFilterUI)this.getConditionPanel()).conditionVisitior().visitReqStatus() == ReqStatusEnum.CANCELLATION) {
            this.actionValidate.setEnabled(false);
            this.actionUnValidate.setEnabled(false);
        }
        if (this.isShowConditionDialog()) {
            this.getConditionDialog().init();
            this.getDefaultFilterUI().onLoad();
            this.showQueryDlg();
        } else {
            this.curCompany = SysContext.getSysContext().getCurrentFIUnit();
            this.createCondition();
        }
        if (this.companys == null) {
            this.companys = new CompanyOrgUnitInfo[]{SysContext.getSysContext().getCurrentFIUnit()};
            this.curCompany = SysContext.getSysContext().getCurrentFIUnit();
        }
        InputMap imEntry = this.getInputMap(2);
        KeyStroke ctrl_f08 = KeyStroke.getKeyStroke(119, 2);
        imEntry.put(ctrl_f08, (Object)this.actionAutoValidate);
        KeyStroke ctrl_f5 = KeyStroke.getKeyStroke(116, 2);
        imEntry.put(ctrl_f5, (Object)this.actionUnValidate);
    }

    protected void visibleWorkButton() {
        this.btnFilter.setVisible(true);
        this.btnRefresh.setVisible(true);
        this.btnSelectAll.setVisible(true);
        this.btnClearAll.setVisible(true);
        this.btnValidate.setVisible(true);
        this.btnUnValidate.setVisible(true);
        this.btnAutoValidate.setVisible(true);
    }

    protected void enableWorkButton() {
        this.btnFilter.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        this.btnSelectAll.setEnabled(true);
        this.btnClearAll.setEnabled(true);
        this.btnValidate.setEnabled(true);
        this.btnUnValidate.setEnabled(true);
        this.actionUnValidate.setEnabled(true);
        this.btnAutoValidate.setEnabled(true);
        this.actionAutoValidate.setEnabled(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnFilter);
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnValidate.setIcon(EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.btnUnValidate.setIcon(EASResource.getIcon((String)"imgTbtn_cancelcollate"));
        this.btnAutoValidate.setIcon(EASResource.getIcon((String)"imgTbtn_autocollate"));
    }

    public static IRequisitionCheck getBizInterface() throws BOSException {
        return RequisitionCheckFactory.getRemoteInstance();
    }

    private boolean showQueryDlg() throws Exception {
        boolean showDlg = true;
        if (this.isFirstDefaultQuery) {
            this.isFirstDefaultQuery = false;
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.gl.cslacct", "RequisitionCheckQuery")).getFullName();
            String curUserID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            String curCompanyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            if (iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName, curCompanyId, curUserID)) {
                QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName, curCompanyId, curUserID);
                QueryPanelCollection panels = solution.getQueryPanelInfo();
                QueryPanelInfo panel = null;
                int size = panels.size();
                for (int i = 0; i < size; ++i) {
                    panel = panels.get(i);
                    if (panel == null || panel.getCustomerParams() == null || !panel.getPanelClassName().equals(this.getDefaultFilterUI().getMetaDataPK().getFullName())) continue;
                    CustomerParams cp = CustomerParams.getCustomerParams2((String)panel.getCustomerParams());
                    this.getDefaultFilterUI().setCustomerParams(cp);
                    break;
                }
                this.companys = ((ReqCheckFilterUI)this.getConditionPanel()).getCompanys();
                this.curCompany = this.companys[0];
                this.conditionVisitor = this.getDefaultFilterUI().conditionVisitior();
                this.createCondition();
                showDlg = false;
            }
        }
        if (showDlg) {
            this.showConditionDialog();
        }
        return true;
    }

    private class GroupByInfo {
        private CompanyOrgUnitInfo company;
        private CurrencyInfo currency;

        private GroupByInfo(CompanyOrgUnitInfo company, CurrencyInfo currency) {
            this.company = company;
            this.currency = currency;
        }

        public CompanyOrgUnitInfo getCompany() {
            return this.company;
        }

        public CurrencyInfo getCurrency() {
            return this.currency;
        }
    }
}

