/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.cslacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.VoucherEditUI;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.cslacct.CheckViewInfo;
import com.kingdee.eas.fi.gl.cslacct.IRequisition;
import com.kingdee.eas.fi.gl.cslacct.IRequisitionAuditFacade;
import com.kingdee.eas.fi.gl.cslacct.ReqCheckCondition;
import com.kingdee.eas.fi.gl.cslacct.ReqStatusEnum;
import com.kingdee.eas.fi.gl.cslacct.RequisitionAuditFacadeFactory;
import com.kingdee.eas.fi.gl.cslacct.RequisitionCheckInfo;
import com.kingdee.eas.fi.gl.cslacct.RequisitionException;
import com.kingdee.eas.fi.gl.cslacct.RequisitionFactory;
import com.kingdee.eas.fi.gl.cslacct.RequisitionInfo;
import com.kingdee.eas.fi.gl.cslacct.VoucherCheckInfo;
import com.kingdee.eas.fi.gl.cslacct.client.AbstractReqCheckVoucherUI;
import com.kingdee.eas.fi.gl.cslacct.client.ClientHelper;
import com.kingdee.eas.fi.gl.cslacct.client.IReqCheckCondition;
import com.kingdee.eas.fi.gl.cslacct.client.ReqConditionVisitor;
import com.kingdee.eas.fi.gl.cslacct.util.RequisitionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReqCheckVoucherUI
extends AbstractReqCheckVoucherUI {
    private static final Logger logger = CoreUIObject.getLogger(ReqCheckVoucherUI.class);
    private RequisitionCheckInfo selectedReqInfo = null;
    CompanyOrgUnitInfo curCompany = null;

    @Override
    public void onLoad() throws Exception {
        Map uiCtx = super.getUIContext();
        uiCtx.put("is_fromReqCheck", Boolean.TRUE);
        if (uiCtx.get("ID") != null) {
            this.requisitionId = uiCtx.get("ID").toString();
        }
        this.curCompany = uiCtx.get("company") != null ? (CompanyOrgUnitInfo)uiCtx.get("company") : SysContext.getSysContext().getCurrentFIUnit();
        this.loadFields();
        if (!this.curCompany.isIsBizUnit()) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        this.initData = RequisitionFactory.getRemoteInstance().fetchInitData(this.curCompany.getId().toString());
        Boolean isAllowAcctCussent = (Boolean)this.initData.get("GLG01");
        if (!isAllowAcctCussent.booleanValue()) {
            throw new RequisitionException(RequisitionException.REQISNOTUSED);
        }
        int re = Integer.valueOf(this.initData.get("GL_026").toString());
        this.isAllowUnConfirm = re == 2;
        BooksUtil.checkIsNotBook();
        super.onLoad();
        this.actionFilter.setVisible(false);
        this.btnFilter.setVisible(false);
        if (uiCtx.get("ID") != null) {
            this.btnUnValidate.setEnabled(false);
            this.btnAutoValidate.setEnabled(false);
        }
        this.setAuditButtonState();
        this.srcTb.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getRowIndex() != -1 && e.getClickCount() == 1) {
                    this.repaintHead(e);
                }
            }

            private void repaintHead(KDTMouseEvent e) {
                IRow row = ReqCheckVoucherUI.this.srcTb.getRow(e.getRowIndex());
                ReqCheckVoucherUI.this.txtCompany.setText(this.toString(row.getCell("srccompany.name").getValue()));
                ReqCheckVoucherUI.this.txtTargCompany.setText(this.toString(row.getCell("targcompany.name").getValue()));
                ReqCheckVoucherUI.this.txtNumber.setText(this.toString(row.getCell("requisition.number").getValue()));
                ReqCheckVoucherUI.this.dateCreateTime.setValue(row.getCell("requisition.createtime").getValue());
                ReqCheckVoucherUI.this.txtVchNumber.setText(this.toString(row.getCell("voucher.number").getValue()));
            }

            private String toString(Object obj) {
                if (obj != null) {
                    return obj.toString();
                }
                return "";
            }
        });
        this.initTable();
        this.myInitListener();
        if (this.getUIContext().get("isFromWorkflow") != null) {
            this.getServiceContext().remove("GlobalService");
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        ClientHelper.activeTableRow(0, this.srcTb);
        this.setState();
    }

    @Override
    public void loadFields() {
        IRequisition ie = null;
        try {
            ie = RequisitionFactory.getRemoteInstance();
            if (this.requisitionId != null) {
                ObjectStringPK pk = new ObjectStringPK(this.requisitionId);
                this.requisition = (RequisitionInfo)ie.getValue((IObjectPK)pk, this.getSelectors());
                this.setDataObject((IObjectValue)this.requisition);
            }
        }
        catch (BOSException e) {
            super.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (EASBizException e) {
            super.handUIExceptionAndAbort((Exception)((Object)e));
        }
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        super.setQueryExecutor(exec);
        return exec;
    }

    @Override
    protected Collection getSrcCheckViews(ActionEvent e) {
        ArrayList<RequisitionCheckInfo> views = new ArrayList<RequisitionCheckInfo>();
        KDTSelectManager manager = this.srcTb.getSelectManager();
        if (manager != null) {
            int rowIndex = manager.getActiveRowIndex();
            this.selectedReqInfo = rowIndex != -1 ? AbstractReqCheckVoucherUI.getReqCheckInfoByRow(this.srcTb.getRow(rowIndex)) : AbstractReqCheckVoucherUI.getReqCheckInfoByRow(this.srcTb.getRow(0));
            views.add(this.selectedReqInfo);
        }
        return views;
    }

    @Override
    protected Collection getTargCheckViews(ActionEvent e) {
        return super.getSelectedItems(this.targTb, e.getSource().equals(this.btnValidate), VoucherCheckInfo.class.getName());
    }

    @Override
    protected void refreshSrcData() {
        this.srcTb.removeRows();
        this.setState();
    }

    @Override
    protected void refreshTargData() {
        this.targTb.removeRows();
    }

    @Override
    protected String getSelectedPosition() {
        return "isChecked";
    }

    @Override
    protected CheckViewInfo getSelectedItem(IRow row, String t) {
        return AbstractReqCheckVoucherUI.getVchCheckInfoByRow(row);
    }

    @Override
    protected boolean isShowConditionDialog() {
        return false;
    }

    @Override
    protected IMetaDataPK getQueryObjectPK() {
        return this.requisitionQueryPK;
    }

    @Override
    protected String getParentUIClassName() {
        return ReqCheckVoucherUI.class.getName();
    }

    @Override
    protected void createTargCondition() {
        this.assistRecordCheckQuery = new EntityViewInfo();
        if (this.conditionVisitor != null) {
            this.assistRecordCheckQuery.setFilter(this.getStrCondition(this.conditionVisitor));
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (this.requisition != null) {
                params.put("srcCompany.id", this.requisition.getCompany());
            } else {
                try {
                    params.put("srcCompany.id", ClientHelper.getCurCompany());
                }
                catch (BOSException e) {
                    super.handUIException((Throwable)e);
                }
            }
            params.put("reqstatus", ReqStatusEnum.UNCHECKED);
            params.put("isReqCheckVoucherUI", true);
            ReqConditionVisitor visitor = new ReqConditionVisitor(params);
            this.assistRecordCheckQuery.setFilter(this.getStrCondition(visitor));
        }
    }

    private FilterInfo getStrCondition(IReqCheckCondition condition) {
        FilterInfo filter = condition.createSrcCondition();
        FilterInfo fil = new FilterInfo();
        StringBuffer oql = new StringBuffer();
        oql.append(" voucher.id not in(");
        oql.append(" select rqst.FvoucherID from T_CSL_Requisition rqst ");
        oql.append(" where rqst.FSrcCompanyID ='" + condition.visitSrcCompany().getId().toString() + "')");
        fil.getFilterItems().add(new FilterItemInfo(oql.toString()));
        try {
            filter.mergeFilter(fil, "and");
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        return filter;
    }

    @Override
    protected void createSrcCondition() {
        this.requisitionQuery = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.conditionVisitor != null) {
            if (this.requisition.getSrcCompany() != null) {
                try {
                    this.conditionVisitor.setElement("srcCompany.id", this.requisition.getCompany());
                }
                catch (Exception e) {
                    super.handUIException((Throwable)e);
                }
            }
            filter = this.conditionVisitor.createTargCondition();
        } else {
            filter.getFilterItems().add(new FilterItemInfo("reqstatus", (Object)new Integer(1), CompareType.EQUALS));
        }
        if (this.requisition != null) {
            filter.getFilterItems().add(new FilterItemInfo("requisition.id", (Object)this.requisitionId, CompareType.EQUALS));
        }
        this.requisitionQuery.setFilter(filter);
    }

    @Override
    protected KDTable getSrcTable() {
        return null;
    }

    @Override
    protected KDTable getTargetTable() {
        return this.targTb;
    }

    @Override
    protected ReqCheckCondition getCheckCondition() {
        ReqCheckCondition condition = new ReqCheckCondition();
        if (this.conditionVisitor != null) {
            condition = this.conditionVisitor.toCheckCondition();
        }
        if (this.requisitionId != null) {
            condition.setRequisitionId(this.requisitionId);
        }
        return condition;
    }

    @Override
    protected String getFilterTitle() {
        return this.getUITitle();
    }

    protected void initTable() {
        this.targTb.checkParsed();
        this.targTb.getColumn("createTime").getStyleAttributes().setNumberFormat("yyyy-MM-dd");
    }

    public void myInitListener() {
        this.srcTb.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    int start = e.getFirstRow();
                    int end = e.getLastRow();
                    ReqCheckVoucherUI.this.setCellFormat(ReqCheckVoucherUI.this.srcTb, start, end);
                }
                catch (Exception e2) {
                    ReqCheckVoucherUI.this.handUIException(e2);
                }
            }
        });
        this.targTb.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    int start = e.getFirstRow();
                    int end = e.getLastRow();
                    ReqCheckVoucherUI.this.setCellFormat(ReqCheckVoucherUI.this.targTb, start, end);
                }
                catch (Exception e2) {
                    ReqCheckVoucherUI.this.handUIException(e2);
                }
            }
        });
    }

    private void setCellFormat(KDTable table, int start, int end) {
        for (int i = start; i <= end && table.getRow2(i) != null; ++i) {
            Object curpreObj = table.getRow2(i).getCell("currency.precision").getValue();
            int curPre = curpreObj == null ? 0 : (Integer)curpreObj;
            table.getColumn("origAmount").getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(curPre));
        }
    }

    private boolean getAuditParam() {
        String companyId = null;
        companyId = this.curCompany != null ? this.curCompany.getId().toString() : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        boolean isAudit = false;
        try {
            IRequisitionAuditFacade audit = RequisitionAuditFacadeFactory.getRemoteInstance();
            isAudit = audit.getRequisitionAuditParam(companyId);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return isAudit;
    }

    private void setAuditButtonState() {
        this.btnAssociate.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        String tarCompanyId = this.requisition.getTargCompany().getId().toString();
        String companyId = null;
        companyId = this.curCompany != null ? this.curCompany.getId().toString() : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        if (tarCompanyId.equals(companyId)) {
            if (this.isInWorkFlow()) {
                boolean isUseAudit = this.getAuditParam();
                boolean isCheck = this.requisition.isFiVouchered();
                boolean isAudited = this.requisition.isIsAudit();
                if (isCheck) {
                    this.btnUnAudit.setVisible(false);
                    this.actionUnAudit.setEnabled(false);
                } else if (isUseAudit) {
                    if (isAudited) {
                        this.btnUnAudit.setVisible(true);
                        this.actionUnAudit.setEnabled(true);
                    } else {
                        this.btnUnAudit.setVisible(false);
                        this.actionUnAudit.setEnabled(false);
                    }
                } else {
                    this.btnUnAudit.setVisible(false);
                    this.actionUnAudit.setEnabled(false);
                }
            } else {
                this.btnUnAudit.setVisible(false);
                this.actionUnAudit.setEnabled(false);
            }
        } else {
            this.btnUnAudit.setVisible(false);
            this.actionUnAudit.setEnabled(false);
        }
    }

    @Override
    public void actionAssociate_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssociate_actionPerformed(e);
        VoucherInfo voucher = this.requisition.getVoucher();
        IVoucher iVoucher = VoucherFactory.getRemoteInstance();
        String companyId = null;
        companyId = this.curCompany != null ? this.curCompany.getId().toString() : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        HashMap hmAllParam = GlUtils.getDefaultGLParam(null, companyId);
        boolean allowView = Boolean.valueOf(hmAllParam.get("GL_077").toString());
        try {
            voucher = allowView ? (VoucherInfo)iVoucher.getVoucherWithoutPermissionCheck((IObjectPK)new ObjectUuidPK(voucher.getId())) : (VoucherInfo)iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucher.getId()));
        }
        catch (BOSException ex) {
            super.handUIException((Throwable)ex);
            SysUtil.abort((Throwable)ex);
        }
        catch (EASBizException ex) {
            super.handUIException((Throwable)ex);
            SysUtil.abort((Throwable)ex);
        }
        if (voucher != null) {
            VoucherEditUI.showVoucher((IUIObject)this, "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory", OprtState.VIEW, voucher, "com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
        ObjectUuidPK pk = new ObjectUuidPK(this.requisition.getId());
        IRequisition iRequisition = RequisitionFactory.getRemoteInstance();
        iRequisition.antiAudit((IObjectPK)pk);
        String RESOURCE = "com.kingdee.eas.fi.gl.cslacct.GRUIResource";
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"REQUISITION_UNAUDIT_SUCCESS"));
        this.onLoad();
        this.refreshSrcData();
    }

    private void setState() {
        boolean isAudit = this.getAuditParam();
        if (isAudit) {
            BizEnumValueInfo info = new BizEnumValueInfo();
            info.setInt(4);
            info.setAlias(ReqStatusEnum.UNAUDIT.getAlias());
            RequisitionInfo reqInfo = this.requisition;
            ArrayList<String> reqIds = new ArrayList<String>();
            reqIds.add(this.requisition.getVoucher().getId().toString());
            boolean isReqAudit = reqInfo.isIsAudit();
            if (!isReqAudit) {
                int entryRow = reqInfo.getRequisitionEntry().size();
                for (int i = 0; i < entryRow; ++i) {
                    if (this.srcTb.getCell(i, "reqstatus") == null) continue;
                    this.srcTb.getCell(i, "reqstatus").setValue((Object)info.getAlias());
                }
            }
        }
    }

    private boolean isInWorkFlow() {
        try {
            String[] ids = RequisitionHelper.checkBizObjInWfProcess(null, new String[]{this.requisition.getId().toString()});
            if (ids != null && ids.length > 0) {
                return true;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return false;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("isAudit"));
        return sic;
    }
}

