/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.cslacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.cslacct.ReqCheckCondition;
import com.kingdee.eas.fi.gl.cslacct.ReqStatusEnum;
import com.kingdee.eas.fi.gl.cslacct.client.ClientHelper;
import com.kingdee.eas.fi.gl.cslacct.client.ICycleControl;
import com.kingdee.eas.fi.gl.cslacct.client.ICycleElement;
import com.kingdee.eas.fi.gl.cslacct.client.IReqCheckCondition;
import com.kingdee.eas.fi.gl.cslacct.util.Constant;
import com.kingdee.eas.fi.gl.cslacct.util.Helper;
import java.util.Date;
import java.util.Map;
import java.util.Observable;
import org.apache.log4j.Logger;

public final class ReqConditionVisitor
implements IReqCheckCondition {
    private static final Logger logger = Logger.getLogger(ReqConditionVisitor.class);
    public static final int BY_DATE = 64;
    public static final int SINGLE_PERIOD = 128;
    public static final int SAME_YEAR = 256;
    public static final int DIFF_YEAR = 512;
    private ICycleControl controller = null;
    private Map visitor = null;

    public ReqConditionVisitor(Map visitor) {
        this.visitor = visitor;
    }

    @Override
    public void addCycleController(ICycleControl cyc) {
        this.controller = cyc;
        this.controller.addElementChangeListener(this);
    }

    @Override
    public Map getVisitor() {
        return this.visitor;
    }

    @Override
    public ReqCheckCondition toCheckCondition() {
        ReqCheckCondition condition = new ReqCheckCondition();
        if (this.isVisitable("srcCompany.id") && !this.isSelectedAll("srcCompany.id")) {
            condition.setCompany(this.visitSrcCompany());
        }
        if (this.isVisitable("company.id") && !this.isSelectedAll("company.id")) {
            condition.setTargCompany(this.visitTargetCompany());
        }
        if (this.isVisitable("currency.id") && !this.isSelectedAll("currency.id")) {
            condition.setCurrency(this.visitCurrency());
        }
        if (this.isVisitable("startDate")) {
            condition.setStartDate(this.visitStartDate());
        }
        if (this.isVisitable("endDate")) {
            condition.setEndDate(this.visitEndDate());
        }
        if (this.isVisitable("accountNumberForRecive")) {
            condition.setAcctNumForRecive(this.visitReciveAccountNumber());
        }
        condition.setFlag(this.visitFlag());
        condition.setFromPiNum(this.visitFromPiNum());
        condition.setFromPiYear(this.visitFromPiYear());
        condition.setToPiNum(this.visitToPiNum());
        condition.setToPiYear(this.visitToPiYear());
        condition.setIncludeAvoid(this.visitIncludeAvoid());
        condition.setAccount(this.visitAccountView());
        return condition;
    }

    @Override
    public ICycleControl cycleController() {
        return this.controller;
    }

    @Override
    public void setElement(String keyString, Object o) throws Exception {
        if (this.controller != null && this.controller.isCycle(keyString, o)) {
            this.controller.moveTo(keyString, o);
        } else {
            this.setValue(keyString, o);
        }
    }

    @Override
    public FilterInfo createSrcCondition() {
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer("(");
        int maskeIndex = 0;
        if (this.isVisitable("srcCompany.id") && !this.isSelectedAll("srcCompany.id")) {
            filter.getFilterItems().add(new FilterItemInfo("srcCompany.id", (Object)this.visitSrcCompany().getId().toString(), CompareType.EQUALS));
            maskString.append("#0");
            ++maskeIndex;
            if (this.isVisitable("account.number")) {
                filter.getFilterItems().add(new FilterItemInfo("account.number", (Object)this.visitAccountView().getNumber(), CompareType.EQUALS));
                maskString.append("and #1");
                ++maskeIndex;
            }
        }
        if (this.isVisitable("company.id") && !this.isSelectedAll("company.id")) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.visitTargetCompany().getId().toString(), CompareType.EQUALS));
            if (maskeIndex > 0) {
                maskString.append(" and #").append(maskeIndex);
            } else {
                maskString.append(" #").append(maskeIndex);
            }
            ++maskeIndex;
        }
        maskString.append(")");
        if (maskeIndex > 0) {
            filter.setMaskString(maskString.toString());
        }
        FilterInfo f = this.createCommonCondition(false);
        try {
            filter.mergeFilter(f, "and");
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return filter;
    }

    @Override
    public FilterInfo createTargCondition() {
        FilterInfo filter = new FilterInfo();
        if (this.isVisitable("company.id") && !this.isSelectedAll("company.id")) {
            filter.getFilterItems().add(new FilterItemInfo("srcCompany.id", (Object)this.visitTargetCompany().getId().toString(), CompareType.EQUALS));
            StringBuffer maskString = new StringBuffer("");
            maskString.append("(#0");
            if (this.isVisitable("accountNumberForRecive")) {
                filter.getFilterItems().add(new FilterItemInfo("account.number", (Object)this.visitReciveAccountNumber(), CompareType.EQUALS));
                maskString.append("and #1)");
                filter.setMaskString(maskString.toString());
            }
        } else if (this.isVisitable("accountNumberForRecive")) {
            filter.getFilterItems().add(new FilterItemInfo("account.number", (Object)this.visitReciveAccountNumber(), CompareType.EQUALS));
        }
        if (this.isVisitable("srcCompany.id") && !this.isSelectedAll("srcCompany.id")) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.visitSrcCompany().getId().toString(), CompareType.EQUALS));
        }
        FilterInfo f = this.createCommonCondition(true);
        try {
            filter.mergeFilter(f, "and");
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return filter;
    }

    @Override
    public FilterInfo createSrcCustomCondition(FilterInfo f, FilterInfo commonFilter) {
        FilterInfo filter = new FilterInfo();
        for (FilterItemInfo filterItem : commonFilter.getFilterItems()) {
            if (filterItem.getPropertyName().startsWith("srcCompany.number")) continue;
            filter.getFilterItems().add(filterItem);
        }
        try {
            filter.mergeFilter(f, "and");
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return filter;
    }

    @Override
    public FilterInfo createTargCustomCondition(FilterInfo f, FilterInfo commonFilter) {
        FilterInfo filter = new FilterInfo();
        for (FilterItemInfo filterItem : commonFilter.getFilterItems()) {
            if (filterItem.getPropertyName().startsWith("company.number")) continue;
            filter.getFilterItems().add(filterItem);
        }
        try {
            filter.mergeFilter(f, "and");
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return filter;
    }

    public FilterInfo createCommonCondition(boolean isReciver) {
        FilterInfo f = new FilterInfo();
        int index = 0;
        StringBuffer maskString = new StringBuffer("");
        int flag = 64;
        if (this.isVisitable("startDate")) {
            flag = this.visitFlag();
        }
        if ((flag & 0x40) == 0) {
            Integer yearFrom = this.visitFromPiYear();
            Integer periodFrom = this.visitFromPiNum();
            Integer yearTo = this.visitToPiYear();
            Integer periodTo = this.visitToPiNum();
            maskString.append("(");
            if ((flag & 0x80) != 0) {
                f.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)yearFrom));
                f.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)periodFrom));
                maskString.append("#" + index++ + " AND ");
                maskString.append("#" + index++ + ")");
            } else if ((flag & 0x100) != 0) {
                f.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)yearFrom));
                f.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)periodFrom, CompareType.GREATER_EQUALS));
                f.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)periodTo, CompareType.LESS_EQUALS));
                maskString.append("#" + index++ + " AND ");
                maskString.append("#" + index++ + " AND ");
                maskString.append("#" + index++ + ")");
            } else {
                f.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)yearFrom));
                f.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)periodFrom, CompareType.GREATER_EQUALS));
                f.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)yearFrom, CompareType.GREATER));
                f.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)yearTo));
                f.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)periodTo, CompareType.LESS_EQUALS));
                f.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)yearTo, CompareType.LESS));
                maskString.append("((#" + index++ + " AND ");
                maskString.append("#" + index++ + ") OR ");
                maskString.append("#" + index++ + ") AND ");
                maskString.append("((#" + index++ + " AND ");
                maskString.append("#" + index++ + ") OR ");
                maskString.append("#" + index++ + "))");
            }
        } else {
            if (this.isVisitable("startDate")) {
                f.getFilterItems().add(new FilterItemInfo("createTime", (Object)Helper.getFilterDate(this.visitStartDate(), "startDate"), CompareType.GREATER));
                if (maskString.length() > 0) {
                    maskString.append(" And #" + index++);
                } else {
                    maskString.append(" #" + index++);
                }
            }
            if (this.isVisitable("endDate")) {
                f.getFilterItems().add(new FilterItemInfo("createTime", (Object)Helper.getFilterDate(this.visitEndDate(), "endDate"), CompareType.LESS));
                if (maskString.length() > 0) {
                    maskString.append(" And #" + index++);
                } else {
                    maskString.append(" #" + index++);
                }
            }
        }
        if (this.isVisitable("currency.id") && !this.isSelectedAll("currency.id")) {
            f.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.visitCurrency().getId().toString(), CompareType.EQUALS));
            if (maskString.length() > 0) {
                maskString.append(" And #" + index++);
            } else {
                maskString.append(" #" + index++);
            }
        }
        if (this.isVisitable("reqstatus")) {
            if (this.visitReqStatus().getValue() == 0) {
                f.getFilterItems().add(new FilterItemInfo("reqstatus", (Object)"1,2", CompareType.INNER));
            } else {
                f.getFilterItems().add(new FilterItemInfo("reqstatus", (Object)new Integer(this.visitReqStatus().getValue()), CompareType.EQUALS));
            }
            if (maskString.length() > 0) {
                maskString.append(" And #" + index++);
            } else {
                maskString.append(" #" + index++);
            }
        }
        if (this.isVisitable("isAvoidCheck")) {
            Boolean includeAvoid = this.visitIncludeAvoid();
            try {
                int gl_026Value = Integer.valueOf(GlUtils.getParamByKey(null, this.visitSrcCompany().getId().toString(), "GL_026").toString());
                if (!includeAvoid.booleanValue() && gl_026Value != 2) {
                    f.getFilterItems().add(new FilterItemInfo("isAvoidCheck", (Object)new Integer(0), CompareType.EQUALS));
                    if (maskString.length() > 0) {
                        maskString.append(" And #" + index++);
                    } else {
                        maskString.append(" #" + index++);
                    }
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        f.setMaskString(maskString.toString());
        return f;
    }

    @Override
    public boolean isVisitable(String keyString) {
        return this.visitor != null && this.visitor.containsKey(keyString);
    }

    @Override
    public Object visit(String keyString) {
        return this.visitor.get(keyString);
    }

    @Override
    public CompanyOrgUnitInfo visitSrcCompany() {
        return (CompanyOrgUnitInfo)this.visit("srcCompany.id");
    }

    @Override
    public CompanyOrgUnitInfo visitTargetCompany() {
        return (CompanyOrgUnitInfo)this.visit("company.id");
    }

    @Override
    public CurrencyInfo visitCurrency() {
        return (CurrencyInfo)this.visit("currency.id");
    }

    @Override
    public ReqStatusEnum visitReqStatus() {
        return (ReqStatusEnum)this.visit("reqstatus");
    }

    public Integer visitFromPiYear() {
        return (Integer)this.visit("fromPiYear");
    }

    public Integer visitToPiYear() {
        return (Integer)this.visit("toPiYear");
    }

    public Integer visitFromPiNum() {
        return (Integer)this.visit("fromPiNum");
    }

    public Integer visitToPiNum() {
        return (Integer)this.visit("toPiNum");
    }

    @Override
    public Integer visitFlag() {
        return new Integer(this.visit("isRadByPeriod").toString());
    }

    public AccountViewInfo visitAccountView() {
        return (AccountViewInfo)this.visit("account.number");
    }

    public String visitReciveAccountNumber() {
        return (String)this.visit("accountNumberForRecive");
    }

    @Override
    public Date visitStartDate() {
        return ClientHelper.createFilterDate((Date)this.visit("startDate"));
    }

    @Override
    public Date visitEndDate() {
        return ClientHelper.createFilterDate((Date)this.visit("endDate"));
    }

    @Override
    public Integer visitIsAccept() {
        return (Integer)this.visit("isaccept");
    }

    @Override
    public Integer visitIsSend() {
        return (Integer)this.visit("issend");
    }

    public Boolean visitIncludeAvoid() {
        return (Boolean)this.visit("isAvoidCheck");
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof ICycleElement) {
            ((ICycleElement)arg).read(this.visitor);
        }
    }

    private void setValue(String keyString, Object o) {
        if (this.visitor != null && this.visitor.containsKey(keyString)) {
            this.visitor.put(keyString, o);
        }
    }

    private boolean isSelectedAll(String keyString) {
        boolean isTrue = false;
        if (this.isVisitable(keyString) && Constant.SELECTALLITEM.equalsIgnoreCase(this.visit(keyString).toString())) {
            isTrue = true;
        }
        return isTrue;
    }
}

