/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.cslacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.client.VoucherEditUI;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.cslacct.IRequisition;
import com.kingdee.eas.fi.gl.cslacct.IRequisitionAuditFacade;
import com.kingdee.eas.fi.gl.cslacct.ReqStatusEnum;
import com.kingdee.eas.fi.gl.cslacct.RequisitionAuditFacadeFactory;
import com.kingdee.eas.fi.gl.cslacct.RequisitionEntryInfo;
import com.kingdee.eas.fi.gl.cslacct.RequisitionFactory;
import com.kingdee.eas.fi.gl.cslacct.RequisitionInfo;
import com.kingdee.eas.fi.gl.cslacct.client.AbstractRequisitionEditUI;
import com.kingdee.eas.fi.gl.cslacct.client.RequisitionStaticUI;
import com.kingdee.eas.fi.gl.cslacct.util.RequisitionHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class RequisitionEditUI
extends AbstractRequisitionEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RequisitionEditUI.class);
    private static final String KEYSTRING_SUMMARY = "summary";
    private static final String KEYSTRING_DC = "dc";
    private static final String KEYSTRING_AMOUNT = "originalAmount";
    private static final String KEYSTRING_CHECKVCHNUMBER = "checkVchNumber";
    private static final String KEYSTRING_STATUS = "status";

    public void onLoad() throws Exception {
        this.kdtRequisitionEntry.checkParsed();
        super.onLoad();
        this.btnAddNew.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnSubmit.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.setAuditButtonState();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.setCurrencyPrecision();
            this.getVoucherInfomation();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handleException(ex);
        }
        this.setAuditButtonState();
        this.setState();
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        row.setUserObject((Object)obj);
        RequisitionEntryInfo lineInfo = (RequisitionEntryInfo)obj;
        row.getCell(KEYSTRING_SUMMARY).setValue((Object)lineInfo.getSummary());
        row.getCell(KEYSTRING_DC).setValue((Object)lineInfo.getDc());
        row.getCell(KEYSTRING_AMOUNT).setValue((Object)lineInfo.getOriginalAmount());
        row.getCell(KEYSTRING_CHECKVCHNUMBER).setValue((Object)lineInfo.getCheckNumber());
        row.getCell(KEYSTRING_STATUS).setValue((Object)lineInfo.getStatus());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RequisitionFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected RequisitionInfo getRequisitionInfo() throws Exception {
        return (RequisitionInfo)this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()));
    }

    protected void getVoucherInfomation() throws Exception {
        RequisitionInfo info = this.getRequisitionInfo();
        String[] strInfo = RequisitionStaticUI.getVoucherInfomation(info);
        if (strInfo[0].length() > 0) {
            this.lblVoucherInfo.setText(strInfo[0]);
        }
        if (strInfo[1] != null && strInfo[1].length() > 0) {
            this.lblVoucher.setText(strInfo[1]);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("voucher.*"));
        sic.add(new SelectorItemInfo("voucher.period.*"));
        sic.add(new SelectorItemInfo("voucher.voucherType.*"));
        sic.add(new SelectorItemInfo("voucher.creator.*"));
        sic.add(new SelectorItemInfo("voucher.auditor.*"));
        return sic;
    }

    private boolean getAuditParam() {
        String companyId = this.editData.getTargCompany().getId().toString();
        boolean isAudit = false;
        try {
            IRequisitionAuditFacade audit = RequisitionAuditFacadeFactory.getRemoteInstance();
            isAudit = audit.getRequisitionAuditParam(companyId);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return isAudit;
    }

    private void setAuditButtonState() {
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnAssociate.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        String tarCompanyId = this.editData.getTargCompany().getId().toString();
        boolean isTargCompany = this.isTargCompany(tarCompanyId);
        if (isTargCompany) {
            if (this.getAuditParam()) {
                boolean inWorkflow = this.isInWorkFlow();
                if (!inWorkflow) {
                    boolean audited = this.editData.isIsAudit();
                    boolean checked = this.editData.isFiVouchered();
                    if (checked) {
                        this.actionAudit.setEnabled(false);
                        this.actionUnAudit.setEnabled(false);
                    } else if (audited) {
                        this.actionAudit.setEnabled(false);
                        this.actionUnAudit.setEnabled(true);
                    } else {
                        this.actionAudit.setEnabled(true);
                        this.actionUnAudit.setEnabled(false);
                    }
                } else {
                    this.actionAudit.setEnabled(false);
                    this.actionUnAudit.setEnabled(false);
                }
            } else {
                this.actionAudit.setEnabled(false);
                this.actionUnAudit.setEnabled(false);
            }
        } else {
            this.actionAudit.setEnabled(false);
            this.actionUnAudit.setEnabled(false);
        }
    }

    private boolean isTargCompany(String tarCompanyId) {
        boolean isTargCompany = false;
        CompanyOrgUnitInfo[] companys = (CompanyOrgUnitInfo[])this.getUIContext().get("companys");
        if (companys != null) {
            for (int i = 0; i < companys.length; ++i) {
                if (companys[i] == null || !tarCompanyId.equals(companys[i].getId().toString())) continue;
                isTargCompany = true;
                break;
            }
        }
        return isTargCompany;
    }

    @Override
    public void actionAssociate_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssociate_actionPerformed(e);
        VoucherInfo voucher = this.editData.getVoucher();
        IVoucher iVoucher = VoucherFactory.getRemoteInstance();
        HashMap hmAllParam = GlUtils.getDefaultGLParam(null, SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        boolean allowView = Boolean.valueOf(hmAllParam.get("GL_077").toString());
        voucher = allowView ? (VoucherInfo)iVoucher.getVoucherWithoutPermissionCheck((IObjectPK)new ObjectUuidPK(voucher.getId())) : (VoucherInfo)iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucher.getId()));
        if (voucher != null) {
            VoucherEditUI.showVoucher((IUIObject)this, "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory", OprtState.VIEW, voucher, "com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule");
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        IRequisition requisition = RequisitionFactory.getRemoteInstance();
        if (this.editData.getTargCompany() != null) {
            // empty if block
        }
        Set companyIdSet = this.getCompanyIdSet();
        requisition.audit((IObjectPK)pk, companyIdSet);
        String RESOURCE = "com.kingdee.eas.fi.gl.cslacct.GRUIResource";
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"REQUISITION_AUDIT_SUCCESS"));
        this.loadData();
    }

    private Set getCompanyIdSet() {
        CompanyOrgUnitInfo[] companys = (CompanyOrgUnitInfo[])this.getUIContext().get("companys");
        HashSet<String> companyIdSet = new HashSet<String>();
        if (companys != null) {
            for (int i = 0; i < companys.length; ++i) {
                if (companys[i] == null) continue;
                companyIdSet.add(companys[i].getId().toString());
            }
        } else {
            companyIdSet.add(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        }
        return companyIdSet;
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAudit_actionPerformed(e);
        ObjectUuidPK[] pks = new ObjectUuidPK[]{new ObjectUuidPK(this.editData.getId())};
        IRequisition requisition = RequisitionFactory.getRemoteInstance();
        Set companyIdSet = this.getCompanyIdSet();
        requisition.unAudit((IObjectPK[])pks, companyIdSet);
        String RESOURCE = "com.kingdee.eas.fi.gl.cslacct.GRUIResource";
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"REQUISITION_UNAUDIT_SUCCESS"));
        this.loadData();
    }

    private void setState() {
        boolean isAudit = this.getAuditParam();
        if (isAudit) {
            BizEnumValueInfo info = new BizEnumValueInfo();
            info.setInt(4);
            info.setAlias(ReqStatusEnum.UNAUDIT.getAlias());
            RequisitionInfo reqInfo = null;
            try {
                reqInfo = this.getRequisitionInfo();
                boolean isReqAudit = reqInfo.isIsAudit();
                if (!isReqAudit) {
                    int entryRow = reqInfo.getRequisitionEntry().size();
                    for (int i = 0; i < entryRow; ++i) {
                        int reqEntryStatus = reqInfo.getRequisitionEntry().get(i).getStatus().getValue();
                        if (reqEntryStatus != 1) continue;
                        this.kdtRequisitionEntry.getCell(i, KEYSTRING_STATUS).setValue((Object)info.getAlias());
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private boolean isInWorkFlow() {
        try {
            String[] ids = RequisitionHelper.checkBizObjInWfProcess(null, new String[]{this.editData.getId().toString()});
            if (ids != null && ids.length > 0) {
                return true;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return false;
    }

    private void setCurrencyPrecision() throws EASBizException, BOSException {
        ICurrency currency = CurrencyFactory.getRemoteInstance();
        for (int i = 0; i < this.editData.getRequisitionEntry().size(); ++i) {
            RequisitionEntryInfo reqEntry = this.editData.getRequisitionEntry().get(i);
            if (reqEntry == null) continue;
            int curPre = ((CurrencyInfo)currency.getValue((IObjectPK)new ObjectUuidPK(reqEntry.getCurrency().getId().toString()))).getPrecision();
            this.kdtRequisitionEntry.getColumn(KEYSTRING_AMOUNT).getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(curPre));
        }
    }
}

