/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.cslacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.client.BillListUISupport;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.uicontroller.DefaultRowDataProvider;
import com.kingdee.eas.framework.client.uicontroller.IRowDataProvider;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RequisitionListUISupport
extends BillListUISupport {
    private Logger logger = Logger.getLogger(BillListUISupport.class);
    private CompanyOrgUnitInfo[] companys = null;

    public RequisitionListUISupport(CoreUI ui) {
        super(ui);
    }

    public CompanyOrgUnitInfo[] getCompanys() {
        return this.companys;
    }

    public void setCompanys(CompanyOrgUnitInfo[] companys) {
        this.companys = companys;
    }

    protected void tranToProvider(CoreBillListUI ui, IRowDataProvider provider) {
        int mode = 0;
        List data_items = new ArrayList();
        ArrayList blockList = ui.getMainTable().getSelectManager().getBlocks();
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)ui.getMainTable().getSelectManager().getBlocks().get(0)).getMode();
        }
        data_items = mode == 8 ? this.getSelectionIDsWithQuery(ui, provider) : this.getSelectionIDsWithTable(ui, provider);
        ((DefaultRowDataProvider)provider).setData(data_items);
    }

    private List getSelectionIDsWithQuery(CoreBillListUI ui, IRowDataProvider provider) {
        ArrayList<IRowDataProvider.RowData> data_items = new ArrayList<IRowDataProvider.RowData>();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo(provider.getPkName()));
        if (provider.getEntryName() != null) {
            selectors.add(new SelectorItemInfo(provider.getEntryName()));
        }
        selectors.add(new SelectorItemInfo(provider.getOrgName()));
        EntityViewInfo view = (EntityViewInfo)ui.getMainQuery().clone();
        view.setAppendSelectors(false);
        view.setSelector(selectors);
        IQueryExecutor queryExecutor = null;
        queryExecutor = ui.getUIMainOrgContext() != null ? QueryExecutorFactory.getRemoteInstanceWithObjectContext((IMetaDataPK)ui.getMainQueryPK(), (Context)ui.getUIMainOrgContext()) : QueryExecutorFactory.getRemoteInstance((IMetaDataPK)ui.getMainQueryPK());
        queryExecutor.setObjectView(view);
        boolean isOrderBy = false;
        if (view.getSorter() != null && view.getSorter().size() > 0) {
            isOrderBy = true;
        }
        queryExecutor.option().isIgnoreOrder = isOrderBy;
        queryExecutor.option().isIgnoreRowCount = true;
        queryExecutor.option().isIgnorePermissionCheck = true;
        try {
            IRowSet rs = queryExecutor.executeQuery();
            while (rs.next()) {
                String companyId;
                Object[] row_data = new Object[3];
                row_data[0] = rs.getObject(1);
                if (provider.getEntryName() != null) {
                    row_data[1] = rs.getObject(2);
                    row_data[2] = rs.getObject(3);
                } else {
                    row_data[2] = rs.getObject(2);
                }
                if (this.getCompany(companyId = (String)rs.getObject("company.id")) == null) continue;
                data_items.add(new IRowDataProvider.RowData(row_data));
            }
        }
        catch (BOSException e) {
            this.logger.error((Object)"fail IQueryExecutor.execueQuery ", (Throwable)e);
        }
        catch (SQLException e) {
            this.logger.error((Object)"fail IRowSet fetch data ", (Throwable)e);
        }
        return data_items;
    }

    private List getSelectionIDsWithTable(CoreBillListUI ui, IRowDataProvider provider) {
        ArrayList<IRowDataProvider.RowData> data_items = new ArrayList<IRowDataProvider.RowData>();
        ArrayList blocks = ui.getMainTable().getSelectManager().getBlocks();
        for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            String[] key_names = new String[]{provider.getPkName(), provider.getEntryName(), provider.getOrgName()};
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                Object[] row_data = new Object[3];
                for (int i = 0; i < key_names.length; ++i) {
                    ICell cl;
                    if (key_names[i] == null || (cl = ui.getMainTable().getRow(rowIndex).getCell(key_names[i])) == null || cl.getValue() == null) continue;
                    row_data[i] = cl.getValue().toString();
                }
                String companyId = (String)ui.getMainTable().getRow(rowIndex).getCell("company.id").getValue();
                if (this.getCompany(companyId) == null) continue;
                data_items.add(new IRowDataProvider.RowData(row_data));
            }
        }
        return data_items;
    }

    private CompanyOrgUnitInfo getCompany(String companyId) {
        if (companyId == null) {
            return null;
        }
        CompanyOrgUnitInfo[] companys = this.getCompanys();
        if (companys != null) {
            for (int i = 0; i < companys.length; ++i) {
                if (!companyId.equals(companys[i].getId().toString())) continue;
                return companys[i];
            }
        }
        return null;
    }
}

