/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.cslacct.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.cslacct.CheckViewInfo;
import com.kingdee.eas.fi.gl.cslacct.ReqCheckCondition;
import com.kingdee.eas.fi.gl.cslacct.RequisitionCheckInfo;
import com.kingdee.eas.fi.gl.cslacct.VoucherCheckInfo;
import com.kingdee.eas.fi.gl.cslacct.client.AbstractVoucherCheckReqUI;
import com.kingdee.eas.fi.gl.cslacct.client.ClientHelper;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class VoucherCheckReqUI
extends AbstractVoucherCheckReqUI {
    private ReqCheckCondition condition = null;
    private Set companyIdSet;

    @Override
    public void onLoad() throws Exception {
        Map uiCtx = super.getUIContext();
        if (uiCtx.get("condition") != null) {
            this.condition = (ReqCheckCondition)uiCtx.get("condition");
        }
        if (uiCtx.get("srcCompanyIdSet") != null) {
            this.companyIdSet = (Set)uiCtx.get("srcCompanyIdSet");
        }
        super.onLoad();
        if (uiCtx.get("condition") != null) {
            this.actionUnValidate.setEnabled(false);
        }
        this.myInitListener();
    }

    public void onShow() throws Exception {
        super.onShow();
        ClientHelper.activeTableRow(0, this.tbSrc);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        super.setQueryExecutor(exec);
        return exec;
    }

    @Override
    protected void createSrcCondition() {
        FilterInfo filter = new FilterInfo();
        this.assistRecordCheckQuery = new EntityViewInfo();
        String companyId = null;
        if (this.condition != null && this.condition.getCompany() != null) {
            companyId = this.condition.getCompany().getId().toString();
        }
        if (this.conditionVisitor != null) {
            if (companyId != null) {
                try {
                    this.conditionVisitor.setElement("srcCompany.id", this.condition.getCompany());
                }
                catch (Exception e) {
                    super.handUIException((Throwable)e);
                }
            }
            filter = this.conditionVisitor.createSrcCondition();
            FilterInfo filterTemp = new FilterInfo();
            for (FilterItemInfo item : filter.getFilterItems()) {
                if ("isAvoidCheck".equals(item.getPropertyName())) continue;
                filterTemp.getFilterItems().add(item);
            }
            filter = filterTemp;
        } else {
            filter.getFilterItems().add(new FilterItemInfo("reqstatus", (Object)new Integer(1), CompareType.EQUALS));
        }
        if (this.condition != null) {
            if (this.condition.getVoucherID() != null) {
                filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)this.condition.getVoucherID(), CompareType.INCLUDE));
            }
            if (companyId != null) {
                filter.getFilterItems().add(new FilterItemInfo("srcCompany.id", (Object)companyId, CompareType.EQUALS));
            }
            if (this.companyIdSet != null) {
                filter.getFilterItems().add(new FilterItemInfo("srcCompany.id", (Object)this.companyIdSet, CompareType.INCLUDE));
            }
            if (this.condition.getPeriodID() != null) {
                filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)this.condition.getPeriodID(), CompareType.EQUALS));
            }
        }
        this.assistRecordCheckQuery.setFilter(filter);
    }

    @Override
    protected void createTargCondition() {
        FilterInfo filter = new FilterInfo();
        this.requisitionCheckQuery = new EntityViewInfo();
        String companyId = null;
        if (this.condition != null && this.condition.getCompany() != null) {
            companyId = this.condition.getCompany().getId().toString();
        }
        if (this.conditionVisitor != null) {
            if (companyId != null) {
                try {
                    this.conditionVisitor.setElement("srcCompany.id", this.condition.getCompany());
                }
                catch (Exception e) {
                    super.handUIException((Throwable)e);
                }
            }
            filter = this.conditionVisitor.createTargCondition();
        } else {
            if (this.condition.getRequisitionId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("requisitionEntry.id", (Object)this.condition.getRequisitionId(), CompareType.INCLUDE));
            }
            if (companyId != null) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
            }
            if (this.companyIdSet != null) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyIdSet, CompareType.INCLUDE));
            }
            filter.getFilterItems().add(new FilterItemInfo("reqstatus", (Object)new Integer(1), CompareType.EQUALS));
        }
        this.requisitionCheckQuery.setFilter(filter);
    }

    @Override
    protected Collection getSrcCheckViews(ActionEvent e) {
        return super.getSelectedItems(this.tbSrc, e.getSource().equals(this.btnValidate), VoucherCheckInfo.class.getName());
    }

    @Override
    protected Collection getTargCheckViews(ActionEvent e) {
        return super.getSelectedItems(this.tbTarg, e.getSource().equals(this.btnValidate), RequisitionCheckInfo.class.getName());
    }

    @Override
    protected void refreshSrcData() {
        this.tbSrc.removeRows();
    }

    @Override
    protected void refreshTargData() {
        this.tbTarg.removeRows();
    }

    public void myInitListener() {
        this.tbSrc.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    int start = e.getFirstRow();
                    int end = e.getLastRow();
                    VoucherCheckReqUI.this.setCellFormat(VoucherCheckReqUI.this.tbSrc, start, end);
                }
                catch (Exception e2) {
                    VoucherCheckReqUI.this.handUIException(e2);
                }
            }
        });
        this.tbTarg.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    int start = e.getFirstRow();
                    int end = e.getLastRow();
                    VoucherCheckReqUI.this.setCellFormat(VoucherCheckReqUI.this.tbTarg, start, end);
                }
                catch (Exception e2) {
                    VoucherCheckReqUI.this.handUIException(e2);
                }
            }
        });
    }

    private void setCellFormat(KDTable table, int start, int end) {
        for (int i = start; i <= end && table.getRow2(i) != null; ++i) {
            Object curpreObj = table.getRow2(i).getCell("currency.precision").getValue();
            int curPre = curpreObj == null ? 0 : (Integer)curpreObj;
            table.getColumn("origAmount").getStyleAttributes().setNumberFormat(RptClientUtil.getDecimalFormat(curPre));
        }
    }

    @Override
    protected String getSelectedPosition() {
        return "isChecked";
    }

    @Override
    protected CheckViewInfo getSelectedItem(IRow row, String t) {
        if (t.equals(VoucherCheckInfo.class.getName())) {
            return AbstractVoucherCheckReqUI.getVchCheckInfoByRow(row);
        }
        return AbstractVoucherCheckReqUI.getReqCheckInfoByRow(row);
    }

    @Override
    protected boolean isShowConditionDialog() {
        return false;
    }

    @Override
    protected IMetaDataPK getQueryObjectPK() {
        return this.assistRecordCheckQueryPK;
    }

    @Override
    protected String getParentUIClassName() {
        return VoucherCheckReqUI.class.getName();
    }

    @Override
    protected KDTable getSrcTable() {
        return this.tbSrc;
    }

    @Override
    protected KDTable getTargetTable() {
        return this.tbTarg;
    }

    @Override
    protected ReqCheckCondition getCheckCondition() {
        ReqCheckCondition c = new ReqCheckCondition();
        if (this.conditionVisitor != null) {
            c = this.conditionVisitor.toCheckCondition();
        }
        if (this.condition != null) {
            c.setVoucherID(this.condition.getVoucherID());
            c.setRequisitionId(this.condition.getRequisitionId());
            c.setCompany(this.condition.getCompany());
            c.setPeriodID(this.condition.getPeriodID());
        }
        return c;
    }

    @Override
    protected String getFilterTitle() {
        return this.getUITitle();
    }

    @Override
    protected void visibleWorkButton() {
        this.btnFilter.setVisible(false);
        this.btnRefresh.setVisible(false);
        this.btnSelectAll.setVisible(true);
        this.btnClearAll.setVisible(true);
        this.btnValidate.setVisible(true);
        this.btnUnValidate.setVisible(false);
        this.btnAutoValidate.setVisible(true);
    }

    @Override
    public void actionValidate_actionPerformed(ActionEvent e) throws Exception {
        Collection srcCheckViews = this.getSrcCheckViews(e);
        if (srcCheckViews.size() > 1) {
            this.autoCheck();
        } else {
            super.actionValidate_actionPerformed(e);
        }
    }
}

