/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.dbf.utils;

import com.kingdee.eas.fi.gl.dbf.utils.DBFAlignment;
import com.kingdee.eas.fi.gl.dbf.utils.DBFBase;
import com.kingdee.eas.fi.gl.dbf.utils.DBFCharsetHelper;
import com.kingdee.eas.fi.gl.dbf.utils.DBFException;
import com.kingdee.eas.fi.gl.dbf.utils.DBFField;
import com.kingdee.eas.fi.gl.dbf.utils.DBFFileFormat;
import com.kingdee.eas.fi.gl.dbf.utils.DBFHeader;
import com.kingdee.eas.fi.gl.dbf.utils.DBFStandardCharsets;
import com.kingdee.eas.fi.gl.dbf.utils.DBFUtils;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DBFWriter
extends DBFBase
implements Closeable {
    private DBFHeader header;
    private List<Object[]> v_records = new ArrayList<Object[]>();
    private int recordCount = 0;
    private RandomAccessFile raf = null;
    private OutputStream outputStream = null;
    private boolean closed = false;

    @Deprecated
    public DBFWriter() {
        this(DEFAULT_CHARSET);
    }

    @Deprecated
    public DBFWriter(Charset charset) {
        this.setCharset(charset);
        this.header = new DBFHeader();
        this.header.setUsedCharset(charset);
    }

    public DBFWriter(OutputStream out) {
        this(out, DEFAULT_CHARSET);
    }

    public DBFWriter(OutputStream out, Charset charset) {
        this(out, charset, DBFFileFormat.COMPATIBLE);
    }

    public DBFWriter(OutputStream out, Charset charset, DBFFileFormat format) {
        this.setCharset(charset);
        this.header = new DBFHeader(format.getSignature());
        this.header.setUsedCharset(charset);
        this.outputStream = out;
    }

    public DBFWriter(File dbfFile) {
        this(dbfFile, null);
    }

    public DBFWriter(File dbfFile, Charset charset) {
        this(dbfFile, charset, DBFFileFormat.COMPATIBLE);
    }

    public DBFWriter(File dbfFile, Charset charset, DBFFileFormat format) {
        try {
            this.raf = new RandomAccessFile(dbfFile, "rw");
            this.header = new DBFHeader(format.getSignature());
            if (dbfFile.length() == 0L) {
                if (charset != null) {
                    if (DBFCharsetHelper.getDBFCodeForCharset(charset) == 0 && !DBFStandardCharsets.UTF_8.equals(charset)) {
                        throw new DBFException("Unssuported charset " + charset);
                    }
                    this.setCharset(charset);
                    this.header.setUsedCharset(charset);
                } else {
                    this.setCharset(DBFStandardCharsets.ISO_8859_1);
                    this.header.setUsedCharset(DBFStandardCharsets.ISO_8859_1);
                }
            } else {
                this.header.read(this.raf, charset, false);
                this.setCharset(this.header.getUsedCharset());
                if (this.raf.length() > (long)this.header.headerLength) {
                    this.raf.seek(this.raf.length() - 1L);
                } else {
                    this.raf.seek(this.raf.length());
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new DBFException("Specified file is not found. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new DBFException(e.getMessage() + " while reading header", e);
        }
        this.recordCount = this.header.numberOfRecords;
    }

    public void setFields(DBFField[] fields) {
        if (this.closed) {
            throw new IllegalStateException("You can not set fields to a closed DBFWriter");
        }
        try {
            if (this.raf != null && this.raf.length() > 0L) {
                throw new DBFException("You can not change fields on an existing file");
            }
        }
        catch (IOException e) {
            throw new DBFException("Error accesing file:" + e.getMessage(), e);
        }
        if (this.header.fieldArray != null) {
            throw new DBFException("Fields has already been set");
        }
        if (fields == null || fields.length == 0) {
            throw new DBFException("Should have at least one field");
        }
        if (fields.length > 255) {
            throw new DBFException("Exceded column limit of 255 (" + fields.length + ")");
        }
        ArrayList<Integer> fieldsWithNull = new ArrayList<Integer>();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] != null) continue;
            fieldsWithNull.add(i);
        }
        if (!fieldsWithNull.isEmpty()) {
            if (fieldsWithNull.size() == 1) {
                throw new DBFException("Field " + fieldsWithNull.get(0) + " is null");
            }
            throw new DBFException("Fields " + ((Object)fieldsWithNull).toString() + " are null");
        }
        int maxFieldNameLength = 10;
        if (this.header.isDB7()) {
            maxFieldNameLength = 31;
        }
        for (DBFField field : fields) {
            if (!field.getType().isWriteSupported()) {
                throw new DBFException("Field " + field.getName() + " is of type " + (Object)((Object)field.getType()) + " that is not supported for writting");
            }
            int fieldNameLength = field.getName().getBytes(this.getCharset()).length;
            if (fieldNameLength <= maxFieldNameLength) continue;
            throw new DBFException("NON-ASCII field name:" + field.getName() + " exceds allowed length of " + maxFieldNameLength + "(" + maxFieldNameLength + ")");
        }
        this.header.fieldArray = new DBFField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            this.header.fieldArray[i] = new DBFField(fields[i]);
        }
        try {
            if (this.raf != null && this.raf.length() == 0L) {
                this.header.write(this.raf);
            }
        }
        catch (IOException e) {
            throw new DBFException("Error accesing file:" + e.getMessage(), e);
        }
    }

    public void addRecord(Object[] values) {
        if (this.closed) {
            throw new IllegalStateException("You can add records a closed DBFWriter");
        }
        if (this.header.fieldArray == null) {
            throw new DBFException("Fields should be set before adding records");
        }
        if (values == null) {
            throw new DBFException("Null cannot be added as row");
        }
        if (values.length != this.header.fieldArray.length) {
            throw new DBFException("Invalid record. Invalid number of fields in row");
        }
        block10: for (int i = 0; i < this.header.fieldArray.length; ++i) {
            Object value = values[i];
            if (value == null) continue;
            switch (this.header.fieldArray[i].getType()) {
                case CHARACTER: {
                    if (value instanceof String) continue block10;
                    throw new DBFException("Invalid value for field " + i + ":" + value);
                }
                case LOGICAL: {
                    if (value instanceof Boolean) continue block10;
                    throw new DBFException("Invalid value for field " + i + ":" + value);
                }
                case DATE: {
                    if (value instanceof Date) continue block10;
                    throw new DBFException("Invalid value for field " + i + ":" + value);
                }
                case NUMERIC: 
                case FLOATING_POINT: {
                    if (value instanceof Number) continue block10;
                    throw new DBFException("Invalid value for field " + i + ":" + value);
                }
                case LONG: 
                case AUTOINCREMENT: {
                    if (value instanceof Number) continue block10;
                    throw new DBFException("Invalid value for field " + i + ":" + value);
                }
                case TIMESTAMP: 
                case TIMESTAMP_DBASE7: {
                    if (value instanceof Date || value instanceof Calendar) continue block10;
                    throw new DBFException("Invalid value for field " + i + ":" + value);
                }
                default: {
                    throw new DBFException("Unsupported writting of field type " + i + " " + (Object)((Object)this.header.fieldArray[i].getType()));
                }
            }
        }
        if (this.raf == null) {
            this.v_records.add(values);
        } else {
            try {
                this.writeRecord(this.raf, values);
                ++this.recordCount;
            }
            catch (IOException e) {
                throw new DBFException("Error occured while writing record. " + e.getMessage(), e);
            }
        }
    }

    private void writeToStream(OutputStream out) {
        try {
            DataOutputStream outStream = new DataOutputStream(out);
            this.header.numberOfRecords = this.v_records.size();
            this.header.write(outStream);
            for (Object[] record : this.v_records) {
                this.writeRecord(outStream, record);
            }
            outStream.write(26);
            outStream.flush();
        }
        catch (IOException e) {
            throw new DBFException(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.raf != null) {
            try {
                this.header.numberOfRecords = this.recordCount;
                this.raf.seek(0L);
                this.header.write(this.raf);
                this.raf.seek(this.raf.length());
                this.raf.writeByte(26);
            }
            catch (IOException e) {
                throw new DBFException(e.getMessage(), e);
            }
            finally {
                DBFUtils.close(this.raf);
            }
        }
        if (this.outputStream != null) {
            try {
                this.writeToStream(this.outputStream);
            }
            finally {
                DBFUtils.close(this.outputStream);
            }
        }
    }

    private void writeRecord(DataOutput dataOutput, Object[] objectArray) throws IOException {
        dataOutput.write(32);
        block8: for (int j = 0; j < this.header.fieldArray.length; ++j) {
            switch (this.header.fieldArray[j].getType()) {
                case CHARACTER: {
                    String strValue = "";
                    if (objectArray[j] != null) {
                        strValue = objectArray[j].toString();
                    }
                    dataOutput.write(DBFUtils.textPadding(strValue, this.getCharset(), this.header.fieldArray[j].getLength(), DBFAlignment.LEFT, (byte)32));
                    continue block8;
                }
                case DATE: {
                    if (objectArray[j] != null) {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setTime((Date)objectArray[j]);
                        dataOutput.write(DBFUtils.textPadding(String.valueOf(calendar.get(1)), DBFStandardCharsets.US_ASCII, 4, DBFAlignment.RIGHT, (byte)48));
                        dataOutput.write(DBFUtils.textPadding(String.valueOf(calendar.get(2) + 1), DBFStandardCharsets.US_ASCII, 2, DBFAlignment.RIGHT, (byte)48));
                        dataOutput.write(DBFUtils.textPadding(String.valueOf(calendar.get(5)), DBFStandardCharsets.US_ASCII, 2, DBFAlignment.RIGHT, (byte)48));
                        continue block8;
                    }
                    dataOutput.write("        ".getBytes(DBFStandardCharsets.US_ASCII));
                    continue block8;
                }
                case NUMERIC: 
                case FLOATING_POINT: {
                    if (objectArray[j] != null) {
                        dataOutput.write(DBFUtils.doubleFormating((Number)objectArray[j], this.getCharset(), this.header.fieldArray[j].getLength(), this.header.fieldArray[j].getDecimalCount()));
                        continue block8;
                    }
                    dataOutput.write(DBFUtils.textPadding(" ", this.getCharset(), this.header.fieldArray[j].getLength(), DBFAlignment.RIGHT, (byte)32));
                    continue block8;
                }
                case LOGICAL: {
                    if (objectArray[j] instanceof Boolean) {
                        if (((Boolean)objectArray[j]).booleanValue()) {
                            dataOutput.write(84);
                            continue block8;
                        }
                        dataOutput.write(70);
                        continue block8;
                    }
                    dataOutput.write(63);
                    continue block8;
                }
                case LONG: 
                case AUTOINCREMENT: {
                    if (objectArray[j] != null) {
                        dataOutput.write(DBFUtils.littleEndian(((Number)objectArray[j]).intValue()));
                        continue block8;
                    }
                    dataOutput.write(0);
                    continue block8;
                }
                case TIMESTAMP: 
                case TIMESTAMP_DBASE7: {
                    Calendar c = Calendar.getInstance();
                    if (objectArray[j] instanceof Calendar) {
                        c = (Calendar)objectArray[j];
                    }
                    if (objectArray[j] instanceof Date) {
                        c.setTime((Date)objectArray[j]);
                    }
                    int millis = c.get(11) * 3600000 + c.get(12) * 60000 + c.get(13) * 1000 + c.get(14);
                    int days = (int)((c.getTimeInMillis() - (long)millis) / 86400000L - -2440588L);
                    dataOutput.writeInt(DBFUtils.littleEndian(days));
                    dataOutput.writeInt(DBFUtils.littleEndian(millis));
                    continue block8;
                }
                default: {
                    throw new DBFException("Unknown field type " + (Object)((Object)this.header.fieldArray[j].getType()));
                }
            }
        }
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected RandomAccessFile getRamdonAccessFile() {
        return this.raf;
    }

    @Deprecated
    public void write(OutputStream out) {
        if (this.raf == null) {
            this.writeToStream(out);
        }
    }

    @Deprecated
    public void write() {
        this.close();
    }
}

