/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptExcelExporter;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class GLRptAccountBalanceExcelExporter
extends GLRptExcelExporter {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.GLRptPageExcelExporter");
    private static final String BN_TOTAL = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"BNSum");
    private static final String BW_TOTAL = EASResource.getString((String)"com.kingdee.eas.fi.gl.ReportBase", (String)"BWSum");
    private static final String ACCOUNT_TOTAL = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"total");
    private static final String CURRENCY_TOTAL = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"subtotal");
    private static final String ACCOUNT_NUMBER_COL = "accountNumber";
    private static final String ACCOUNT_NAME_COL = "accountName";
    private static final String[] NEED_FILL_COL_NAMES = new String[]{"accountNumber", "accountName", "currencyName"};
    private GLRptRowSet preRow = null;
    private boolean needFillInfo = false;

    public GLRptAccountBalanceExcelExporter(Map<String, Object> params) {
        super(params);
        this.needFillInfo = params.get("needFillInfo") != null && (Boolean)params.get("needFillInfo") != false;
    }

    @Override
    protected IGLRptBaseFacade getIGLRptFacade() throws BOSException {
        return GLRptAccountBalanceFacadeFactory.getRemoteInstance();
    }

    @Override
    protected void doGLRowSet(GLRptRowSet rs) throws EASBizException, BOSException {
        if (this.preRow == null) {
            this.preRow = new GLRptRowSet(NEED_FILL_COL_NAMES, 1);
            this.preRow.insertRow();
        }
        rs.beforeFirst();
        GLRptAccountBalanceCondition cond = this.getCond();
        while (rs.next()) {
            Object isAccTotal;
            boolean isAccountTotal;
            Object isBWSum;
            if (this.needFillInfo) {
                this.fillInfoByPreRow(rs);
            }
            boolean isBWAccountSum = false;
            GLRptTreeNode node = null;
            if (CompanyDisplayModeEnum.enumerate != cond.getCompanyDisplayMode()) {
                node = (GLRptTreeNode)rs.getObject("companyName");
            }
            if (cond.getIncludeBWAccount() && (isBWSum = rs.getObject("FIsAccountBWSum")) != null) {
                boolean bl = isBWAccountSum = new BigDecimal(isBWSum.toString()).intValue() == 1;
            }
            if (node != null && CompanyDisplayModeEnum.merger == cond.getCompanyDisplayMode()) {
                SimpleCompanyUserObject obj = (SimpleCompanyUserObject)node.getUserObject();
                if (!node.isLeaf()) {
                    obj.setName(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"367_RptAsstactGGUI"));
                }
            }
            boolean bl = isAccountTotal = (isAccTotal = rs.getObject("FIsAccountTotal")) != null && new BigDecimal(isAccTotal.toString()).intValue() == 1;
            if (isBWAccountSum) {
                boolean isBWAccount = false;
                Object isBW = rs.getObject("FBWType");
                if (isBW != null) {
                    boolean bl2 = isBWAccount = new BigDecimal(isBW.toString()).intValue() == 1;
                }
                if (CompanyDisplayModeEnum.enumerate == cond.getCompanyDisplayMode()) {
                    rs.updateString(ACCOUNT_NAME_COL, isBWAccount ? BW_TOTAL : BN_TOTAL);
                    rs.updateString(ACCOUNT_NUMBER_COL, null);
                } else if (node != null && node.getLevel() == 0) {
                    rs.updateString(ACCOUNT_NAME_COL, isBWAccount ? BW_TOTAL : BN_TOTAL);
                    rs.updateString(ACCOUNT_NUMBER_COL, null);
                }
            } else if (isAccountTotal) {
                if (CompanyDisplayModeEnum.enumerate == cond.getCompanyDisplayMode()) {
                    rs.updateString(ACCOUNT_NAME_COL, ACCOUNT_TOTAL);
                    rs.updateString(ACCOUNT_NUMBER_COL, null);
                } else if (node != null && node.getLevel() == 0) {
                    rs.updateString(ACCOUNT_NAME_COL, ACCOUNT_TOTAL);
                    rs.updateString(ACCOUNT_NUMBER_COL, null);
                }
            }
            if (cond.isAllCurrency()) {
                boolean isCurrencyTotal;
                boolean bl3 = isCurrencyTotal = rs.getInt("FIsCurrencyTotal") == 1;
                if (isCurrencyTotal && (CompanyDisplayModeEnum.enumerate == cond.getCompanyDisplayMode() || node != null && !node.isLeaf() && node.getParentNode() == null)) {
                    rs.updateString("currencyName", CURRENCY_TOTAL);
                }
            }
            if (!this.needFillInfo) continue;
            Object companyName = rs.getObject("companyName");
            if (companyName instanceof GLRptTreeNode) {
                ((GLRptTreeNode)companyName).setShow(true);
            }
            this.storePreRow(rs);
        }
    }

    private void storePreRow(GLRptRowSet rs) throws BOSException {
        for (String colName : NEED_FILL_COL_NAMES) {
            this.preRow.updateObject(colName, rs.getObject(colName));
        }
    }

    private void fillInfoByPreRow(GLRptRowSet rs) throws BOSException {
        for (String colName : NEED_FILL_COL_NAMES) {
            if (rs.getObject(colName) != null || this.preRow.getObject(colName) == null) continue;
            rs.updateObject(colName, this.preRow.getObject(colName));
        }
    }

    @Override
    protected int createRptHead(Sheet sheet) {
        int rowIndex = 0;
        Row row = sheet.createRow(rowIndex++);
        GLRptAccountBalanceCondition cond = this.getCond();
        Cell cell = row.createCell(0);
        cell.setCellValue(this.buildRichTextString((String)this.params.get("Period")));
        CellRangeAddress rang = new CellRangeAddress(0, 0, 0, 3);
        sheet.addMergedRegion(rang);
        cell = row.createCell(4);
        cell.setCellValue(this.buildRichTextString((String)this.params.get("Currency")));
        rang = new CellRangeAddress(0, 0, 4, 5);
        sheet.addMergedRegion(rang);
        if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.enumerate) {
            cell = row.createCell(6);
            cell.setCellValue(this.buildRichTextString(EASResource.getString((String)"com.kingdee.eas.fi.gl.rpt.GLRPptOtherResource", (String)"company") + ":" + cond.getCompany().getName()));
            rang = new CellRangeAddress(0, 0, 6, 7);
            sheet.addMergedRegion(rang);
        }
        StringBuilder optionPosting = new StringBuilder();
        if (cond.getOptionPosting()) {
            optionPosting.append(EASResource.getString((String)this.GL_RPT_RESOURCE, (String)"optionPosting")).append("/");
        }
        if (cond.isNotIncluePLVoucher()) {
            optionPosting.append(EASResource.getString((String)this.GL_RPT_RESOURCE, (String)"notIncluePLVoucher")).append("/");
        }
        if (cond.isOptionAmountZero()) {
            optionPosting.append(EASResource.getString((String)this.GL_RPT_RESOURCE, (String)"optionAmountZero2"));
        } else if (cond.isOptionAmountAndBalZero()) {
            optionPosting.append(EASResource.getString((String)this.GL_RPT_RESOURCE, (String)"optionAmountAndBalZero2"));
        } else if (cond.isOptionBalanceZero()) {
            optionPosting.append(EASResource.getString((String)this.GL_RPT_RESOURCE, (String)"optionBalanceZero"));
        } else if (cond.getOptionYearAmountZero()) {
            optionPosting.append(EASResource.getString((String)this.GL_RPT_RESOURCE, (String)"optionYearAmountZero"));
        } else if (cond.getOptionYearAmountAndBalZero()) {
            optionPosting.append(EASResource.getString((String)this.GL_RPT_RESOURCE, (String)"optionYearAmountAndBalZero"));
        } else if (cond.isNeverUsed()) {
            optionPosting.append(EASResource.getString((String)this.GL_RPT_RESOURCE, (String)"neverUsed"));
        }
        if (optionPosting.length() > 0 && optionPosting.lastIndexOf("/") == optionPosting.length() - 1) {
            optionPosting.deleteCharAt(optionPosting.length() - 1);
        }
        cell = row.createCell(8);
        cell.setCellValue(this.buildRichTextString(optionPosting.toString()));
        rang = new CellRangeAddress(0, 0, 8, 11);
        sheet.addMergedRegion(rang);
        return rowIndex;
    }

    @Override
    protected boolean isTotal(GLRptRowSet data) throws BOSException {
        Object currencyTotal;
        Object isAccountTypeTotal;
        boolean isTotal = false;
        Object accountTotal = data.getObject("FIsAccountTotal");
        if (accountTotal == null || accountTotal.toString().equals("1")) {
            isTotal = true;
        }
        if ((isAccountTypeTotal = data.getObject("FIsAccountTypeTotal")) != null && isAccountTypeTotal.toString().equals("1")) {
            isTotal = true;
        }
        if ((currencyTotal = data.getObject("FIsCurrencyTotal")) != null && currencyTotal.toString().equals("1")) {
            isTotal = true;
        }
        return isTotal;
    }

    @Override
    protected void setCellValueAndStyle(GLRptTableHeadInfo.GLRptTableColumnInfo col, Cell cell, GLRptRowSet data, boolean isTotal) throws BOSException {
        String colName = col.getColName();
        Object value = data.getObject(colName);
        CellStyle style = null;
        Object isAccountTypeTotal = data.getObject("FIsAccountTypeTotal");
        if (isAccountTypeTotal != null && isAccountTypeTotal.toString().equals("1") && ACCOUNT_NUMBER_COL.equals(colName)) {
            value = "";
        }
        if (isAccountTypeTotal != null && isAccountTypeTotal.toString().equals("1") && ACCOUNT_NAME_COL.equals(colName)) {
            value = data.getObject("FpTypeName");
        }
        GLRptAccountBalanceCondition cond = this.getCond();
        if (colName.equals("FLocalExchangeRate")) {
            int localExRatePre = col.getScale();
            if (cond.isAllCurrency()) {
                localExRatePre = data.getInt("FLocalExRatePre");
            }
            style = this.getNumericStyle(isTotal, localExRatePre);
            this.setCellDoubleValue(cell, value);
        } else if (colName.equals("FReportingExchangeRate")) {
            int rptExRatePre = col.getScale();
            if (cond.isAllCurrency()) {
                rptExRatePre = data.getInt("FRptExRatePre");
            }
            style = this.getNumericStyle(isTotal, rptExRatePre);
            this.setCellDoubleValue(cell, value);
        } else if (col.isNumeral()) {
            cell.setCellType(CellType.NUMERIC);
            int precision = col.getScale();
            if (cond.isAllCurrency() && colName.endsWith("For")) {
                precision = data.getInt("currencyPre");
            }
            style = this.getNumericStyle(isTotal, precision);
            this.setCellDoubleValue(cell, value);
        } else {
            style = value instanceof String && !StringUtil.isExcelNumber((String)((String)value)) ? this.getTextStyle(isTotal) : this.getCommStyle(isTotal);
            if (value != null) {
                cell.setCellValue(this.buildRichTextString(value.toString()));
            } else if (isTotal && colName.equals(ACCOUNT_NAME_COL)) {
                if (data.getObject("FIsAccountBWSum") != null && data.getObject("FIsAccountBWSum").toString().equals("1")) {
                    if (data.getObject("FBWType").toString().equals("0")) {
                        cell.setCellValue(this.buildRichTextString(BN_TOTAL));
                    } else if (data.getObject("FBWType").toString().equals("1")) {
                        cell.setCellValue(this.buildRichTextString(BW_TOTAL));
                    }
                } else {
                    cell.setCellValue(this.buildRichTextString(ACCOUNT_TOTAL));
                }
            } else if (isTotal && colName.equals("currencyName")) {
                if (data.getObject("currencyName") == null && data.getObject("FIsCurrencyTotal") != null && data.getObject("FIsCurrencyTotal").toString().equals("1")) {
                    cell.setCellValue(this.buildRichTextString(CURRENCY_TOTAL));
                }
            } else {
                cell.setCellType(CellType.BLANK);
            }
        }
        cell.setCellStyle(style);
    }

    @Override
    protected GLRptAccountBalanceCondition getCond() {
        return (GLRptAccountBalanceCondition)super.getCond();
    }

    @Override
    protected String getFileName() {
        return "accountBalanceTmp";
    }

    protected String getTempFilename(String prefix) {
        return (String)this.params.get("exportFileName");
    }
}

