/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstActTypeBalanceCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstActTypeBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptExcelExporter;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.util.client.EASResource;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class GLRptAsstActTypeBalanceExcelExporter
extends GLRptExcelExporter {
    private String resource = "com.kingdee.eas.fi.gl.rpt.GLRPptOtherResource";

    public GLRptAsstActTypeBalanceExcelExporter(Map<String, Object> params) {
        super(params);
    }

    @Override
    protected IGLRptBaseFacade getIGLRptFacade() throws BOSException {
        return GLRptAsstActTypeBalanceFacadeFactory.getRemoteInstance();
    }

    @Override
    protected int createRptHead(Sheet sheet) {
        int rowIndex = 0;
        Row row = sheet.createRow(rowIndex++);
        GLRptAsstActTypeBalanceCondition cond = this.getCond();
        Cell cell = row.createCell(0);
        cell.setCellValue(this.buildRichTextString((String)this.params.get("Period")));
        CellRangeAddress rang = new CellRangeAddress(0, 0, 0, 3);
        sheet.addMergedRegion(rang);
        cell = row.createCell(4);
        cell.setCellValue(this.buildRichTextString((String)this.params.get("Currency")));
        rang = new CellRangeAddress(0, 0, 4, 5);
        sheet.addMergedRegion(rang);
        if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.enumerate) {
            cell = row.createCell(6);
            cell.setCellValue(this.buildRichTextString(EASResource.getString((String)this.resource, (String)"company") + ":" + cond.getCompany().getName()));
            rang = new CellRangeAddress(0, 0, 6, 7);
            sheet.addMergedRegion(rang);
        }
        String optionPosting = cond.getOptionPosting() ? EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"include_unpostvoucher") : EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"posted_voucher");
        cell = row.createCell(8);
        cell.setCellValue(this.buildRichTextString(optionPosting));
        rang = new CellRangeAddress(0, 0, 8, 9);
        sheet.addMergedRegion(rang);
        return rowIndex;
    }

    @Override
    protected boolean isTotal(GLRptRowSet data) throws BOSException {
        boolean isTotal = false;
        GLRptAsstActTypeBalanceCondition cond = this.getCond();
        Object actTypeIsTotal = cond.isShowAsstItemTotal() ? data.getObject("asstactTypeIsTotal") : null;
        Object istotal = data.getObject("isTotal");
        if (istotal != null && istotal.toString().equals("1") || actTypeIsTotal != null && actTypeIsTotal.toString().equals("1")) {
            isTotal = true;
        }
        return isTotal;
    }

    @Override
    protected void setCellValueAndStyle(GLRptTableHeadInfo.GLRptTableColumnInfo col, Cell cell, GLRptRowSet data, boolean isTotal) throws BOSException {
        String colName = col.getColName();
        Object value = data.getObject(colName);
        CellStyle style = null;
        GLRptAsstActTypeBalanceCondition cond = this.getCond();
        if (colName.equals("FLocalExchangeRate")) {
            int localExRatePre = col.getScale();
            if (cond.isAllCurrency()) {
                localExRatePre = data.getInt("FLocalExRatePre");
            }
            style = this.getNumericStyle(isTotal, localExRatePre);
            this.setCellDoubleValue(cell, value);
        } else if (colName.equals("FReportingExchangeRate")) {
            int rptExRatePre = col.getScale();
            if (cond.isAllCurrency()) {
                rptExRatePre = data.getInt("FRptExRatePre");
            }
            style = this.getNumericStyle(isTotal, rptExRatePre);
            this.setCellDoubleValue(cell, value);
        } else if (col.isNumeral()) {
            cell.setCellType(CellType.NUMERIC);
            int precision = col.getScale();
            if (cond.isAllCurrency() && colName.endsWith("For")) {
                precision = data.getInt("currencyPre");
            }
            style = this.getNumericStyle(isTotal, precision);
            this.setCellDoubleValue(cell, value);
        } else {
            style = value instanceof String && !StringUtil.isExcelNumber((String)((String)value)) ? this.getTextStyle(isTotal) : this.getCommStyle(isTotal);
            if (value != null) {
                cell.setCellValue(this.buildRichTextString(value.toString()));
            } else {
                cell.setCellValue(this.buildRichTextString(""));
            }
        }
        cell.setCellStyle(style);
    }

    @Override
    protected GLRptAsstActTypeBalanceCondition getCond() {
        return (GLRptAsstActTypeBalanceCondition)super.getCond();
    }

    @Override
    protected String getFileName() {
        return "asstActTypeBalanceTmp";
    }

    protected String getTempFilename(String prefix) {
        return (String)this.params.get("exportFileName");
    }
}

