/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactItemFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptExcelExporter;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryResult;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.util.client.EASResource;
import java.util.Map;

public abstract class GLRptAsstactBaseExcelExporter
extends GLRptExcelExporter {
    protected Integer exportTotalSize;
    protected Integer exportBatchSize;

    public GLRptAsstactBaseExcelExporter(Map<String, Object> params) {
        super(params);
        this.exportBatchSize = (Integer)params.get("exportBatchSize");
    }

    @Override
    protected IGLRptBaseFacade getIGLRptFacade() throws BOSException {
        return GLRptAsstactItemFacadeFactory.getRemoteInstance();
    }

    protected abstract IGLRptBaseFacade getIGLRptDataFacade() throws BOSException;

    @Override
    public void export() throws Exception {
        this.info("Execute query ...");
        String queryId = (String)this.params.get("queryId");
        GLRptQueryResult qrs = this.queryRight(queryId, this.view);
        if (qrs == null) {
            return;
        }
        this.info("Build excel ...");
        this.export(qrs.getTableHeadInfo(), qrs.getData());
        this.info("Export finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GLRptQueryResult queryRight(String queryId, EntityViewInfo view) throws BOSException, EASBizException {
        IGLRptBaseFacade facade = this.getIGLRptDataFacade();
        GLRptQueryResult rs = null;
        GLRptQueryResult totalRs = null;
        try {
            GLRptAsstactBaseCondition cond = (GLRptAsstactBaseCondition)view.get("GLFixCondition");
            view.put("isShowAsstItem", (Object)Boolean.TRUE);
            view.put("PAGE_ROW_COUNT", (Object)new Integer(this.exportPageSize));
            cond.setDataSourceTable(queryId);
            this.info("Execute query ...");
            rs = facade.query(view);
            if (rs == null) {
                GLRptQueryResult gLRptQueryResult = null;
                return gLRptQueryResult;
            }
            this.doPrintData(rs, facade);
            if (view.get("isExportAll") != null && cond.isShowAsstItemTotal()) {
                view.put("isPrintTotal", (Object)Boolean.TRUE);
                this.info("Execute subsum query ...");
                totalRs = facade.query(view);
                this.doPrintData(totalRs, facade);
                this.doMergeDate(rs, totalRs);
            }
        }
        finally {
            if (rs != null && rs.getQueryId() != null) {
                facade.releaseDataSource(rs.getQueryId());
            }
            if (totalRs != null && totalRs.getQueryId() != null) {
                facade.releaseDataSource(totalRs.getQueryId());
            }
        }
        return rs;
    }

    protected void doMergeDate(GLRptQueryResult rs, GLRptQueryResult totalRs) throws BOSException {
        if (rs != null && rs.getData() != null && totalRs != null && totalRs.getData() != null) {
            GLRptRowSet rsSet = rs.getData();
            GLRptRowSet totalRsSet = totalRs.getData();
            GLRptTableHeadInfo totalRsHead = totalRs.getTableHeadInfo();
            block0: while (totalRsSet.next()) {
                GLRptTableHeadInfo.GLRptTableColumnInfo col = null;
                int colSize = totalRsHead.getColumnSize();
                for (int j = 0; j < colSize; ++j) {
                    Object value;
                    col = totalRsHead.getTableColumnInfo(j);
                    String colName = col.getColName();
                    if (col.isHide() || (value = totalRsSet.getObject(colName)) != null) continue;
                    totalRsSet.updateObject(colName, EASResource.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"total"));
                    continue block0;
                }
            }
            if (rsSet.size() > 100 && totalRsSet.size() < 100) {
                totalRsSet.beforeFirst();
                GLRptRowSet newTotalSet = new GLRptRowSet(rsSet.getColumKeys(), totalRsSet.size());
                while (totalRsSet.next()) {
                    newTotalSet.next();
                    GLRptTableHeadInfo.GLRptTableColumnInfo col = null;
                    int colSize = totalRsHead.getColumnSize();
                    for (int j = 0; j < colSize; ++j) {
                        col = totalRsHead.getTableColumnInfo(j);
                        String colName = col.getColName();
                        if (colName.equals("SQL_BATCH")) continue;
                        newTotalSet.updateObject(colName, totalRsSet.getObject(colName));
                    }
                }
                rsSet.addRowSets(newTotalSet);
            } else {
                rsSet.addRowSets(totalRsSet);
            }
        }
    }
}

