/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseExcelExporter;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGDFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptExcelExporter;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryResult;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.IGLRptAsstactGDFacade;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.framework.config.ColumnItemData;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class GLRptAsstactGDExcelExporter
extends GLRptAsstactBaseExcelExporter {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.GLRptAsstactGDPageExcelExporter");
    private GLRptQueryResult tQueryResult = null;
    private String strTotal = EASResource.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"total");
    private int currentItemIndex = 0;
    private boolean isExportBatch = false;
    private boolean isWorkbookBuilt = false;
    private boolean isSheetBuilt = false;

    public GLRptAsstactGDExcelExporter(Map<String, Object> params) {
        super(params);
    }

    @Override
    protected IGLRptBaseFacade getIGLRptDataFacade() throws BOSException {
        return GLRptAsstactGDFacadeFactory.getRemoteInstance();
    }

    @Override
    protected void doMergeDate(GLRptQueryResult rs, GLRptQueryResult totalRs) throws BOSException {
        if (rs != null && rs.getData() != null && totalRs != null && totalRs.getData() != null) {
            GLRptRowSet rsSet = rs.getData();
            GLRptRowSet totalRsSet = totalRs.getData();
            GLRptTableHeadInfo totalRsHead = totalRs.getTableHeadInfo();
            GLRptTableHeadInfo rsHead = rs.getTableHeadInfo();
            GLRptRowSet newRs = new GLRptRowSet(rsSet.getColumKeys(), totalRsSet.size());
            int totalColSize = totalRsHead.getColumnSize();
            totalRsSet.beforeFirst();
            while (totalRsSet.next()) {
                newRs.insertRow();
                for (int i = 0; i < totalColSize; ++i) {
                    String colName = totalRsHead.getTableColumnInfo(i).getColName();
                    GLRptTableHeadInfo.GLRptTableColumnInfo rsCol = rsHead.getTableColumnInfo(colName);
                    if (rsCol == null) continue;
                    newRs.updateObject(colName, totalRsSet.getObject(colName));
                }
            }
            newRs.beforeFirst();
            block2: while (newRs.next() && newRs.getCurrRowIndex() != newRs.size() - 1) {
                int colSize = rsHead.getColumnSize();
                for (int j = 0; j < colSize; ++j) {
                    Object value;
                    GLRptTableHeadInfo.GLRptTableColumnInfo col = rsHead.getTableColumnInfo(j);
                    String colName = col.getColName();
                    if (col.isHide() || (value = newRs.getObject(colName)) != null) continue;
                    newRs.updateObject(colName, EASResource.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"total"));
                    continue block2;
                }
            }
            rsSet.addRowSets(newRs);
        }
    }

    @Override
    public void export(GLRptTableHeadInfo head, GLRptRowSet data) throws BOSException {
        com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGDExcelExporter exporter = new com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGDExcelExporter(this.getCond(), (Map<String, Object>)this.params);
        exporter.export(head, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export() throws Exception {
        File excelFile = (File)this.params.get("excelFile");
        if (excelFile != null && excelFile.getName().toLowerCase().endsWith(".xls")) {
            super.export();
            return;
        }
        this.exportType = GLRptExcelExporter.ExportType.XLSX;
        EntityViewInfo view = (EntityViewInfo)this.params.get("view");
        String queryId = (String)this.params.get("queryId");
        if (this.exportBatchSize != null && this.exportBatchSize > 0) {
            this.isExportBatch = true;
        } else {
            this.exportBatchSize = Integer.MAX_VALUE;
        }
        IGLRptAsstactGDFacade facade = GLRptAsstactGDFacadeFactory.getRemoteInstance();
        GLRptQueryResult rs = null;
        try {
            GLRptAsstactBaseCondition cond = (GLRptAsstactBaseCondition)view.get("GLFixCondition");
            GLRptRowSet selectedItem = cond.getSelectedItem();
            this.exportTotalSize = selectedItem != null ? selectedItem.size() : 0;
            view.put("isShowAsstItem", (Object)Boolean.TRUE);
            view.put("PAGE_ROW_COUNT", (Object)this.exportPageSize);
            cond.setDataSourceTable(queryId);
            int batchCount = this.isExportBatch && selectedItem != null ? (selectedItem.size() % this.exportBatchSize == 0 ? this.exportTotalSize / this.exportBatchSize : this.exportTotalSize / this.exportBatchSize + 1) : 1;
            if (selectedItem != null) {
                selectedItem.beforeFirst();
            }
            this.currentItemIndex = 0;
            for (int i = 0; i < batchCount; ++i) {
                GLRptRowSet exportItem = null;
                if (selectedItem != null) {
                    exportItem = new GLRptRowSet(selectedItem.getColumKeys(), Math.min(this.exportBatchSize, selectedItem.size()));
                }
                if (exportItem != null) {
                    String[] columnKeys = selectedItem.getColumKeys();
                    int t = 0;
                    while (t++ < this.exportBatchSize && selectedItem.next()) {
                        ++this.currentItemIndex;
                        exportItem.insertRow();
                        for (String columnKey : columnKeys) {
                            exportItem.updateObject(columnKey, selectedItem.getObject(columnKey));
                        }
                    }
                }
                cond.setSelectedItem(exportItem);
                this.info("Execute query ...");
                rs = facade.query(view);
                if (rs == null || rs.getData() == null || rs.getData().size() == 0) {
                    throw new EASBizException(new NumericExceptionSubItem("101", EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"62_RptAsstactGGExportHelper")));
                }
                if (!this.isWorkbookBuilt) {
                    this.setWb(this.buildWorkbook());
                    this.isWorkbookBuilt = true;
                }
                this.generate(this.getWb(), rs);
            }
            this.writeFile(this.getWb(), excelFile);
        }
        finally {
            if (rs != null && rs.getQueryId() != null) {
                facade.releaseDataSource(rs.getQueryId());
            }
            if (this.tQueryResult != null && this.tQueryResult.getQueryId() != null) {
                facade.releaseDataSource(this.tQueryResult.getQueryId());
            }
        }
        this.info("Export finished");
    }

    private void generate(Workbook wb, GLRptQueryResult queryResult) throws Exception {
        Sheet sheet;
        IGLRptAsstactGDFacade facade = GLRptAsstactGDFacadeFactory.getRemoteInstance();
        GLRptTableHeadInfo head = queryResult.getTableHeadInfo();
        this.useCustomizeTableStyle(head);
        GLRptRowSet rs = queryResult.getData();
        String[] columKeys = rs.getColumKeys();
        this.info("Get sum data ...");
        Map<Integer, Map<String, Object>> sumRow = this.getSumData(queryResult.getQueryId());
        if (!this.isSheetBuilt) {
            sheet = this.buildSheetWithHead(wb, head);
            this.isSheetBuilt = true;
        } else {
            sheet = this.getSheetIfNull(wb);
        }
        int rowIndex = this.getRowSize(sheet);
        int beginIndex = 0;
        this.updateSumData(rs, beginIndex, sumRow);
        rowIndex = this.createTableBody(head, rs, wb, rowIndex);
        for (beginIndex = this.exportPageSize.intValue(); beginIndex < queryResult.getViewRowCount(); beginIndex += this.exportPageSize.intValue()) {
            this.info("Get data " + beginIndex + "/" + queryResult.getViewRowCount() + " ...");
            rs = facade.getData(queryResult.getQueryId(), beginIndex, this.exportPageSize);
            this.updateSumData(rs, beginIndex, sumRow);
            rowIndex = this.createTableBody(head, rs, wb, rowIndex);
        }
        EntityViewInfo view = (EntityViewInfo)this.params.get("view");
        GLRptAsstactBaseCondition cond = (GLRptAsstactBaseCondition)view.get("GLFixCondition");
        if (view.get("isExportAll") != null && cond.isShowAsstItemTotal()) {
            GLRptQueryResult tQueryResult;
            if (this.isExportBatch && this.currentItemIndex != this.exportTotalSize) {
                return;
            }
            cond.setSelectedItem(null);
            view.put("isPrintTotal", (Object)Boolean.TRUE);
            this.info("Execute subsum query ...");
            this.tQueryResult = tQueryResult = facade.query(view);
            rs = tQueryResult.getData();
            this.info("Get subsum sum data ...");
            sumRow = this.getSumData(tQueryResult.getQueryId());
            beginIndex = 0;
            this.updateSumData(rs, beginIndex, sumRow);
            rs = this.doMergeDate(rs, tQueryResult.getTableHeadInfo(), head, columKeys, tQueryResult.getViewRowCount() - (beginIndex + rs.size()) <= 0);
            rowIndex = this.createTableBody(head, rs, wb, rowIndex);
            for (beginIndex = this.exportPageSize.intValue(); beginIndex < tQueryResult.getViewRowCount(); beginIndex += this.exportPageSize.intValue()) {
                this.info("Get subsum data " + beginIndex + "/" + tQueryResult.getViewRowCount() + " ...");
                rs = facade.getData(tQueryResult.getQueryId(), beginIndex, this.exportPageSize);
                this.updateSumData(rs, beginIndex, sumRow);
                rs = this.doMergeDate(rs, tQueryResult.getTableHeadInfo(), head, columKeys, tQueryResult.getViewRowCount() - (beginIndex + rs.size()) <= 0);
                rowIndex = this.createTableBody(head, rs, wb, rowIndex);
            }
            System.out.println();
        }
    }

    @Override
    protected int createRptHead(Sheet sheet) {
        int rowIndex = 0;
        GLRptAsstactBaseCondition cond = this.getCond();
        Row row = sheet.createRow(rowIndex++);
        row.setHeightInPoints(21.75f);
        this.addMergeCell(sheet, 0, 0, 0, 1, this.buildRichTextString((String)this.params.get("AsstAct")));
        this.addMergeCell(sheet, 0, 0, 2, 3, this.buildRichTextString((String)this.params.get("AsstActItem")));
        this.addMergeCell(sheet, 0, 0, 4, 5, this.buildRichTextString((String)this.params.get("Period")));
        this.addMergeCell(sheet, 0, 0, 6, 7, this.buildRichTextString((String)this.params.get("Currency")));
        if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.enumerate) {
            this.addMergeCell(sheet, 0, 0, 8, 9, this.buildRichTextString(cond.getCompany().getName()));
        }
        String optionPosting = cond.getOptionPosting() ? com.kingdee.bos.util.EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"include_unpostvoucher") : com.kingdee.bos.util.EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"posted_voucher");
        this.addMergeCell(sheet, 0, 0, 10, 11, this.buildRichTextString(optionPosting));
        return rowIndex;
    }

    @Override
    protected void setCellValueAndStyle(GLRptTableHeadInfo.GLRptTableColumnInfo col, Cell cell, GLRptRowSet data, boolean isTotal) throws BOSException {
        CellStyle style;
        String colName = col.getColName();
        Object value = data.getObject(colName);
        GLRptAsstactBaseCondition cond = this.getCond();
        if (colName.equals("FLocalExchangeRate")) {
            int localExRatePre = col.getScale();
            if (cond.isAllCurrency()) {
                localExRatePre = data.getInt("FRptExRatePre");
            }
            style = this.getNumericStyle(isTotal, localExRatePre);
            this.setCellDoubleValue(cell, value);
        } else if (colName.equals("FReportingExchangeRate")) {
            int rptExRatePre = col.getScale();
            if (cond.isAllCurrency()) {
                rptExRatePre = data.getInt("FRptExRatePre");
            }
            style = this.getNumericStyle(isTotal, rptExRatePre);
            this.setCellDoubleValue(cell, value);
        } else {
            super.setCellValueAndStyle(col, cell, data, isTotal);
            return;
        }
        cell.setCellStyle(style);
    }

    protected void useCustomizeTableStyle(GLRptTableHeadInfo head) {
        Object userSettingTableStyle = this.params.get("userSettingTableStyle");
        if (userSettingTableStyle != null) {
            Map userCustomConfigItemData = ((UserCustomConfigItemData)userSettingTableStyle).getColumnData();
            for (Object key : userCustomConfigItemData.keySet()) {
                ColumnItemData customCol = (ColumnItemData)userCustomConfigItemData.get(key);
                GLRptTableHeadInfo.GLRptTableColumnInfo col = head.getTableColumnInfo(key.toString());
                if (col == null) continue;
                col.setHide(customCol.isHidden());
                col.setWidth(customCol.getWidth());
            }
        }
    }

    @Override
    protected boolean isTotal(GLRptRowSet data) throws BOSException {
        boolean isTotal = false;
        Object balSeq = data.getObject("FBalSeq");
        if (balSeq == null || balSeq.toString().equals("4") || balSeq.toString().equals("5") || balSeq.toString().equals("2") && data.getString("voucherNumber") == null) {
            isTotal = true;
        }
        return isTotal;
    }

    @Override
    protected GLRptAsstactBaseCondition getCond() {
        EntityViewInfo view = (EntityViewInfo)this.params.get("view");
        GLRptAsstactBaseCondition cond = (GLRptAsstactBaseCondition)view.get("GLFixCondition");
        return cond;
    }

    protected GLRptRowSet doMergeDate(GLRptRowSet trs, GLRptTableHeadInfo thead, GLRptTableHeadInfo head, String[] columKeys, boolean isLast) throws BOSException {
        GLRptRowSet newRs = new GLRptRowSet(columKeys, trs.size());
        int totalColSize = thead.getColumnSize();
        trs.beforeFirst();
        while (trs.next()) {
            newRs.insertRow();
            for (int i = 0; i < totalColSize; ++i) {
                String colName = thead.getTableColumnInfo(i).getColName();
                GLRptTableHeadInfo.GLRptTableColumnInfo rsCol = head.getTableColumnInfo(colName);
                if (rsCol == null) continue;
                newRs.updateObject(colName, trs.getObject(colName));
            }
        }
        newRs.beforeFirst();
        block2: while (newRs.next() && (!isLast || newRs.getCurrRowIndex() != newRs.size() - 1)) {
            int colSize = head.getColumnSize();
            for (int j = 0; j < colSize; ++j) {
                Object value;
                GLRptTableHeadInfo.GLRptTableColumnInfo col = head.getTableColumnInfo(j);
                String colName = col.getColName();
                if (col.isHide() || (value = newRs.getObject(colName)) != null) continue;
                newRs.updateObject(colName, this.strTotal);
                continue block2;
            }
        }
        return newRs;
    }

    protected Map<Integer, Map<String, Object>> getSumData(String queryId) throws EASBizException, BOSException {
        HashMap<Integer, Map<String, Object>> sumRs = new HashMap<Integer, Map<String, Object>>();
        GLRptRowSet sumRow = GLRptAsstactGDFacadeFactory.getRemoteInstance().getSumData(queryId);
        if (sumRow != null) {
            String[] colKey = sumRow.getColumKeys();
            while (sumRow.next()) {
                int rowIndex = sumRow.getRowIndex();
                HashMap<String, Object> row = new HashMap<String, Object>();
                sumRs.put(rowIndex, row);
                for (int i = 0; i < colKey.length; ++i) {
                    row.put(colKey[i], sumRow.getObject(colKey[i]));
                }
            }
        }
        return sumRs;
    }

    protected void updateSumData(GLRptRowSet rowSet, int beginIndex, Map<Integer, Map<String, Object>> sumRow) throws BOSException {
        if (sumRow.size() == 0) {
            return;
        }
        for (int rowIndex = 0; rowIndex < rowSet.size(); ++rowIndex) {
            Map<String, Object> row = sumRow.get(beginIndex + rowIndex);
            if (row == null) continue;
            for (String colKey : row.keySet()) {
                rowSet.updateObject(rowIndex, colKey, row.get(colKey));
            }
        }
    }

    @Override
    protected String getFileName() {
        return "asstActGDTmp";
    }
}

